/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.DataUtil;
import game.sengoku.window.WindowClickable;

public class ProgressSprite
extends WindowClickable {
    private int progress;
    private int progressColor;
    private int fontColor;

    public ProgressSprite(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n7, n7, MouseSymbolLayerManager.LAYER_NORMAL);
        this.setBgColor(n7);
        this.progressColor = n6;
        this.fontColor = n8;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int n) {
        this.progressColor = n;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int n) {
        if (this.progress != n) {
            this.progress = DataUtil.checkInteger((int)n, (int)0, (int)100);
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        int n = this.width * this.progress / 100;
        this.content.fill(this.progressColor, 0, 0, n, this.height);
        this.content.drawText("" + this.progress + "\uff05", GameFontUtil.FONT22, this.fontColor, this.width / 2 - 30, 22);
    }

    @Override
    public void update() {
        super.update();
    }
}

