/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.font.Font;
import game.base.graphic.ColorSpace;
import game.base.symbol.MouseSymbolLayer;
import game.sengoku.common.GameUtil;
import game.sengoku.window.WindowClickable;

public class ButtonSprite
extends WindowClickable {
    public static final int BUTTON_NORMAL_COLOR = -235801635;
    public static final int BUTTON_OVER_COLOR = 1768520959;
    protected boolean textCentering = false;
    protected Font font;
    protected String text;
    protected int fontColor = 438578943;

    public ButtonSprite(int n, int n2) {
        super(n, n2);
    }

    public ButtonSprite(int n, int n2, int n3, int n4, int n5, int n6, int n7, Font font, String string, boolean bl, MouseSymbolLayer mouseSymbolLayer) {
        super(n, n2, n3, n4, n5, n6, n7, mouseSymbolLayer, null);
        this.font = font;
        this.text = string;
        this.textCentering = bl;
        this.bgColor = n6;
    }

    public ButtonSprite(int n, int n2, int n3, int n4, int n5, int n6, int n7, Font font, String string, boolean bl, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        this(n, n2, n3, n4, n5, n6, n7, font, string, bl, mouseSymbolLayer);
        this.origine = hasAbsoluteXY;
        this.bgColor = n6;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.needUpdate();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (this.text == null && string != null || this.text != null && string == null || !this.text.equals(string)) {
            this.text = string;
            this.needUpdate();
        }
    }

    public boolean isTextCentering() {
        return this.textCentering;
    }

    public void setTextCentering(boolean bl) {
        if (this.textCentering != bl) {
            this.textCentering = bl;
            this.needUpdate();
        }
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int n) {
        if (this.fontColor != n) {
            this.fontColor = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateBackGround() {
        byte[] byArray = this.background.getBytes(ColorSpace.RGB_ALPHA);
        for (int i = 0; i < byArray.length / 4; ++i) {
            if (!GameUtil.cornerRectInner(i % this.width, i / this.width, this.width, this.height, 5)) continue;
            byArray[i * 4 + 3] = (byte)(0xFF & this.bgColor);
            byArray[i * 4 + 2] = (byte)(0xFF & this.bgColor >>> 8);
            byArray[i * 4 + 1] = (byte)(0xFF & this.bgColor >>> 16);
            byArray[i * 4 + 0] = (byte)(0xFF & this.bgColor >>> 24);
        }
        this.background.reset(byArray, ColorSpace.RGB_ALPHA);
        this.background.commit();
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.text != null && this.font != null) {
            if (this.textCentering) {
                int n = (this.height - (int)this.font.getFontSize()) / 2;
                int n2 = (this.width - (int)this.font.getFontSize() * this.text.length()) / 2;
                this.content.drawText(this.text, this.font, this.fontColor, n2, this.height - n);
            } else {
                this.content.drawText(this.text, this.font, this.fontColor, 6, 6 + (int)this.font.getFontSize());
            }
        }
    }
}

