/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.server;

import game.base.common.Pair;
import game.sengoku.common.GameHistoryCreator;
import game.sengoku.common.GameNoticeCreator;
import game.sengoku.common.GameUtil;
import game.sengoku.data.CommandV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GameServerSetting;
import game.sengoku.data.SaveData;
import game.sengoku.data.Scenario;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.GameDebugUtil;
import game.sengoku.game.GameEventUtil;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.Notice;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.StoreAction;
import game.sengoku.game.domestic.DomesticAction;
import game.sengoku.game.domestic.DomesticEvent;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.game.tactics.TacticsActionEntry;
import game.sengoku.game.tactics.TacticsResult;
import game.sengoku.main.FlowControler;
import game.sengoku.server.GameClient;
import game.sengoku.server.GameMessage;
import game.sengoku.server.PostBox;
import game.sengoku.server.entity.DiplomacyActionRequest;
import game.sengoku.server.entity.DiplomacyActionResponse;
import game.sengoku.server.entity.DomesticActionRequest;
import game.sengoku.server.entity.DomesticActionResponse;
import game.sengoku.server.entity.DomesticEventRequest;
import game.sengoku.server.entity.DomesticEventResponse;
import game.sengoku.server.entity.DomesticPhaseRequest;
import game.sengoku.server.entity.GameDataRequest;
import game.sengoku.server.entity.GameDataResponse;
import game.sengoku.server.entity.GameFinalRequest;
import game.sengoku.server.entity.GameMessagePayload;
import game.sengoku.server.entity.GameStartRequest;
import game.sengoku.server.entity.GameStartRequestServer;
import game.sengoku.server.entity.MessageNotice;
import game.sengoku.server.entity.MessageResponse;
import game.sengoku.server.entity.NegotiationActionRequest;
import game.sengoku.server.entity.NegotiationActionResponse;
import game.sengoku.server.entity.NegotiationResultRequest;
import game.sengoku.server.entity.NegotiationStartRequest;
import game.sengoku.server.entity.NegotiationStartResponse;
import game.sengoku.server.entity.StoreActionRequest;
import game.sengoku.server.entity.StoreActionResponse;
import game.sengoku.server.entity.TacticsActionRequest;
import game.sengoku.server.entity.TacticsActionResponse;
import game.sengoku.server.entity.TacticsPhaseRequest;
import game.sengoku.server.entity.TacticsResultRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class GameServer {
    public static final int ADDRESS_ALL = 99;
    public static final int GAME_SERVER_ID = 2;
    public static final int GAME_PLAYER_ID = 100;
    public static final int GAME_START_REQUEST_WAIT = 1;
    public static final int GAME_START_RESPONSE_WAIT = 2;
    public static final int DOMESTIC_START_DOING = 31;
    public static final int DOMESTIC_START_RESPONSE_WAIT = 3;
    public static final int DOMESTIC_EVENT_REQUESTING = 25;
    public static final int DOMESTIC_EVENT_RESPONSE_WAIT = 24;
    public static final int DOMESTIC_ACTION_REQUESTING = 12;
    public static final int DOMESTIC_RESULT_RESPONSE_WAIT = 21;
    public static final int DOMESTIC_ACTION_RESPONSE_WAIT = 4;
    public static final int DIPLOMACY_START_RESPONSE_WAIT = 5;
    public static final int DIPLOMACY_ACTION_REQUESTING = 13;
    public static final int DIPLOMACY_ACTION_RESPONSE_WAIT = 15;
    public static final int STORE_ACTION_RESPONSE_WAIT = 32;
    public static final int NEGOTIATION_START_RESPONSE_WAIT = 6;
    public static final int NEGOTIATION_ACTION_RESPONSE_WAIT = 7;
    public static final int NEGOTIATION_RESULT_RESPONSE_WAIT = 8;
    public static final int TACTICS_START_RESPONSE_WAIT = 9;
    public static final int TACTICS_ACTION_REQUESTING = 14;
    public static final int TACTICS_ACTION_RESPONSE_WAIT = 10;
    public static final int TACTICS_RESULT_RESPONSE_WAIT = 11;
    public static final int TACTICS_END_RESPONSE_WAIT = 22;
    public static final int INTERVAL_ACTION_REQUESTING = 26;
    public static final int INTERVAL_ACTION_RESPONSE_WAIT = 27;
    public static final int GAME_FINAL_REQUESTING = 28;
    public static final int GAME_FINAL_RESPONSE_WAIT = 29;
    private int id = 0;
    private int status = 0;
    private int backStatus = 0;
    private PostBox post = null;
    private Set<Integer> connectedClients = null;
    private Map<Integer, Boolean> responsedClients = null;
    private Queue<Integer> clientQueue = null;
    private Set<Integer> messageSend = null;
    private Scenario scenario;
    private GameData gameData;
    private GameAIData gameAiData;
    private GameDataV gameDataV;
    private Map<Integer, List<CommandV>> domesticActions;
    private Map<Integer, TacticsAction> tacticsActions;
    private Set<Integer> negotiationDaimyoIds;
    private Set<Integer> negotiationStoreIds;
    private List<Pair<Integer, DomesticEvent>> domesticEvents;
    private List<TacticsActionEntry> tacticsActionEntries;
    private List<TacticsActionEntry> tacticsActionNewEntries;
    private int pairingKey = 1;
    private TacticsResult tacticsResult;

    public GameServer(int n, PostBox postBox) {
        this.id = n;
        this.post = postBox;
        this.connectedClients = new HashSet<Integer>();
        this.responsedClients = new HashMap<Integer, Boolean>();
        this.clientQueue = new LinkedList<Integer>();
        this.messageSend = new HashSet<Integer>();
        this.domesticActions = new HashMap<Integer, List<CommandV>>();
        this.tacticsActions = new HashMap<Integer, TacticsAction>();
        this.negotiationDaimyoIds = new HashSet<Integer>();
        this.negotiationStoreIds = new HashSet<Integer>();
        this.domesticEvents = new ArrayList<Pair<Integer, DomesticEvent>>();
        this.tacticsActionEntries = new ArrayList<TacticsActionEntry>();
        this.tacticsActionNewEntries = new ArrayList<TacticsActionEntry>();
    }

    public int getId() {
        return this.id;
    }

    public void init() {
        this.status = 2;
    }

    public void update() {
        GameDebugUtil.printServerStatus(this.id, this.status);
        if (!this.messageSend.isEmpty()) {
            this.receiveMessage();
            return;
        }
        switch (this.status) {
            case 1: {
                this.receive();
                break;
            }
            case 31: {
                this.domesticPreStart();
                break;
            }
            case 2: {
                this.receive();
                break;
            }
            case 3: {
                this.receive();
                break;
            }
            case 25: {
                this.domesticEventRequesting();
                break;
            }
            case 12: {
                this.domesticActionRequesting();
                break;
            }
            case 24: {
                this.receive();
                break;
            }
            case 4: {
                this.receive();
                break;
            }
            case 21: {
                this.receive();
                break;
            }
            case 5: {
                this.receive();
                break;
            }
            case 13: {
                this.diplomacyActionRequesting(true);
                break;
            }
            case 15: {
                this.receive();
                break;
            }
            case 32: {
                this.receive();
                break;
            }
            case 6: {
                this.receive();
                break;
            }
            case 7: {
                this.receive();
                break;
            }
            case 8: {
                this.receive();
                break;
            }
            case 9: {
                this.receive();
                break;
            }
            case 14: {
                this.tacticsActionRequesting();
                break;
            }
            case 10: {
                this.receive();
                break;
            }
            case 11: {
                this.receive();
                break;
            }
            case 22: {
                this.receive();
                break;
            }
            case 27: {
                this.receive();
                break;
            }
            case 28: 
            case 29: {
                this.receive();
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + this.status);
            }
        }
    }

    private void receiveMessage() {
        GameMessage gameMessage;
        while ((gameMessage = this.post.receive(this.id, 99)) != null) {
            MessageResponse messageResponse = (MessageResponse)gameMessage.getPayload();
            this.messageSend.remove(gameMessage.getPairingKey());
        }
    }

    private void receive() {
        while (this.receiveOnce()) {
        }
    }

    private void sendNoticesByDaimyoId(List<Pair<Integer, Notice>> list) {
        list.forEach(pair -> this.sendNotice((Pair<Integer, Notice>)pair));
        list.clear();
    }

    private void sendNotice(Pair<Integer, Notice> pair) {
        this.sendNotice(pair.getFirst(), pair.getSecond());
    }

    private void sendNotice(int n, Notice notice) {
        if (n == 99) {
            this.messageStartAll(notice);
        } else {
            int n2 = FlowControler.getInstance().getPlayerId(n);
            if (0 < n2) {
                this.messageStart(n2, notice);
            }
        }
    }

    private boolean receiveOnce() {
        GameMessage gameMessage = this.post.receive(this.id);
        if (gameMessage == null) {
            return false;
        }
        switch (gameMessage.getMessageId()) {
            case 80: {
                this.gameStartRequest(gameMessage);
                break;
            }
            case 12: {
                this.gameStartReceive(gameMessage);
                break;
            }
            case 14: {
                this.domesticStartResponseReceive(gameMessage);
                break;
            }
            case 16: {
                this.domesticEventReceive(gameMessage);
                break;
            }
            case 18: {
                this.domesticActionReceive(gameMessage);
                break;
            }
            case 20: {
                this.domesticResultReceive(gameMessage);
                break;
            }
            case 22: {
                this.diplomacyStartResponseReceive(gameMessage);
                break;
            }
            case 24: {
                this.diplomacyActionReceive(gameMessage);
                break;
            }
            case 28: {
                this.negotiationStartResponseReceive(gameMessage);
                break;
            }
            case 30: {
                this.negotiationActionReceive(gameMessage);
                break;
            }
            case 26: {
                this.storeActionReceive(gameMessage);
                break;
            }
            case 32: {
                this.negotiationResultReceive(gameMessage);
                break;
            }
            case 34: {
                this.tacticsStartResponseReceive(gameMessage);
                break;
            }
            case 36: {
                this.tacticsActionReceive(gameMessage);
                break;
            }
            case 38: {
                this.tacticsResultResponseReceive(gameMessage);
                break;
            }
            case 40: {
                this.tacticsEndReceive(gameMessage);
                break;
            }
            case 50: {
                this.IntervalActionResponseReceive(gameMessage);
                break;
            }
            case 52: {
                this.gameFinalResponseReceive(gameMessage);
                break;
            }
            case 47: {
                this.gameDataRequestReceive(gameMessage);
                break;
            }
            case 42: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new RuntimeException("invalid message id = " + gameMessage.getMessageId());
            }
        }
        return true;
    }

    protected void gameStartRequest(GameMessage gameMessage) {
        GameStartRequestServer gameStartRequestServer = (GameStartRequestServer)gameMessage.getPayload();
        this.scenario = gameStartRequestServer.getScenario();
        this.gameDataV = gameStartRequestServer.getGameDataV();
        this.gameAiData = this.gameDataV.getGameAIData();
        this.gameData = this.gameDataV.getGameData();
        this.connectedClients.clear();
        this.connectedClients.addAll(gameStartRequestServer.getConnectedClients());
        this.refreshResponsedClients();
        this.commonStart(11, 2, new GameStartRequest());
    }

    protected void gameStartReceive(GameMessage gameMessage) {
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.updateClientQueue();
            GameCommandUtil.updateNewGame(this.gameDataV);
            this.domesticPreStart();
        }
    }

    private void gameDataRequestReceive(GameMessage gameMessage) {
        GameDataRequest gameDataRequest = (GameDataRequest)gameMessage.getPayload();
        this.post.send(new GameMessage(48, this.id, 1, 3, new GameDataResponse(gameDataRequest.getId(), this.scenario, this.gameDataV, this.getGameServerSetting())));
    }

    protected void domesticPreStart() {
        ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
        GameCommandUtil.updateByMonth(this.gameDataV, arrayList);
        if (this.gameDataV.getWorld().getYear() >= 1600) {
            this.gameFinalRequest(0);
        } else {
            this.sendNoticesByDaimyoId(arrayList);
            this.domesticStart();
        }
    }

    protected void domesticStart() {
        this.gameDataV.update();
        this.commonStart(13, 3, new DomesticPhaseRequest());
    }

    protected void domesticStartResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 25, () -> {
            this.domesticEvents.clear();
            GameEventUtil.createEvents(this.gameDataV, this.domesticEvents);
        });
    }

    protected void domesticEventRequesting() {
        if (this.domesticEvents.isEmpty()) {
            this.gameDataV.getDaimyos().values().forEach(daimyoV -> daimyoV.getCashFlow().clear());
            ArrayList arrayList = new ArrayList();
            this.gameDataV.update();
            this.updateClientQueue();
            this.domesticActions.clear();
            this.status = 12;
            return;
        }
        this.refreshResponsedClients(true);
        Iterator<Pair<Integer, DomesticEvent>> iterator = this.domesticEvents.iterator();
        while (iterator.hasNext()) {
            Pair<Integer, DomesticEvent> pair = iterator.next();
            int n = FlowControler.getInstance().getPlayerId(pair.getFirst());
            if (!this.responsedClients.get(n).booleanValue()) continue;
            this.post.send(new GameMessage(15, this.id, n, 3, new DomesticEventRequest(pair.getSecond())));
            this.responsedClients.put(n, false);
            iterator.remove();
        }
        this.status = 24;
    }

    protected void domesticEventReceive(GameMessage gameMessage) {
        DomesticEventResponse domesticEventResponse = (DomesticEventResponse)gameMessage.getPayload();
        ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
        GameEventUtil.reflectEventsResult(this.gameDataV, domesticEventResponse.getDomesticEventResult(), arrayList);
        this.sendNoticesByDaimyoId(arrayList);
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.status = 25;
        }
    }

    protected void domesticActionRequesting() {
        this.refreshResponsedClients(true);
        for (int n : this.connectedClients) {
            int n2 = FlowControler.getInstance().getDaimyoId(n);
            if (!GameCommandUtil.canDomestic(this.gameDataV, n2)) continue;
            this.responsedClients.put(n, false);
            this.post.send(new GameMessage(17, this.id, n, 3, new DomesticActionRequest()));
        }
        this.status = 4;
    }

    protected void domesticActionReceive(GameMessage gameMessage) {
        DomesticActionResponse domesticActionResponse = (DomesticActionResponse)gameMessage.getPayload();
        DomesticAction domesticAction = domesticActionResponse.getDomesticAction();
        this.domesticActions.put(domesticAction.getDaimyoId(), domesticAction.getCommandList());
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.gameDataV.getDaimyos().values().forEach(daimyoV -> daimyoV.getCashFlow().clear());
            ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
            for (Map.Entry<Integer, List<CommandV>> entry : this.domesticActions.entrySet()) {
                List<CommandV> list;
                int n = entry.getKey();
                if (!GameCommandUtil.reflectActions(this.gameDataV, n, list = entry.getValue(), arrayList)) continue;
                DaimyoV daimyoV2 = (DaimyoV)this.gameDataV.getDaimyos().get(n);
                Notice notice = GameNoticeCreator.soubuji(daimyoV2);
                this.messageStartAll(notice);
                notice = GameHistoryCreator.soubuji(daimyoV2);
                this.messageStartAll(notice);
                this.gameFinalRequest(n);
                return;
            }
            this.domesticActions.clear();
            this.sendNoticesByDaimyoId(arrayList);
            this.gameDataV.update();
            this.domesticResultRequesting();
        }
    }

    protected void domesticResultRequesting() {
        this.commonStart(19, 21, null);
    }

    protected void domesticResultReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 0, () -> this.domesticEnd());
    }

    protected void domesticEnd() {
        this.diplomacyPreStart();
    }

    protected void diplomacyPreStart() {
        this.diplomacyStart();
    }

    protected void diplomacyStart() {
        this.commonStart(21, 5, null);
    }

    protected void diplomacyStartResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 13);
    }

    private void diplomacyActionRequesting(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (this.clientQueue.isEmpty()) {
                this.tacticsPreStart();
                return;
            }
            n2 = this.clientQueue.peek();
            n = FlowControler.getInstance().getDaimyoId(n2);
            if (GameCommandUtil.canDiplomacy(this.gameDataV, n)) break;
            this.clientQueue.poll();
        }
        if (bl) {
            n = FlowControler.getInstance().getDaimyoId(n2);
            GameCommandUtil.createNegotiationTarget(this.gameDataV, n, this.negotiationDaimyoIds, this.negotiationStoreIds);
        } else {
            GameCommandUtil.filterNegotiationTarget(this.gameDataV, n, this.negotiationDaimyoIds);
        }
        this.post.send(new GameMessage(23, this.id, n2, 3, new DiplomacyActionRequest(this.negotiationDaimyoIds, this.negotiationStoreIds)));
        this.status = 15;
    }

    private void diplomacyActionReceive(GameMessage gameMessage) {
        ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
        int n = FlowControler.getInstance().getDaimyoId(gameMessage.getFromId());
        DiplomacyActionResponse diplomacyActionResponse = (DiplomacyActionResponse)gameMessage.getPayload();
        switch (diplomacyActionResponse.getType()) {
            case 1: {
                this.negotiationDaimyoIds.remove(diplomacyActionResponse.getNegotiationToId());
                int n2 = FlowControler.getInstance().getPlayerId(diplomacyActionResponse.getNegotiationToId());
                if (0 < n2) {
                    this.negotiationStart(n2, diplomacyActionResponse.getNegotiationToId(), n);
                    break;
                }
                this.diplomacyActionRequesting(false);
                break;
            }
            case 5: {
                this.storeActionRequest(gameMessage.getFromId(), diplomacyActionResponse.getNegotiationToId());
                break;
            }
            case 2: {
                GameCommandUtil.breakWith(this.gameDataV, n, diplomacyActionResponse.getNegotiationToId(), false, arrayList);
                this.negotiationDaimyoIds.remove(diplomacyActionResponse.getNegotiationToId());
                this.gameDataV.update();
                this.diplomacyActionRequesting(false);
                break;
            }
            case 3: {
                GameCommandUtil.enemy(this.gameDataV, n, diplomacyActionResponse.getNegotiationToId(), arrayList);
                this.negotiationDaimyoIds.remove(diplomacyActionResponse.getNegotiationToId());
                this.gameDataV.update();
                this.diplomacyActionRequesting(false);
                break;
            }
            case 4: {
                if (this.gameDataV.getWorld().getKingFamilyId() == n) {
                    GameCommandUtil.toubatsu(this.gameDataV, diplomacyActionResponse.getNegotiationToId(), arrayList);
                }
                this.negotiationDaimyoIds.remove(diplomacyActionResponse.getNegotiationToId());
                this.gameDataV.update();
                this.diplomacyActionRequesting(false);
                break;
            }
            case 6: {
                this.clientQueue.poll();
                this.diplomacyActionRequesting(true);
            }
        }
        this.sendNoticesByDaimyoId(arrayList);
    }

    protected void negotiationStart(int n, int n2, int n3) {
        this.post.send(new GameMessage(27, this.id, n, 3, new NegotiationStartRequest(n2, n3)));
        this.status = 6;
    }

    protected void negotiationStartResponseReceive(GameMessage gameMessage) {
        NegotiationStartResponse negotiationStartResponse = (NegotiationStartResponse)gameMessage.getPayload();
        if (negotiationStartResponse.isContinuous()) {
            int n = FlowControler.getInstance().getPlayerId(negotiationStartResponse.getTargetDaimyoId());
            this.negotiationActionRequest(n, new NegotiationAction(true, negotiationStartResponse.getTargetDaimyoId(), negotiationStartResponse.getSelfDaimyoId()));
        } else {
            int n = FlowControler.getInstance().getPlayerId(negotiationStartResponse.getTargetDaimyoId());
            int n2 = FlowControler.getInstance().getPlayerId(negotiationStartResponse.getSelfDaimyoId());
            DaimyoV daimyoV = (DaimyoV)this.gameDataV.getDaimyos().get(negotiationStartResponse.getSelfDaimyoId());
            Notice notice = GameNoticeCreator.negotiationRefused(daimyoV);
            this.messageStart(n, notice);
            this.negotiationResultNotice(n, n2, false, negotiationStartResponse.getTargetDaimyoId(), negotiationStartResponse.getSelfDaimyoId());
        }
    }

    protected void storeActionRequest(int n, int n2) {
        this.post.send(new GameMessage(25, this.id, n, 3, new StoreActionRequest(n2)));
        this.status = 32;
    }

    protected void storeActionReceive(GameMessage gameMessage) {
        StoreActionResponse storeActionResponse = (StoreActionResponse)gameMessage.getPayload();
        for (StoreAction storeAction : storeActionResponse.getStoreActions()) {
            if (storeAction == null) continue;
            ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
            int n = FlowControler.getInstance().getDaimyoId(gameMessage.getFromId());
            GameCommandUtil.reflectActions(this.gameDataV, storeAction, n, arrayList);
        }
        this.gameDataV.update();
        this.diplomacyActionRequesting(false);
    }

    protected void negotiationActionRequest(int n, NegotiationAction negotiationAction) {
        negotiationAction.setSequenceNumber(negotiationAction.getSequenceNumber() + 1);
        this.post.send(new GameMessage(29, this.id, n, 3, new NegotiationActionRequest(negotiationAction)));
        this.status = 7;
    }

    protected void negotiationActionReceive(GameMessage gameMessage) {
        NegotiationActionResponse negotiationActionResponse = (NegotiationActionResponse)gameMessage.getPayload();
        NegotiationAction negotiationAction = negotiationActionResponse.getNegotiationAction();
        int n = FlowControler.getInstance().getPlayerId(negotiationAction.getSelfEntry().getDaimyoId());
        int n2 = FlowControler.getInstance().getPlayerId(negotiationAction.getTargetEntry().getDaimyoId());
        if (n != 100 && n2 != 100 && 5 <= negotiationAction.getSequenceNumber()) {
            negotiationAction.setContinuous(false);
            negotiationAction.setAgreement(false);
        }
        if (negotiationAction.isContinuous()) {
            NegotiationAction negotiationAction2 = NegotiationAction.reverse(negotiationAction);
            this.negotiationActionRequest(n2, negotiationAction2);
        } else if (negotiationAction.isAgreement()) {
            Notice notice = GameNoticeCreator.negotiationAgreement();
            this.messageStart(n, notice);
            this.messageStart(n2, notice);
            ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
            GameCommandUtil.reflectActions(this.gameDataV, negotiationAction, arrayList);
            this.sendNoticesByDaimyoId(arrayList);
            this.gameDataV.update();
            this.negotiationResultNotice(n, n2, true, negotiationAction.getSelfEntry().getDaimyoId(), negotiationAction.getTargetEntry().getDaimyoId());
        } else {
            Notice notice = GameNoticeCreator.negotiationBreak();
            this.messageStart(n, notice);
            this.messageStart(n2, notice);
            this.negotiationResultNotice(n, n2, false, negotiationAction.getSelfEntry().getDaimyoId(), negotiationAction.getTargetEntry().getDaimyoId());
        }
    }

    protected void negotiationResultNotice(int n, int n2, boolean bl, int n3, int n4) {
        this.post.send(new GameMessage(31, this.id, n, 3, new NegotiationResultRequest(bl, n4)));
        this.post.send(new GameMessage(31, this.id, n2, 3, new NegotiationResultRequest(bl, n3)));
        this.responsedClients.clear();
        this.responsedClients.put(n, false);
        this.responsedClients.put(n2, false);
        this.status = 8;
    }

    protected void negotiationResultReceive(GameMessage gameMessage) {
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.diplomacyActionRequesting(false);
        }
    }

    protected void tacticsPreStart() {
        ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
        GameTacticsUtil.updateBeforeSprint(this.gameDataV, arrayList);
        this.sendNoticesByDaimyoId(arrayList);
        this.tacticsStart();
    }

    protected void tacticsStart() {
        this.tacticsActions.clear();
        this.commonStart(33, 9, new TacticsPhaseRequest());
    }

    protected void tacticsStartResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 14);
    }

    private void tacticsActionRequesting() {
        this.refreshResponsedClients(true);
        for (int n : this.connectedClients) {
            int n2 = FlowControler.getInstance().getDaimyoId(n);
            if (!GameCommandUtil.canTactics(this.gameDataV, n2)) continue;
            this.responsedClients.put(n, false);
            this.post.send(new GameMessage(35, this.id, n, 3, new TacticsActionRequest()));
        }
        this.status = 10;
    }

    protected void tacticsActionReceive(GameMessage gameMessage) {
        TacticsActionResponse tacticsActionResponse = (TacticsActionResponse)gameMessage.getPayload();
        TacticsAction tacticsAction = tacticsActionResponse.getTacticsAction();
        this.tacticsActions.put(tacticsAction.getDaimyoId(), tacticsAction);
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            TacticsAction tacticsAction2 = new TacticsAction(0);
            GameTacticsUtil.initTacticsAction(this.gameDataV, 0, tacticsAction2);
            GameTacticsUtil.movePirate(this.gameDataV, tacticsAction2);
            this.tacticsActions.put(0, tacticsAction2);
            this.tacticsResultStart();
        }
    }

    protected void tacticsResultStart() {
        this.tacticsActionEntries.clear();
        this.tacticsActionNewEntries.clear();
        for (TacticsAction object : this.tacticsActions.values()) {
            this.tacticsActionNewEntries.addAll(object.getCommandNewMap().values());
            this.tacticsActionEntries.addAll(object.getCommandMap().values());
        }
        this.tacticsActions.clear();
        GameTacticsUtil.setSpeed(this.gameDataV, this.tacticsActionEntries);
        this.tacticsActionEntries.sort((tacticsActionEntry, tacticsActionEntry2) -> tacticsActionEntry2.getSpeed() - tacticsActionEntry.getSpeed());
        this.tacticsActionEntries.add(TacticsActionEntry.commandBattle());
        ArrayList arrayList = new ArrayList();
        for (TacticsActionEntry tacticsActionEntry3 : this.tacticsActionNewEntries) {
            GameTacticsUtil.reflectAction(this.gameDataV, tacticsActionEntry3, (List<Pair<Integer, Notice>>)arrayList);
        }
        this.gameDataV.update();
        this.tacticsResult();
    }

    protected void tacticsResult() {
        block2: {
            while (!this.tacticsActionEntries.isEmpty()) {
                TacticsActionEntry tacticsActionEntry = this.tacticsActionEntries.get(0);
                this.tacticsActionEntries.remove(0);
                if (tacticsActionEntry.getCommandType() != 6 && !this.gameDataV.getUnits().containsKey(tacticsActionEntry.getUnitId())) continue;
                ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
                this.tacticsResult = GameTacticsUtil.reflectAction(this.gameDataV, tacticsActionEntry, arrayList);
                this.sendNoticesByDaimyoId(arrayList);
                this.gameDataV.update();
                if (this.isResultReflect(this.tacticsResult)) {
                    this.tacticsResultRequesting(this.tacticsResult);
                    break block2;
                }
                this.reflectAction(this.tacticsResult);
            }
            this.gameDataV.update();
            this.tacticsResultRequesting(null);
        }
    }

    protected void tacticsResultRequesting(TacticsResult tacticsResult) {
        this.commonStart(37, 11, new TacticsResultRequest(tacticsResult));
    }

    private boolean isResultReflect(TacticsResult tacticsResult) {
        GameClient gameClient = FlowControler.getInstance().getPlayerClient();
        return GameTacticsUtil.isResultReflect(this.gameDataV, gameClient.getDaimyoV(), tacticsResult);
    }

    private void reflectAction(TacticsResult tacticsResult) {
        if (tacticsResult != null) {
            ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
            GameTacticsUtil.reflectAction(this.gameDataV, tacticsResult, arrayList);
            this.sendNoticesByDaimyoId(arrayList);
            this.gameDataV.update();
        }
    }

    protected void tacticsResultResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 0, () -> {
            this.reflectAction(this.tacticsResult);
            this.tacticsResult = null;
            if (!this.tacticsActionEntries.isEmpty()) {
                this.tacticsResult();
            } else {
                ArrayList<Pair<Integer, Notice>> arrayList = new ArrayList<Pair<Integer, Notice>>();
                GameTacticsUtil.updateBySprint(this.gameDataV, arrayList);
                this.sendNoticesByDaimyoId(arrayList);
                this.tacticsEndRequesting();
            }
        });
    }

    protected void tacticsEndRequesting() {
        this.commonStart(39, 22, null);
    }

    protected void tacticsEndReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 0, () -> {
            WorldDataV worldDataV = this.gameDataV.getWorld();
            worldDataV.setDay(worldDataV.getDay() + 10);
            if (worldDataV.getDay() > 30) {
                this.tacticsEnd();
            } else {
                this.tacticsStart();
            }
        });
    }

    protected void tacticsEnd() {
        this.IntervalActionRequest();
    }

    protected void IntervalActionRequest() {
        this.commonStart(49, 27, null);
    }

    protected void IntervalActionResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 26, () -> this.domesticPreStart());
    }

    protected void gameFinalRequest(int n) {
        this.commonStart(51, 29, new GameFinalRequest(n));
    }

    protected void gameFinalResponseReceive(GameMessage gameMessage) {
        this.commonStartResponseReceive(gameMessage, 28, null);
    }

    protected void messageStart(int n, Notice notice) {
        this.pairingKey += GameUtil.getRandom(1, 5);
        GameMessage gameMessage = new GameMessage(98, this.id, n, 3, new MessageNotice(notice));
        gameMessage.setPairingKey(this.pairingKey);
        this.post.send(gameMessage);
        this.messageSend.add(this.pairingKey);
    }

    protected void messageStartAll(Notice notice) {
        this.connectedClients.forEach(n -> this.messageStart((int)n, notice));
    }

    private void updateClientQueue() {
        this.clientQueue.clear();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.connectedClients);
        arrayList.sort((n, n2) -> this.getPriority((int)n2) - this.getPriority((int)n));
        arrayList.forEach(n -> this.clientQueue.offer((Integer)n));
    }

    private int getPriority(int n) {
        DaimyoV daimyoV;
        int n2 = FlowControler.getInstance().getDaimyoId(n);
        if (this.gameDataV != null && (daimyoV = (DaimyoV)this.gameDataV.getDaimyos().get(n2)) != null) {
            return daimyoV.getFame() * 1000 + daimyoV.getImpact();
        }
        return 0;
    }

    protected void commonStart(int n, int n3, GameMessagePayload gameMessagePayload) {
        this.connectedClients.forEach(n2 -> this.post.send(new GameMessage(n, this.id, (int)n2, 3, gameMessagePayload)));
        this.refreshResponsedClients();
        this.status = n3;
    }

    protected void commonStartResponseReceive(GameMessage gameMessage, int n) {
        this.commonStartResponseReceive(gameMessage, n, null);
    }

    protected void commonStartResponseReceive(GameMessage gameMessage, int n, Runnable runnable) {
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.updateClientQueue();
            this.status = n;
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    protected void refreshResponsedClients() {
        this.refreshResponsedClients(false);
    }

    protected void refreshResponsedClients(boolean bl) {
        this.responsedClients.clear();
        this.connectedClients.forEach(n -> this.responsedClients.put((Integer)n, bl));
    }

    public GameServerSetting getGameServerSetting() {
        GameServerSetting gameServerSetting = new GameServerSetting(this.id);
        gameServerSetting.getConnectedClients().addAll(this.connectedClients);
        return gameServerSetting;
    }

    public void reset(GameDataV gameDataV, SaveData saveData) {
        GameServerSetting gameServerSetting = saveData.getGameServerSetting();
        this.gameDataV = gameDataV;
        this.gameAiData = this.gameDataV.getGameAIData();
        this.gameData = this.gameDataV.getGameData();
        this.scenario = new Scenario(saveData.getName(), saveData.getTimestamp(), saveData.getScenario(), this.gameDataV);
        this.id = gameServerSetting.getId();
        this.status = 31;
        this.clientQueue.clear();
        this.connectedClients.clear();
        this.connectedClients.addAll(gameServerSetting.getConnectedClients());
        this.domesticActions.clear();
        this.responsedClients.clear();
    }
}

