/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.server;

import game.sengoku.common.GameUtil;
import game.sengoku.data.AIType;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.data.Scenario;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.GameDebugUtil;
import game.sengoku.game.Notice;
import game.sengoku.main.FlowControler;
import game.sengoku.server.GameMessage;
import game.sengoku.server.PostBox;
import game.sengoku.server.entity.GameDataRequest;
import game.sengoku.server.entity.GameDataResponse;
import game.sengoku.server.entity.GameJoinRequest;
import game.sengoku.server.entity.GameJoinRequestAi;
import game.sengoku.server.entity.GameJoinResponse;
import game.sengoku.server.entity.GameMessagePayload;
import game.sengoku.server.entity.GameSaveDataResponse;
import game.sengoku.server.entity.GameSaveRequest;
import game.sengoku.server.entity.GameSaveResponse;
import game.sengoku.server.entity.GameStartRequestServer;
import game.sengoku.server.entity.MessageNotice;
import game.sengoku.server.entity.SelectDaimyoResponse;
import game.sengoku.server.entity.SelectLoadRequest;
import game.sengoku.server.entity.SelectLoadResponse;
import game.sengoku.server.entity.SelectScenarioRequest;
import game.sengoku.server.entity.SelectScenarioResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class GameCenterServer {
    public static final int GAME_CENTER_SERVER_ID = 1;
    public static final int GAME_JOIN_REQUEST_WAIT = 1;
    public static final int GAME_JOIN_REQUEST_WAIT_AI = 24;
    public static final int SELECT_SCENARIO_RESPONSE_WAIT = 21;
    public static final int SELECT_DAIMYO_RESPONSE_WAIT = 22;
    public static final int SELECT_LOAD_RESPONSE_WAIT = 23;
    public static final int GAME_START_RESPONSE_WAIT = 2;
    public static final int GAME_DATA_RESPONSE_WAIT = 25;
    private int id = 0;
    private int status = 0;
    private PostBox post = null;
    private Map<Integer, Boolean> joinedMap = null;
    private Set<Integer> connectedClients = null;
    private Map<Integer, Boolean> responsedClients = null;
    private Queue<Integer> clientQueue = null;
    private Set<Integer> messageSend = null;
    private GameData gameData;
    private GameAIData gameAiData;
    private GameDataV gameDataV;
    private Scenario scenario;
    private boolean isNewFile;
    private String fileName;

    public GameCenterServer(int n, PostBox postBox) {
        this.id = n;
        this.post = postBox;
        this.connectedClients = new HashSet<Integer>();
        this.responsedClients = new HashMap<Integer, Boolean>();
        this.clientQueue = new LinkedList<Integer>();
        this.messageSend = new HashSet<Integer>();
    }

    public int getId() {
        return this.id;
    }

    public void init() {
        this.gameData = GameUtil.loadData();
        this.gameAiData = GameUtil.loadAIData();
        for (AIType aIType : this.gameAiData.getAiTypes().values()) {
            GameCommandUtil.initAiType(this.gameData, aIType);
        }
        this.status = 1;
    }

    public void update() {
        GameDebugUtil.printCenterServerStatus(this.id, this.status);
        if (!this.messageSend.isEmpty()) {
            this.receiveMessage();
            return;
        }
        switch (this.status) {
            case 1: {
                this.receive();
                break;
            }
            case 24: {
                this.receive();
                break;
            }
            case 21: {
                this.receive();
                break;
            }
            case 22: {
                this.receive();
                break;
            }
            case 23: {
                this.receive();
                break;
            }
            case 2: {
                this.receive();
                break;
            }
            case 25: {
                this.receive();
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + this.status);
            }
        }
    }

    private void receiveMessage() {
        GameMessage gameMessage;
        while ((gameMessage = this.post.receive(this.id, 99)) != null) {
            this.messageSend.remove(gameMessage.getFromId());
        }
    }

    private void receive() {
        while (this.receiveOnce()) {
        }
    }

    private boolean receiveOnce() {
        GameMessage gameMessage = this.post.receive(this.id);
        if (gameMessage == null) {
            return false;
        }
        switch (gameMessage.getMessageId()) {
            case 1: {
                this.gameJoin(gameMessage);
                break;
            }
            case 2: {
                this.gameJoinAI(gameMessage);
                break;
            }
            case 12: {
                this.gameStartReceive(gameMessage);
                break;
            }
            case 6: {
                this.selectScenarioReceive(gameMessage);
                break;
            }
            case 8: {
                this.selectDaimyoReceive(gameMessage);
                break;
            }
            case 10: {
                this.selectLoadReceive(gameMessage);
                break;
            }
            case 43: {
                this.gameSaveDataRequestReceive(gameMessage);
                break;
            }
            case 45: {
                this.gameSaveRequestReceive(gameMessage);
                break;
            }
            case 48: {
                this.gameDataResponseReceive(gameMessage);
                break;
            }
            case 42: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new RuntimeException("invalid message id = " + gameMessage.getMessageId());
            }
        }
        return true;
    }

    protected void gameJoin(GameMessage gameMessage) {
        this.connectedClients.clear();
        this.connectedClients.add(gameMessage.getFromId());
        this.post.send(new GameMessage(3, this.id, gameMessage.getFromId(), 3, new GameJoinResponse(this.gameData, this.gameAiData)));
        GameJoinRequest gameJoinRequest = (GameJoinRequest)gameMessage.getPayload();
        if (!gameJoinRequest.isContinus()) {
            this.selectScenarioRequeste();
        } else {
            this.selectLoadRequest();
        }
    }

    protected void selectScenarioRequeste() {
        int n = 100;
        ArrayList<Scenario> arrayList = new ArrayList<Scenario>();
        GameUtil.loadScenarios(arrayList);
        arrayList.forEach(scenario -> {
            GameDataV gameDataV = scenario.getData();
            gameDataV.setGameData(this.gameData);
            gameDataV.setGameAIData(this.gameAiData);
            gameDataV.setReference();
            gameDataV.update();
        });
        this.post.send(new GameMessage(5, this.id, n, 3, new SelectScenarioRequest(arrayList)));
        this.status = 21;
    }

    protected void selectScenarioReceive(GameMessage gameMessage) {
        SelectScenarioResponse selectScenarioResponse = (SelectScenarioResponse)gameMessage.getPayload();
        if (selectScenarioResponse.isCancel()) {
            this.status = 1;
        } else {
            this.selectDaimyoRequeste(selectScenarioResponse.getScenario());
        }
    }

    protected void selectDaimyoRequeste(Scenario scenario) {
        this.scenario = scenario;
        this.gameDataV = scenario.getData();
        int n = 100;
        this.post.send(new GameMessage(7, this.id, n, 3, null));
        this.status = 22;
    }

    protected void selectDaimyoReceive(GameMessage gameMessage) {
        SelectDaimyoResponse selectDaimyoResponse = (SelectDaimyoResponse)gameMessage.getPayload();
        if (selectDaimyoResponse.isCancel()) {
            this.selectScenarioRequeste();
        } else {
            this.createJoinedMap(this.gameDataV);
            this.joinedMap.put(selectDaimyoResponse.getDaimyoId(), true);
            FlowControler.getInstance().createAIPlayers(this.gameDataV, selectDaimyoResponse.getDaimyoId());
            this.status = 24;
        }
    }

    protected void selectLoadRequest() {
        int n = 100;
        ArrayList<SaveDataInterface> arrayList = new ArrayList<SaveDataInterface>();
        GameUtil.loadSaves(arrayList);
        this.post.send(new GameMessage(9, this.id, n, 3, new SelectLoadRequest(arrayList)));
        this.status = 23;
    }

    protected void selectLoadReceive(GameMessage gameMessage) {
        SelectLoadResponse selectLoadResponse = (SelectLoadResponse)gameMessage.getPayload();
        if (selectLoadResponse.isCancel()) {
            this.status = 1;
            return;
        }
        this.gameDataV = selectLoadResponse.getSaveData().getData();
        this.gameDataV.setGameData(this.gameData);
        this.gameDataV.setGameAIData(this.gameAiData);
        this.gameDataV.setReference();
        this.gameDataV.update();
        this.createJoinedMap(this.gameDataV);
        this.joinedMap.put(100, true);
        FlowControler.getInstance().resetAIPlayers(this.gameDataV, selectLoadResponse.getSaveData());
        this.status = 24;
    }

    protected void gameJoinAI(GameMessage gameMessage) {
        GameJoinRequestAi gameJoinRequestAi = (GameJoinRequestAi)gameMessage.getPayload();
        this.joinedMap.put(gameJoinRequestAi.getPlayer().getDaimyoId(), true);
        this.connectedClients.add(gameMessage.getFromId());
        this.post.send(new GameMessage(4, this.id, gameMessage.getFromId(), 3, new GameJoinResponse(this.gameData, this.gameAiData)));
        if (this.joinedMap.values().parallelStream().allMatch(bl -> bl)) {
            this.responsedClients.clear();
            this.gameStart(this.scenario);
        }
    }

    protected void gameStart(Scenario scenario) {
        this.post.send(new GameMessage(80, this.id, 2, 3, new GameStartRequestServer(scenario, this.gameDataV, this.connectedClients)));
        this.status = 2;
    }

    protected void gameStartReceive(GameMessage gameMessage) {
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.updateClientQueue();
        }
    }

    private void gameSaveDataRequestReceive(GameMessage gameMessage) {
        this.gameSaveDataResponse(gameMessage.getFromId());
    }

    protected void gameSaveDataResponse(int n) {
        ArrayList<SaveDataInterface> arrayList = new ArrayList<SaveDataInterface>();
        GameUtil.loadSaves(arrayList);
        this.post.send(new GameMessage(44, this.id, n, 3, new GameSaveDataResponse(arrayList)));
    }

    public void gameSaveRequestReceive(GameMessage gameMessage) {
        GameSaveRequest gameSaveRequest = (GameSaveRequest)gameMessage.getPayload();
        if (gameSaveRequest.isCancel()) {
            this.gameSaveResponse(gameMessage.getFromId(), true, null);
        } else {
            this.isNewFile = gameSaveRequest.isNewFile();
            this.fileName = gameSaveRequest.getSaveData();
            this.gameDataRequest(gameMessage.getFromId());
        }
    }

    private void gameDataRequest(int n) {
        this.post.send(new GameMessage(47, this.id, 2, 3, new GameDataRequest(n)));
        this.status = 25;
    }

    protected void gameDataResponseReceive(GameMessage gameMessage) {
        GameDataResponse gameDataResponse = (GameDataResponse)gameMessage.getPayload();
        List<PlayerV> list = FlowControler.getInstance().getPlayers();
        Map<Integer, Integer> map = FlowControler.getInstance().getPlayerStatus();
        String string = null;
        string = this.isNewFile ? GameUtil.getNewSaveName() : this.fileName;
        GameUtil.saveGameData(string, gameDataResponse.getScenario(), gameDataResponse.getGameDataV(), list, gameDataResponse.getSetting(), map);
        this.gameSaveResponse(gameDataResponse.getId(), false, string);
    }

    private void gameSaveResponse(int n, boolean bl, String string) {
        this.post.send(new GameMessage(46, this.id, n, 3, new GameSaveResponse(bl, string)));
    }

    protected void messageStart(int n, Notice notice) {
        this.post.send(new GameMessage(98, this.id, n, 3, new MessageNotice(notice)));
        this.messageSend.add(n);
    }

    protected void messageStartAll(Notice notice) {
        this.connectedClients.forEach(n -> {
            this.post.send(new GameMessage(98, this.id, (int)n, 3, new MessageNotice(notice)));
            this.messageSend.add((Integer)n);
        });
    }

    private void updateClientQueue() {
        this.clientQueue.clear();
        this.connectedClients.forEach(n -> this.clientQueue.offer((Integer)n));
    }

    protected void commonStart(int n, int n3, GameMessagePayload gameMessagePayload) {
        this.connectedClients.forEach(n2 -> this.post.send(new GameMessage(n, this.id, (int)n2, 3, gameMessagePayload)));
        this.refreshResponsedClients();
        this.status = n3;
    }

    protected void commonStartResponseReceive(GameMessage gameMessage, int n) {
        this.responsedClients.put(gameMessage.getFromId(), true);
        if (this.responsedClients.values().parallelStream().allMatch(bl -> bl)) {
            this.refreshResponsedClients();
            this.updateClientQueue();
            this.status = n;
        }
    }

    protected void refreshResponsedClients() {
        this.responsedClients.clear();
        this.connectedClients.forEach(n -> this.responsedClients.put((Integer)n, false));
    }

    protected void createJoinedMap(GameDataV gameDataV) {
        this.joinedMap = new HashMap<Integer, Boolean>();
        for (DaimyoV daimyoV : gameDataV.getDaimyos().values()) {
            this.joinedMap.put(daimyoV.getId(), false);
        }
    }
}

