/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.base.common.Tuple4;
import game.sengoku.data.UnitEffect;
import game.sengoku.data.UnitV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TacticsResult {
    private int daimyoId = 0;
    private int unitId = 0;
    private int type = 0;
    private int moveToSpotId = 0;
    private int shotToSpotId = 0;
    private int recruitMoney = 0;
    private int recruitArmy = 0;
    private int techniqueId = 0;
    private Map<Integer, Integer> moralPlus = null;
    private Map<Integer, List<UnitEffect>> effectPlus = null;
    private List<Tuple4<Integer, Integer, Map<Integer, Integer>, Integer>> damageList = new ArrayList<Tuple4<Integer, Integer, Map<Integer, Integer>, Integer>>();
    private Set<Integer> lostUnitIds = null;
    private boolean battle = false;
    private Map<Integer, Boolean> stealth = null;
    private Map<Integer, Boolean> confused = null;

    public TacticsResult() {
        this.effectPlus = new HashMap<Integer, List<UnitEffect>>();
        this.moralPlus = new HashMap<Integer, Integer>();
        this.lostUnitIds = new HashSet<Integer>();
        this.stealth = new HashMap<Integer, Boolean>();
        this.confused = new HashMap<Integer, Boolean>();
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int n) {
        this.unitId = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getMoveToSpotId() {
        return this.moveToSpotId;
    }

    public void setMoveToSpotId(int n) {
        this.moveToSpotId = n;
    }

    public int getShotToSpotId() {
        return this.shotToSpotId;
    }

    public void setShotToSpotId(int n) {
        this.shotToSpotId = n;
    }

    public int getRecruitMoney() {
        return this.recruitMoney;
    }

    public void setRecruitMoney(int n) {
        this.recruitMoney = n;
    }

    public int getRecruitArmy() {
        return this.recruitArmy;
    }

    public void setRecruitArmy(int n) {
        this.recruitArmy = n;
    }

    public int getTechniqueId() {
        return this.techniqueId;
    }

    public void setTechniqueId(int n) {
        this.techniqueId = n;
    }

    public Map<Integer, Integer> getMoralPlus() {
        return this.moralPlus;
    }

    public Map<Integer, List<UnitEffect>> getEffectPlus() {
        return this.effectPlus;
    }

    public Set<Integer> getDamageKeySet() {
        Set<Integer> set = this.damageList.parallelStream().mapToInt(tuple4 -> (Integer)tuple4.getFirst()).boxed().collect(Collectors.toSet());
        return set;
    }

    public List<Tuple4<Integer, Integer, Map<Integer, Integer>, Integer>> getDamageList() {
        return this.damageList;
    }

    public void addDamage(UnitV unitV, int n, int n2) {
        Tuple4 tuple42;
        int n3 = 1;
        if (0 < unitV.getUnit().getGun()) {
            n3 *= 2;
        }
        if (0 < unitV.getUnit().getHorse()) {
            n3 *= 3;
        }
        if ((tuple42 = (Tuple4)this.damageList.stream().filter(tuple4 -> ((Integer)tuple4.getFirst()).intValue() == unitV.getId()).findFirst().orElse(null)) != null) {
            Map map = (Map)tuple42.getThird();
            if (!map.containsKey(n2)) {
                map.put(n2, n3);
            } else {
                map.put(n2, n3 *= ((Integer)map.get(n2)).intValue());
            }
        } else {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            hashMap.put(n2, n3);
            this.damageList.add(new Tuple4(unitV.getId(), n, hashMap, 1));
        }
    }

    public boolean isBattle() {
        return this.battle;
    }

    public void setBattle(boolean bl) {
        this.battle = bl;
    }

    public Map<Integer, Boolean> getStealth() {
        return this.stealth;
    }

    public Map<Integer, Boolean> getConfused() {
        return this.confused;
    }

    public String toString() {
        return "TacticsResult [daimyoId=" + this.daimyoId + ", unitId=" + this.unitId + ", type=" + this.type + ", moveToSpotId=" + this.moveToSpotId + ", shotToSpotId=" + this.shotToSpotId + ", recruitMoney=" + this.recruitMoney + ", recruitArmy=" + this.recruitArmy + ", techniqueId=" + this.techniqueId + ", moralPlus=" + this.moralPlus + ", effectPlus=" + this.effectPlus + ", damageList=" + this.damageList + ", lostUnitIds=" + this.lostUnitIds + ", battle=" + this.battle + ", stealth=" + this.stealth + ", confused=" + this.confused + "]";
    }
}

