/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.sengoku.common.AudioUtil;
import game.sengoku.data.MapPosition;
import game.sengoku.data.SpotV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameUnitUtil;
import game.sengoku.game.SceneMapCommon;
import game.sengoku.game.tactics.TacticsResult;
import game.sengoku.window.AnimationSprite;
import game.sengoku.window.DamageSprite;
import game.sengoku.window.UnitSprite;
import game.sengoku.window.WindowTacticsResult;
import java.util.ArrayList;
import java.util.List;

public class SceneTacticsResult
extends SceneMapCommon {
    private static final int COUNTER_MAX = 30;
    private TacticsResult tacticsResult;
    private int counter = 0;
    private int beforeCounter = 0;
    private boolean damaging = false;
    private List<AnimationSprite> animes;
    private List<DamageSprite> damages;
    private int seId = 0;
    private WindowTacticsResult windowTacticsResult;

    public SceneTacticsResult() {
        this.enableDrag = false;
        this.animes = new ArrayList<AnimationSprite>();
        this.damages = new ArrayList<DamageSprite>();
        this.windowTacticsResult = new WindowTacticsResult(20, 550, 1000, 560, 30, this.getDaimyo().getId(), this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.createSpotSymbols();
        this.createBuildSymbols();
        this.createConflicts();
        this.createUnits();
        this.info.setVisible(false);
        this.setReceiveNotice(true);
        this.animes.clear();
        this.damages.clear();
        this.counter = 0;
        this.beforeCounter = 0;
        this.damaging = false;
        this.tacticsResult = this.getGameTemp().getTacticsResult();
        this.windowTacticsResult.setTacticsResult(this.tacticsResult);
        if (this.tacticsResult != null) {
            switch (this.tacticsResult.getType()) {
                case 2: {
                    UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(this.tacticsResult.getUnitId());
                    this.shift(unitV);
                    MapPosition mapPosition = unitV.getSpot().getPosition();
                    MapPosition mapPosition2 = ((SpotV)this.getGameDataV().getSpots().get(this.tacticsResult.getMoveToSpotId())).getPosition();
                    int n = GameUnitUtil.calcDegree(mapPosition2, mapPosition);
                    UnitSprite unitSprite = (UnitSprite)this.units.get(this.tacticsResult.getUnitId());
                    if (unitSprite == null) {
                        MapPosition mapPosition3 = unitV.getSpot().getPosition();
                        unitSprite = new UnitSprite(mapPosition3.getX() + x - 12, mapPosition3.getY() + y - 12, 200, this.getDaimyo(), unitV);
                        this.units.put(unitV.getId(), unitSprite);
                    }
                    unitSprite.setFixed(true);
                    unitSprite.setDegree(n);
                    break;
                }
                case 3: {
                    Technique technique = (Technique)this.getGameData().getTechniques().get(this.tacticsResult.getTechniqueId());
                    UnitV unitV = (UnitV)this.getGameDataV().getUnits().get(this.tacticsResult.getUnitId());
                    this.shift(unitV);
                    int n = unitV.getSpotId();
                    if (technique == null) break;
                    switch (technique.getKind()) {
                        case 1: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 2: {
                            n = this.tacticsResult.getShotToSpotId();
                        }
                    }
                    SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(n);
                    if (spotV != null && technique.getAnimation() != null && !"".equals(technique.getAnimation())) {
                        MapPosition mapPosition = spotV.getPosition();
                        this.animes.add(new AnimationSprite(mapPosition.getX() + x - 25, mapPosition.getY() + y - 35, 200, technique.getAnimation()));
                    }
                    this.seId = technique.getSe();
                    break;
                }
                case 6: {
                    this.counter = 30;
                }
            }
        }
    }

    private void shift(UnitV unitV) {
        SpotV spotV = unitV.getSpot();
        if (spotV != null) {
            MapPosition mapPosition = spotV.getPosition();
            this.shift(mapPosition.getX(), mapPosition.getY());
        }
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.tacticsResult = null;
    }

    @Override
    public void update() {
        super.update();
        if (this.messageWindow.isVisible()) {
            return;
        }
        this.windowTacticsResult.update();
        if (this.beforeCounter < 10) {
            ++this.beforeCounter;
            return;
        }
        this.damages.forEach(damageSprite -> damageSprite.update());
        this.animes.forEach(animationSprite -> animationSprite.update());
        if (this.tacticsResult != null) {
            if (this.damaging) {
                if (this.counter == 2 && this.damages.size() > 0) {
                    AudioUtil.sePlay(18);
                }
            } else {
                switch (this.tacticsResult.getType()) {
                    case 2: {
                        UnitSprite unitSprite = (UnitSprite)this.units.get(this.tacticsResult.getUnitId());
                        MapPosition mapPosition = unitSprite.getUnit().getSpot().getPosition();
                        MapPosition mapPosition2 = ((SpotV)this.getGameDataV().getSpots().get(this.tacticsResult.getMoveToSpotId())).getPosition();
                        unitSprite.setX(((30 - this.counter) * mapPosition.getX() + this.counter * mapPosition2.getX()) / 30 + x);
                        unitSprite.setY(((30 - this.counter) * mapPosition.getY() + this.counter * mapPosition2.getY()) / 30 + y);
                        break;
                    }
                    case 3: {
                        if (this.counter != 2) break;
                        AudioUtil.sePlay(this.seId);
                        this.seId = 0;
                        break;
                    }
                }
            }
        }
        if (!this.isMessageExists()) {
            ++this.counter;
        }
        if (30 < this.counter) {
            if (this.damaging) {
                this.tacticsResult = null;
                this.getGameTemp().setTacticsResult(null);
            } else if (this.tacticsResult != null && !this.tacticsResult.getDamageList().isEmpty()) {
                this.damaging = true;
                this.counter = 0;
                this.animes.clear();
                this.tacticsResult.getDamageList().forEach(tuple4 -> {
                    int n = (Integer)tuple4.getFirst();
                    int n2 = (Integer)tuple4.getSecond();
                    UnitSprite unitSprite = (UnitSprite)this.units.get(n);
                    if (unitSprite != null) {
                        UnitV unitV = unitSprite.getUnit();
                        this.damages.add(new DamageSprite(unitSprite.getX(), unitSprite.getY(), unitSprite.getZ() + 100, 100, 12, unitV.getTotal() * 100, unitV.getLeave(), n2));
                    }
                });
            } else {
                this.tacticsResult = null;
                this.getGameTemp().setTacticsResult(null);
            }
        }
        this.unitInfo.setVisible(false);
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.animes.forEach(animationSprite -> animationSprite.draw(this.bcontext));
        this.damages.forEach(damageSprite -> damageSprite.draw(this.bcontext));
        this.windowTacticsResult.draw(this.bcontext);
    }

    @Override
    protected void exit() {
    }
}

