/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.base.common.Tuple;
import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.MapPosition;
import game.sengoku.data.SpotV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.SceneMapCommon;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.game.tactics.TacticsActionEntry;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.UnitSprite;
import game.sengoku.window.WindowBase;
import game.sengoku.window.WindowClickable;
import game.sengoku.window.WindowCommandSelect;
import game.sengoku.window.WindowMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class SceneTacticsMenu
extends SceneMapCommon {
    public static final int MENU_UNIT = 1;
    public static final int MENU_GO_OUT = 4;
    public static final int MENU_INFO = 5;
    public static final int MENU_SPECIAL = 6;
    public static final int MENU_SYSTEM = 7;
    private static final int MENU_X = 50;
    private static final int MENU_Y = 10;
    private static final int MENU_X_INTERVAL = 85;
    private static final int SUBMENU_X_INTERVAL = 70;
    private ButtonSprite menuUnit;
    private ButtonSprite menuGoOut;
    private ButtonSprite menuInfo;
    private ButtonSprite subMenuDetail;
    private ButtonSprite subMenuRanking;
    private ButtonSprite subMenuHistory;
    private ButtonSprite menuSystem;
    private ButtonSprite commit;
    private int type = -1;
    protected WindowMessage explain;

    public SceneTacticsMenu() {
        Font font = GameFontUtil.FONT22;
        Font font2 = GameFontUtil.FONT16;
        int n = 0;
        this.menuUnit = new ButtonSprite(50 + 85 * n, 10, 2000, 80, 25, -235801635, 1768520959, font2, "\u30e6\u30cb\u30c3\u30c8", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuUnit.setPrimaryClicked(windowClickable -> this.selectMenu(1));
        this.menuUnit.setMouseEnter(windowClickable -> this.resetMessage("\u30e6\u30cb\u30c3\u30c8\u306e\u60c5\u5831\u3092\u53c2\u7167\u3057\u307e\u3059\u3002"));
        this.menuUnit.setMouseExit(windowClickable -> this.resetMessage(null));
        this.menuGoOut = new ButtonSprite(50 + 85 * ++n, 10, 2000, 80, 25, -235801635, 1768520959, font2, "\u51fa\u9663", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuGoOut.setPrimaryClicked(windowClickable -> this.selectMenu(4));
        this.menuGoOut.setMouseEnter(windowClickable -> this.resetMessage("\u30e6\u30cb\u30c3\u30c8\u3092\u51fa\u9663\u3055\u305b\u307e\u3059\u3002"));
        this.menuGoOut.setMouseExit(windowClickable -> this.resetMessage(null));
        this.menuInfo = new ButtonSprite(50 + 85 * ++n, 10, 2000, 80, 25, -235801635, 1768520959, font2, "\u60c5\u5831", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuInfo.setPrimaryClicked(windowClickable -> this.selectMenu(5));
        this.menuInfo.setMouseEnter(windowClickable -> this.resetMessage("\u5404\u7a2e\u60c5\u5831\u3092\u53c2\u7167\u3057\u307e\u3059\u3002"));
        this.menuInfo.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuDetail = new ButtonSprite(50, 60, 2000, 65, 25, -235801635, 1768520959, font2, "\u8a73\u7d30", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuDetail.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(11));
        this.subMenuDetail.setMouseEnter(windowClickable -> this.resetMessage("\u5927\u540d\u3084\u56fd\u306e\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuDetail.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuDetail.setVisible(false);
        this.subMenuRanking = new ButtonSprite(120, 60, 2000, 65, 25, -235801635, 1768520959, font2, "\u5927\u540d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuRanking.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(12));
        this.subMenuRanking.setMouseEnter(windowClickable -> this.resetMessage("\u5927\u540d\u306e\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuRanking.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuRanking.setVisible(false);
        this.subMenuHistory = new ButtonSprite(190, 60, 2000, 65, 25, -235801635, 1768520959, font2, "\u5c65\u6b74", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuHistory.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(13));
        this.subMenuHistory.setMouseEnter(windowClickable -> this.resetMessage("\u4e8b\u8c61\u5c65\u6b74\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuHistory.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuHistory.setVisible(false);
        this.menuSystem = new ButtonSprite(50 + 85 * ++n, 10, 2000, 80, 25, -235801635, 1768520959, font2, "\u30b7\u30b9\u30c6\u30e0", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuSystem.setPrimaryClicked(windowClickable -> this.selectMenu(7));
        this.commit = new ButtonSprite(50 + 85 * ++n, 10, 2000, 100, 35, -235801635, 1768520959, font, "\u5b8c\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> this.commit());
        this.commit.setMouseEnter(windowClickable -> this.resetMessage("\u884c\u8ecd\u30b3\u30de\u30f3\u30c9\u3092\u5b8c\u4e86\u3057\u307e\u3059\u3002"));
        this.commit.setMouseExit(windowClickable -> this.resetMessage(null));
        this.commit.setSoundId(4);
        this.explain = new WindowMessage(20, 550, 2000, 560, 30, 877223628, GameFontUtil.FONT16, -269422081, "");
        this.resetMessage(null);
        this.enableDrag = true;
    }

    @Override
    public void load() {
        super.load();
        this.getGameTemp().setReturnSubSceneId(1);
        this.getGameTemp().setCandidateCountryId(0);
        this.getGameTemp().setSelectedKnightId(0);
        this.getGameTemp().setSelectedSpotId(0);
        this.getGameTemp().setSelectedUnitId(0);
        this.getGameTemp().setSelectedPower(0);
        this.getGameTemp().setSelectedGun(0);
        this.getGameTemp().setSelectedHorse(0);
        this.getGameTemp().setPlunder(false);
        this.getGameTemp().setSelectedTechniqueId(0);
        this.optionUse = true;
        this.createSpotSymbols();
        this.createBuildSymbols();
        this.createConflicts();
        this.createUnits();
        this.selectMenu(-1);
        this.info.setVisible(true);
        this.unitInfo.setVisible(true);
        this.setReceiveNotice(true);
        UnitV unitV = null;
        if (this.getGameTemp().getOperationUnitId() != -1) {
            unitV = (UnitV)this.getGameDataV().getUnits().get(this.getGameTemp().getOperationUnitId());
            this.getGameTemp().setOperationUnitId(-1);
        }
        if (unitV != null) {
            SpotV spotV = unitV.getSpot();
            MapPosition mapPosition = spotV.getPosition();
            this.shift(mapPosition.getX(), mapPosition.getY(), true);
            this.commandSelect(unitV);
        }
    }

    private void selectMenu(int n) {
        this.menuSystem.setVisible(false);
        this.subMenuDetail.setVisible(false);
        this.subMenuRanking.setVisible(false);
        this.subMenuHistory.setVisible(false);
        switch (n) {
            case 1: {
                this.getGameTemp().setSubSceneId(10);
                break;
            }
            case 4: {
                this.getGameTemp().setSubSceneId(2);
                break;
            }
            case 5: {
                this.subMenuDetail.setVisible(true);
                this.subMenuRanking.setVisible(true);
                this.subMenuHistory.setVisible(true);
                this.type = n;
                break;
            }
            case 7: {
                break;
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.menuUnit.update();
        this.menuGoOut.update();
        this.menuInfo.update();
        this.subMenuDetail.update();
        this.subMenuRanking.update();
        this.subMenuHistory.update();
        this.menuSystem.update();
        this.commit.update();
        this.explain.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.menuUnit.draw(this.bcontext);
        this.menuGoOut.draw(this.bcontext);
        this.menuInfo.draw(this.bcontext);
        this.subMenuDetail.draw(this.bcontext);
        this.subMenuRanking.draw(this.bcontext);
        this.subMenuHistory.draw(this.bcontext);
        this.menuSystem.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.explain.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.setMiddleWindow(null);
        this.selectMenu(-1);
    }

    @Override
    public void selectUnit(UnitSprite unitSprite) {
        super.selectUnit(unitSprite);
        int n = unitSprite.getUnit().getSpot().getId();
        this.selectSpot(n);
    }

    private boolean isOperationed(UnitV unitV) {
        if (!this.getGameTemp().getTacticsAction().getCommandMap().containsKey(unitV.getId())) {
            return false;
        }
        TacticsActionEntry tacticsActionEntry = this.getGameTemp().getTacticsAction().getCommandMap().get(unitV.getId());
        return tacticsActionEntry.getCommandType() != 5;
    }

    @Override
    public void selectSpot(int n) {
        super.selectSpot(n);
        SpotV spotV = (SpotV)this.getGameDataV().getSpots().get(n);
        ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>> arrayList = new ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>>();
        for (UnitV unitV : spotV.getUnits()) {
            int n2;
            int n3 = n2 = this.isOperationed(unitV) ? -69579521 : -319753729;
            if (unitV.getOperationDaimyoId() != this.getDaimyo().getId()) continue;
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>(unitV.getKnight().getFullName() + "\u968a", n2, windowClickable -> {
                this.setMiddleWindow(null);
                this.commandSelect(unitV);
            }));
        }
        if (arrayList.isEmpty()) {
            if (this.canGoOut(spotV)) {
                int n4 = this.isGoOutReserved(spotV) ? -69579521 : -319753729;
                arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u51fa\u9663", n4, windowClickable -> {
                    this.setMiddleWindow(null);
                    this.goOutShootCut(spotV);
                }));
            } else {
                return;
            }
        }
        arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u30ad\u30e3\u30f3\u30bb\u30eb", -319753729, windowClickable -> this.setMiddleWindow(null)));
        WindowCommandSelect windowCommandSelect = new WindowCommandSelect(300, 100, 200, 200, arrayList);
        this.setMiddleWindow(windowCommandSelect);
    }

    private boolean isGoOutReserved(SpotV spotV) {
        return this.getGameTemp().getTacticsAction().getCommandNewMap().values().stream().anyMatch(tacticsActionEntry -> tacticsActionEntry.getSpotId() == spotV.getId());
    }

    private boolean canGoOut(SpotV spotV) {
        if (spotV.getCountryId() == 0) {
            return false;
        }
        List<Integer> list = GameTacticsUtil.getGoOutSpotIds(this.getGameDataV(), this.getDaimyo().getId(), spotV.getCountryId());
        return list.contains(spotV.getId());
    }

    protected void goOutShootCut(SpotV spotV) {
        this.getGameTemp().setCandidateCountryId(spotV.getCountryId());
        this.getGameTemp().setSubSceneId(3);
    }

    public void commandSelect(UnitV unitV) {
        if (unitV.getOperationDaimyoId() != this.getDaimyo().getId()) {
            this.setMiddleWindow(null);
            return;
        }
        ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>> arrayList = new ArrayList<Tuple<String, Integer, Consumer<WindowClickable>>>();
        if (!unitV.isBattle()) {
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u79fb\u52d5", -319753729, windowClickable -> {
                this.setMiddleWindow(null);
                this.commandMove(unitV);
            }));
        }
        if (unitV.isReleasable()) {
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u89e3\u6563", -319753729, windowClickable -> {
                this.setMiddleWindow(null);
                this.commandRelease(unitV);
            }));
        }
        Object object = unitV.getTechniqueIds().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            Technique technique = (Technique)this.getGameData().getTechniques().get(n);
            if (technique == null) continue;
            unitV.updateBattle();
            if (unitV.isBattle() && technique.getKind() != 4 || !unitV.isBattle() && technique.getKind() == 4 || 0 < unitV.getWaitTurn()) continue;
            arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>(technique.getName(), -319753729, windowClickable -> {
                this.setMiddleWindow(null);
                this.commandTecnique(unitV, technique);
            }));
        }
        if (arrayList.isEmpty()) {
            this.alert(0, "\u3053\u306e\u30e6\u30cb\u30c3\u30c8\u306b\u306f\u3001\u73fe\u5728\u3001\u547d\u4ee4\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        arrayList.add(new Tuple<String, Integer, Consumer<WindowClickable>>("\u30ad\u30e3\u30f3\u30bb\u30eb", -319753729, windowClickable -> this.setMiddleWindow(null)));
        object = new WindowCommandSelect(300, 200, 200, 200, arrayList);
        this.setMiddleWindow((WindowBase)object);
    }

    private void commandMove(UnitV unitV) {
        this.getGameTemp().getCandidateSpotIds().clear();
        List<Integer> list = GameTacticsUtil.getMoveSpotIds(this.getGameDataV(), this.getDaimyo().getId(), unitV.getSpotId());
        this.getGameTemp().getCandidateSpotIds().addAll(list);
        this.getGameTemp().setSelectedSpotId(unitV.getSpotId());
        this.getGameTemp().setSelectedUnitId(unitV.getId());
        this.getGameTemp().setCenterSpotId(unitV.getSpotId());
        this.getGameTemp().setSubSceneId(7);
    }

    private void commandRelease(UnitV unitV) {
        TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandRelease(this.getDaimyo().getId(), unitV.getId());
        this.getGameTemp().getTacticsAction().put(unitV.getId(), tacticsActionEntry);
    }

    private void commandTecnique(UnitV unitV, Technique technique) {
        TacticsActionEntry tacticsActionEntry = null;
        switch (technique.getKind()) {
            case 4: {
                tacticsActionEntry = TacticsActionEntry.commandTechniqueAttack(this.getDaimyo().getId(), unitV.getId(), technique.getId(), unitV.getSpotId());
                break;
            }
            case 1: {
                tacticsActionEntry = TacticsActionEntry.commandTechniqueEnhance(this.getDaimyo().getId(), unitV.getId(), technique.getId(), unitV.getSpotId());
                break;
            }
            case 2: {
                if (unitV.getDaimyo().getGunpowder() < technique.getGunpowder() * unitV.getLeave()) {
                    this.alert(0, "\u706b\u85ac\u304c\u8db3\u308a\u306a\u3044\u305f\u3081\u3001\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
                    return;
                }
                this.getGameTemp().setSelectedUnitId(unitV.getId());
                this.getGameTemp().setSelectedTechniqueId(technique.getId());
                this.getGameTemp().getCandidateSpotIds().clear();
                Set set = this.getGameDataV().nearbySpotIds(unitV.getSpotId(), unitV.getUnit().getVision());
                this.getGameTemp().getCandidateSpotIds().addAll(set);
                this.getGameTemp().setCenterSpotId(unitV.getSpotId());
                this.getGameTemp().setSubSceneId(8);
                return;
            }
        }
        this.getGameTemp().getTacticsAction().put(unitV.getId(), tacticsActionEntry);
    }

    private void resetMessage(String string) {
        if (string == null) {
            string = "\u4eca\u6708\u306e\u884c\u8ecd\u30b3\u30de\u30f3\u30c9\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002";
        }
        this.explain.setMessages(string);
    }

    private void commit() {
        TacticsAction tacticsAction = this.getGameTemp().getTacticsAction();
        SpotV spotV = GameTacticsUtil.alertSpot(this.getGameDataV(), this.getDaimyo(), tacticsAction);
        if (spotV == null) {
            this.getPlayerClient().tacticsActionResponse(tacticsAction);
        } else {
            MapPosition mapPosition = spotV.getPosition();
            this.shift(mapPosition.getX(), mapPosition.getY());
            this.alert(1, () -> this.getPlayerClient().tacticsActionResponse(tacticsAction), null, spotV.getName() + "\u306b\u96a3\u63a5\u3059\u308b\u5730\u70b9\u306b\u6575\u30e6\u30cb\u30c3\u30c8\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" + "\u30e6\u30cb\u30c3\u30c8\u3092\u51fa\u6483\u3055\u305b\u306a\u3051\u308c\u3070\u3001" + spotV.getName() + "\u3092\u5360\u9818\u3055\u308c\u308b\u6050\u308c\u304c\u3042\u308a\u307e\u3059\u3002", "\u3053\u306e\u307e\u307e\u547d\u4ee4\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f");
        }
    }
}

