/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.KnightV;
import game.sengoku.data.TreasureV;
import game.sengoku.game.SceneTableCommon;
import game.sengoku.game.domestic.DomesticTreasureV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowMessage;
import java.util.List;

public class SceneTreasureSelect
extends SceneTableCommon {
    protected static final int ITEM_NAME = 1;
    protected static final int ITEM_KNIGHT = 2;
    protected static final int ITEM_DOMESTIC = 3;
    protected static final int ITEM_TACTICS = 4;
    protected static final int ITEM_CULTURE = 5;
    protected WindowMessage info;
    private DomesticTreasureV dpost;

    public SceneTreasureSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.info = new WindowMessage(20, 10, 100, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, this.getDefaultMessage());
        this.dpost = new DomesticTreasureV(this.getGameDataV(), this.getPlayer());
        this.dpost.update();
    }

    protected String getDefaultMessage() {
        return "\u6240\u6709\u8005\u3092\u5909\u66f4\u3059\u308b\u5bb6\u5b9d\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    public void load() {
        super.load();
        this.dpost = new DomesticTreasureV(this.getGameDataV(), this.getPlayer());
        this.dpost.update();
    }

    protected int[] getWriterItems() {
        return new int[]{1, 2, 3, 4, 5};
    }

    @Override
    protected int getTopY() {
        return 50;
    }

    @Override
    protected int getRowMax() {
        return 15;
    }

    @Override
    protected int getColumnMax() {
        return 8;
    }

    private DomesticTreasureV getDomesticTreasureV() {
        return this.dpost;
    }

    @Override
    protected void createTable() {
        this.dpost.update();
        this.createTableWriter();
        this.dataTable.setFixItem(1);
    }

    protected void createTableWriter() {
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        Object object = this.getDomesticTreasureV().getTreasures().keySet().iterator();
        while (object.hasNext()) {
            int n = object.next();
            list2.add(new DataTableRecord(n));
        }
        block8: for (Object object2 : object = (Object)this.getWriterItems()) {
            switch (object2) {
                case 1: {
                    list.add(new DataTableHeaderItem(100, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        TreasureV treasureV = (TreasureV)this.getGameDataV().getTreasures().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, treasureV.getTreasure().getName(), dataTableRecord.getId(), dataTable -> this.clickedTreasure(dataTableRecord.getId())));
                    });
                    continue block8;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(120, "\u6b66\u5c06", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        int n = this.getDomesticTreasureV().getKnightId(dataTableRecord.getId());
                        KnightV knightV = (KnightV)this.getGameDataV().getKnights().get(n);
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, knightV == null ? "----" : knightV.getFullName(), n, dataTable -> this.clickedTreasure(dataTableRecord.getId())));
                    });
                    continue block8;
                }
                case 3: {
                    list.add(new DataTableHeaderItem(65, "\u5185\u653f", dataTableHeaderItem -> this.setWeights(3, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        TreasureV treasureV = (TreasureV)this.getGameDataV().getTreasures().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + treasureV.getTreasure().getDomesticPlus(), treasureV.getTreasure().getDomesticPlus()));
                    });
                    continue block8;
                }
                case 4: {
                    list.add(new DataTableHeaderItem(65, "\u6226\u8853", dataTableHeaderItem -> this.setWeights(4, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        TreasureV treasureV = (TreasureV)this.getGameDataV().getTreasures().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + treasureV.getTreasure().getTacticsPlus(), treasureV.getTreasure().getTacticsPlus()));
                    });
                    continue block8;
                }
                case 5: {
                    list.add(new DataTableHeaderItem(65, "\u6559\u990a", dataTableHeaderItem -> this.setWeights(5, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        TreasureV treasureV = (TreasureV)this.getGameDataV().getTreasures().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + treasureV.getTreasure().getCulturePlus(), treasureV.getTreasure().getCulturePlus()));
                    });
                }
            }
        }
    }

    private void clickedTreasure(int n) {
        this.getGameTemp().setSelectedTreasureId(n);
        this.getGameTemp().setSubSceneId(23);
    }

    @Override
    protected int getItemIndex(int n) {
        int n2 = -1;
        int[] nArray = this.getWriterItems();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    public void unLoad() {
    }

    @Override
    public void update() {
        super.update();
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.info.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    protected void resetTable() {
    }
}

