/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.SceneEmployBase;

public class SceneReleaseSelect
extends SceneEmployBase {
    public SceneReleaseSelect() {
        this.commandKindKnight = 8;
        this.commandKindGiant = 9;
    }

    @Override
    protected String getDefaultMessage() {
        return "\u89e3\u96c7\u3059\u308b\u6b66\u5c06\u3001\u6587\u5316\u4eba\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    protected String getCancelMessage() {
        return "\u306e\u89e3\u96c7\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected String getDecideMessage() {
        return "\u3092\u89e3\u96c7\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected void loadData() {
        this.knights = GameCommandUtil.getKnightRelease(this.getGameDataV(), this.getPlayer().getDaimyoId());
        this.giants = GameCommandUtil.getGiantRelease(this.getGameDataV(), this.getPlayer().getDaimyoId());
    }

    @Override
    protected void selectedKnight(int n) {
        PlayerV playerV = this.getPlayer();
        CommandV commandV = GameCommandCreator.commandReleaseKnight(0, n);
        playerV.getCommands().add(commandV);
        this.forceReLoad();
    }

    @Override
    protected void selectedGiant(int n) {
        PlayerV playerV = this.getPlayer();
        CommandV commandV = GameCommandCreator.commandReleaseGiant(0, n);
        playerV.getCommands().add(commandV);
        this.forceReLoad();
    }

    @Override
    protected int costOfKnight(int n) {
        return 0;
    }

    @Override
    protected int costOfGiant(int n) {
        return 0;
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 13, 11, 6, 7, 8};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[]{1, 25, 11, 22, 23, 24};
    }
}

