/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.common.Pair;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.CultureV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.game.SceneTableCommon;
import game.sengoku.game.domestic.DomesticResearchUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowMessage;
import game.sengoku.window.WindowMoney;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SceneEmployBase
extends SceneTableCommon {
    protected static final int ITEM_FULLNAME = 1;
    protected static final int ITEM_DAIMYO = 2;
    protected static final int ITEM_SPOT = 4;
    protected static final int ITEM_AGE = 5;
    protected static final int ITEM_DOMESTIC = 6;
    protected static final int ITEM_TACTICS = 7;
    protected static final int ITEM_CULTURE = 8;
    protected static final int ITEM_HEAD_COST = 10;
    protected static final int ITEM_COST = 11;
    protected static final int ITEM_ABSORP = 12;
    protected static final int ITEM_GOOUT_COST = 26;
    protected static final int ITEM_STATUS = 13;
    protected static final int ITEM_EFFECT_NAME1 = 14;
    protected static final int ITEM_EFFECT_VALUE1 = 15;
    protected static final int ITEM_EFFECT_NAME2 = 16;
    protected static final int ITEM_EFFECT_VALUE2 = 17;
    protected static final int ITEM_EFFECT_NAME3 = 18;
    protected static final int ITEM_EFFECT_VALUE3 = 19;
    protected static final int ITEM_BUILD = 20;
    protected static final int ITEM_TECHNOLOGY = 21;
    protected static final int ITEM_STUDY_CULTURE = 22;
    protected static final int ITEM_STUDY_TECHNOLOGY = 23;
    protected static final int ITEM_STUDY_TREASURE = 24;
    protected static final int ITEM_GIANT_TYPE = 25;
    protected static final int TYPE_KNIGHT = 0;
    protected static final int TYPE_GIANT = 1;
    protected ButtonSprite kindKnight;
    protected ButtonSprite kindGiant;
    protected WindowMoney moneyWindow;
    protected WindowMessage info;
    protected List<KnightV> knights;
    protected List<GiantV> giants;
    protected List<Integer> emploiedKnights;
    protected List<Integer> emploiedGiants;
    protected int commandKindKnight;
    protected int commandKindGiant;
    private int kind = 0;
    protected Map<Integer, List<Pair<String, String>>> effects;

    public SceneEmployBase() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.emploiedKnights = new ArrayList<Integer>();
        this.emploiedGiants = new ArrayList<Integer>();
        this.effects = new HashMap<Integer, List<Pair<String, String>>>();
        this.kindGiant = new ButtonSprite(310, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6587\u5316\u4eba", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindGiant.setPrimaryClicked(windowClickable -> this.setKind(1));
        this.kindKnight = new ButtonSprite(410, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6b66\u5c06", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindKnight.setPrimaryClicked(windowClickable -> this.setKind(0));
        this.moneyWindow = new WindowMoney(660, 550, 10, 120, 35);
        this.info = new WindowMessage(20, 10, 100, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, this.getDefaultMessage());
    }

    protected String getDefaultMessage() {
        return "\u96c7\u7528\u3059\u308b\u6b66\u5c06\u3001\u6587\u5316\u4eba\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    protected String getCancelMessage() {
        return "\u306e\u96c7\u7528\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3059\u304b\uff1f";
    }

    protected String getDecideMessage() {
        return "\u3092\u96c7\u7528\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    public void load() {
        super.load();
    }

    protected abstract int[] getKnightsItems();

    protected abstract int[] getGiantsItems();

    public void setKind(int n) {
        if (this.kind != n) {
            this.kind = n;
            this.unLoad();
            this.load();
        }
    }

    protected void loadEmploiedData() {
        this.emploiedKnights = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == this.commandKindKnight).mapToInt(commandV -> (Integer)commandV.getArgs().get(0)).boxed().collect(Collectors.toList());
        this.emploiedGiants = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == this.commandKindGiant).mapToInt(commandV -> (Integer)commandV.getArgs().get(0)).boxed().collect(Collectors.toList());
    }

    protected abstract void loadData();

    @Override
    protected int getTopY() {
        return 50;
    }

    @Override
    protected int getRowMax() {
        return 10;
    }

    @Override
    protected int getColumnMax() {
        return 8;
    }

    @Override
    protected void createTable() {
        this.updateSumCost();
        this.loadEmploiedData();
        this.loadData();
        switch (this.kind) {
            case 0: {
                this.createTableKnights();
                break;
            }
            case 1: {
                this.createTableGiants();
                break;
            }
        }
        this.dataTable.setFixItem(1);
    }

    protected KnightV getDataKnight(int n) {
        KnightV knightV = (KnightV)this.getGameDataV().getKnights().get(n);
        return knightV;
    }

    protected void createTableKnights() {
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        Object object = this.knights.iterator();
        while (object.hasNext()) {
            KnightV object2 = object.next();
            list2.add(new DataTableRecord(object2.getId()));
        }
        block17: for (Object object3 : object = (Object)this.getKnightsItems()) {
            switch (object3) {
                case 1: {
                    list.add(new DataTableHeaderItem(120, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, knightV.getFullName(), dataTableRecord.getId(), dataTable -> this.clickedKnight(knightV)));
                    });
                    continue block17;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(120, "\u5927\u540d", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, knightV.getDaimyoId() == 0 ? "-" : knightV.getDaimyo().getName(), knightV.getDaimyoId()));
                    });
                    continue block17;
                }
                case 13: {
                    list.add(new DataTableHeaderItem(65, "\u72b6\u614b", dataTableHeaderItem -> this.setWeights(13, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, knightV.getStatus(), 0));
                    });
                    continue block17;
                }
                case 4: {
                    list.add(new DataTableHeaderItem(100, "\u6ede\u5728\u5730\u70b9", dataTableHeaderItem -> this.setWeights(4, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, knightV.getSpotId() == 0 ? "-" : knightV.getSpot().getSpot().getName(), knightV.getSpotId()));
                    });
                    continue block17;
                }
                case 5: {
                    list.add(new DataTableHeaderItem(65, "\u5e74\u9f62", dataTableHeaderItem -> this.setWeights(5, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + knightV.getAge(), knightV.getAge()));
                    });
                    continue block17;
                }
                case 6: {
                    list.add(new DataTableHeaderItem(65, "\u5185\u653f", dataTableHeaderItem -> this.setWeights(6, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        int n = knightV.getKnight().getDomestic() + knightV.getDomesticPlus();
                        int n2 = knightV.getDomestic() - n;
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + n + (n2 > 0 ? "+" + n2 : ""), knightV.getDomestic()));
                    });
                    continue block17;
                }
                case 7: {
                    list.add(new DataTableHeaderItem(65, "\u6226\u8853", dataTableHeaderItem -> this.setWeights(7, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        int n = knightV.getKnight().getTactics() + knightV.getTacticsPlus();
                        int n2 = knightV.getTactics() - n;
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + n + (n2 > 0 ? "+" + n2 : ""), knightV.getTactics()));
                    });
                    continue block17;
                }
                case 8: {
                    list.add(new DataTableHeaderItem(65, "\u6559\u990a", dataTableHeaderItem -> this.setWeights(8, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        int n = knightV.getKnight().getCulture() + knightV.getCulturePlus();
                        int n2 = knightV.getCulture() - n;
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + n + (n2 > 0 ? "+" + n2 : ""), knightV.getCulture()));
                    });
                    continue block17;
                }
                case 10: {
                    list.add(new DataTableHeaderItem(100, "\u96c7\u7528\u30b3\u30b9\u30c8", dataTableHeaderItem -> this.setWeights(10, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, "" + knightV.getHeadPay(), knightV.getHeadPay()));
                    });
                    continue block17;
                }
                case 11: {
                    list.add(new DataTableHeaderItem(65, "\u7d66\u6599", dataTableHeaderItem -> this.setWeights(11, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + knightV.getPay(), knightV.getPay()));
                    });
                    continue block17;
                }
                case 12: {
                    list.add(new DataTableHeaderItem(120, "\u53d6\u8fbc\u30b3\u30b9\u30c8", dataTableHeaderItem -> this.setWeights(12, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, "" + this.costOfKnight(knightV.getId()), this.costOfKnight(knightV.getId())));
                    });
                    continue block17;
                }
                case 26: {
                    list.add(new DataTableHeaderItem(120, "\u51fa\u9663\u30b3\u30b9\u30c8", dataTableHeaderItem -> this.setWeights(26, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, "" + knightV.getGoOutPay(), knightV.getGoOutPay()));
                    });
                    continue block17;
                }
                case 20: {
                    list.add(new DataTableHeaderItem(180, "\u5efa\u8a2d\u671f\u9593", dataTableHeaderItem -> this.setWeights(20, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        int n = this.getGameTemp().getBuildSelectedBuildId();
                        Build build = (Build)this.getGameData().getBuilds().get(n);
                        int n2 = this.getGameTemp().getBuildSelectedCountryId();
                        CountryV countryV = (CountryV)this.getGameDataV().getCountries().get(n2);
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        int n3 = countryV.getPower();
                        n3 += n3 * knightV.getDomestic() / 10;
                        dataTableRecord.getItems().add(new DataTableRecordItem(180, "\u5b8c\u6210\u307e\u3067" + (build.getPower() / n3 + 1) + "\u30f6\u6708", build.getPower() / n3 + 1));
                    });
                    continue block17;
                }
                case 21: {
                    list.add(new DataTableHeaderItem(180, "\u7814\u7a76\u671f\u9593", dataTableHeaderItem -> this.setWeights(21, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        int n = this.getGameTemp().getSelectedTechnologyId();
                        int n2 = DomesticResearchUtil.getProgress(n, this.getPlayer());
                        KnightV knightV = this.getDataKnight(dataTableRecord.getId());
                        int n3 = (100 - n2) / knightV.getCulture();
                        dataTableRecord.getItems().add(new DataTableRecordItem(180, "\u7814\u7a76\u5b8c\u4e86\u307e\u3067" + n3 + "\u30f6\u6708", n3));
                    });
                }
            }
        }
    }

    protected void createTableGiants() {
        Object object;
        Object object22;
        Object object3;
        this.effects.clear();
        for (GiantV object42 : this.giants) {
            object3 = new ArrayList();
            object22 = GameEffectUtil.getEffectValues(object42.getGiant().getEffect());
            for (Map.Entry<Integer, Integer> i : object22.entrySet()) {
                object = i.getKey();
                int n = i.getValue();
                String string = GameEffectUtil.getEffectName(object);
                object3.add(new Pair<String, String>(string, "" + n));
            }
            this.effects.put(object42.getId(), (List<Pair<String, String>>)object3);
        }
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        for (Object object22 : this.giants) {
            list2.add(new DataTableRecord(object22.getId()));
        }
        object3 = this.getGiantsItems();
        object22 = object3;
        int n = ((GiantV)object22).length;
        block20: for (int i = 0; i < n; ++i) {
            object = object22[i];
            switch (object) {
                case 1: {
                    list.add(new DataTableHeaderItem(120, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, giantV.getFullName(), dataTableRecord.getId(), dataTable -> this.clickedGiant(giantV)));
                    });
                    continue block20;
                }
                case 25: {
                    list.add(new DataTableHeaderItem(80, "\u7a2e\u985e", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(80, giantV.getGiant().getType(), dataTableRecord.getId(), dataTable -> this.clickedGiant(giantV)));
                    });
                    continue block20;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(120, "\u5927\u540d", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, giantV.getDaimyoId() == 0 ? "-" : giantV.getDaimyo().getName(), giantV.getDaimyoId()));
                    });
                    continue block20;
                }
                case 4: {
                    list.add(new DataTableHeaderItem(80, "\u6ede\u5728\u5730\u70b9", dataTableHeaderItem -> this.setWeights(4, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(80, giantV.getSpotId() == 0 ? "-" : giantV.getSpot().getSpot().getName(), giantV.getSpotId()));
                    });
                    continue block20;
                }
                case 10: {
                    list.add(new DataTableHeaderItem(100, "\u96c7\u7528\u30b3\u30b9\u30c8", dataTableHeaderItem -> this.setWeights(10, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, "" + giantV.getHeadPay(), giantV.getHeadPay()));
                    });
                    continue block20;
                }
                case 11: {
                    list.add(new DataTableHeaderItem(65, "\u7d66\u6599", dataTableHeaderItem -> this.setWeights(11, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(65, "" + giantV.getPay(), giantV.getPay()));
                    });
                    continue block20;
                }
                case 14: {
                    list.add(new DataTableHeaderItem(120, "\u52b9\u679c\u540d", dataTableHeaderItem -> this.setWeights(14, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, list.size() < 1 ? "-" : list.get(0).getFirst(), 0));
                    });
                    continue block20;
                }
                case 15: {
                    list.add(new DataTableHeaderItem(50, "\u52b9\u679c", dataTableHeaderItem -> this.setWeights(15, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(50, list.size() < 1 ? "-" : list.get(0).getSecond(), 0));
                    });
                    continue block20;
                }
                case 16: {
                    list.add(new DataTableHeaderItem(120, "\u52b9\u679c\u540d", dataTableHeaderItem -> this.setWeights(16, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, list.size() < 2 ? "-" : list.get(1).getFirst(), 0));
                    });
                    continue block20;
                }
                case 17: {
                    list.add(new DataTableHeaderItem(50, "\u52b9\u679c", dataTableHeaderItem -> this.setWeights(17, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(50, list.size() < 2 ? "-" : list.get(1).getSecond(), 0));
                    });
                    continue block20;
                }
                case 18: {
                    list.add(new DataTableHeaderItem(120, "\u52b9\u679c\u540d", dataTableHeaderItem -> this.setWeights(18, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, list.size() < 3 ? "-" : list.get(2).getFirst(), 0));
                    });
                    continue block20;
                }
                case 19: {
                    list.add(new DataTableHeaderItem(50, "\u52b9\u679c", dataTableHeaderItem -> this.setWeights(19, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        List<Pair<String, String>> list = this.effects.get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(50, list.size() < 3 ? "-" : list.get(2).getSecond(), 0));
                    });
                    continue block20;
                }
                case 22: {
                    list.add(new DataTableHeaderItem(100, "\u7814\u7a76\u6587\u5316", dataTableHeaderItem -> this.setWeights(22, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        CultureV cultureV = giantV.getCulture();
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, cultureV == null ? "-" : cultureV.getName(), cultureV == null ? 0 : cultureV.getId()));
                    });
                    continue block20;
                }
                case 23: {
                    list.add(new DataTableHeaderItem(100, "\u7814\u7a76\u6280\u8853", dataTableHeaderItem -> this.setWeights(23, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        TechnologyV technologyV = giantV.getTechnology();
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, technologyV == null ? "-" : technologyV.getName(), technologyV == null ? 0 : technologyV.getId()));
                    });
                    continue block20;
                }
                case 24: {
                    list.add(new DataTableHeaderItem(100, "\u7814\u7a76\u5bb6\u5b9d", dataTableHeaderItem -> this.setWeights(24, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        GiantV giantV = (GiantV)this.getGameDataV().getGiants().get(dataTableRecord.getId());
                        TreasureV treasureV = giantV.getTreasure();
                        dataTableRecord.getItems().add(new DataTableRecordItem(100, treasureV == null ? "-" : treasureV.getName(), treasureV == null ? 0 : treasureV.getId()));
                    });
                }
            }
        }
    }

    @Override
    protected void resetTable() {
        switch (this.kind) {
            case 0: {
                this.resetTableKnights();
                break;
            }
            case 1: {
                this.resetTableGiants();
                break;
            }
        }
    }

    protected void resetTableKnights() {
        for (DataTableRecord dataTableRecord : this.dataTable.getRecords()) {
            dataTableRecord.setSelected(false);
            dataTableRecord.setDisabled(false);
            if (this.emploiedKnights.contains(dataTableRecord.getId())) {
                dataTableRecord.setSelected(true);
                continue;
            }
            if (this.getUsableMoney() >= this.costOfKnight(dataTableRecord.getId())) continue;
            dataTableRecord.setDisabled(true);
        }
    }

    protected void resetTableGiants() {
        for (DataTableRecord dataTableRecord : this.dataTable.getRecords()) {
            dataTableRecord.setSelected(false);
            dataTableRecord.setDisabled(false);
            if (this.emploiedGiants.contains(dataTableRecord.getId())) {
                dataTableRecord.setSelected(true);
                continue;
            }
            if (this.getUsableMoney() >= this.costOfGiant(dataTableRecord.getId())) continue;
            dataTableRecord.setDisabled(true);
        }
    }

    protected void clickedKnight(KnightV knightV) {
        if (knightV != null) {
            if (this.getUsableMoney() < this.costOfKnight(knightV.getId())) {
                this.alert(0, "\u8cc7\u91d1\u304c\u8db3\u308a\u307e\u305b\u3093 " + this.getUsableMoney() + " < " + this.costOfKnight(knightV.getId()));
                return;
            }
            if (this.emploiedKnights.contains(knightV.getId())) {
                this.alert(1, () -> this.cancelKnight(knightV.getId()), null, knightV.getFullName() + this.getCancelMessage());
            } else {
                this.alert(1, () -> this.selectedKnight(knightV.getId()), null, knightV.getFullName() + this.getDecideMessage());
            }
        }
    }

    protected void clickedGiant(GiantV giantV) {
        if (giantV != null) {
            if (this.getUsableMoney() < this.costOfGiant(giantV.getId())) {
                this.alert(0, "\u8cc7\u91d1\u304c\u8db3\u308a\u307e\u305b\u3093 " + this.getUsableMoney() + " < " + this.costOfGiant(giantV.getId()));
                return;
            }
            if (this.emploiedGiants.contains(giantV.getId())) {
                this.alert(1, () -> this.cancelGiant(giantV.getId()), null, giantV.getFullName() + this.getCancelMessage());
            } else {
                this.alert(1, () -> this.selectedGiant(giantV.getId()), null, giantV.getFullName() + this.getDecideMessage());
            }
        }
    }

    protected void cancelKnight(int n) {
        PlayerV playerV = this.getPlayer();
        playerV.getCommands().removeIf(commandV -> commandV.getKind() == this.commandKindKnight && (Integer)commandV.getArgs().get(0) == n);
        this.forceReLoad();
    }

    protected abstract void selectedKnight(int var1);

    protected void cancelGiant(int n) {
        PlayerV playerV = this.getPlayer();
        playerV.getCommands().removeIf(commandV -> commandV.getKind() == this.commandKindGiant && (Integer)commandV.getArgs().get(0) == n);
        this.forceReLoad();
    }

    protected abstract void selectedGiant(int var1);

    @Override
    public void unLoad() {
    }

    protected abstract int costOfKnight(int var1);

    protected abstract int costOfGiant(int var1);

    @Override
    protected int getItemIndex(int n) {
        int n2 = -1;
        int[] nArray = null;
        switch (this.kind) {
            case 0: {
                nArray = this.getKnightsItems();
                break;
            }
            case 1: {
                nArray = this.getGiantsItems();
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    public void update() {
        super.update();
        switch (this.kind) {
            case 0: {
                this.kindKnight.setNormalColor(1768520959);
                this.kindGiant.setNormalColor(-235801635);
                break;
            }
            case 1: {
                this.kindGiant.setNormalColor(1768520959);
                this.kindKnight.setNormalColor(-235801635);
            }
        }
        this.kindGiant.update();
        this.kindKnight.update();
        this.moneyWindow.setMoney(this.getUsableMoney());
        this.moneyWindow.update();
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.kindGiant.draw(this.bcontext);
        this.kindKnight.draw(this.bcontext);
        this.moneyWindow.draw(this.bcontext);
        this.info.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }
}

