/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameCommandCreator;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameData;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowPropagateInfo;
import java.util.ArrayList;
import java.util.List;

public class SceneDomesticPropagate
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> countryInfoButtons;
    private WindowPropagateInfo countryInfoWindow;

    public SceneDomesticPropagate() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.countryInfoButtons = new ArrayList<CountrySelectButton>();
        this.countryInfoWindow = new WindowPropagateInfo(50, 450, 10, 700, 140, 0, "\u5e03\u6559\u3092\u884c\u3046\u56fd\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.countryInfoWindow.setDaimyoId(-1);
        this.setReceiveNotice(true);
        this.setMiddleWindow(null);
        this.createCountryInfo();
        this.updateVisible();
    }

    private void updateVisible() {
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
        this.countryInfoWindow.setVisible(true);
        this.countryInfoWindow.setDaimyoId(this.getPlayer().getDaimyoId());
    }

    private int getColor(CountryV countryV) {
        return countryV.getDaimyo().getColor();
    }

    private void createCountryInfo() {
        this.countryInfoButtons.clear();
        for (CountryV countryV : this.getGameDataV().getCountries().values()) {
            int n = this.getColor(countryV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(countryV.getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.countryInfoWindow.setTargetCountryId(countryV.getId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.countryInfoWindow.setTargetCountryId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.countryClicked(countryV);
                }
            });
            this.countryInfoButtons.add(countrySelectButton);
        }
    }

    private void countryClicked(CountryV countryV) {
        boolean bl = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 18).anyMatch(commandV -> ((Integer)commandV.getArgs().get(0)).intValue() == countryV.getId());
        if (bl) {
            this.alert(1, () -> this.cancelPropagate(countryV), null, countryV.getName() + "\u56fd\u3067\u306e\u5e03\u6559\u6d3b\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u304b\uff1f");
            return;
        }
        int[] nArray = GameCommandUtil.calcMission(countryV);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        if (this.getDaimyo().getMoney() < n5) {
            this.alert(0, "\u5e03\u6559\u306b\u5fc5\u8981\u306a\u91d1\u92ad\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        if (n4 + countryV.getChrist() <= 100) {
            this.alert(1, () -> {
                CommandV commandV = GameCommandCreator.commandPropagate(n5, countryV.getId(), n, n2, n3, n4);
                this.getPlayer().getCommands().add(commandV);
            }, null, countryV.getName() + "\u56fd\u3067\u5e03\u6559\u6d3b\u52d5\u3092\u884c\u3044\u307e\u3059\u304b\uff1f", "\u5e03\u6559\u7387  " + n2 + " \u2192 " + n4, "\u4fe1\u8005\u6570  " + n + " \u2192 " + n3, "\u91d1\u92ad  " + this.getDaimyo().getMoney() + " \u2192 " + (this.getDaimyo().getMoney() - n5));
        } else {
            this.alert(0, "\u3053\u306e\u56fd\u3067\u306f\u3053\u308c\u4ee5\u4e0a\u4fe1\u8005\u3092\u5897\u3084\u3059\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
    }

    private void cancelPropagate(CountryV countryV) {
        this.getPlayer().getCommands().removeIf(commandV -> commandV.getKind() == 18 && ((Integer)commandV.getArgs().get(0)).intValue() == countryV.getId());
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.countryInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.countryInfoWindow.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.countryInfoWindow.draw(this.bcontext);
    }
}

