/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.TechnologyV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.DomesticResearch;
import game.sengoku.game.domestic.DomesticResearchUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ProgressSprite;
import game.sengoku.window.VSliderSprite;
import game.sengoku.window.WindowClickable;
import game.sengoku.window.WindowMessage;
import game.sengoku.window.WindowTechnology;
import java.util.ArrayList;
import java.util.List;

public class SceneDomesticInfoTechnology
extends SceneCommon {
    private static final int ROW_MAX = 10;
    private List<WindowMessage> labels;
    private List<ProgressSprite> progresses;
    private List<List<WindowMessage>> records;
    private VSliderSprite slider;
    private WindowTechnology info;
    private boolean recreate = false;

    public SceneDomesticInfoTechnology() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.labels = new ArrayList<WindowMessage>();
        this.progresses = new ArrayList<ProgressSprite>();
        this.records = new ArrayList<List<WindowMessage>>();
        this.slider = new VSliderSprite(760, 20, 100, 30, 415, MouseSymbolLayerManager.LAYER_NORMAL);
        this.slider.setValueChanged(() -> {
            this.recreate = true;
        });
        this.info = new WindowTechnology(50, 450, 10, 600, 140, "\u6280\u8853\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.info.setDaimyoId(this.getDaimyo().getId());
        this.createProgressInfo();
    }

    private void createProgressInfo() {
        this.labels.clear();
        this.progresses.clear();
        this.records.clear();
        List<TechnologyV> list = GameCommandUtil.getProgressTechnology(this.getGameDataV(), this.getDaimyo().getId());
        ArrayList<DomesticResearch> arrayList = new ArrayList<DomesticResearch>();
        for (TechnologyV technologyV : list) {
            arrayList.add(new DomesticResearch(technologyV, DomesticResearchUtil.getStatus(technologyV.getId(), this.getPlayer()), DomesticResearchUtil.getProgress(technologyV.getId(), this.getPlayer())));
        }
        arrayList.sort((domesticResearch, domesticResearch2) -> domesticResearch.getStatus() - domesticResearch2.getStatus());
        this.slider.setValueMin(0);
        this.slider.setValueMax(Math.max(arrayList.size() - 10, 0));
        Object object = new WindowMessage(40, 20, 100, 200, 30, -235801635, GameFontUtil.FONT16, 438578943, "\u6280\u8853\u540d");
        this.labels.add((WindowMessage)object);
        object = new WindowMessage(250, 20, 100, 100, 30, -235801635, GameFontUtil.FONT16, 438578943, "\u72b6\u614b");
        this.labels.add((WindowMessage)object);
        object = new WindowMessage(360, 20, 100, 390, 30, -235801635, GameFontUtil.FONT16, 438578943, "\u9032\u6357");
        this.labels.add((WindowMessage)object);
        int n = 0;
        for (DomesticResearch domesticResearch3 : arrayList) {
            if (n < this.slider.getValue()) {
                ++n;
                continue;
            }
            if (this.slider.getValue() + 10 <= n) break;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n2 = 55 + (n - this.slider.getValue()) * 35;
            object = new WindowMessage(40, n2, 100, 200, 30, 877223628, GameFontUtil.FONT16, -269422081, domesticResearch3.getTechnology().getName());
            ((WindowClickable)object).setMouseEnter(windowClickable -> {
                this.info.setMode(0);
                this.info.setTechnology(domesticResearch3.getTechnology());
            });
            ((WindowClickable)object).setPrimaryClicked(windowClickable -> this.clickedTechnology(domesticResearch3.getTechnology()));
            arrayList2.add(object);
            object = new WindowMessage(250, n2, 100, 100, 30, 877223628, GameFontUtil.FONT16, -269422081, DomesticResearchUtil.getStatusName(domesticResearch3.getStatus()));
            ((WindowClickable)object).setMouseEnter(windowClickable -> {
                this.info.setMode(0);
                this.info.setTechnology(domesticResearch3.getTechnology());
            });
            ((WindowClickable)object).setPrimaryClicked(windowClickable -> this.clickedTechnology(domesticResearch3.getTechnology()));
            arrayList2.add(object);
            this.records.add(arrayList2);
            ProgressSprite progressSprite = new ProgressSprite(360, n2, 100, 390, 30, -1069995111, 877223628, -319753729);
            progressSprite.setMouseEnter(windowClickable -> {
                this.info.setMode(1);
                this.info.setTechnology(domesticResearch3.getTechnology());
            });
            if (this.getDaimyo().getTechnologyIds().contains(domesticResearch3.getTechnology().getId())) {
                progressSprite.setProgress(100);
            } else {
                progressSprite.setProgress(DomesticResearchUtil.getProgress(domesticResearch3.getTechnology().getId(), this.getPlayer()));
            }
            progressSprite.setPrimaryClicked(windowClickable -> this.clickedTechnology(domesticResearch3.getTechnology()));
            this.progresses.add(progressSprite);
            ++n;
        }
    }

    protected void clickedTechnology(TechnologyV technologyV) {
        int n = DomesticResearchUtil.getStatus(technologyV.getId(), this.getPlayer());
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.alert(0, "\u7814\u7a76\u3092\u958b\u59cb\u3059\u308b\u305f\u3081\u306e\u6761\u4ef6\u304c\u6e80\u305f\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            case 6: {
                this.alert(0, "\u3059\u3067\u306b\u7fd2\u5f97\u6e08\u307f\u3067\u3059\u3002");
                return;
            }
        }
        this.getGameTemp().setSelectedTechnologyId(technologyV.getId());
        this.getGameTemp().setSubSceneId(25);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    public void update() {
        super.update();
        if (this.recreate) {
            this.createProgressInfo();
            this.recreate = false;
        }
        this.slider.update();
        this.labels.forEach(windowMessage -> windowMessage.update());
        this.records.forEach(list -> list.forEach(windowMessage -> windowMessage.update()));
        this.progresses.forEach(progressSprite -> progressSprite.update());
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.slider.draw(this.bcontext);
        this.labels.forEach(windowMessage -> windowMessage.draw(this.bcontext));
        this.records.forEach(list -> list.forEach(windowMessage -> windowMessage.draw(this.bcontext)));
        this.progresses.forEach(progressSprite -> progressSprite.draw(this.bcontext));
        this.info.draw(this.bcontext);
    }
}

