/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.GiantV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ProgressSprite;
import game.sengoku.window.VSliderSprite;
import game.sengoku.window.WindowGiantProgress;
import game.sengoku.window.WindowMessage;
import java.util.ArrayList;
import java.util.List;

public class SceneDomesticInfoGiant
extends SceneCommon {
    private static final int ROW_MAX = 10;
    private List<WindowMessage> labels;
    private List<ProgressSprite> progresses;
    private List<List<WindowMessage>> records;
    private VSliderSprite slider;
    private WindowGiantProgress info;
    private boolean recreate = false;

    public SceneDomesticInfoGiant() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.labels = new ArrayList<WindowMessage>();
        this.progresses = new ArrayList<ProgressSprite>();
        this.records = new ArrayList<List<WindowMessage>>();
        this.slider = new VSliderSprite(760, 20, 100, 30, 415, MouseSymbolLayerManager.LAYER_NORMAL);
        this.slider.setValueChanged(() -> {
            this.recreate = true;
        });
        this.info = new WindowGiantProgress(50, 450, 10, 600, 140, "\u6587\u5316\u4eba\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.createProgressInfo();
    }

    private void createProgressInfo() {
        this.labels.clear();
        this.progresses.clear();
        this.records.clear();
        List list = this.getDaimyo().getGiants();
        this.slider.setValueMin(0);
        this.slider.setValueMax(Math.max(list.size() - 10, 0));
        WindowMessage windowMessage = new WindowMessage(40, 20, 100, 200, 30, -235801635, GameFontUtil.FONT16, 438578943, "\u6587\u5316\u4eba\u540d");
        this.labels.add(windowMessage);
        windowMessage = new WindowMessage(250, 20, 100, 500, 30, -235801635, GameFontUtil.FONT16, 438578943, "\u9032\u6357");
        this.labels.add(windowMessage);
        int n = 0;
        for (GiantV giantV : list) {
            if (n < this.slider.getValue()) {
                ++n;
                continue;
            }
            if (this.slider.getValue() + 10 <= n) break;
            ArrayList<WindowMessage> arrayList = new ArrayList<WindowMessage>();
            int n2 = 55 + (n - this.slider.getValue()) * 35;
            windowMessage = new WindowMessage(40, n2, 100, 200, 30, 877223628, GameFontUtil.FONT16, -269422081, giantV.getFullName());
            windowMessage.setMouseEnter(windowClickable -> this.info.setGiantId(giantV.getId()));
            arrayList.add(windowMessage);
            this.records.add(arrayList);
            ProgressSprite progressSprite = new ProgressSprite(250, n2, 100, 500, 30, -1069995111, 877223628, -319753729);
            progressSprite.setMouseEnter(windowClickable -> this.info.setGiantId(giantV.getId()));
            int n3 = giantV.getMonth() * 100 / giantV.getGiant().getCultureMonths();
            progressSprite.setProgress(n3);
            this.progresses.add(progressSprite);
            ++n;
        }
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    public void update() {
        super.update();
        if (this.recreate) {
            this.createProgressInfo();
            this.recreate = false;
        }
        this.slider.update();
        this.labels.forEach(windowMessage -> windowMessage.update());
        this.records.forEach(list -> list.forEach(windowMessage -> windowMessage.update()));
        this.progresses.forEach(progressSprite -> progressSprite.update());
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.slider.draw(this.bcontext);
        this.labels.forEach(windowMessage -> windowMessage.draw(this.bcontext));
        this.records.forEach(list -> list.forEach(windowMessage -> windowMessage.draw(this.bcontext)));
        this.progresses.forEach(progressSprite -> progressSprite.draw(this.bcontext));
        this.info.draw(this.bcontext);
    }
}

