/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameData;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.BuildButton;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBuild;
import game.sengoku.window.WindowMoney;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SceneBuildSelect
extends SceneCommon {
    private List<BuildButton> buttons;
    private ButtonSprite next;
    private ButtonSprite prev;
    private Build overBuild;
    private WindowBuild info;
    private int pageIndex = 0;
    private Map<Integer, List<Integer>> buildMap;
    private WindowMoney moneyWindow;

    public SceneBuildSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<BuildButton>();
        this.overBuild = null;
        this.prev = new ButtonSprite(340, 420, 100, 50, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u524d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.prev.setPrimaryClicked(windowClickable -> this.prev());
        this.next = new ButtonSprite(410, 420, 100, 50, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6b21", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.next.setPrimaryClicked(windowClickable -> this.next());
        this.info = new WindowBuild(50, 450, 10, 600, 140, 0, "\u65bd\u8a2d\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", this.getGameDataV());
        this.moneyWindow = new WindowMoney(660, 450, 10, 120, 35);
    }

    @Override
    public void load() {
        super.load();
        this.getGameTemp().setBuildSelectedBuildId(0);
        this.overBuild = null;
        this.info.setCountryId(this.getGameTemp().getCandidateCountryId());
        this.updateSumCost();
        this.loadData();
    }

    private void loadData() {
        this.buttons.clear();
        this.buildMap = GameCommandUtil.getMakableBuilds(this.getGameDataV(), this.getGameTemp().getCandidateCountryId());
        GameData gameData = this.getPlayerClient().getGameData();
        this.buildMap.keySet().stream().sorted((n, n2) -> n - n2).filter(n -> !this.buildMap.get(n).isEmpty()).forEachOrdered(n -> {
            Build build = (Build)gameData.getBuilds().get(n);
            int n2 = this.buttons.size();
            BuildButton buildButton = new BuildButton(75 + 130 * (n2 / 12), 30 + 30 * (n2 % 12), build);
            buildButton.setMouseEnter(windowClickable -> {
                this.overBuild = ((BuildButton)windowClickable).getBuild();
                this.info.setBuild(this.overBuild);
            });
            buildButton.setMouseExit(windowClickable -> {
                this.overBuild = null;
            });
            buildButton.setPrimaryClicked(windowClickable -> {
                this.overBuild = ((BuildButton)windowClickable).getBuild();
                if (this.overBuild != null && !this.buildMap.get(this.overBuild.getId()).isEmpty()) {
                    this.buildSelected(this.overBuild.getId());
                }
            });
            this.buttons.add(buildButton);
        });
    }

    private int getCost(Build build) {
        double d = this.getWorld().getInflationRate();
        double d2 = (double)(100 - this.getDiscount()) / 100.0;
        return (int)Math.ceil((double)build.getHeadCost() * d * d2);
    }

    protected void buildSelected(int n) {
        int n2 = this.getCost(this.overBuild);
        if (this.getUsableMoney() < n2) {
            this.alert(0, "\u8cc7\u91d1\u304c\u8db3\u308a\u307e\u305b\u3093 " + this.getUsableMoney() + " < " + n2);
            return;
        }
        this.getGameTemp().getCandidateSpotIds().clear();
        this.getGameTemp().getCandidateSpotIds().addAll((Collection<Integer>)this.buildMap.get(n));
        this.getGameTemp().setBuildSelectedBuildId(n);
        this.getGameTemp().setBuildSelectedCost(n2);
        int n3 = this.getGameTemp().getCandidateCountryId();
        CountryV countryV = (CountryV)this.getGameDataV().getCountries().get(n3);
        this.getGameTemp().setCenterSpotId(countryV.getCapitalSpot().getId());
        this.getGameTemp().setSubSceneId(3);
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.prev.update();
        this.next.update();
        for (int i = 0; i < this.buttons.size(); ++i) {
            BuildButton buildButton2 = this.buttons.get(i);
            buildButton2.setVisible(i < (this.pageIndex + 5) * 12 && this.pageIndex * 12 <= i);
            buildButton2.setX(75 + 130 * (i / 12 - this.pageIndex));
        }
        this.buttons.forEach(buildButton -> {
            Build build = buildButton.getBuild();
            if (this.getUsableMoney() < this.getCost(build)) {
                buildButton.setFontColor(-1785354753);
            } else {
                buildButton.setFontColor(-84214785);
            }
            buildButton.update();
        });
        this.moneyWindow.setMoney(this.getUsableMoney());
        this.moneyWindow.update();
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.prev.draw(this.bcontext);
        this.next.draw(this.bcontext);
        this.info.draw(this.bcontext);
        this.moneyWindow.draw(this.bcontext);
        this.buttons.forEach(buildButton -> buildButton.draw(this.bcontext));
    }

    private void next() {
        if (this.pageIndex < (this.buttons.size() - 60) / 12 + 1) {
            ++this.pageIndex;
        }
    }

    private void prev() {
        if (0 < this.pageIndex) {
            --this.pageIndex;
        }
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(1);
    }
}

