/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.SceneCountriesSelect;

public class SceneBuildCountriesSelect
extends SceneCountriesSelect {
    @Override
    public void loadCountries() {
        this.countries.addAll(this.getDaimyo().getCountries());
    }

    protected boolean isBuildPlaned(CountryV countryV) {
        boolean bl = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 2).anyMatch(commandV -> countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
        return bl;
    }

    protected boolean isBuildCanceled(CountryV countryV) {
        boolean bl = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 1).anyMatch(commandV -> countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
        return bl;
    }

    protected void deleteBuildPlaned(CountryV countryV) {
        this.getPlayer().getCommands().removeIf(commandV -> commandV.getKind() == 2 && countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
    }

    protected void buildCancel(CountryV countryV) {
        PlayerV playerV = this.getPlayer();
        CommandV commandV = GameCommandCreator.commandBuildCancel(0, countryV.getId());
        playerV.getCommands().add(commandV);
    }

    protected boolean isBuildPlanExist(CountryV countryV) {
        boolean bl = this.isBuildPlaned(countryV);
        boolean bl2 = this.isBuildCanceled(countryV);
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        return !countryV.getBuildPlans().isEmpty();
    }

    @Override
    protected int getColor(CountryV countryV) {
        if (this.isBuildPlanExist(countryV)) {
            return -16776961;
        }
        return 65535;
    }

    @Override
    protected void countryClicked(CountryV countryV) {
        boolean bl = this.isBuildCanceled(countryV);
        if (this.isBuildPlanExist(countryV)) {
            this.alert(1, () -> {
                this.deleteBuildPlaned(countryV);
                if (!bl) {
                    this.buildCancel(countryV);
                }
                this.countrySelected(countryV.getId());
            }, null, "\u73fe\u5728\u306e\u5efa\u8a2d\u4e88\u7d04\u306f\u89e3\u9664\u3055\u308c\u307e\u3059");
        } else {
            this.countrySelected(countryV.getId());
        }
    }

    @Override
    protected void countrySelected(int n) {
        this.getGameTemp().setBuildSelectedCountryId(n);
        this.getGameTemp().setCandidateCountryId(n);
        this.getGameTemp().setSubSceneId(2);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }
}

