/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy.semiscene;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.RoleV;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.game.diplomacy.semiscene.SemiScene;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.GameDataObjectButton;
import game.sengoku.window.WindowRoleInfo;
import java.util.ArrayList;
import java.util.List;

public class SemiSceneRole
extends SemiScene {
    private static final int CLUMN_MAX = 4;
    private static final int ROW_MAX = 12;
    private List<GameDataObjectButton> buttons;
    private ButtonSprite next;
    private ButtonSprite prev;
    private WindowRoleInfo info;
    private int pageIndex = 0;

    public SemiSceneRole() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.buttons = new ArrayList<GameDataObjectButton>();
        this.prev = new ButtonSprite(340, 390, 100, 50, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u524d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.prev.setPrimaryClicked(windowClickable -> this.prev());
        this.next = new ButtonSprite(410, 390, 100, 50, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6b21", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.next.setPrimaryClicked(windowClickable -> this.next());
        this.info = new WindowRoleInfo(50, 450, 10, 600, 140, "\u5f79\u8077\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.pageIndex = 0;
        this.loadData();
    }

    private void loadData() {
        this.buttons.clear();
        if (!GameDiplomacyUtil.canRoleRequest(this.getGameDataV(), this.receiveDaimyoId(), this.getGameTemp().getNegotiationEditDaimyoId())) {
            return;
        }
        int n = this.receiveDaimyoId();
        List<RoleV> list = GameDiplomacyUtil.getTradeRole(this.getGameDataV(), this.getGameTemp().getNegotiationEditDaimyoId(), n);
        list.stream().forEachOrdered(roleV -> {
            int n = this.buttons.size();
            GameDataObjectButton gameDataObjectButton = new GameDataObjectButton(75 + 130 * (n / 12), 30 + 30 * (n % 12), (GameDataObject)roleV.getRole());
            gameDataObjectButton.setMouseEnter(windowClickable -> {
                GameDataObject gameDataObject = ((GameDataObjectButton)windowClickable).getObject();
                this.info.setRoleId(gameDataObject.getId());
            });
            gameDataObjectButton.setMouseExit(windowClickable -> this.info.setRoleId(0));
            gameDataObjectButton.setPrimaryClicked(windowClickable -> {
                GameDataObject gameDataObject = ((GameDataObjectButton)windowClickable).getObject();
                if (gameDataObject != null) {
                    this.selected(gameDataObject.getId());
                }
            });
            this.buttons.add(gameDataObjectButton);
        });
    }

    protected void selected(int n) {
        NegotiationActionEntry negotiationActionEntry = this.getEntry();
        if (negotiationActionEntry != null) {
            if (!negotiationActionEntry.getRoleIds().contains(n)) {
                negotiationActionEntry.getRoleIds().add(n);
            } else {
                negotiationActionEntry.getRoleIds().removeIf(n2 -> n2 == n);
            }
            this.setEntryChange(true);
        }
    }

    @Override
    public void unLoad() {
        this.buttons.clear();
    }

    @Override
    public void update() {
        super.update();
        if (this.prev != null) {
            if (this.isFirst()) {
                this.prev.setNormalColor(-1380583425);
            } else {
                this.prev.setNormalColor(388883421);
            }
            this.prev.update();
        }
        if (this.next != null) {
            if (this.isLast()) {
                this.next.setNormalColor(-1380583425);
            } else {
                this.next.setNormalColor(388883421);
            }
            this.next.update();
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            GameDataObjectButton gameDataObjectButton2 = this.buttons.get(i);
            gameDataObjectButton2.setVisible(i < (this.pageIndex + 4) * 12 && this.pageIndex * 12 <= i);
            gameDataObjectButton2.setX(75 + 130 * (i / 12 - this.pageIndex));
        }
        NegotiationActionEntry negotiationActionEntry = this.getEntry();
        this.buttons.forEach(gameDataObjectButton -> {
            if (negotiationActionEntry.getCultureIds().contains(gameDataObjectButton.getObjectId())) {
                gameDataObjectButton.setFontColor(-69579521);
            } else {
                gameDataObjectButton.setFontColor(-84214785);
            }
            gameDataObjectButton.update();
        });
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.prev.draw(this.bcontext);
        this.next.draw(this.bcontext);
        this.info.draw(this.bcontext);
        this.buttons.forEach(gameDataObjectButton -> gameDataObjectButton.draw(this.bcontext));
    }

    private boolean isFirst() {
        return this.pageIndex <= 0;
    }

    private boolean isLast() {
        return this.pageIndex >= this.buttons.size() / 12 - 4 + 1;
    }

    private void next() {
        if (!this.isLast()) {
            ++this.pageIndex;
        }
    }

    private void prev() {
        if (!this.isFirst()) {
            --this.pageIndex;
        }
    }

    @Override
    protected void exit() {
    }
}

