/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.RelationV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowRelationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SceneNegotiationTargetSelect
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> relationInfoButtons;
    private WindowRelationInfo relationInfoWindow;

    public SceneNegotiationTargetSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.relationInfoButtons = new ArrayList<CountrySelectButton>();
        this.relationInfoWindow = new WindowRelationInfo(50, 450, 10, 700, 140, 0, "\u5bfe\u8c61\u3068\u3059\u308b\u5927\u540d\u5bb6\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.relationInfoWindow.setDaimyoId(-1);
        this.setReceiveNotice(true);
        this.createRelationInfo();
        this.updateVisible();
        if (this.getGameTemp().getCandidateObjectIds().isEmpty()) {
            this.alert(0, () -> this.exit(), null, "\u5019\u88dc\u3068\u306a\u308b\u5927\u540d\u5bb6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
    }

    private void updateVisible() {
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
        this.relationInfoWindow.setVisible(true);
        this.relationInfoWindow.setDaimyoId(this.getPlayer().getDaimyoId());
    }

    protected int getColor(DaimyoV daimyoV) {
        return daimyoV.getColor();
    }

    private void createRelationInfo() {
        this.relationInfoButtons.clear();
        for (int n : this.getGameTemp().getCandidateObjectIds()) {
            DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(n);
            int n2 = this.getColor(daimyoV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(((CountryV)daimyoV.getCountries().get(0)).getCountry(), this.getGameDataV(), n2, n2);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.relationInfoWindow.setTargetDaimyoId(countryV.getDaimyoId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.relationInfoWindow.setTargetDaimyoId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.relationClicked(countryV.getDaimyo());
                }
            });
            this.relationInfoButtons.add(countrySelectButton);
        }
    }

    protected void relationClicked(DaimyoV daimyoV) {
        this.getGameTemp().setSelectedObjectId(daimyoV.getId());
        Consumer<Integer> consumer = this.getGameTemp().getCallBack();
        if (consumer != null) {
            consumer.accept(daimyoV.getId());
        }
        this.exit();
    }

    protected int getColor(RelationV relationV) {
        return 65535;
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(2);
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.relationInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.relationInfoWindow.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.relationInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.relationInfoWindow.draw(this.bcontext);
    }
}

