/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.PhaseStartButton;
import game.sengoku.window.WindowHistory;
import game.sengoku.window.WindowMessage;

public class SceneDiplomacyStart
extends SceneCommon {
    private Texture minimap;
    private WindowHistory info;
    private WindowMessage message;
    private int _step = 0;

    public SceneDiplomacyStart() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.info = new WindowHistory(50, 450, 10, 700, 140, this.getGameDataV(), this.getPlayer());
        this.message = new WindowMessage(50, 410, 10, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, "");
    }

    @Override
    public void load() {
        super.load();
        switch (this.getPlayerClient().getStatus()) {
            case 37: {
                PhaseStartButton phaseStartButton = new PhaseStartButton("\u5916\u4ea4\u30d5\u30a7\u30fc\u30ba", this.getYMD());
                phaseStartButton.setFontColor(-319753729);
                phaseStartButton.setPrimaryClicked(windowClickable -> this.setMiddleWindow(null));
                this.setMiddleWindow(phaseStartButton);
                break;
            }
            case 8: {
                DaimyoV daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(this.getGameTemp().getNegotiationDaimyoId());
                this.alert(1, () -> this.getPlayerClient().negotiationResponse(this.getPlayer().getDaimyoId(), this.getGameTemp().getNegotiationDaimyoId(), true), () -> this.getPlayerClient().negotiationResponse(this.getPlayer().getDaimyoId(), this.getGameTemp().getNegotiationDaimyoId(), false), daimyoV.getName() + "\u304b\u3089\u5916\u4ea4\u306e\u4f7f\u8005\u304c\u6765\u3066\u3044\u307e\u3059\u3002\u5fdc\u3058\u307e\u3059\u304b\uff1f");
            }
        }
        this.setReceiveNotice(true);
        this._step = 0;
    }

    @Override
    public void update() {
        super.update();
        this.info.update();
        this.message.update();
        this.message.setVisible(this.getPlayerClient().getStatus() != 37);
        switch (this.getPlayerClient().getStatus()) {
            case 37: {
                if (this.getMiddleWindow() != null) break;
                this.setMiddleWindow(null);
                this.getPlayerClient().diplomacyStartResponse();
                break;
            }
            default: {
                ++this._step;
                StringBuilder stringBuilder = new StringBuilder("\u4ed6\u5bb6\u304c\u5916\u4ea4\u3057\u3066\u3044\u307e\u3059.");
                for (int i = 0; i < this._step % 5; ++i) {
                    stringBuilder.append(".");
                }
                this.message.setMessages(stringBuilder.toString());
            }
        }
    }

    @Override
    protected void exit() {
    }

    @Override
    public void unLoad() {
        super.unLoad();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.info.draw(this.bcontext);
        this.message.draw(this.bcontext);
    }
}

