/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.sengoku.game.diplomacy.NegotiationActionEntry;

public class NegotiationAction {
    private NegotiationActionEntry selfEntry = new NegotiationActionEntry();
    private NegotiationActionEntry targetEntry = new NegotiationActionEntry();
    private boolean continuous = false;
    private boolean agreement = false;
    private int sequenceNumber = 0;

    public static NegotiationAction reverse(NegotiationAction negotiationAction) {
        NegotiationAction negotiationAction2 = new NegotiationAction(true, negotiationAction.getTargetEntry().getDaimyoId(), negotiationAction.getSelfEntry().getDaimyoId());
        negotiationAction2.getSelfEntry().copy(negotiationAction.getTargetEntry());
        negotiationAction2.getTargetEntry().copy(negotiationAction.getSelfEntry());
        negotiationAction2.setSequenceNumber(negotiationAction.getSequenceNumber());
        return negotiationAction2;
    }

    public NegotiationAction(boolean bl, int n, int n2) {
        this.selfEntry.setDaimyoId(n);
        this.targetEntry.setDaimyoId(n2);
        this.continuous = bl;
    }

    public void copy(NegotiationAction negotiationAction) {
        this.targetEntry.copy(negotiationAction.getTargetEntry());
        this.selfEntry.copy(negotiationAction.getSelfEntry());
        this.setSequenceNumber(negotiationAction.getSequenceNumber());
        this.continuous = negotiationAction.isContinuous();
        this.agreement = negotiationAction.isAgreement();
    }

    public boolean isEmpty() {
        return this.selfEntry.isEmpty() && this.targetEntry.isEmpty();
    }

    public boolean isEmptyOr() {
        return this.selfEntry.isEmpty() || this.targetEntry.isEmpty();
    }

    public void clear() {
        this.selfEntry.clear();
        this.targetEntry.clear();
    }

    public NegotiationActionEntry getSelfEntry() {
        return this.selfEntry;
    }

    public NegotiationActionEntry getTargetEntry() {
        return this.targetEntry;
    }

    public void validate() {
        this.selfEntry.validate();
        this.targetEntry.validate();
        if (this.selfEntry.getMoney() < this.targetEntry.getMoney()) {
            this.targetEntry.setMoney(this.targetEntry.getMoney() - this.selfEntry.getMoney());
            this.selfEntry.setMoney(0);
        } else if (this.targetEntry.getMoney() < this.selfEntry.getMoney()) {
            this.selfEntry.setMoney(this.selfEntry.getMoney() - this.targetEntry.getMoney());
            this.targetEntry.setMoney(0);
        }
        if (this.selfEntry.getGun() < this.targetEntry.getGun()) {
            this.targetEntry.setGun(this.targetEntry.getGun() - this.selfEntry.getGun());
            this.selfEntry.setGun(0);
        } else if (this.targetEntry.getGun() < this.selfEntry.getGun()) {
            this.selfEntry.setGun(this.selfEntry.getGun() - this.targetEntry.getGun());
            this.targetEntry.setGun(0);
        }
        if (this.selfEntry.getGunpowder() < this.targetEntry.getGunpowder()) {
            this.targetEntry.setGunpowder(this.targetEntry.getGunpowder() - this.selfEntry.getGunpowder());
            this.selfEntry.setGunpowder(0);
        } else if (this.targetEntry.getGunpowder() < this.selfEntry.getGunpowder()) {
            this.selfEntry.setGunpowder(this.selfEntry.getGunpowder() - this.targetEntry.getGunpowder());
            this.targetEntry.setGunpowder(0);
        }
        if (this.selfEntry.getHorse() < this.targetEntry.getHorse()) {
            this.targetEntry.setHorse(this.targetEntry.getHorse() - this.selfEntry.getHorse());
            this.selfEntry.setHorse(0);
        } else if (this.targetEntry.getHorse() < this.selfEntry.getHorse()) {
            this.selfEntry.setHorse(this.selfEntry.getHorse() - this.targetEntry.getHorse());
            this.targetEntry.setHorse(0);
        }
        if (this.selfEntry.getIron() < this.targetEntry.getIron()) {
            this.targetEntry.setIron(this.targetEntry.getIron() - this.selfEntry.getIron());
            this.selfEntry.setIron(0);
        } else if (this.targetEntry.getIron() < this.selfEntry.getIron()) {
            this.selfEntry.setIron(this.selfEntry.getIron() - this.targetEntry.getIron());
            this.targetEntry.setIron(0);
        }
        if (this.selfEntry.getSaltpeter() < this.targetEntry.getSaltpeter()) {
            this.targetEntry.setSaltpeter(this.targetEntry.getSaltpeter() - this.selfEntry.getSaltpeter());
            this.selfEntry.setSaltpeter(0);
        } else if (this.targetEntry.getSaltpeter() < this.selfEntry.getSaltpeter()) {
            this.selfEntry.setSaltpeter(this.selfEntry.getSaltpeter() - this.targetEntry.getSaltpeter());
            this.targetEntry.setSaltpeter(0);
        }
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public boolean isAgreement() {
        return this.agreement;
    }

    public void setAgreement(boolean bl) {
        this.agreement = bl;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public String toString() {
        return "NegotiationAction [selfEntry=" + this.selfEntry + ", targetEntry=" + this.targetEntry + ", continuous=" + this.continuous + ", agreement=" + this.agreement + ", sequenceNumber=" + this.sequenceNumber + "]";
    }
}

