/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.MapPosition;
import game.sengoku.data.UnitV;
import game.sengoku.main.KessenMain;

public class GameUnitUtil {
    public static int calcEdge(UnitV unitV) {
        if (10000 <= unitV.getLeave()) {
            return 25;
        }
        if (1000 <= unitV.getLeave()) {
            return 20;
        }
        if (100 <= unitV.getLeave()) {
            return 15;
        }
        return 10;
    }

    public static Texture selectTexture(DaimyoV daimyoV, UnitV unitV) {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        GameDataV gameDataV = daimyoV.getGameDataV();
        Texture texture = null;
        texture = daimyoV.getId() == unitV.getDaimyoId() ? (Texture)graphicPool.getResource("army.png") : (gameDataV.isAlliance(daimyoV.getId(), unitV.getDaimyoId()) ? (Texture)graphicPool.getResource("army_alliance.png") : (gameDataV.isNonAggression(daimyoV.getId(), unitV.getDaimyoId()) ? (Texture)graphicPool.getResource("army_non_aggresion.png") : (gameDataV.isAllianceLike(daimyoV.getId(), unitV.getDaimyoId()) ? (Texture)graphicPool.getResource("army_colony.png") : (Texture)graphicPool.getResource("army_enemy.png"))));
        return texture;
    }

    public static int calcDegree(MapPosition mapPosition, MapPosition mapPosition2) {
        int n = 0;
        if (mapPosition.getY() == mapPosition2.getY()) {
            if (mapPosition.getX() < mapPosition2.getX()) {
                n = 270;
                return n;
            }
            n = 90;
            return n;
        }
        double d = Math.atan(-1.0 * (double)(mapPosition.getX() - mapPosition2.getX()) / (1.0 * (double)(mapPosition.getY() - mapPosition2.getY())));
        n = (int)(Math.toDegrees(d) % 180.0);
        if (mapPosition2.getY() < mapPosition.getY()) {
            n += 180;
        }
        return n;
    }
}

