/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.common.Pair;
import game.sengoku.common.GameHistoryCreator;
import game.sengoku.common.GameNoticeCreator;
import game.sengoku.common.GameUtil;
import game.sengoku.data.BattleReport;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SpotV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitEffect;
import game.sengoku.data.UnitType;
import game.sengoku.data.UnitV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.Notice;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.game.tactics.TacticsActionEntry;
import game.sengoku.game.tactics.TacticsResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GameTacticsUtil {
    private static void updateUnitOrder(GameDataV gameDataV) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(gameDataV.getUnits().values());
        arrayList.sort((unitV, unitV2) -> unitV2.getSpeed() - unitV.getSpeed());
        int n = 1;
        for (UnitV unitV3 : arrayList) {
            unitV3.setMoveOrder(n);
            ++n;
        }
    }

    public static void updateBeforeSprint(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        gameDataV.getSpots().values().forEach(spotV -> spotV.setBattle(0));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(gameDataV.getUnits().values());
        for (UnitV unitV : arrayList) {
            if (unitV.getSpot().getCountry() != null) {
                int n;
                int n2 = unitV.getDaimyoId();
                if (gameDataV.isNonAggression(n2, n = unitV.getSpot().getCountry().getDaimyoId())) {
                    GameTacticsUtil.releaseUnit(gameDataV, unitV);
                } else if (!gameDataV.isAllianceLike(n2, n) && n2 != n) {
                    GameTacticsUtil.startWar(gameDataV, unitV.getOperationDaimyoId(), n, true, list);
                }
            }
            if (unitV.getDaimyo() != null && unitV.getDaimyo().isFall()) {
                GameTacticsUtil.releaseUnit(gameDataV, unitV);
            }
            if (unitV.getKnight() != null && unitV.getKnight().getRentalDaimyoId() != 0 && !GameDiplomacyUtil.canRental(gameDataV, unitV.getKnight().getRentalDaimyoId(), unitV.getKnight().getDaimyoId())) {
                GameTacticsUtil.releaseUnit(gameDataV, unitV);
            }
            unitV.update();
        }
        GameTacticsUtil.updateUnitOrder(gameDataV);
        gameDataV.update();
    }

    public static void updateBySprint(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        int n;
        int n2;
        UnitV unitV;
        Object object2;
        WorldDataV worldDataV = gameDataV.getWorld();
        if (worldDataV.getDay() == 21) {
            for (Object object2 : gameDataV.getCountries().values()) {
                unitV = new HashMap();
                for (UnitV unitV2 : object2.getCapitalSpot().getUnits()) {
                    if (unitV.containsKey(unitV2.getOperationDaimyoId())) {
                        int n3 = (Integer)unitV.get(unitV2.getOperationDaimyoId());
                        unitV.put(unitV2.getOperationDaimyoId(), n3 + unitV2.getLeave());
                        continue;
                    }
                    unitV.put(unitV2.getOperationDaimyoId(), unitV2.getLeave());
                }
                n2 = unitV.keySet().stream().anyMatch(arg_0 -> GameTacticsUtil.lambda$updateBySprint$252(gameDataV, (CountryV)object2, arg_0)) ? 1 : 0;
                n = GameUtil.getMaxKey((Map<Integer, Integer>)unitV);
                if (0 >= n || n2 != 0 || !gameDataV.isBattleTerget(n, object2.getDaimyoId())) continue;
                GameTacticsUtil.countryOwnerChange(gameDataV, object2.getId(), n, list);
            }
        }
        gameDataV.getSpots().values().forEach(spotV -> spotV.setBattle(0));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(gameDataV.getUnits().values());
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            unitV = (UnitV)object2.next();
            n2 = gameDataV.getParameters().getMoralDown();
            if (unitV.getCountryId() != unitV.getSpot().getCountryId() && !unitV.getUnit().isSpecial()) {
                unitV.setMorale(unitV.getMorale() - n2);
            }
            if (unitV.getSpot().getCountry() != null) {
                int n4;
                n = unitV.getDaimyoId();
                if (gameDataV.isNonAggression(n, n4 = unitV.getSpot().getCountry().getDaimyoId())) {
                    GameTacticsUtil.releaseUnit(gameDataV, unitV);
                } else if (!gameDataV.isAllianceLike(n, n4) && n != n4) {
                    GameTacticsUtil.startWar(gameDataV, unitV.getOperationDaimyoId(), n4, true, list);
                    GameTacticsUtil.plunder(gameDataV, unitV, list);
                }
            }
            n = gameDataV.getParameters().getRequestMoralMin();
            if (unitV.getLeave() <= 0 || unitV.getMorale() <= n) {
                Notice notice = GameNoticeCreator.collapseArmy(unitV);
                list.add(new Pair<Integer, Notice>(unitV.getOperationDaimyoId(), notice));
                GameTacticsUtil.releaseUnit(gameDataV, unitV);
            }
            if (unitV.getDaimyo() != null && unitV.getDaimyo().isFall()) {
                GameTacticsUtil.releaseUnit(gameDataV, unitV);
            }
            unitV.updateByTurn();
        }
        GameTacticsUtil.updateUnitOrder(gameDataV);
        gameDataV.update();
    }

    private static void plunder(GameDataV gameDataV, UnitV unitV, List<Pair<Integer, Notice>> list) {
        if (!unitV.isPlunder()) {
            return;
        }
        if (unitV.getSpot().getDaimyo() == null) {
            return;
        }
        DaimyoV daimyoV = unitV.getSpot().getDaimyo();
        if (daimyoV.getMoney() <= 0) {
            return;
        }
        int n = (int)Math.ceil((double)gameDataV.getParameters().getPlunderMoney() * gameDataV.getWorld().getInflationRate());
        n = Math.min(n, daimyoV.getMoney());
        int n2 = gameDataV.getParameters().getPlunderFameDown();
        daimyoV.setMoneyChange(14, -1 * n);
        Notice notice = GameNoticeCreator.plunder(unitV, n);
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        if (unitV.getOperationDaimyo() != null) {
            DaimyoV daimyoV2 = unitV.getOperationDaimyo();
            daimyoV2.setMoneyChange(6, n);
            daimyoV2.setFame(daimyoV2.getFame() - n2);
            Notice notice2 = GameNoticeCreator.plunderGet(unitV, n);
            list.add(new Pair<Integer, Notice>(unitV.getOperationDaimyoId(), notice2));
        }
    }

    private static void countryOwnerChange(GameDataV gameDataV, int n, int n2, List<Pair<Integer, Notice>> list) {
        CountryV countryV = (CountryV)gameDataV.getCountries().get(n);
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        DaimyoV daimyoV2 = countryV.getDaimyo();
        countryV.setDaimyoId(n2);
        for (Object object2 : daimyoV2.getKnights()) {
            if (object2.isEmployee() || !object2.getKnight().isKokujin()) continue;
            object2.setDaimyoId(n2);
        }
        for (Object object2 : countryV.getUnits()) {
            GameTacticsUtil.releaseUnit(gameDataV, (UnitV)object2);
        }
        countryV.getBuildPlans().clear();
        Object object = GameNoticeCreator.countryOwnerChange(daimyoV, daimyoV2, countryV);
        list.add(new Pair<Integer, Object>(99, object));
        object = GameHistoryCreator.gainCountry(countryV);
        list.add(new Pair<Integer, Object>(daimyoV.getId(), object));
        object = GameHistoryCreator.lostCountry(countryV);
        list.add(new Pair<Integer, Object>(daimyoV2.getId(), object));
        daimyoV2.updateCountries();
        daimyoV2.updateKnights();
        if (daimyoV2.getCountries().isEmpty()) {
            Object object2;
            daimyoV2.setFall(true);
            for (Object object3 : daimyoV2.getGiants()) {
                object3.setDaimyoId(0);
                object3.setSpotId(((Integer)countryV.getSpotIds().get(0)).intValue());
                object3.setMonth(0);
            }
            for (Object object3 : daimyoV2.getKnights()) {
                GameCommandUtil.releaseKnight(gameDataV, (KnightV)object3);
            }
            object2 = GameNoticeCreator.daimyoFall(daimyoV, daimyoV2);
            list.add(new Pair<Integer, Object>(99, object2));
            if (daimyoV2.getId() == gameDataV.getWorld().getKingFamilyId()) {
                Object object3;
                gameDataV.getRoles().values().forEach(roleV -> roleV.setDaimyoId(0));
                object3 = GameNoticeCreator.bakubuClose(daimyoV, daimyoV2);
                list.add(new Pair<Integer, GiantV>(99, (GiantV)object3));
                object3 = GameHistoryCreator.bakubuClose(daimyoV2);
                list.add(new Pair<Integer, GiantV>(99, (GiantV)object3));
            }
        }
    }

    public static int[] getUsingResource(TacticsAction tacticsAction, CountryV countryV) {
        if (countryV == null) {
            return new int[]{0, 0, 0, 0};
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Map<Integer, TacticsActionEntry> map = tacticsAction.getCommandNewMap();
        for (TacticsActionEntry tacticsActionEntry : map.values()) {
            if (countryV.getSpotIds().contains(tacticsActionEntry.getSpotId())) {
                n += tacticsActionEntry.getPower();
            }
            n2 += tacticsActionEntry.getGun();
            n3 += tacticsActionEntry.getHorse();
            n4 += tacticsActionEntry.getMoney();
        }
        return new int[]{n, n2, n3, n4};
    }

    public static Set<Integer> getVisibleSpotIds(GameDataV gameDataV, int n2) {
        Object object22;
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        HashSet<Pair<Integer, Integer>> hashSet = new HashSet<Pair<Integer, Integer>>();
        daimyoV.getCountries().stream().flatMap(countryV -> countryV.getSpots().stream()).forEach(spotV -> hashSet.add(new Pair<Integer, Integer>(spotV.getId(), GameTacticsUtil.getVision(gameDataV, spotV))));
        for (Object object22 : daimyoV.getColonies()) {
            object22.getCountries().stream().flatMap(countryV -> countryV.getSpotIds().stream()).forEach(n -> hashSet.add(new Pair<Integer, Integer>((Integer)n, 1)));
        }
        List<UnitV> list = GameTacticsUtil.getOperationUnits(gameDataV, n2);
        object22 = list.iterator();
        while (object22.hasNext()) {
            UnitV unitV = (UnitV)object22.next();
            hashSet.add(new Pair<Integer, Integer>(unitV.getSpotId(), 1));
        }
        if (daimyoV.isCanHongan()) {
            int n3 = gameDataV.getParameters().getIkkouId();
            for (UnitV unitV : gameDataV.getUnits().values()) {
                if (unitV.getUnitId() != n3) continue;
                hashSet.add(new Pair<Integer, Integer>(unitV.getSpotId(), 1));
            }
        }
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (UnitV unitV : gameDataV.getSpots().values()) {
            for (Pair pair : hashSet) {
                if (gameDataV.distanceSpot(unitV.getId(), ((Integer)pair.getFirst()).intValue()) > (Integer)pair.getSecond()) continue;
                hashSet2.add(unitV.getId());
            }
        }
        return hashSet2;
    }

    private static int getVision(GameDataV gameDataV, SpotV spotV) {
        int n = spotV.getBuilds().stream().mapToInt(build -> build.getVision()).max().orElse(0);
        return Math.max(n, 1);
    }

    public static List<CountryV> getOperationCountries(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        ArrayList<CountryV> arrayList = new ArrayList<CountryV>();
        arrayList.addAll(daimyoV.getCountries());
        for (DaimyoV daimyoV2 : daimyoV.getColonies()) {
            arrayList.addAll(daimyoV2.getCountries());
        }
        return arrayList;
    }

    public static List<CountryV> getGoOutCountries(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        ArrayList<CountryV> arrayList = new ArrayList<CountryV>();
        arrayList.addAll(daimyoV.getCountries());
        for (DaimyoV daimyoV2 : daimyoV.getColonies()) {
            arrayList.addAll(daimyoV2.getCountries());
        }
        arrayList.removeIf(countryV -> GameTacticsUtil.getGoOutSpotIds(gameDataV, n, countryV.getId()).isEmpty());
        return arrayList;
    }

    public static List<Integer> getGoOutSpotIds(GameDataV gameDataV, int n, int n3) {
        CountryV countryV = (CountryV)gameDataV.getCountries().get(n3);
        List<Integer> list = countryV.getSpots().stream().filter(spotV -> spotV.getBuilds().stream().anyMatch(build -> build.isBaseCamp())).mapToInt(spotV -> spotV.getId()).boxed().collect(Collectors.toList());
        if (!list.contains(countryV.getCapitalSpot().getId())) {
            list.add(countryV.getCapitalSpot().getId());
        }
        list.removeIf(n2 -> {
            SpotV spotV = (SpotV)gameDataV.getSpots().get(n2);
            for (UnitV unitV : spotV.getUnits()) {
                if (unitV.getUnit().isSpecial() || !gameDataV.isBattleTerget(n, unitV.getOperationDaimyoId())) continue;
                return true;
            }
            return false;
        });
        return list;
    }

    public static List<Integer> getMoveSpotIds(GameDataV gameDataV, int n, int n2) {
        Set set = gameDataV.nearbySpotIds(n2);
        set.remove(n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            SpotV spotV = (SpotV)gameDataV.getSpots().get(n3);
            if (spotV.getCountry() != null && spotV.getCountry().getDaimyoId() != n && gameDataV.isNonAggression(n, spotV.getCountry().getDaimyoId())) continue;
            arrayList.add(n3);
        }
        return arrayList;
    }

    public static int countGoOutKnight(GameDataV gameDataV, int n, PlayerV playerV) {
        DaimyoV daimyoV = ((CountryV)gameDataV.getCountries().get(n)).getDaimyo();
        long l = daimyoV.getBeingKnights().parallelStream().filter(knightV -> {
            if (knightV.isEmployee()) {
                return true;
            }
            if (knightV.getKnight().isKokujin()) {
                return knightV.getSpot().getCountryId() == n;
            }
            return false;
        }).filter(knightV -> !knightV.isGoOut()).filter(knightV -> knightV.getUnmoveMonth() <= 0).count();
        KnightV knightV2 = daimyoV.getKnight();
        if (!knightV2.isGoOut() && knightV2.getUnmoveMonth() <= 0) {
            ++l;
        }
        return (int)l;
    }

    public static List<KnightV> getGoOutKnight(GameDataV gameDataV, int n, PlayerV playerV, TacticsAction tacticsAction) {
        DaimyoV daimyoV = ((CountryV)gameDataV.getCountries().get(n)).getDaimyo();
        List<KnightV> list = daimyoV.getBeingKnights().parallelStream().filter(knightV -> {
            if (knightV.isEmployee()) {
                return true;
            }
            if (knightV.getKnight().isKokujin()) {
                return knightV.getSpot().getCountryId() == n;
            }
            return false;
        }).filter(knightV -> !knightV.isGoOut()).filter(knightV -> knightV.getUnmoveMonth() <= 0).collect(Collectors.toList());
        KnightV knightV2 = daimyoV.getKnight();
        if (!knightV2.isGoOut() && knightV2.getUnmoveMonth() <= 0) {
            list.add(0, knightV2);
        }
        list.removeIf(knightV -> tacticsAction.getCommandNewMap().containsKey(knightV.getId()));
        int n2 = tacticsAction.getCommandNewMap().values().stream().mapToInt(tacticsActionEntry -> tacticsActionEntry.getMoney()).sum();
        int n3 = daimyoV.getMoney() - n2;
        list.removeIf(knightV -> knightV.getGoOutPay() > n3);
        return list;
    }

    public static List<UnitType> getGoOutUnits(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, TacticsAction tacticsAction) {
        DaimyoV daimyoV2 = countryV.getDaimyo();
        List<UnitType> list = gameDataV.getGameData().getUnitTypes().values().stream().filter(unitType -> !unitType.isSpecial()).filter(unitType -> unitType.getTechnologyId() == 0 || daimyoV2.getTechnologyIds().contains(unitType.getTechnologyId()) || daimyoV.getTechnologyIds().contains(unitType.getTechnologyId())).filter(unitType -> unitType.getUniqCountryId() == 0 || unitType.getUniqCountryId() == countryV.getId()).collect(Collectors.toList());
        int[] nArray = GameTacticsUtil.getUsingResource(tacticsAction, countryV);
        list.removeIf(unitType -> {
            if (0 < unitType.getGun()) {
                return daimyoV.getGun() <= nArray[1];
            }
            return false;
        });
        list.removeIf(unitType -> {
            if (0 < unitType.getHorse()) {
                return daimyoV.getHorse() <= nArray[2];
            }
            return false;
        });
        return list;
    }

    public static List<UnitV> getOperationUnits(GameDataV gameDataV, int n) {
        List<UnitV> list = gameDataV.getUnits().values().stream().filter(unitV -> unitV.getOperationDaimyoId() == n).collect(Collectors.toList());
        return list;
    }

    public static void setSpeed(GameDataV gameDataV, List<TacticsActionEntry> list) {
        for (TacticsActionEntry tacticsActionEntry : list) {
            UnitV unitV = (UnitV)gameDataV.getUnits().get(tacticsActionEntry.getUnitId());
            if (unitV == null) continue;
            if (unitV.isStealth()) {
                tacticsActionEntry.setSpeed(-99999);
                continue;
            }
            tacticsActionEntry.setSpeed(-1 * unitV.getMoveOrder());
        }
    }

    public static void releaseUnit(GameDataV gameDataV, UnitV unitV) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(unitV.getDaimyoId());
        CountryV countryV = (CountryV)gameDataV.getCountries().get(unitV.getCountryId());
        KnightV knightV = (KnightV)gameDataV.getKnights().get(unitV.getKnightId());
        gameDataV.getUnits().remove(unitV.getId());
        if (knightV == null) {
            return;
        }
        knightV.setUnmoveMonth(2);
        countryV.setUsableArmy(countryV.getUsableArmy() + unitV.getLeave() / 100);
    }

    public static int releaseUnitOn(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        List<UnitV> list = daimyoV2.getCountries().stream().flatMap(countryV -> countryV.getSpots().stream()).flatMap(spotV -> spotV.getUnits().stream()).filter(unitV -> unitV.getOperationDaimyoId() == daimyoV.getId()).collect(Collectors.toList());
        list.forEach(unitV -> GameTacticsUtil.releaseUnit(gameDataV, unitV));
        return list.size();
    }

    public static void moveUnit(GameDataV gameDataV, UnitV unitV, int n, List<Pair<Integer, Notice>> list) {
        int n2 = unitV.getSpotId();
        if (n == n2) {
            return;
        }
        unitV.setSpotId(n);
        unitV.setBeforeSpotId(n2);
        if (gameDataV.isBattleTerget(unitV.getOperationDaimyoId(), unitV.getSpot().getDaimyoId())) {
            GameTacticsUtil.startWar(gameDataV, unitV.getOperationDaimyoId(), unitV.getSpot().getDaimyoId(), true, list);
        }
    }

    private static void entryUpdate(GameDataV gameDataV, TacticsActionEntry tacticsActionEntry) {
        int n = tacticsActionEntry.getUnitId();
        UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
        unitV.updateBattle();
        if (unitV.isBattle()) {
            tacticsActionEntry.setCommandType(5);
            tacticsActionEntry.setBattle(true);
        }
    }

    public static void movePirate(GameDataV gameDataV, TacticsAction tacticsAction) {
        int n = gameDataV.getParameters().getPirateId();
        gameDataV.getUnits().values().forEach(unitV -> {
            if (unitV.getUnitId() == n) {
                Set set = gameDataV.nearbySpotIds(unitV.getSpot().getId());
                HashSet<Integer> hashSet = new HashSet<Integer>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    SpotV spotV = (SpotV)gameDataV.getSpots().get(n2);
                    if (!spotV.getSpot().isSea() && !spotV.getSpot().isSeaSize()) continue;
                    hashSet.add(n2);
                }
                if (!hashSet.isEmpty()) {
                    int n3 = (Integer)GameUtil.getRandom(hashSet);
                    if (unitV.getSpotId() != n3) {
                        TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandMove(0, unitV.getId(), unitV.getSpotId(), n3);
                        tacticsAction.put(unitV.getId(), tacticsActionEntry);
                    }
                }
            }
        });
    }

    public static void initTacticsAction(GameDataV gameDataV, int n, TacticsAction tacticsAction) {
        List<UnitV> list = GameTacticsUtil.getOperationUnits(gameDataV, n);
        for (UnitV unitV : list) {
            tacticsAction.getCommandMap().put(unitV.getId(), TacticsActionEntry.commandNone(n, unitV.getId()));
        }
    }

    public static TacticsResult reflectAction(GameDataV gameDataV, TacticsActionEntry tacticsActionEntry, List<Pair<Integer, Notice>> list) {
        if (tacticsActionEntry.getCommandType() != 1 && tacticsActionEntry.getCommandType() != 6) {
            if (tacticsActionEntry.getCommandType() == 3) {
                Technique technique = (Technique)gameDataV.getGameData().getTechniques().get(tacticsActionEntry.getTecniqueId());
                if (technique.getKind() != 4) {
                    GameTacticsUtil.entryUpdate(gameDataV, tacticsActionEntry);
                }
            } else {
                GameTacticsUtil.entryUpdate(gameDataV, tacticsActionEntry);
            }
        }
        switch (tacticsActionEntry.getCommandType()) {
            case 1: {
                int n2 = tacticsActionEntry.getKnightId();
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n2);
                int n3 = tacticsActionEntry.getUnitTypeId();
                UnitType unitType = (UnitType)gameDataV.getGameData().getUnitTypes().get(n3);
                int n4 = tacticsActionEntry.getSpotId();
                SpotV spotV = (SpotV)gameDataV.getSpots().get(n4);
                int n5 = tacticsActionEntry.getPower();
                if (!knightV.isGoOut() && knightV.getUnmoveMonth() <= 0) {
                    int n6 = n5 * unitType.getGun();
                    int n7 = n5 * unitType.getHorse();
                    CountryV countryV = spotV.getCountry();
                    DaimyoV daimyoV = countryV.getDaimyo();
                    if (n6 <= daimyoV.getGun() && n7 <= daimyoV.getHorse() && n5 <= countryV.getUsableArmy() && knightV.getGoOutPay() <= daimyoV.getMoney()) {
                        daimyoV.setMoneyChange(15, -1 * knightV.getGoOutPay());
                        daimyoV.setGun(daimyoV.getGun() - n6);
                        daimyoV.setGun(daimyoV.getHorse() - n7);
                        countryV.setUsableArmy(countryV.getUsableArmy() - n5);
                        int n8 = gameDataV.getUnits().keySet().stream().mapToInt(n -> n).max().orElse(0) + 1;
                        int n9 = countryV.getTamichu();
                        boolean bl = tacticsActionEntry.isPlunder();
                        UnitV unitV = new UnitV(n8, daimyoV.getId(), n2, countryV.getId(), n4, 0, n3, n5, n5 * 100, n9, 0, bl, false, false);
                        unitV.setGameDataV(gameDataV);
                        unitV.setGameData(gameDataV.getGameData());
                        gameDataV.getUnits().put(n8, unitV);
                    }
                }
                return null;
            }
            case 2: {
                int n10 = tacticsActionEntry.getUnitId();
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n10);
                int n11 = tacticsActionEntry.getFromSpotId();
                int n12 = tacticsActionEntry.getToSpotId();
                TacticsResult tacticsResult = new TacticsResult();
                tacticsResult.setDaimyoId(tacticsActionEntry.getDaimyoId());
                tacticsResult.setUnitId(n10);
                tacticsResult.setMoveToSpotId(n12);
                tacticsResult.setType(2);
                if (n11 != n12 && unitV.isStealth()) {
                    tacticsResult.getStealth().put(n10, false);
                }
                return tacticsResult;
            }
            case 5: {
                int n13 = tacticsActionEntry.getUnitId();
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n13);
                TacticsResult tacticsResult = new TacticsResult();
                tacticsResult.setDaimyoId(tacticsActionEntry.getDaimyoId());
                tacticsResult.setUnitId(n13);
                tacticsResult.setType(5);
                return tacticsResult;
            }
            case 6: {
                TacticsResult tacticsResult = new TacticsResult();
                tacticsResult.setType(6);
                for (SpotV spotV : gameDataV.getSpots().values()) {
                    GameTacticsUtil.battle(gameDataV, tacticsResult, spotV);
                    if (!tacticsResult.isBattle()) continue;
                    spotV.setBattle(spotV.getUnits().size());
                }
                tacticsResult.setBattle(true);
                return tacticsResult;
            }
            case 4: {
                int n14 = tacticsActionEntry.getUnitId();
                TacticsResult tacticsResult = new TacticsResult();
                tacticsResult.setDaimyoId(tacticsActionEntry.getDaimyoId());
                tacticsResult.setUnitId(n14);
                tacticsResult.setType(4);
                return tacticsResult;
            }
            case 3: {
                int n15 = tacticsActionEntry.getUnitId();
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n15);
                Technique technique = (Technique)gameDataV.getGameData().getTechniques().get(tacticsActionEntry.getTecniqueId());
                TacticsResult tacticsResult = new TacticsResult();
                switch (technique.getKind()) {
                    case 4: {
                        SpotV spotV = unitV.getSpot();
                        GameTacticsUtil.shot(gameDataV, unitV, technique, spotV, tacticsResult, list);
                        break;
                    }
                    case 2: {
                        int n16 = tacticsActionEntry.getSpotId();
                        SpotV spotV = (SpotV)gameDataV.getSpots().get(n16);
                        GameTacticsUtil.shot(gameDataV, unitV, technique, spotV, tacticsResult, list);
                        tacticsResult.setShotToSpotId(n16);
                        break;
                    }
                    case 1: {
                        GameTacticsUtil.enhance(gameDataV, unitV, technique, tacticsResult);
                    }
                }
                tacticsResult.setDaimyoId(tacticsActionEntry.getDaimyoId());
                tacticsResult.setUnitId(n15);
                tacticsResult.setTechniqueId(tacticsActionEntry.getTecniqueId());
                tacticsResult.setType(3);
                return tacticsResult;
            }
        }
        return null;
    }

    private static void updateBattleReport(GameDataV gameDataV, int n, SpotV spotV, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        if (daimyoV == null) {
            return;
        }
        BattleReport battleReport = daimyoV.getReport();
        battleReport.setWin(battleReport.getWin() + 1);
        switch (spotV.getType()) {
            case 1: {
                battleReport.setWinPlane(battleReport.getWinPlane() + 1);
                break;
            }
            case 2: {
                battleReport.setWinMountain(battleReport.getWinMountain() + 1);
                break;
            }
            case 4: {
                battleReport.setWinSea(battleReport.getWinSea() + 1);
                break;
            }
            case 3: {
                break;
            }
        }
        if (n2 % 2 == 0) {
            battleReport.setWinGun(battleReport.getWinGun() + 1);
        }
        if (n2 % 3 == 0) {
            battleReport.setWinHorse(battleReport.getWinHorse() + 1);
        }
        if (spotV.getCountry() != null && spotV.getCountry().getCapitalSpot().getId() == spotV.getId()) {
            battleReport.setWinCastle(battleReport.getWinCastle() + 1);
        }
        if (daimyoV.getId() == spotV.getDaimyoId()) {
            battleReport.setWinDefense(battleReport.getWinDefense() + 1);
        }
    }

    public static void reflectAction(GameDataV gameDataV, TacticsResult tacticsResult, List<Pair<Integer, Notice>> list2) {
        UnitV unitV;
        int n3;
        switch (tacticsResult.getType()) {
            case 2: {
                n3 = tacticsResult.getUnitId();
                unitV = (UnitV)gameDataV.getUnits().get(n3);
                int n4 = tacticsResult.getMoveToSpotId();
                GameTacticsUtil.moveUnit(gameDataV, unitV, n4, list2);
                break;
            }
            case 4: {
                n3 = tacticsResult.getUnitId();
                unitV = (UnitV)gameDataV.getUnits().get(n3);
                GameTacticsUtil.releaseUnit(gameDataV, unitV);
            }
        }
        tacticsResult.getStealth().forEach((n, bl) -> {
            UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
            if (unitV != null) {
                unitV.setStealth(bl.booleanValue());
            }
        });
        tacticsResult.getConfused().forEach((n, bl) -> {
            UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
            if (unitV != null) {
                unitV.setConfused(bl.booleanValue());
            }
        });
        if (3 == tacticsResult.getType()) {
            n3 = tacticsResult.getUnitId();
            unitV = (UnitV)gameDataV.getUnits().get(n3);
            Technique technique = (Technique)gameDataV.getGameData().getTechniques().get(tacticsResult.getTechniqueId());
            if (technique != null && technique.getKind() == 2) {
                SpotV spotV = (SpotV)gameDataV.getSpots().get(tacticsResult.getShotToSpotId());
                if (gameDataV.isBattleTerget(unitV.getOperationDaimyoId(), spotV.getDaimyoId())) {
                    GameTacticsUtil.startWar(gameDataV, unitV.getOperationDaimyoId(), spotV.getDaimyoId(), true, list2);
                }
            }
        }
        if (3 == tacticsResult.getType() || tacticsResult.isBattle()) {
            tacticsResult.getMoralPlus().forEach((n, n2) -> {
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
                if (unitV != null) {
                    unitV.setMorale(unitV.getMorale() + n2);
                }
            });
            tacticsResult.getEffectPlus().forEach((n, list) -> {
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
                if (unitV != null) {
                    unitV.getUnitEffects().addAll(list);
                }
            });
            tacticsResult.getDamageList().forEach(tuple4 -> {
                int n = (Integer)tuple4.getFirst();
                int n2 = (Integer)tuple4.getSecond();
                Map map = (Map)tuple4.getThird();
                UnitV unitV = (UnitV)gameDataV.getUnits().get(n);
                if (unitV != null) {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        int n3 = (Integer)iterator.next();
                        GameTacticsUtil.startWar(gameDataV, n3, unitV.getOperationDaimyoId(), false, list2);
                        unitV.setLeave(unitV.getLeave() - n2);
                        if (unitV.getLeave() <= 0) {
                            Notice notice;
                            GameTacticsUtil.updateBattleReport(gameDataV, n3, unitV.getSpot(), (Integer)map.get(n3));
                            int n4 = gameDataV.getParameters().getWinImpactPlus();
                            DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n3);
                            if (daimyoV != null) {
                                daimyoV.setImpactBase(daimyoV.getImpactBase() + n4);
                            }
                            if (unitV.getOperationDaimyo() != null) {
                                unitV.getOperationDaimyo().setImpactBase(unitV.getOperationDaimyo().getImpactBase() - n4);
                            }
                            int n5 = gameDataV.getParameters().getPirateId();
                            int n6 = gameDataV.getParameters().getIkkouId();
                            if (unitV.getOperationDaimyoId() != 0) {
                                notice = GameNoticeCreator.lose(unitV);
                                list2.add(new Pair<Integer, Notice>(n3, notice));
                                list2.add(new Pair<Integer, Notice>(unitV.getOperationDaimyoId(), notice));
                            } else if (unitV.getUnit().getId() == n5) {
                                int n7 = (int)(100.0 * gameDataV.getWorld().getInflationRate());
                                Notice notice2 = GameNoticeCreator.breakPirate(n7);
                                list2.add(new Pair<Integer, Notice>(n3, notice2));
                                if (daimyoV != null) {
                                    daimyoV.setMoneyChange(7, n7);
                                }
                            } else if (unitV.getUnit().getId() == n6) {
                                notice = GameNoticeCreator.breakIkkou();
                                list2.add(new Pair<Integer, Notice>(n3, notice));
                            }
                            GameTacticsUtil.releaseUnit(gameDataV, unitV);
                        }
                        GameCommandUtil.brokenBuild(gameDataV, unitV.getSpot(), list2);
                        GameTacticsUtil.createField(gameDataV, unitV.getSpot(), list2);
                    }
                }
            });
            if (tacticsResult.getTechniqueId() != 0) {
                n3 = tacticsResult.getUnitId();
                unitV = (UnitV)gameDataV.getUnits().get(n3);
                Technique technique = (Technique)gameDataV.getGameData().getTechniques().get(tacticsResult.getTechniqueId());
                unitV.setWaitTurn(technique.getWaitTurn());
                unitV.getDaimyo().setGunpowder(unitV.getDaimyo().getGunpowder() - technique.getGunpowder() * unitV.getLeave());
            }
        }
    }

    private static void createField(GameDataV gameDataV, SpotV spotV, List<Pair<Integer, Notice>> list) {
        if (2 <= spotV.getBattle() && GameUtil.getRandom(20) && spotV.getBuilds().stream().allMatch(build -> build.getKind() != 10)) {
            int n = 0;
            for (Object object : gameDataV.getGameData().getBuilds().values()) {
                if (object.getKind() != 10 || object.getSpotId() != spotV.getId()) continue;
                n = object.getId();
                break;
            }
            if (n != 0) {
                Object object;
                Build build2 = (Build)gameDataV.getGameData().getBuilds().get(n);
                object = GameNoticeCreator.appearField(spotV.getCountry(), spotV, build2);
                list.add(new Pair<Integer, Build>(spotV.getDaimyoId(), (Build)object));
            }
        }
        spotV.setBattle(0);
    }

    public static boolean isResultReflect(GameDataV gameDataV, DaimyoV daimyoV, TacticsResult tacticsResult) {
        UnitV unitV;
        int n;
        if (tacticsResult == null) {
            return false;
        }
        if (tacticsResult.getType() == 5) {
            return false;
        }
        if (tacticsResult.getType() == 6) {
            return true;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(tacticsResult.getUnitId());
        hashSet.addAll(tacticsResult.getDamageKeySet());
        hashSet.addAll(tacticsResult.getEffectPlus().keySet());
        hashSet.addAll(tacticsResult.getMoralPlus().keySet());
        Set<Integer> set = hashSet.iterator();
        while (set.hasNext()) {
            n = (Integer)set.next();
            unitV = (UnitV)gameDataV.getUnits().get(n);
            if (unitV == null) {
                return false;
            }
            if (unitV.getDaimyoId() != daimyoV.getId() && unitV.getOperationDaimyoId() != daimyoV.getId()) continue;
            return true;
        }
        set = GameTacticsUtil.getVisibleSpotIds(gameDataV, daimyoV.getId());
        if (set.contains(n = tacticsResult.getMoveToSpotId())) {
            return true;
        }
        n = tacticsResult.getShotToSpotId();
        if (set.contains(n)) {
            return true;
        }
        unitV = (UnitV)gameDataV.getUnits().get(tacticsResult.getUnitId());
        n = unitV.getSpotId();
        return set.contains(n);
    }

    public static void startWar(GameDataV gameDataV, int n, int n2, boolean bl, List<Pair<Integer, Notice>> list) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        if (unmodifiableReration == null) {
            return;
        }
        if (unmodifiableReration.getWar() <= 0) {
            Notice notice;
            List list2 = gameDataV.getJusticeList(n, n2);
            if (list2.isEmpty()) {
                unmodifiableReration.getDaimyo1().setFame(unmodifiableReration.getDaimyo1().getFame() - 25);
            }
            if ((notice = GameNoticeCreator.declarationOfWar(gameDataV, unmodifiableReration.getDaimyo1(), unmodifiableReration.getDaimyo2(), null)) != null) {
                list.add(new Pair<Integer, Notice>(n2, notice));
            }
            notice = GameNoticeCreator.war(unmodifiableReration.getDaimyo1(), unmodifiableReration.getDaimyo2());
            list.add(new Pair<Integer, Notice>(99, notice));
            notice = GameNoticeCreator.warTo(unmodifiableReration.getDaimyo1());
            list.add(new Pair<Integer, Notice>(n2, notice));
            notice = GameNoticeCreator.warTo(unmodifiableReration.getDaimyo2());
            list.add(new Pair<Integer, Notice>(n, notice));
        }
        if (bl) {
            int n3 = gameDataV.getParameters().getHatePeriod();
            gameDataV.setHate(n2, n, n3);
        }
        gameDataV.startWar(n, n2);
    }

    public static void battle(GameDataV gameDataV, TacticsResult tacticsResult, SpotV spotV) {
        tacticsResult.setBattle(false);
        List list = spotV.getUnits();
        for (UnitV unitV : list) {
            for (UnitV unitV2 : list) {
                if (!gameDataV.isBattleTerget(unitV, unitV2)) continue;
                int n = GameTacticsUtil.damage(unitV, unitV2, spotV);
                tacticsResult.addDamage(unitV2, n, unitV.getOperationDaimyoId());
                if (0 < n) {
                    tacticsResult.getStealth().put(unitV2.getId(), false);
                    tacticsResult.getStealth().put(unitV.getId(), false);
                    if (unitV.isStealth()) {
                        tacticsResult.getConfused().put(unitV2.getId(), true);
                    }
                    if (unitV.getKnight() != null) {
                        unitV.getKnight().setTacticsExp(unitV.getKnight().getTacticsExp() + 5);
                    }
                }
                tacticsResult.setBattle(true);
            }
        }
    }

    public static void shot(GameDataV gameDataV, UnitV unitV, Technique technique, SpotV spotV, TacticsResult tacticsResult, List<Pair<Integer, Notice>> list) {
        if (unitV.getDaimyo().getGunpowder() < technique.getGunpowder() * unitV.getLeave()) {
            Notice notice = GameNoticeCreator.disableShot(technique);
            list.add(new Pair<Integer, Notice>(unitV.getDaimyoId(), notice));
            tacticsResult.setType(5);
            return;
        }
        spotV.updateUnits();
        List list2 = spotV.getUnits();
        for (UnitV unitV2 : list2) {
            if (!gameDataV.isBattleTerget(unitV, unitV2)) continue;
            int n = GameTacticsUtil.damage(unitV, unitV2, spotV) * technique.getDamage() / 100;
            int n2 = unitV.getAmountEffect().getAttackPlusRateShoot();
            if (0 < n2) {
                n += n * n2 / 100;
            }
            tacticsResult.addDamage(unitV2, n, unitV.getOperationDaimyoId());
            if (0 >= n) continue;
            tacticsResult.getStealth().put(unitV2.getId(), false);
            tacticsResult.getStealth().put(unitV.getId(), false);
            if (unitV.isStealth()) {
                tacticsResult.getConfused().put(unitV2.getId(), true);
            }
            if (unitV.getKnight() == null) continue;
            unitV.getKnight().setTacticsExp(unitV.getKnight().getTacticsExp() + 5);
        }
    }

    public static void enhance(GameDataV gameDataV, UnitV unitV, Technique technique, TacticsResult tacticsResult) {
        HashSet<UnitV> hashSet = new HashSet<UnitV>();
        if (!technique.isMulti()) {
            hashSet.add(unitV);
        } else {
            for (UnitV unitV2 : gameDataV.getUnits().values()) {
                if (unitV2.getUnit().isSpecial() || unitV2.getDaimyoId() != unitV.getDaimyoId() || gameDataV.distanceSpot(unitV.getSpotId(), unitV2.getSpotId()) > technique.getRadius()) continue;
                hashSet.add(unitV2);
            }
        }
        for (UnitV unitV2 : hashSet) {
            Effect effect = new Effect();
            effect.setAttackPlusRate(technique.getAttackPlusRate());
            effect.setDefensePlusRate(technique.getDefensePlusRate());
            effect.setSpeedPlusRate(technique.getSpeedPlusRate());
            List<UnitEffect> list = tacticsResult.getEffectPlus().get(unitV2.getId());
            if (list == null) {
                list = new ArrayList<UnitEffect>();
            }
            list.add(new UnitEffect(technique.getName(), technique.getEffectPeriod(), effect));
            tacticsResult.getEffectPlus().put(unitV2.getId(), list);
            if (!technique.isStealth()) continue;
            tacticsResult.getStealth().put(unitV2.getId(), true);
        }
    }

    public static int damage(UnitV unitV, UnitV unitV2, SpotV spotV) {
        long l = (long)((double)unitV.getAttack() * Math.sqrt(unitV.getLeave()));
        long l2 = 0L;
        switch (spotV.getType()) {
            case 2: {
                l2 += (long)unitV.getAmountEffect().getAttackPlusRateMountain();
                break;
            }
            case 1: {
                l2 += (long)unitV.getAmountEffect().getAttackPlusRatePlane();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                l2 += (long)unitV.getAmountEffect().getAttackPlusRateSea();
            }
        }
        if (0 < unitV.getUnit().getGun()) {
            l2 += (long)unitV.getAmountEffect().getAttackPlusRateGun();
        }
        if (0 < unitV.getUnit().getHorse()) {
            l2 += (long)unitV.getAmountEffect().getAttackPlusRateHorse();
        }
        if (spotV.getCountryId() == unitV.getCountryId()) {
            l2 += (long)unitV.getAmountEffect().getAttackPlusRateInner();
            if (spotV.getId() == unitV.getSpotId()) {
                l2 += (long)spotV.getDefense();
            }
        }
        if (unitV.getOperationDaimyo() != null && unitV.getOperationDaimyo().isDark() && unitV.getOperationDaimyo().getFame() < 0) {
            l2 += (long)unitV.getGameDataV().getParameters().getDarkAttackRate();
        }
        l += l * l2 / 100L;
        long l3 = (long)((double)unitV2.getDefense() * Math.sqrt(unitV2.getLeave()));
        long l4 = 0L;
        switch (spotV.getType()) {
            case 2: {
                l4 += (long)unitV2.getAmountEffect().getDefensePlusRateMountain();
                break;
            }
            case 1: {
                l4 += (long)unitV2.getAmountEffect().getDefensePlusRatePlane();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                l4 += (long)unitV2.getAmountEffect().getDefensePlusRateSea();
            }
        }
        if (0 < unitV2.getUnit().getGun()) {
            l4 += (long)unitV2.getAmountEffect().getDefensePlusRateGun();
        }
        if (0 < unitV2.getUnit().getHorse()) {
            l4 += (long)unitV2.getAmountEffect().getDefensePlusRateHorse();
        }
        if (spotV.getCountryId() == unitV2.getCountryId()) {
            l4 += (long)unitV2.getAmountEffect().getDefensePlusRateInner();
            if (spotV.getId() == unitV2.getSpotId()) {
                l4 += (long)spotV.getDefense();
            }
        }
        l3 += l3 * l4 / 100L;
        int n = (int)Math.ceil((double)((long)unitV.getLeave() * l) * 1.0 / (double)(l3 * 5L));
        return n;
    }

    public static SpotV getBattleTargetUnit(GameDataV gameDataV, int n, SpotV spotV, int n2) {
        List<SpotV> list = GameUtil.getSpots(gameDataV, gameDataV.nearbySpotIds(spotV.getId(), n2));
        for (SpotV spotV2 : list) {
            if (!GameTacticsUtil.existsBattleTargetUnit(gameDataV, n, spotV2)) continue;
            return spotV2;
        }
        return null;
    }

    public static boolean existsBattleTargetUnit(GameDataV gameDataV, int n, SpotV spotV, int n2) {
        List<SpotV> list = GameUtil.getSpots(gameDataV, gameDataV.nearbySpotIds(spotV.getId(), n2));
        for (SpotV spotV2 : list) {
            if (!GameTacticsUtil.existsBattleTargetUnit(gameDataV, n, spotV2)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsBattleTargetUnit(GameDataV gameDataV, int n, SpotV spotV) {
        return spotV.getUnits().stream().anyMatch(unitV -> gameDataV.isBattleTerget(n, unitV.getOperationDaimyoId()));
    }

    public static boolean existsOperationUnit(GameDataV gameDataV, int n, SpotV spotV) {
        return spotV.getUnits().stream().anyMatch(unitV -> unitV.getOperationDaimyoId() == n);
    }

    public static SpotV alertSpot(GameDataV gameDataV, DaimyoV daimyoV, TacticsAction tacticsAction) {
        List<CountryV> list = GameTacticsUtil.getGoOutCountries(gameDataV, daimyoV.getId());
        if (list.isEmpty()) {
            return null;
        }
        for (CountryV countryV : list) {
            SpotV spotV = countryV.getCapitalSpot();
            boolean bl = tacticsAction.getCommandNewMap().values().stream().anyMatch(tacticsActionEntry -> tacticsActionEntry.getSpotId() == spotV.getId());
            if (bl || !GameTacticsUtil.existsBattleTargetUnit(gameDataV, daimyoV.getId(), spotV, 1) || GameTacticsUtil.existsOperationUnit(gameDataV, daimyoV.getId(), spotV)) continue;
            return spotV;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$updateBySprint$252(GameDataV gameDataV, CountryV countryV, Integer n) {
        return gameDataV.isAllianceLike(n.intValue(), countryV.getDaimyoId());
    }
}

