/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.common.Pair;
import game.sengoku.common.GameHistoryCreator;
import game.sengoku.common.GameNoticeCreator;
import game.sengoku.common.GameUtil;
import game.sengoku.common.JusticeCreator;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Justice;
import game.sengoku.data.KnightV;
import game.sengoku.data.RoleV;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.Notice;
import game.sengoku.game.domestic.DomesticEvent;
import game.sengoku.game.domestic.DomesticEventResult;
import java.util.List;

public class GameEventUtil {
    public static void createEvents(GameDataV gameDataV, List<Pair<Integer, DomesticEvent>> list) {
        gameDataV.getDaimyos().values().stream().filter(daimyoV -> !daimyoV.isFall()).sorted((daimyoV, daimyoV2) -> daimyoV2.getFame() - daimyoV.getFame()).forEach(daimyoV -> GameEventUtil.createEvents(gameDataV, daimyoV.getId(), list));
    }

    public static void createEvents(GameDataV gameDataV, int n, List<Pair<Integer, DomesticEvent>> list) {
        int n2;
        Object object;
        int n3 = gameDataV.getParameters().getJusticeBorderMinPeriod();
        int n4 = gameDataV.getParameters().getEventAppearRate();
        gameDataV.getBorderConflicts().stream().filter(borderConflictV -> borderConflictV.getMonth() > n3).filter(borderConflictV -> borderConflictV.getDaimyoId1() == n || borderConflictV.getDaimyoId2() == n).forEach(borderConflictV -> {
            if (gameDataV.getJustices().stream().noneMatch(justice -> justice.getDaimyoId() == n && justice.getTargetId() == borderConflictV.getId()) && GameUtil.getRandom(n4)) {
                DomesticEvent domesticEvent = new DomesticEvent(1);
                domesticEvent.setSpotId(borderConflictV.getSpotId1());
                domesticEvent.getArgs().add(borderConflictV.getId());
                list.add(new Pair<Integer, DomesticEvent>(n, domesticEvent));
            }
        });
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        if (daimyoV.getChristTreat() == 1) {
            for (Object object2 : daimyoV.getNearbyDaimyo()) {
                if (object2.getChristTreat() != -1 || !gameDataV.getJustices().stream().noneMatch(arg_0 -> GameEventUtil.lambda$createEvents$243(n, (DaimyoV)object2, arg_0)) || !GameUtil.getRandom(n4)) continue;
                object = new DomesticEvent(2);
                ((DomesticEvent)object).getArgs().add(object2.getId());
                list.add(new Pair<Integer, Object>(n, object));
            }
        }
        for (Object object2 : daimyoV.getCountries()) {
            for (CountryV countryV2 : gameDataV.getCountries().values()) {
                if (object2.getId() == countryV2.getId() || object2.getDaimyoId() == countryV2.getDaimyoId() || gameDataV.distanceCountry(object2.getId(), countryV2.getId()) != 1 || countryV2.getTamichu() * 3 >= object2.getTamichu() || !gameDataV.getJustices().stream().noneMatch(justice -> justice.getDaimyoId() == n && justice.getTargetId() == countryV2.getDaimyoId()) || !GameUtil.getRandom(n4)) continue;
                DomesticEvent domesticEvent = new DomesticEvent(3);
                domesticEvent.setSpotId(countryV2.getCapitalSpot().getId());
                domesticEvent.getArgs().add(countryV2.getDaimyoId());
                list.add(new Pair<Integer, DomesticEvent>(n, domesticEvent));
            }
        }
        WorldDataV worldDataV = gameDataV.getWorld();
        if (daimyoV.getChrist() >= 10 && worldDataV.getMonth() % 3 == 0 && daimyoV.getChristTreat() == 0) {
            Object object2;
            object2 = new DomesticEvent(4);
            list.add(new Pair<Integer, DaimyoV>(n, (DaimyoV)object2));
        }
        if (daimyoV.getChristTreat() == 1 && (n2 = daimyoV.getCountries().stream().mapToInt(countryV -> countryV.getChrist()).max().orElse(0)) >= 60 && !daimyoV.getKnight().isBaptism() && GameUtil.getRandom(n4)) {
            object = new DomesticEvent(5);
            list.add(new Pair<Integer, Object>(n, object));
        }
        int n5 = gameDataV.getParameters().getShogunImpactMin();
        if (daimyoV.getImpact() >= n5 && worldDataV.getKingFamilyId() == 0 && worldDataV.getMonth() == 1 && gameDataV.getDaimyos().values().stream().noneMatch(daimyoV2 -> daimyoV.getImpact() <= daimyoV2.getImpact() && daimyoV.getId() != daimyoV2.getId()) && GameUtil.getRandom(n4)) {
            object = new DomesticEvent(6);
            int n6 = GameEventUtil.getShogunId(gameDataV);
            if (n6 != 0) {
                ((DomesticEvent)object).getArgs().add(n6);
                list.add(new Pair<Integer, Object>(n, object));
            }
        }
    }

    public static int getShogunId(GameDataV gameDataV) {
        return gameDataV.getRoles().values().parallelStream().filter(roleV -> roleV.getRole().isTop()).mapToInt(roleV -> roleV.getId()).findFirst().orElse(0);
    }

    public static void reflectEventsResult(GameDataV gameDataV, DomesticEventResult domesticEventResult, List<Pair<Integer, Notice>> list) {
        if (domesticEventResult == null) {
            return;
        }
        switch (domesticEventResult.getEventId()) {
            case 1: {
                BorderConflictV borderConflictV2 = gameDataV.getBorderConflicts().stream().filter(borderConflictV -> borderConflictV.getId() == domesticEventResult.getArgs().get(0).intValue()).findFirst().orElse(null);
                if (borderConflictV2 == null) {
                    return;
                }
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = null;
                int n2 = 0;
                int n3 = 0;
                if (borderConflictV2.getDaimyoId1() == n) {
                    daimyoV = borderConflictV2.getDaimyo2();
                    n2 = borderConflictV2.getCountryId1();
                    n3 = borderConflictV2.getCountryId2();
                } else {
                    daimyoV = borderConflictV2.getDaimyo1();
                    n2 = borderConflictV2.getCountryId2();
                    n3 = borderConflictV2.getCountryId1();
                }
                int n4 = gameDataV.getParameters().getJusticeBorderPeriod();
                Justice justice = JusticeCreator.justiceBorder(n, daimyoV.getId(), borderConflictV2, n4);
                gameDataV.getJustices().add(justice);
                Notice notice = GameNoticeCreator.borderConflictJustice(daimyoV);
                list.add(new Pair<Integer, Notice>(n, notice));
                break;
            }
            case 2: {
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(domesticEventResult.getArgs().get(0));
                int n5 = gameDataV.getParameters().getJusticeChristPeriod();
                Justice justice = JusticeCreator.justiceChrist(n, daimyoV.getId(), n5);
                gameDataV.getJustices().add(justice);
                Notice notice = GameNoticeCreator.borderConflictJustice(daimyoV);
                list.add(new Pair<Integer, Notice>(n, notice));
                break;
            }
            case 3: {
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(domesticEventResult.getArgs().get(0));
                int n6 = gameDataV.getParameters().getJusticeHelpPeriod();
                Justice justice = JusticeCreator.justiceHelp(n, daimyoV.getId(), n6);
                gameDataV.getJustices().add(justice);
                Notice notice = GameNoticeCreator.borderConflictJustice(daimyoV);
                list.add(new Pair<Integer, Notice>(n, notice));
                break;
            }
            case 4: {
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
                int n7 = domesticEventResult.getArgs().get(0);
                daimyoV.setChristTreat(n7);
                Notice notice = GameNoticeCreator.christTreat(n7);
                list.add(new Pair<Integer, Notice>(n, notice));
                break;
            }
            case 5: {
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
                KnightV knightV = daimyoV.getKnight();
                GameCommandUtil.updateBaptism(gameDataV, knightV, list);
                break;
            }
            case 6: {
                int n = domesticEventResult.getDaimyoId();
                DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
                int n8 = domesticEventResult.getArgs().get(0);
                RoleV roleV = (RoleV)gameDataV.getRoles().get(n8);
                roleV.setDaimyoId(n);
                Notice notice = GameNoticeCreator.role(daimyoV, roleV);
                list.add(new Pair<Integer, Notice>(99, notice));
                notice = GameHistoryCreator.role(roleV);
                list.add(new Pair<Integer, Notice>(n, notice));
            }
        }
    }

    private static /* synthetic */ boolean lambda$createEvents$243(int n, DaimyoV daimyoV, Justice justice) {
        return justice.getDaimyoId() == n && justice.getTargetId() == daimyoV.getId();
    }
}

