/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.RoleV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.data.WorldDataV;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GameDiplomacyUtil {
    public static boolean canAlliance(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && (unmodifiableReration.getStatus() == 0 || unmodifiableReration.getStatus() == 2);
    }

    public static boolean canNonAggression(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && unmodifiableReration.getStatus() == 5;
    }

    public static boolean canDetante(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && unmodifiableReration.getStatus() == 4;
    }

    public static boolean canTreat(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        if (unmodifiableReration.getStatus() == 7 || unmodifiableReration.getStatus() == 6) {
            return false;
        }
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent();
    }

    public static boolean canBorderConflict(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return 0 < unmodifiableReration.getBorder();
    }

    public static boolean canBreakAlliance(GameDataV gameDataV, int n, int n2) {
        return gameDataV.isAllianceLike(n, n2);
    }

    public static boolean canEnemyTo(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && unmodifiableReration.getStatus() == 0;
    }

    public static boolean canToubatsu(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration;
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        return gameDataV.getWorld().getKingFamilyId() == n && daimyoV.isIndependent() && ((unmodifiableReration = gameDataV.getRelation(n, n2)).getStatus() == 0 || unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) && daimyoV.getToubatsuLeave() <= 0;
    }

    public static boolean canToubatsuRemove(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        return gameDataV.getWorld().getKingFamilyId() == n2 && 0 < daimyoV.getToubatsuLeave();
    }

    public static boolean canToubatsuRequest(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        return gameDataV.getWorld().getKingFamilyId() == n2 && daimyoV.getToubatsuLeave() <= 0;
    }

    public static boolean canRental(GameDataV gameDataV, int n, int n2) {
        return gameDataV.isAllianceLike(n, n2);
    }

    public static boolean canReturnRental(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV;
        long l;
        return gameDataV.isAllianceLike(n, n2) && (l = (daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n)).getKnights().stream().filter(knightV -> knightV.getRentalDaimyoId() == n2).count()) > 0L;
    }

    public static boolean canEnemyToRequest(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && (unmodifiableReration.getStatus() == 0 || unmodifiableReration.getStatus() == 2 || unmodifiableReration.getStatus() == 1);
    }

    public static boolean canBreakAllianceRequest(GameDataV gameDataV, int n, int n2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(n, n2);
        return unmodifiableReration.getDaimyo1().isIndependent() && unmodifiableReration.getDaimyo2().isIndependent() && (unmodifiableReration.getStatus() == 0 || unmodifiableReration.getStatus() == 2 || unmodifiableReration.getStatus() == 1);
    }

    public static boolean canRoleRequest(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        return gameDataV.getWorld().getKingFamilyId() == n2 && daimyoV.getToubatsuLeave() <= 0;
    }

    public static List<KnightV> getKnightRental(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> knightV.isEmployee()).filter(knightV -> !knightV.isGoOut()).filter(knightV -> knightV.getRentalDaimyoId() == 0).collect(Collectors.toList());
        return list;
    }

    public static List<Integer> getKnightRentalIds(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<Integer> list = daimyoV.getKnights().parallelStream().filter(knightV -> knightV.isEmployee()).filter(knightV -> !knightV.isGoOut()).filter(knightV -> knightV.getRentalDaimyoId() == 0).mapToInt(knightV -> knightV.getId()).boxed().collect(Collectors.toList());
        return list;
    }

    public static List<Integer> getKnightRentalReturn(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<Integer> list = daimyoV.getBeingKnights().parallelStream().filter(knightV -> knightV.isEmployee()).filter(knightV -> !knightV.isGoOut()).filter(knightV -> knightV.getDaimyoId() == n2).mapToInt(knightV -> knightV.getId()).boxed().collect(Collectors.toList());
        return list;
    }

    public static List<Integer> getEnemyDaimyoIds(GameDataV gameDataV, int n, int n2) {
        if (!GameDiplomacyUtil.canEnemyToRequest(gameDataV, n2, n)) {
            return Collections.emptyList();
        }
        List<Integer> list = gameDataV.getRelations().stream().filter(relationV -> relationV.getDaimyoId1() == n).filter(relationV -> relationV.getDaimyoId2() != n2).filter(relationV -> relationV.getStatus() == 0).mapToInt(relationV -> relationV.getDaimyoId2()).boxed().collect(Collectors.toList());
        return list;
    }

    public static List<Integer> getBreakDaimyoIds(GameDataV gameDataV, int n, int n2) {
        if (!GameDiplomacyUtil.canBreakAllianceRequest(gameDataV, n2, n)) {
            return Collections.emptyList();
        }
        List<Integer> list = gameDataV.getRelations().stream().filter(relationV -> relationV.getDaimyoId1() == n).filter(relationV -> relationV.getDaimyoId2() != n2).filter(relationV -> relationV.getStatus() == 1 || relationV.getStatus() == 6 || relationV.getStatus() == 7).mapToInt(relationV -> relationV.getDaimyoId2()).boxed().collect(Collectors.toList());
        return list;
    }

    public static List<Integer> getToubatsuDaimyoIds(GameDataV gameDataV, int n) {
        WorldDataV worldDataV = gameDataV.getWorld();
        List<Integer> list = gameDataV.getDaimyos().values().stream().filter(daimyoV -> daimyoV.getId() != n).filter(daimyoV -> daimyoV.getId() != worldDataV.getKingFamilyId()).filter(daimyoV -> daimyoV.getToubatsuLeave() <= 0).filter(daimyoV -> !gameDataV.isAllianceLike(n, daimyoV.getId())).mapToInt(daimyoV -> daimyoV.getId()).boxed().collect(Collectors.toList());
        return list;
    }

    public static List<TechnologyV> getTradeTechnology(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        List<TechnologyV> list = daimyoV.getTechnologies().stream().filter(technologyV -> technologyV.getTechnology().isCanTrade()).filter(technologyV -> !daimyoV2.getTechnologyIds().contains(technologyV.getId())).collect(Collectors.toList());
        return list;
    }

    public static List<CultureV> getTradeCulture(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        List<CultureV> list = daimyoV.getCultures().stream().filter(cultureV -> cultureV.getCulture().isCanTrade()).filter(cultureV -> !daimyoV2.getCultureIds().contains(cultureV.getId())).collect(Collectors.toList());
        return list;
    }

    public static List<RoleV> getTradeRole(GameDataV gameDataV, int n, int n2) {
        List<RoleV> list = gameDataV.getRoles().values().stream().filter(roleV -> roleV.getDaimyoId() == 0).filter(roleV -> !roleV.getRole().isTop()).collect(Collectors.toList());
        return list;
    }
}

