/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.common.HasAbsoluteXY;
import game.base.common.HasXY;
import game.base.symbol.MouseSymbol;
import game.base.symbol.MouseSymbolLayer;
import game.base.symbol.SymbolRect;
import game.sengoku.main.KessenMain;
import java.util.function.Consumer;

public class CommonSymbol
implements HasAbsoluteXY {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected MouseSymbol mouseSymbol;
    protected Consumer<CommonSymbol> mouseEnter;
    protected Consumer<CommonSymbol> mouseExit;
    protected Consumer<CommonSymbol> primaryClicked;
    protected Consumer<CommonSymbol> secondaryClicked;
    protected MouseSymbolLayer layer;
    protected HasAbsoluteXY origine;

    public CommonSymbol(int n, int n2, int n3, int n4, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        this.setX(n);
        this.setY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
        this.layer = mouseSymbolLayer;
        this.origine = hasAbsoluteXY;
        this.init();
    }

    public CommonSymbol(int n, int n2, int n3, int n4, MouseSymbolLayer mouseSymbolLayer) {
        this(n, n2, n3, n4, mouseSymbolLayer, null);
    }

    protected void init() {
        if (this.origine == null) {
            this.origine = this;
        }
        this.mouseSymbol = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbol.setOrigin(this.origine);
        this.mouseSymbol.setActive(true);
        this.mouseSymbol.getAreas().add(new SymbolRect(this.x, this.y, this.width, this.height));
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setPrimaryClicked(Consumer<CommonSymbol> consumer) {
        this.primaryClicked = consumer;
    }

    public void setSecondaryClicked(Consumer<CommonSymbol> consumer) {
        this.secondaryClicked = consumer;
    }

    public void setMouseEnter(Consumer<CommonSymbol> consumer) {
        this.mouseEnter = consumer;
    }

    public void setMouseExit(Consumer<CommonSymbol> consumer) {
        this.mouseExit = consumer;
    }

    public MouseSymbol getMouseSymbol() {
        return this.mouseSymbol;
    }

    public void update() {
        this.mouseSymbol.update();
        if (this.mouseSymbol.isMouseEnter() && this.mouseEnter != null) {
            this.mouseEnter.accept(this);
        }
        if (this.mouseSymbol.isMouseExit() && this.mouseExit != null) {
            this.mouseExit.accept(this);
        }
        if (this.mouseSymbol.isMousePrimaryClicked()) {
            if (this.primaryClicked != null) {
                this.primaryClicked.accept(this);
            }
        } else if (this.mouseSymbol.isMouseSecondaryClicked() && this.secondaryClicked != null) {
            this.secondaryClicked.accept(this);
        }
    }

    @Override
    public HasXY getParent() {
        return null;
    }
}

