/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.common.Pair;
import game.sengoku.data.AITarget;
import game.sengoku.data.AIUseObject;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SpotV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitType;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameDebugUtil;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.game.tactics.TacticsActionEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AITacticsUtil {
    public static void createTacticsAction(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, TacticsAction tacticsAction) {
        AITarget aITarget;
        AIUseObject aIUseObject;
        AITacticsUtil.stableUnit(gameDataV, playerV, daimyoV, tacticsAction);
        List<CountryV> list = GameTacticsUtil.getOperationCountries(gameDataV, daimyoV.getId());
        for (CountryV object2 : list) {
            aIUseObject = playerV.getAIUseObject();
            aITarget = (AITarget)aIUseObject.getCountryTarget().get(object2.getId());
            if (aITarget == null) continue;
            switch (aITarget.getKind()) {
                case 4: {
                    AITacticsUtil.goOut(gameDataV, playerV, daimyoV, object2.getCapitalSpot(), false, tacticsAction);
                    break;
                }
                case 3: {
                    AITacticsUtil.goOut(gameDataV, playerV, daimyoV, object2.getCapitalSpot(), false, tacticsAction);
                    break;
                }
            }
        }
        List<UnitV> list2 = GameTacticsUtil.getOperationUnits(gameDataV, daimyoV.getId());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            aIUseObject = (UnitV)iterator.next();
            if (aIUseObject.isBattle()) continue;
            aITarget = playerV.getAIUseObject();
            AITarget aITarget2 = (AITarget)aITarget.getUnitTarget().get(aIUseObject.getKnightId());
            int n = 1;
            if (aITarget2 != null) {
                n = aITarget2.getKind();
            }
            switch (n) {
                case 1: {
                    AITacticsUtil.unitNone(gameDataV, playerV, daimyoV, (UnitV)aIUseObject, tacticsAction);
                    break;
                }
                case 4: {
                    AITacticsUtil.unitAttack(gameDataV, playerV, daimyoV, (UnitV)aIUseObject, aITarget2, tacticsAction);
                    break;
                }
                case 3: {
                    AITacticsUtil.unitDefense(gameDataV, playerV, daimyoV, (UnitV)aIUseObject, aITarget2, tacticsAction);
                    break;
                }
                case 2: {
                    AITacticsUtil.unitShoot(gameDataV, playerV, daimyoV, (UnitV)aIUseObject, tacticsAction);
                    break;
                }
            }
        }
    }

    public static List<Pair<UnitType, Integer>> selectUnitType(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, CountryV countryV, boolean bl, TacticsAction tacticsAction) {
        ArrayList<Pair<UnitType, Integer>> arrayList = new ArrayList<Pair<UnitType, Integer>>();
        List<UnitType> list = GameTacticsUtil.getGoOutUnits(gameDataV, daimyoV, countryV, tacticsAction);
        if (list.isEmpty()) {
            return arrayList;
        }
        int[] nArray = GameTacticsUtil.getUsingResource(tacticsAction, countryV);
        int n = countryV.getUsableArmy() - nArray[0];
        for (UnitType unitType : list) {
            int n2 = n;
            if (0 < unitType.getGun()) {
                n2 = Math.min(n2, (daimyoV.getGun() - nArray[1]) / unitType.getGun());
                n2 = Math.min(n2, daimyoV.getGunpowder() / (unitType.getGun() * 2));
            }
            if (0 < unitType.getHorse()) {
                n2 = Math.min(n2, (daimyoV.getHorse() - nArray[2]) / unitType.getHorse());
            }
            if (!bl && (n2 = Math.min(n2, n - countryV.getMaxArmy() / 3)) <= countryV.getMaxArmy() / 3) continue;
            arrayList.add(new Pair<UnitType, Integer>(unitType, n2));
        }
        if (daimyoV.getAiType().getDemandHorse() > daimyoV.getAiType().getDemandGun()) {
            arrayList.sort((pair, pair2) -> {
                if (pair2.getSecond() == pair.getSecond()) {
                    if (((UnitType)pair2.getFirst()).getHorse() == ((UnitType)pair.getFirst()).getHorse()) {
                        return ((UnitType)pair2.getFirst()).getAttackRate() - ((UnitType)pair.getFirst()).getAttackRate();
                    }
                    return ((UnitType)pair2.getFirst()).getHorse() - ((UnitType)pair.getFirst()).getHorse();
                }
                return (Integer)pair2.getSecond() - (Integer)pair.getSecond();
            });
        } else {
            arrayList.sort((pair, pair2) -> {
                if (pair2.getSecond() == pair.getSecond()) {
                    if (((UnitType)pair2.getFirst()).getGun() == ((UnitType)pair.getFirst()).getGun()) {
                        int n = AITacticsUtil.getMaxShootPower(gameDataV, (UnitType)pair.getFirst());
                        int n2 = AITacticsUtil.getMaxShootPower(gameDataV, (UnitType)pair2.getFirst());
                        if (n2 == n) {
                            return ((UnitType)pair2.getFirst()).getAttackRate() - ((UnitType)pair.getFirst()).getAttackRate();
                        }
                        return n2 - n;
                    }
                    return ((UnitType)pair2.getFirst()).getGun() - ((UnitType)pair.getFirst()).getGun();
                }
                return (Integer)pair2.getSecond() - (Integer)pair.getSecond();
            });
        }
        return arrayList;
    }

    private static int getMaxShootPower(GameDataV gameDataV, UnitType unitType) {
        int n = 0;
        Iterator iterator = unitType.getUniqTechniqueIds().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Technique technique = (Technique)gameDataV.getGameData().getTechniques().get(n2);
            if (technique.getKind() != 2 || n >= technique.getDamage()) continue;
            n = technique.getDamage();
        }
        return n;
    }

    public static int goOut(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, SpotV spotV, boolean bl, TacticsAction tacticsAction) {
        CountryV countryV = spotV.getCountry();
        if (countryV == null) {
            return 0;
        }
        List<KnightV> list = GameTacticsUtil.getGoOutKnight(gameDataV, countryV.getId(), playerV, tacticsAction);
        if (list.isEmpty()) {
            return 0;
        }
        KnightV knightV3 = list.stream().sorted((knightV, knightV2) -> knightV2.getTactics() - knightV.getTactics()).findFirst().orElse(null);
        List<Pair<UnitType, Integer>> list2 = AITacticsUtil.selectUnitType(gameDataV, playerV, daimyoV, countryV, bl, tacticsAction);
        if (list2.isEmpty()) {
            return 0;
        }
        Pair<UnitType, Integer> pair = list2.get(0);
        UnitType unitType = pair.getFirst();
        int n = pair.getSecond();
        int n2 = spotV.getId();
        boolean bl2 = false;
        int n3 = daimyoV.getAiType().getPlunderFameMin();
        boolean bl3 = daimyoV.isCanBisha() || daimyoV.isDark() ? true : (bl2 = daimyoV.getFame() >= n3);
        if (0 < n) {
            TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandGoOut(daimyoV.getId(), knightV3.getId(), unitType.getId(), n2, n, 0, 0, 0, bl2);
            tacticsAction.addNew(tacticsActionEntry);
            return knightV3.getId();
        }
        return 0;
    }

    public static void stableUnit(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, TacticsAction tacticsAction) {
        List<CountryV> list = GameTacticsUtil.getGoOutCountries(gameDataV, daimyoV.getId());
        if (list.isEmpty()) {
            return;
        }
        for (CountryV countryV : list) {
            int n;
            SpotV spotV = countryV.getCapitalSpot();
            if (!GameTacticsUtil.existsBattleTargetUnit(gameDataV, daimyoV.getId(), spotV, 2) || GameTacticsUtil.existsOperationUnit(gameDataV, daimyoV.getId(), spotV) || (n = AITacticsUtil.goOut(gameDataV, playerV, daimyoV, spotV, true, tacticsAction)) == 0) continue;
            AITarget aITarget = new AITarget(2);
            playerV.getAIUseObject().getUnitTarget().put(n, aITarget);
        }
    }

    public static void unitNone(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, UnitV unitV, TacticsAction tacticsAction) {
        if (unitV.isReleasable()) {
            TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandRelease(daimyoV.getId(), unitV.getId());
            tacticsAction.put(unitV.getId(), tacticsActionEntry);
        } else {
            int n = unitV.getCountry().getCapitalSpot().getId();
            AITacticsUtil.unitMove(gameDataV, playerV, daimyoV, unitV, n, tacticsAction);
        }
    }

    public static void unitAttack(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, UnitV unitV, AITarget aITarget, TacticsAction tacticsAction) {
        AITacticsUtil.unitDefense(gameDataV, playerV, daimyoV, unitV, aITarget, tacticsAction);
    }

    public static void unitDefense(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, UnitV unitV, AITarget aITarget, TacticsAction tacticsAction) {
        if (!aITarget.getArgs().isEmpty() && !AITacticsUtil.unitShoot(gameDataV, playerV, daimyoV, unitV, tacticsAction)) {
            int n = (Integer)aITarget.getArgs().get(0);
            AITacticsUtil.unitMove(gameDataV, playerV, daimyoV, unitV, n, tacticsAction);
        }
    }

    private static boolean unitShoot(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, UnitV unitV, TacticsAction tacticsAction) {
        List<Technique> list = AITacticsUtil.shootTechnique(gameDataV, daimyoV, unitV);
        if (list.isEmpty()) {
            return false;
        }
        Technique technique = list.get(0);
        SpotV spotV = GameTacticsUtil.getBattleTargetUnit(gameDataV, daimyoV.getId(), unitV.getSpot(), unitV.getUnit().getVision());
        if (spotV != null) {
            TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandTechniqueShot(daimyoV.getId(), unitV.getId(), technique.getId(), spotV.getId());
            tacticsAction.put(unitV.getId(), tacticsActionEntry);
            return true;
        }
        return false;
    }

    private static boolean unitMove(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, UnitV unitV, int n, TacticsAction tacticsAction) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = gameDataV.distanceSpotWeight(unitV.getSpotId(), n, daimyoV.getId(), arrayList);
        GameDebugUtil.printSpots(gameDataV, arrayList);
        if (0 < n2 && n2 < 100) {
            int n3 = (Integer)arrayList.get(arrayList.size() - 1);
            TacticsActionEntry tacticsActionEntry = TacticsActionEntry.commandMove(daimyoV.getId(), unitV.getId(), unitV.getSpotId(), n3);
            tacticsAction.put(unitV.getId(), tacticsActionEntry);
            return true;
        }
        return false;
    }

    private static List<Technique> shootTechnique(GameDataV gameDataV, DaimyoV daimyoV, UnitV unitV) {
        ArrayList<Technique> arrayList = new ArrayList<Technique>();
        Iterator iterator = unitV.getTechniqueIds().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Technique technique3 = (Technique)gameDataV.getGameData().getTechniques().get(n);
            if (technique3 == null || technique3.getKind() != 2) continue;
            unitV.updateBattle();
            if (unitV.isBattle() || unitV.getDaimyo().getGunpowder() < technique3.getGunpowder() * unitV.getLeave()) continue;
            arrayList.add(technique3);
        }
        arrayList.sort((technique, technique2) -> technique2.getDamage() - technique.getDamage());
        return arrayList;
    }
}

