/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.common.Pair;
import game.sengoku.common.AIDiplomacyUtil;
import game.sengoku.common.AIDomesticUtil;
import game.sengoku.common.TacticsActionEntryValueRecord;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.Present;
import game.sengoku.data.RoleV;
import game.sengoku.data.StoreV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.game.GameCostUtil;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.game.diplomacy.NegotiationValueTable;
import game.sengoku.game.diplomacy.StoreAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AINegotiationUtil {
    private static final int TYPE_FOOD = 1;
    private static final int TYPE_POPULATION = 2;
    private static final int TYPE_COMMERCE = 3;
    private static final int TYPE_ARMY = 4;
    private static final int TYPE_CHRIST = 5;
    private static final int TYPE_POWER = 6;
    private static final int TYPE_CULTURE = 8;
    private static final int TYPE_TAMICHU = 9;
    private static final int TYPE_OTHER = 10;

    private static boolean shouldTradeTechnology(int n, DaimyoV daimyoV, DaimyoV daimyoV2, GameDataV gameDataV) {
        TechnologyV technologyV = (TechnologyV)gameDataV.getTechnologies().get(n);
        if (technologyV != null) {
            return AINegotiationUtil.shouldTrade(daimyoV, daimyoV2, technologyV.getTechnology().getEffect(), gameDataV);
        }
        return false;
    }

    private static boolean shouldTradeCulture(int n, DaimyoV daimyoV, DaimyoV daimyoV2, GameDataV gameDataV) {
        CultureV cultureV = (CultureV)gameDataV.getCultures().get(n);
        if (cultureV != null) {
            return AINegotiationUtil.shouldTrade(daimyoV, daimyoV2, cultureV.getCulture().getEffect(), gameDataV);
        }
        return false;
    }

    private static int monthToCultureWin(DaimyoV daimyoV, Effect effect) {
        int n = 8000;
        double d = daimyoV.getCountries().parallelStream().mapToInt(countryV -> countryV.getAmountEffect().getCulturePlus()).average().orElse(0.0);
        int n2 = daimyoV.getAmountEffect().getCulturePlusRate();
        int n3 = (int)((d + (double)effect.getCulturePlus()) * (double)(100 + n2 + effect.getCulturePlusRate()) / 100.0);
        if (n3 == 0) {
            return 99999;
        }
        int n4 = (n - daimyoV.getCultureArv()) / n3;
        return n4;
    }

    private static boolean shouldTrade(DaimyoV daimyoV, DaimyoV daimyoV2, Effect effect, GameDataV gameDataV) {
        int n = effect.getValue();
        int n2 = daimyoV.getTechnologies().stream().mapToInt(technologyV -> technologyV.getTechnology().getEffect().getValue()).sum() + daimyoV.getCultures().stream().mapToInt(cultureV -> cultureV.getCulture().getEffect().getValue()).sum();
        int n3 = daimyoV2.getTechnologies().stream().mapToInt(technologyV -> technologyV.getTechnology().getEffect().getValue()).sum() + daimyoV2.getCultures().stream().mapToInt(cultureV -> cultureV.getCulture().getEffect().getValue()).sum();
        if (n3 + n > n2) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration == null) {
            return false;
        }
        double d = 1.0;
        if (unmodifiableReration.getFriendShip() > 0) {
            d = 1.0 + (double)unmodifiableReration.getFriendShip() * 0.1;
        } else if (unmodifiableReration.getFriendShip() < 0) {
            d = 1.0 / (1.0 - (double)unmodifiableReration.getFriendShip() * 0.1);
        }
        if (unmodifiableReration.getStatus() == 1) {
            d += 0.2;
        }
        int n4 = AINegotiationUtil.judgeType(effect);
        switch (n4) {
            case 1: {
                if (!((double)daimyoV.getFoodAmount() * d < (double)daimyoV2.getFoodAmount())) break;
                return false;
            }
            case 2: {
                if (!((double)daimyoV.getPopulationAmount() * d < (double)daimyoV2.getPopulationAmount())) break;
                return false;
            }
            case 3: {
                if (!((double)daimyoV.getCommerce() * d < (double)daimyoV2.getCommerce())) break;
                return false;
            }
            case 4: {
                if (!((double)daimyoV.getArmyPower() * d < (double)daimyoV2.getArmyPower())) break;
                return false;
            }
            case 5: {
                if (daimyoV.getChristTreat() == daimyoV2.getChristTreat()) break;
                return false;
            }
            case 6: {
                if (!((double)daimyoV.getCountries().size() * d < (double)daimyoV2.getCountries().size())) break;
                return false;
            }
            case 8: {
                if (!((double)AINegotiationUtil.monthToCultureWin(daimyoV2, effect) * d < (double)AINegotiationUtil.monthToCultureWin(daimyoV, effect))) break;
                return false;
            }
            case 9: {
                if (!((double)daimyoV.getCountries().size() * d < (double)daimyoV2.getCountries().size())) break;
                return false;
            }
            case 10: {
                break;
            }
        }
        return true;
    }

    private static int judgeType(Effect effect) {
        if (effect == null) {
            return 10;
        }
        if (effect.getArmyExpPlus() > 0 || effect.getArmyExpPlusRate() > 0 || effect.getArmyPlus() > 0 || effect.getAttackPlusRate() > 0 || effect.getAttackPlusRateGun() > 0 || effect.getAttackPlusRateHorse() > 0 || effect.getAttackPlusRateInner() > 0 || effect.getAttackPlusRateMountain() > 0 || effect.getAttackPlusRatePlane() > 0 || effect.getAttackPlusRateSea() > 0 || effect.getAttackPlusRateShoot() > 0) {
            return 4;
        }
        if (effect.getDefensePlus() > 0 || effect.getDefensePlusRate() > 0 || effect.getDefensePlusRateGun() > 0 || effect.getDefensePlusRateHorse() > 0 || effect.getDefensePlusRateInner() > 0 || effect.getDefensePlusRateMountain() > 0 || effect.getDefensePlusRatePlane() > 0 || effect.getDefensePlusRateSea() > 0 || effect.getSpeedPlusRate() > 0) {
            return 4;
        }
        if (effect.getCommercePlus() > 0 || effect.getCommercePlusRate() > 0 || effect.getMaxCommerceRate() > 0) {
            return 3;
        }
        if (effect.getCulturePlus() > 0 || effect.getCulturePlusRate() > 0) {
            return 8;
        }
        if (effect.getFoodPlus() > 0 || effect.getFoodPlusRate() > 0 || effect.getMaxFoodRate() > 0) {
            return 1;
        }
        if (effect.getMaxChristRate() > 0 || effect.getChristPlus() > 0) {
            return 5;
        }
        if (effect.getPopulationPlus() > 0 || effect.getPopulationPlusRate() > 0) {
            return 2;
        }
        if (effect.getPowerRate() > 0) {
            return 6;
        }
        if (effect.getTamichuPlus() > 0 || effect.getTamichuPlusRate() > 0 || effect.getMaxTamichuPlus() > 0) {
            return 9;
        }
        return 10;
    }

    public static void valuing(GameDataV gameDataV, NegotiationAction negotiationAction, DaimyoV daimyoV, DaimyoV daimyoV2, NegotiationValueTable negotiationValueTable, NegotiationValueTable negotiationValueTable2, List<TacticsActionEntryValueRecord> list) {
        negotiationAction.validate();
        AINegotiationUtil.valuing(gameDataV, negotiationAction.getSelfEntry(), daimyoV, daimyoV2, negotiationValueTable, negotiationValueTable2, list);
        ArrayList<TacticsActionEntryValueRecord> arrayList = new ArrayList<TacticsActionEntryValueRecord>();
        AINegotiationUtil.valuing(gameDataV, negotiationAction.getTargetEntry(), daimyoV2, daimyoV, negotiationValueTable2, negotiationValueTable, arrayList);
        arrayList.forEach(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.swap());
        list.addAll(arrayList);
    }

    public static void valuing(GameDataV gameDataV, NegotiationActionEntry negotiationActionEntry, DaimyoV daimyoV2, DaimyoV daimyoV3, NegotiationValueTable negotiationValueTable, NegotiationValueTable negotiationValueTable2, List<TacticsActionEntryValueRecord> list) {
        int n;
        int n2;
        int n3;
        int n42;
        for (int n42 : negotiationActionEntry.getTechnologyIds()) {
            n3 = negotiationValueTable2.getTechnologyValues().get(n42);
            list.add(new TacticsActionEntryValueRecord(1, n42, 0, 0, n3, 0));
        }
        for (int n42 : negotiationActionEntry.getCultureIds()) {
            n3 = negotiationValueTable2.getCultureValues().get(n42);
            list.add(new TacticsActionEntryValueRecord(2, n42, 0, 0, n3, 0));
        }
        if (negotiationActionEntry.getMoney() > 0) {
            int n5 = (int)((double)negotiationActionEntry.getMoney() * negotiationValueTable.getMoneyValue());
            n42 = (int)((double)negotiationActionEntry.getMoney() * negotiationValueTable2.getMoneyValue());
            list.add(new TacticsActionEntryValueRecord(3, 0, 0, n5, n42, 0));
        }
        if (negotiationActionEntry.getGun() > 0) {
            int n6 = (int)((double)negotiationActionEntry.getGun() * negotiationValueTable.getGunValue());
            n42 = (int)((double)negotiationActionEntry.getGun() * negotiationValueTable2.getGunValue());
            list.add(new TacticsActionEntryValueRecord(4, 0, 0, n6, n42, 0));
        }
        if (negotiationActionEntry.getHorse() > 0) {
            int n7 = (int)((double)negotiationActionEntry.getHorse() * negotiationValueTable.getHorseValue());
            n42 = (int)((double)negotiationActionEntry.getHorse() * negotiationValueTable2.getHorseValue());
            list.add(new TacticsActionEntryValueRecord(6, 0, 0, n7, n42, 0));
        }
        if (negotiationActionEntry.getIron() > 0) {
            int n8 = (int)((double)negotiationActionEntry.getIron() * negotiationValueTable.getIronValue());
            n42 = (int)((double)negotiationActionEntry.getIron() * negotiationValueTable2.getIronValue());
            list.add(new TacticsActionEntryValueRecord(8, 0, 0, n8, n42, 0));
        }
        if (negotiationActionEntry.getGunpowder() > 0) {
            int n9 = (int)((double)negotiationActionEntry.getGunpowder() * negotiationValueTable.getGunpowderValue());
            n42 = (int)((double)negotiationActionEntry.getGunpowder() * negotiationValueTable2.getGunpowderValue());
            list.add(new TacticsActionEntryValueRecord(5, 0, 0, n9, n42, 0));
        }
        if (negotiationActionEntry.getSaltpeter() > 0) {
            int n10 = (int)((double)negotiationActionEntry.getSaltpeter() * negotiationValueTable.getSaltpeterValue());
            n42 = (int)((double)negotiationActionEntry.getSaltpeter() * negotiationValueTable2.getSaltpeterValue());
            list.add(new TacticsActionEntryValueRecord(7, 0, 0, n10, n42, 0));
        }
        if (negotiationActionEntry.isAlliance()) {
            int n11 = (int)Math.ceil(1.0 * (double)negotiationValueTable.getAllianceValue() * (double)daimyoV2.getActualArmyPower() / (double)daimyoV3.getActualArmyPower());
            list.add(new TacticsActionEntryValueRecord(9, 0, 0, n11, 0, 0));
        }
        if (negotiationActionEntry.isNonAggression()) {
            int n12 = AIDiplomacyUtil.pinchRate(gameDataV, daimyoV2, daimyoV3) * (int)Math.ceil(18000.0 * gameDataV.getWorld().getInflationRate());
            list.add(new TacticsActionEntryValueRecord(10, 0, n12, 0, 0, 0));
        }
        if (negotiationActionEntry.isDetente()) {
            int n13 = (int)Math.ceil(1.0 * (double)negotiationValueTable.getAllianceValue() * (double)daimyoV2.getActualArmyPower() / (double)daimyoV3.getActualArmyPower());
            list.add(new TacticsActionEntryValueRecord(18, 0, 0, n13, 0, 0));
        }
        for (int n42 : negotiationActionEntry.getEnemyToIds()) {
            DaimyoV daimyoV4 = (DaimyoV)gameDataV.getDaimyos().get(n42);
            n2 = AINegotiationUtil.demeritOfEnemyTo(gameDataV, daimyoV2, daimyoV4, negotiationValueTable);
            list.add(new TacticsActionEntryValueRecord(11, n42, 0, n2, 0, 0));
        }
        for (int n42 : negotiationActionEntry.getBreakIds()) {
            DaimyoV daimyoV5 = (DaimyoV)gameDataV.getDaimyos().get(n42);
            n2 = AINegotiationUtil.demeritOfEnemyTo(gameDataV, daimyoV2, daimyoV5, negotiationValueTable);
            list.add(new TacticsActionEntryValueRecord(12, n42, 0, n2, 0, 0));
        }
        for (int n42 : negotiationActionEntry.getRentalKnightIds()) {
            KnightV knightV = (KnightV)gameDataV.getKnights().get(n42);
            n2 = AINegotiationUtil.meritOfKnight(gameDataV, daimyoV2, knightV, negotiationValueTable);
            n = AINegotiationUtil.meritOfKnight(gameDataV, daimyoV3, knightV, negotiationValueTable2);
            list.add(new TacticsActionEntryValueRecord(13, n42, 0, n2, n, 0));
        }
        for (int n42 : negotiationActionEntry.getRentalReturnKnightIds()) {
            KnightV knightV = (KnightV)gameDataV.getKnights().get(n42);
            n2 = AINegotiationUtil.meritOfKnight(gameDataV, daimyoV2, knightV, negotiationValueTable);
            n = AINegotiationUtil.meritOfKnight(gameDataV, daimyoV3, knightV, negotiationValueTable2);
            list.add(new TacticsActionEntryValueRecord(14, n42, 0, n2, n, 0));
        }
        for (int n42 : negotiationActionEntry.getToubatsuToIds()) {
            DaimyoV daimyoV6 = (DaimyoV)gameDataV.getDaimyos().get(n42);
            n2 = AINegotiationUtil.demeritOfEnemyTo(gameDataV, daimyoV2, daimyoV6, negotiationValueTable);
            long l = gameDataV.getDaimyos().values().stream().filter(daimyoV -> daimyoV.getToubatsuLeave() > 0).count();
            list.add(new TacticsActionEntryValueRecord(15, n42, 0, 0, n2 *= (int)Math.pow(2.0, l), 0));
        }
        for (int n42 : negotiationActionEntry.getToubatsuRemoveIds()) {
            DaimyoV daimyoV7 = (DaimyoV)gameDataV.getDaimyos().get(n42);
            n2 = AINegotiationUtil.demeritOfEnemyTo(gameDataV, daimyoV2, daimyoV7, negotiationValueTable);
            long l = gameDataV.getDaimyos().values().stream().filter(daimyoV -> daimyoV.getToubatsuLeave() > 0).count();
            list.add(new TacticsActionEntryValueRecord(16, n42, 0, 0, n2 *= (int)Math.pow(2.0, l), 0));
        }
        for (int n42 : negotiationActionEntry.getRoleIds()) {
            RoleV roleV = (RoleV)gameDataV.getRoles().get(n42);
            n2 = negotiationValueTable.getAllianceValue() * roleV.getRole().getMinImpact() / 30;
            list.add(new TacticsActionEntryValueRecord(17, n42, 0, 0, n2, 0));
        }
    }

    public static int judgeNegotiate(GameDataV gameDataV, PlayerV playerV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        if (AIDiplomacyUtil.mustEnemyTo(gameDataV, playerV, n, n2)) {
            return 3;
        }
        if (AIDiplomacyUtil.shouldBreakAlliance(gameDataV, playerV, daimyoV, daimyoV2)) {
            return 2;
        }
        if (AIDiplomacyUtil.mustToubatsu(gameDataV, playerV, daimyoV, daimyoV2)) {
            return 4;
        }
        NegotiationAction negotiationAction = new NegotiationAction(true, n, n2);
        boolean bl = AINegotiationUtil.createNegotiationActionWithSim(gameDataV, playerV, negotiationAction);
        if (bl && !negotiationAction.isEmptyOr()) {
            return 1;
        }
        return 6;
    }

    public static boolean createNegotiationActionWithSim(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        int n;
        boolean bl = false;
        for (n = 0; n < 3; ++n) {
            AINegotiationUtil.createNegotiationAction(gameDataV, playerV, negotiationAction);
            NegotiationAction negotiationAction2 = NegotiationAction.reverse(negotiationAction);
            AINegotiationUtil.editRequest(gameDataV, negotiationAction2);
            NegotiationAction negotiationAction3 = NegotiationAction.reverse(negotiationAction2);
            bl = AINegotiationUtil.editRequest(gameDataV, playerV, negotiationAction3);
            negotiationAction.copy(negotiationAction3);
            if (!bl) break;
        }
        return n < 3;
    }

    public static void createNegotiationAction(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        negotiationAction.setAgreement(false);
        negotiationAction.setContinuous(true);
        int n = negotiationAction.getSelfEntry().getDaimyoId();
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        int n3 = AIDiplomacyUtil.pinchRate(gameDataV, daimyoV, daimyoV2) * (int)Math.ceil(18000.0 * gameDataV.getWorld().getInflationRate());
        if (2 <= n3) {
            AINegotiationUtil.createNegotiationActionWhenNonAggression(gameDataV, playerV, negotiationAction);
        } else {
            AINegotiationUtil.createNegotiationActionWhenNormal(gameDataV, playerV, negotiationAction);
        }
    }

    public static void createNegotiationActionWhenNonAggression(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        int n = negotiationAction.getSelfEntry().getDaimyoId();
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        negotiationAction.getSelfEntry().setNonAggression(true);
        negotiationAction.getTargetEntry().setNonAggression(true);
        List<TechnologyV> list = GameDiplomacyUtil.getTradeTechnology(gameDataV, n, n2);
        for (TechnologyV object2 : list) {
            negotiationAction.getSelfEntry().getTechnologyIds().add(object2.getId());
        }
        List<CultureV> list2 = GameDiplomacyUtil.getTradeCulture(gameDataV, n, n2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            CultureV cultureV = (CultureV)iterator.next();
            negotiationAction.getSelfEntry().getCultureIds().add(cultureV.getId());
        }
        negotiationAction.getSelfEntry().setMoney(daimyoV.getMoney());
        negotiationAction.getSelfEntry().setGun(daimyoV.getGun());
        negotiationAction.getSelfEntry().setGunpowder(daimyoV.getGunpowder());
        negotiationAction.getSelfEntry().setHorse(daimyoV.getHorse());
        negotiationAction.getSelfEntry().setIron(daimyoV.getIron());
        negotiationAction.getSelfEntry().setSaltpeter(daimyoV.getSaltpeter());
        AINegotiationUtil.ngFilter(gameDataV, playerV, daimyoV, daimyoV2, negotiationAction);
        AINegotiationUtil.editRequest(gameDataV, negotiationAction, true);
        negotiationAction.setAgreement(false);
        negotiationAction.setContinuous(true);
    }

    public static void createNegotiationActionWhenNormal(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        List<CultureV> list;
        int n;
        DaimyoV daimyoV;
        int n2 = negotiationAction.getSelfEntry().getDaimyoId();
        int n3 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        if (AIDiplomacyUtil.mustThreat(gameDataV, playerV, daimyoV2, daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n3))) {
            negotiationAction.getSelfEntry().setThreat(true);
            negotiationAction.getTargetEntry().setSurrender(true);
        } else if (AIDiplomacyUtil.mustAlliance(gameDataV, playerV, daimyoV2, daimyoV)) {
            negotiationAction.getSelfEntry().setAlliance(true);
            negotiationAction.getTargetEntry().setAlliance(true);
        } else if (AIDiplomacyUtil.mustNonAggression(gameDataV, playerV, daimyoV2, daimyoV)) {
            negotiationAction.getSelfEntry().setNonAggression(true);
            negotiationAction.getTargetEntry().setNonAggression(true);
        }
        if (AIDiplomacyUtil.mustBorderConflict(gameDataV, playerV, daimyoV2, daimyoV)) {
            negotiationAction.getSelfEntry().setBorder(true);
            negotiationAction.getTargetEntry().setBorder(true);
        }
        if (AIDiplomacyUtil.mustDetente(gameDataV, playerV, daimyoV2, daimyoV)) {
            negotiationAction.getSelfEntry().setDetente(true);
            negotiationAction.getTargetEntry().setDetente(true);
        }
        Object object = GameDiplomacyUtil.getBreakDaimyoIds(gameDataV, n3, n2).iterator();
        while (object.hasNext()) {
            n = object.next();
            if (negotiationAction.getTargetEntry().getBreakIds().contains(n) || !gameDataV.isEnemy(n2, n) || !AIDiplomacyUtil.shouldBreakAlliance(gameDataV, playerV, daimyoV, daimyoV2, n)) continue;
            negotiationAction.getTargetEntry().getBreakIds().add(n);
            break;
        }
        object = GameDiplomacyUtil.getEnemyDaimyoIds(gameDataV, n3, n2).iterator();
        while (object.hasNext()) {
            n = object.next();
            if (negotiationAction.getTargetEntry().getEnemyToIds().contains(n) || !gameDataV.isEnemy(n2, n) || !AIDiplomacyUtil.shouldEnemyTo(gameDataV, playerV, n3, n)) continue;
            negotiationAction.getTargetEntry().getEnemyToIds().add(n);
            break;
        }
        if (!(object = GameDiplomacyUtil.getTradeTechnology(gameDataV, n3, n2)).isEmpty()) {
            object.sort((technologyV, technologyV2) -> AIDomesticUtil.priprityOfTechnology(daimyoV2, technologyV2.getTechnology()) - AIDomesticUtil.priprityOfTechnology(daimyoV2, technologyV.getTechnology()));
            TechnologyV technologyV3 = (TechnologyV)object.get(0);
            negotiationAction.getTargetEntry().getTechnologyIds().add(technologyV3.getId());
        }
        if (!(list = GameDiplomacyUtil.getTradeCulture(gameDataV, n3, n2)).isEmpty()) {
            list.sort((cultureV, cultureV2) -> AIDomesticUtil.priprityOfCulture(daimyoV2, cultureV2.getCulture()) - AIDomesticUtil.priprityOfCulture(daimyoV2, cultureV.getCulture()));
            CultureV cultureV3 = list.get(0);
            negotiationAction.getTargetEntry().getCultureIds().add(cultureV3.getId());
        }
        for (RoleV roleV : gameDataV.getRoles().values()) {
            if (!AIDiplomacyUtil.mustRole(gameDataV, playerV, daimyoV, daimyoV2, roleV)) continue;
            negotiationAction.getTargetEntry().getRoleIds().add(roleV.getId());
            break;
        }
        for (RoleV roleV : daimyoV2.getWars()) {
            if (roleV.getToubatsuLeave() > 0 || !AIDiplomacyUtil.shouldToubatsu(gameDataV, playerV, daimyoV, (DaimyoV)roleV)) continue;
            negotiationAction.getTargetEntry().getToubatsuToIds().add(roleV.getId());
            break;
        }
        AINegotiationUtil.exchangeHorseGun(gameDataV, daimyoV2, daimyoV, negotiationAction);
        AINegotiationUtil.exchangeHorseGun(gameDataV, daimyoV, daimyoV2, negotiationAction);
    }

    public static void exchangeHorseGun(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, NegotiationAction negotiationAction) {
        int n = (int)Math.floor(100.0 / gameDataV.getWorld().getPriceHorse());
        int n2 = (int)Math.floor(100.0 / gameDataV.getWorld().getPriceGun());
        int n3 = (int)Math.floor(100.0 / gameDataV.getWorld().getPriceGunpowder());
        if (daimyoV.getAiType().getDemandHorse() > 100 && (daimyoV.getGun() > n2 || daimyoV.getGunpowder() > n3) && daimyoV2.getAiType().getDemandGun() > 100 && daimyoV2.getHorse() > n) {
            int n4 = daimyoV.getGun();
            int n5 = daimyoV.getGunpowder();
            int n6 = daimyoV2.getHorse();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while ((n4 > n2 || n5 > n3) && n6 > n) {
                if (n4 > n2) {
                    n4 -= n2;
                    n7 += n2;
                } else if (n5 > n3) {
                    n5 -= n3;
                    n8 += n3;
                }
                if (n6 <= n) continue;
                n6 -= n6;
                n9 += n6;
            }
            negotiationAction.getSelfEntry().setGun(n7);
            negotiationAction.getSelfEntry().setGunpowder(n8);
            negotiationAction.getTargetEntry().setHorse(n9);
        }
    }

    public static void editNegotiationAction(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        if (10 < negotiationAction.getSequenceNumber()) {
            negotiationAction.setAgreement(false);
            negotiationAction.setContinuous(false);
            return;
        }
        boolean bl = false;
        if (AINegotiationUtil.editRequest(gameDataV, playerV, negotiationAction)) {
            bl = true;
        }
        if (negotiationAction.getTargetEntry().isEmpty()) {
            negotiationAction.setAgreement(false);
            negotiationAction.setContinuous(false);
            return;
        }
        if (!bl) {
            negotiationAction.setAgreement(true);
            negotiationAction.setContinuous(false);
            return;
        }
    }

    private static boolean editRequest(GameDataV gameDataV, PlayerV playerV, NegotiationAction negotiationAction) {
        int n = negotiationAction.getSelfEntry().getDaimyoId();
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        boolean bl = AINegotiationUtil.ngFilter(gameDataV, playerV, daimyoV, daimyoV2, negotiationAction);
        boolean bl2 = AINegotiationUtil.editRequest(gameDataV, negotiationAction);
        return bl || bl2;
    }

    public static boolean editRequest(GameDataV gameDataV, NegotiationAction negotiationAction) {
        return AINegotiationUtil.editRequest(gameDataV, negotiationAction, false);
    }

    public static boolean editRequest(GameDataV gameDataV, NegotiationAction negotiationAction, boolean bl) {
        boolean bl2 = false;
        int n = negotiationAction.getSelfEntry().getDaimyoId();
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        NegotiationValueTable negotiationValueTable = new NegotiationValueTable(gameDataV, daimyoV);
        NegotiationValueTable negotiationValueTable2 = new NegotiationValueTable(gameDataV, daimyoV2);
        ArrayList<TacticsActionEntryValueRecord> arrayList = new ArrayList<TacticsActionEntryValueRecord>();
        AINegotiationUtil.valuing(gameDataV, negotiationAction, daimyoV, daimyoV2, negotiationValueTable, negotiationValueTable2, arrayList);
        if (!AINegotiationUtil.valid(gameDataV, negotiationAction, daimyoV, daimyoV2, arrayList)) {
            if (AINegotiationUtil.ajust(gameDataV, negotiationAction, negotiationValueTable, negotiationValueTable2, bl, arrayList)) {
                bl2 = true;
            } else {
                negotiationAction.clear();
            }
        }
        return bl2;
    }

    private static boolean valid(GameDataV gameDataV, NegotiationAction negotiationAction, DaimyoV daimyoV, DaimyoV daimyoV2, List<TacticsActionEntryValueRecord> list) {
        int n = list.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getValue()).sum();
        int n2 = AINegotiationUtil.negotiationLower(gameDataV, daimyoV, daimyoV2);
        return n2 <= n;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean ajust(GameDataV gameDataV, NegotiationAction negotiationAction, NegotiationValueTable negotiationValueTable, NegotiationValueTable negotiationValueTable2, boolean bl, List<TacticsActionEntryValueRecord> list) {
        int n;
        int n2 = negotiationAction.getSelfEntry().getDaimyoId();
        int n3 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n3);
        ArrayList<TacticsActionEntryValueRecord> arrayList = new ArrayList<TacticsActionEntryValueRecord>();
        arrayList.addAll(list);
        ArrayList<TacticsActionEntryValueRecord> arrayList2 = new ArrayList<TacticsActionEntryValueRecord>();
        List<CultureV> list2 = GameDiplomacyUtil.getTradeCulture(gameDataV, n3, n2);
        for (CultureV object2 : list2) {
            if (daimyoV.getCultureIds().contains(object2.getId()) || negotiationAction.getTargetEntry().getCultureIds().contains(object2.getId())) continue;
            int n7 = negotiationValueTable.getCultureValues().get(object2.getId());
            arrayList2.add(new TacticsActionEntryValueRecord(2, object2.getId(), n7, 0, 0, 0));
        }
        List<TechnologyV> list3 = GameDiplomacyUtil.getTradeTechnology(gameDataV, n3, n2);
        Iterator n5 = list3.iterator();
        while (n5.hasNext()) {
            TechnologyV technologyV = (TechnologyV)n5.next();
            if (daimyoV.getTechnologyIds().contains(technologyV.getId()) || negotiationAction.getTargetEntry().getTechnologyIds().contains(technologyV.getId())) continue;
            n = negotiationValueTable.getTechnologyValues().get(technologyV.getId());
            arrayList2.add(new TacticsActionEntryValueRecord(1, technologyV.getId(), n, 0, 0, 0));
        }
        boolean bl2 = false;
        block26: while (true) {
            int n4;
            void var14_17;
            if (100 < ++var14_17) {
                return false;
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            int n6 = arrayList.stream().mapToInt(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getValue()).sum();
            n = AINegotiationUtil.negotiationLower(gameDataV, daimyoV, daimyoV2);
            if (n <= n6 || AINegotiationUtil.increaseActionMerit(gameDataV, negotiationAction, negotiationValueTable, negotiationValueTable2, n - n6, bl)) break;
            arrayList.clear();
            AINegotiationUtil.valuing(gameDataV, negotiationAction, daimyoV, daimyoV2, negotiationValueTable, negotiationValueTable2, arrayList);
            if (bl) {
                arrayList2.clear();
            }
            int n7 = 999999;
            TacticsActionEntryValueRecord tacticsActionEntryValueRecord2 = null;
            int n8 = 1;
            for (TacticsActionEntryValueRecord tacticsActionEntryValueRecord3 : arrayList) {
                n4 = Math.abs(n - (n6 - tacticsActionEntryValueRecord3.getValue()));
                if (n4 >= n7) continue;
                tacticsActionEntryValueRecord2 = tacticsActionEntryValueRecord3;
                n8 = 1;
                n7 = n4;
            }
            for (TacticsActionEntryValueRecord tacticsActionEntryValueRecord3 : arrayList2) {
                n4 = Math.abs(n - (n6 + tacticsActionEntryValueRecord3.getValue()));
                if (n4 >= n7) continue;
                tacticsActionEntryValueRecord2 = tacticsActionEntryValueRecord3;
                n8 = 2;
                n7 = n4;
            }
            if (tacticsActionEntryValueRecord2 == null) {
                arrayList.clear();
                continue;
            }
            if (n8 == 1) {
                arrayList.remove(tacticsActionEntryValueRecord2);
                switch (tacticsActionEntryValueRecord2.getKind()) {
                    case 1: {
                        negotiationAction.getSelfEntry().getTechnologyIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 2: {
                        negotiationAction.getSelfEntry().getCultureIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 3: {
                        negotiationAction.getSelfEntry().setMoney(0);
                        continue block26;
                    }
                    case 4: {
                        negotiationAction.getSelfEntry().setGun(0);
                        continue block26;
                    }
                    case 5: {
                        negotiationAction.getSelfEntry().setGunpowder(0);
                        continue block26;
                    }
                    case 6: {
                        negotiationAction.getSelfEntry().setHorse(0);
                        continue block26;
                    }
                    case 7: {
                        negotiationAction.getSelfEntry().setSaltpeter(0);
                        continue block26;
                    }
                    case 8: {
                        negotiationAction.getSelfEntry().setIron(0);
                        continue block26;
                    }
                    case 18: {
                        negotiationAction.getSelfEntry().setDetente(false);
                        negotiationAction.getTargetEntry().setDetente(false);
                        arrayList.removeIf(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getKind() == 18);
                        continue block26;
                    }
                    case 9: {
                        negotiationAction.getSelfEntry().setAlliance(false);
                        negotiationAction.getTargetEntry().setAlliance(false);
                        arrayList.removeIf(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getKind() == 9);
                        continue block26;
                    }
                    case 10: {
                        negotiationAction.getSelfEntry().setNonAggression(false);
                        negotiationAction.getTargetEntry().setNonAggression(false);
                        arrayList.removeIf(tacticsActionEntryValueRecord -> tacticsActionEntryValueRecord.getKind() == 10);
                        continue block26;
                    }
                    case 11: {
                        negotiationAction.getSelfEntry().getEnemyToIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 12: {
                        negotiationAction.getSelfEntry().getBreakIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 13: {
                        negotiationAction.getSelfEntry().getRentalKnightIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 14: {
                        negotiationAction.getSelfEntry().getRentalReturnKnightIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 15: {
                        negotiationAction.getSelfEntry().getToubatsuToIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 16: {
                        negotiationAction.getSelfEntry().getToubatsuRemoveIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                    case 17: {
                        negotiationAction.getSelfEntry().getRoleIds().remove((Object)tacticsActionEntryValueRecord2.getArg());
                        continue block26;
                    }
                }
                continue;
            }
            if (n8 != 2) continue;
            arrayList2.remove(tacticsActionEntryValueRecord2);
            arrayList.add(tacticsActionEntryValueRecord2);
            switch (tacticsActionEntryValueRecord2.getKind()) {
                case 1: {
                    negotiationAction.getTargetEntry().getTechnologyIds().add(tacticsActionEntryValueRecord2.getArg());
                    break;
                }
                case 2: {
                    negotiationAction.getTargetEntry().getCultureIds().add(tacticsActionEntryValueRecord2.getArg());
                    break;
                }
            }
        }
        return true;
    }

    private static boolean increaseActionMerit(GameDataV gameDataV, NegotiationAction negotiationAction, NegotiationValueTable negotiationValueTable, NegotiationValueTable negotiationValueTable2, int n, boolean bl) {
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        NegotiationActionEntry negotiationActionEntry = negotiationAction.getTargetEntry();
        int n3 = daimyoV.getHorse() - negotiationActionEntry.getHorse();
        int n4 = daimyoV.getIron() - negotiationActionEntry.getIron();
        int n5 = daimyoV.getGun() - negotiationActionEntry.getGun();
        int n6 = daimyoV.getGunpowder() - negotiationActionEntry.getGunpowder();
        int n7 = daimyoV.getSaltpeter() - negotiationActionEntry.getSaltpeter();
        int n8 = 0;
        n8 = (int)((double)n8 + (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()) * (double)n3);
        n8 = (int)((double)n8 + (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()) * (double)n5);
        n8 = (int)((double)n8 + (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()) * (double)n6);
        n8 = (int)((double)n8 + (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()) * (double)n7);
        if ((n8 = (int)((double)n8 + (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()) * (double)n4)) < n || bl) {
            return AINegotiationUtil.reduceActionMerit(gameDataV, negotiationAction, negotiationValueTable, negotiationValueTable2, n);
        }
        n8 = 0;
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        arrayList.add(new Pair<Integer, Integer>(11, negotiationValueTable.getHorseDemand()));
        arrayList.add(new Pair<Integer, Integer>(12, negotiationValueTable.getGunDemand()));
        arrayList.add(new Pair<Integer, Integer>(13, negotiationValueTable.getGunpowderDemand()));
        arrayList.add(new Pair<Integer, Integer>(15, negotiationValueTable.getSaltpeterDemand()));
        arrayList.add(new Pair<Integer, Integer>(14, negotiationValueTable.getIronDemand()));
        arrayList.sort((pair, pair2) -> (int)Math.signum((Integer)pair2.getSecond() - (Integer)pair.getSecond()));
        for (Pair pair3 : arrayList) {
            if (n <= n8) {
                return true;
            }
            switch ((Integer)pair3.getFirst()) {
                case 11: {
                    int n9 = (int)Math.ceil((double)(n - n8) / (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()));
                    n9 = Math.min(n9, n3);
                    n8 = (int)((double)n8 + (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()) * (double)n9);
                    negotiationAction.getTargetEntry().setHorse(negotiationAction.getTargetEntry().getHorse() + n9);
                    break;
                }
                case 12: {
                    int n9 = (int)Math.ceil((double)(n - n8) / (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()));
                    n9 = Math.min(n9, n5);
                    n8 = (int)((double)n8 + (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()) * (double)n9);
                    negotiationAction.getTargetEntry().setGun(negotiationAction.getTargetEntry().getGun() + n9);
                    break;
                }
                case 13: {
                    int n9 = (int)Math.ceil((double)(n - n8) / (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()));
                    n9 = Math.min(n9, n6);
                    n8 = (int)((double)n8 + (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()) * (double)n9);
                    negotiationAction.getTargetEntry().setGunpowder(negotiationAction.getTargetEntry().getGunpowder() + n9);
                    break;
                }
                case 15: {
                    int n9 = (int)Math.ceil((double)(n - n8) / (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()));
                    n9 = Math.min(n9, n7);
                    n8 = (int)((double)n8 + (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()) * (double)n9);
                    negotiationAction.getTargetEntry().setSaltpeter(negotiationAction.getTargetEntry().getSaltpeter() + n9);
                    break;
                }
                case 14: {
                    int n9 = (int)Math.ceil((double)(n - n8) / (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()));
                    n9 = Math.min(n9, n4);
                    n8 = (int)((double)n8 + (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()) * (double)n9);
                    negotiationAction.getTargetEntry().setIron(negotiationAction.getTargetEntry().getIron() + n9);
                    break;
                }
            }
        }
        return AINegotiationUtil.reduceActionMerit(gameDataV, negotiationAction, negotiationValueTable, negotiationValueTable2, n - n8);
    }

    private static boolean reduceActionMerit(GameDataV gameDataV, NegotiationAction negotiationAction, NegotiationValueTable negotiationValueTable, NegotiationValueTable negotiationValueTable2, int n) {
        int n2 = negotiationAction.getTargetEntry().getDaimyoId();
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2);
        NegotiationActionEntry negotiationActionEntry = negotiationAction.getSelfEntry();
        int n3 = negotiationActionEntry.getMoney();
        int n4 = negotiationActionEntry.getHorse();
        int n5 = negotiationActionEntry.getIron();
        int n6 = negotiationActionEntry.getGun();
        int n7 = negotiationActionEntry.getGunpowder();
        int n8 = negotiationActionEntry.getSaltpeter();
        int n9 = 0;
        n9 = (int)((double)n9 + (negotiationValueTable.getMoneyValue() + negotiationValueTable2.getMoneyValue()) * (double)n3);
        n9 = (int)((double)n9 + (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()) * (double)n4);
        n9 = (int)((double)n9 + (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()) * (double)n6);
        n9 = (int)((double)n9 + (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()) * (double)n7);
        n9 = (int)((double)n9 + (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()) * (double)n8);
        if ((n9 = (int)((double)n9 + (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()) * (double)n5)) < n) {
            return false;
        }
        n9 = 0;
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        arrayList.add(new Pair<Integer, Integer>(11, negotiationValueTable.getHorseDemand()));
        arrayList.add(new Pair<Integer, Integer>(12, negotiationValueTable.getGunDemand()));
        arrayList.add(new Pair<Integer, Integer>(13, negotiationValueTable.getGunpowderDemand()));
        arrayList.add(new Pair<Integer, Integer>(15, negotiationValueTable.getSaltpeterDemand()));
        arrayList.add(new Pair<Integer, Integer>(14, negotiationValueTable.getIronDemand()));
        arrayList.add(new Pair<Integer, Integer>(10, 1));
        arrayList.sort((pair, pair2) -> (int)Math.signum((Integer)pair2.getSecond() - (Integer)pair.getSecond()));
        for (Pair pair3 : arrayList) {
            if (n <= n9) {
                return true;
            }
            switch ((Integer)pair3.getFirst()) {
                case 11: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()));
                    n10 = Math.min(n10, n4);
                    n9 = (int)((double)n9 + (negotiationValueTable.getHorseValue() + negotiationValueTable2.getHorseValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setHorse(negotiationAction.getSelfEntry().getHorse() - n10);
                    break;
                }
                case 12: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()));
                    n10 = Math.min(n10, n6);
                    n9 = (int)((double)n9 + (negotiationValueTable.getGunValue() + negotiationValueTable2.getGunValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setGun(negotiationAction.getSelfEntry().getGun() - n10);
                    break;
                }
                case 13: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()));
                    n10 = Math.min(n10, n7);
                    n9 = (int)((double)n9 + (negotiationValueTable.getGunpowderValue() + negotiationValueTable2.getGunpowderValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setGunpowder(negotiationAction.getSelfEntry().getGunpowder() - n10);
                    break;
                }
                case 15: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()));
                    n10 = Math.min(n10, n8);
                    n9 = (int)((double)n9 + (negotiationValueTable.getSaltpeterValue() + negotiationValueTable2.getSaltpeterValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setSaltpeter(negotiationAction.getSelfEntry().getSaltpeter() - n10);
                    break;
                }
                case 14: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()));
                    n10 = Math.min(n10, n5);
                    n9 = (int)((double)n9 + (negotiationValueTable.getIronValue() + negotiationValueTable2.getIronValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setIron(negotiationAction.getSelfEntry().getIron() - n10);
                    break;
                }
                case 10: {
                    int n10 = (int)Math.ceil((double)(n - n9) / (negotiationValueTable.getMoneyValue() + negotiationValueTable2.getMoneyValue()));
                    n10 = Math.min(n10, n3);
                    n9 = (int)((double)n9 + (negotiationValueTable.getMoneyValue() + negotiationValueTable2.getMoneyValue()) * (double)n10);
                    negotiationAction.getSelfEntry().setMoney(negotiationAction.getSelfEntry().getMoney() - n10);
                    break;
                }
            }
        }
        return false;
    }

    public static boolean ngFilter(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2, NegotiationAction negotiationAction) {
        boolean bl = false;
        if (negotiationAction.getSelfEntry().isAlliance() && !AIDiplomacyUtil.shouldAlliance(gameDataV, playerV, daimyoV, daimyoV2)) {
            negotiationAction.getSelfEntry().setAlliance(false);
            negotiationAction.getTargetEntry().setAlliance(false);
            bl = true;
        }
        if (negotiationAction.getSelfEntry().isNonAggression() && !AIDiplomacyUtil.shouldNonAggression(gameDataV, playerV, daimyoV, daimyoV2)) {
            negotiationAction.getSelfEntry().setNonAggression(false);
            negotiationAction.getTargetEntry().setNonAggression(false);
            bl = true;
        }
        if (negotiationAction.getSelfEntry().isSurrender() && !AIDiplomacyUtil.shouldSurrender(gameDataV, playerV, daimyoV, daimyoV2)) {
            negotiationAction.getSelfEntry().setSurrender(false);
            negotiationAction.getTargetEntry().setThreat(false);
            bl = true;
        }
        if (negotiationAction.getSelfEntry().isBorder() && !AIDiplomacyUtil.shouldBorderConflict(gameDataV, playerV, daimyoV, daimyoV2)) {
            negotiationAction.getSelfEntry().setBorder(false);
            negotiationAction.getTargetEntry().setBorder(false);
            bl = true;
        }
        if (negotiationAction.getSelfEntry().isDetente() && !AIDiplomacyUtil.shouldDetente(gameDataV, playerV, daimyoV, daimyoV2)) {
            negotiationAction.getSelfEntry().setDetente(false);
            negotiationAction.getTargetEntry().setDetente(false);
            bl = true;
        }
        if (!negotiationAction.getSelfEntry().getRentalKnightIds().isEmpty()) {
            if (!gameDataV.isAllianceLike(daimyoV.getId(), daimyoV2.getId())) {
                negotiationAction.getSelfEntry().getRentalKnightIds().clear();
                bl = true;
            }
            if (daimyoV2.getImpact() < daimyoV.getImpact() * 2) {
                negotiationAction.getSelfEntry().getRentalKnightIds().clear();
                bl = true;
            }
            if (daimyoV.getKnights().stream().anyMatch(knightV -> knightV.getRentalDaimyoId() == daimyoV2.getId())) {
                negotiationAction.getSelfEntry().getRentalKnightIds().clear();
                bl = true;
            }
        }
        if (!negotiationAction.getSelfEntry().getRentalReturnKnightIds().isEmpty() && daimyoV2.getImpact() * 2 < daimyoV.getImpact()) {
            negotiationAction.getSelfEntry().getRentalReturnKnightIds().clear();
            bl = true;
        }
        int n2 = negotiationAction.getSelfEntry().getBreakIds().size();
        negotiationAction.getSelfEntry().getBreakIds().removeIf(n -> !AIDiplomacyUtil.shouldBreakAlliance(gameDataV, playerV, daimyoV, daimyoV2, n));
        if (negotiationAction.getSelfEntry().getBreakIds().size() != n2) {
            bl = true;
        }
        if (!negotiationAction.getSelfEntry().isNonAggression() && daimyoV.getOwnerId() != daimyoV2.getId()) {
            int n3;
            int n4;
            if (!negotiationAction.getSelfEntry().getTechnologyIds().isEmpty()) {
                n4 = negotiationAction.getSelfEntry().getTechnologyIds().size();
                if (daimyoV.getOwnerId() != daimyoV2.getId()) {
                    negotiationAction.getSelfEntry().getTechnologyIds().removeIf(n -> !AINegotiationUtil.shouldTradeTechnology(n, daimyoV, daimyoV2, gameDataV));
                }
                if (n4 != (n3 = negotiationAction.getSelfEntry().getTechnologyIds().size())) {
                    bl = true;
                }
            }
            if (!negotiationAction.getSelfEntry().getCultureIds().isEmpty()) {
                n4 = negotiationAction.getSelfEntry().getCultureIds().size();
                if (daimyoV.getOwnerId() != daimyoV2.getId()) {
                    negotiationAction.getSelfEntry().getCultureIds().removeIf(n -> !AINegotiationUtil.shouldTradeCulture(n, daimyoV, daimyoV2, gameDataV));
                }
                if (n4 != (n3 = negotiationAction.getSelfEntry().getCultureIds().size())) {
                    bl = true;
                }
            }
        }
        if (daimyoV.getOwnerId() != daimyoV2.getId()) {
            DaimyoV daimyoV3;
            int n5;
            if (!negotiationAction.getSelfEntry().getToubatsuToIds().isEmpty()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(negotiationAction.getSelfEntry().getToubatsuToIds());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    n5 = (Integer)iterator.next();
                    daimyoV3 = (DaimyoV)gameDataV.getDaimyos().get(n5);
                    if (AIDiplomacyUtil.shouldToubatsu(gameDataV, playerV, daimyoV, daimyoV3)) continue;
                    negotiationAction.getSelfEntry().getToubatsuToIds().remove((Object)n5);
                    bl = true;
                }
            }
            if (!negotiationAction.getSelfEntry().getToubatsuRemoveIds().isEmpty()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(negotiationAction.getSelfEntry().getToubatsuRemoveIds());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    n5 = (Integer)iterator.next();
                    daimyoV3 = (DaimyoV)gameDataV.getDaimyos().get(n5);
                    if (!AIDiplomacyUtil.shouldToubatsu(gameDataV, playerV, daimyoV, daimyoV3)) continue;
                    negotiationAction.getSelfEntry().getToubatsuRemoveIds().remove((Object)n5);
                    bl = true;
                }
            }
            if (!negotiationAction.getSelfEntry().getRoleIds().isEmpty()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(negotiationAction.getSelfEntry().getRoleIds());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    n5 = (Integer)iterator.next();
                    daimyoV3 = (RoleV)gameDataV.getRoles().get(n5);
                    if (AIDiplomacyUtil.shouldRole(gameDataV, playerV, daimyoV, daimyoV2, (RoleV)daimyoV3)) continue;
                    negotiationAction.getSelfEntry().getRoleIds().remove((Object)n5);
                    bl = true;
                }
            }
        }
        if (0 < negotiationAction.getSelfEntry().getMoney() && daimyoV.getMoney() < negotiationAction.getSelfEntry().getMoney() + daimyoV.getExpressExpect()) {
            int n6 = daimyoV.getMoney() - (int)((double)daimyoV.getExpressExpect() * 1.2);
            negotiationAction.getSelfEntry().setMoney(Math.max(0, n6));
            bl = true;
        }
        return bl;
    }

    private static int demeritOfEnemyTo(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, NegotiationValueTable negotiationValueTable) {
        double d = 1.0;
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        switch (unmodifiableReration.getFriendShipType()) {
            case -2: {
                d = 0.25;
                break;
            }
            case -1: {
                d = 0.5;
                break;
            }
            case 0: {
                d = 1.0;
                break;
            }
            case 1: {
                d = 2.0;
                break;
            }
            case 2: {
                d = 4.0;
            }
        }
        int n = (int)Math.ceil((double)negotiationValueTable.getAllianceValue() * d);
        return n;
    }

    public static int meritOfKnight(GameDataV gameDataV, DaimyoV daimyoV, KnightV knightV2, NegotiationValueTable negotiationValueTable) {
        double d = daimyoV.getKnightsWithTop().stream().mapToInt(knightV -> knightV.getTactics()).average().orElse(1.0);
        int n = (int)Math.ceil(1.0 * (double)negotiationValueTable.getAllianceValue() * (double)knightV2.getTactics() / d);
        return n;
    }

    public static int negotiationLower(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        double d = -1.5;
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        switch (unmodifiableReration.getFriendShipType()) {
            case -2: {
                d = 1.0;
                break;
            }
            case -1: {
                d = 0.5;
                break;
            }
            case 0: {
                d = -1.5;
                break;
            }
            case 1: {
                d = -2.5;
                break;
            }
            case 2: {
                d = -5.0;
            }
        }
        if (daimyoV.getOwnerId() == daimyoV2.getId()) {
            d = -12.0;
        }
        int n = (int)Math.ceil((double)daimyoV.getIncomeExpect() * d);
        return n;
    }

    private static boolean storeHasTechnology(StoreV storeV, DaimyoV daimyoV) {
        for (Present present : storeV.getStore().getPresents()) {
            if (daimyoV.getTechnologyIds().contains(present.getTechnologyId()) || !daimyoV.getAiType().getPriorTechnologies().contains(present.getTechnologyId())) continue;
            return true;
        }
        return false;
    }

    private static double calcStoreValue(int n, StoreV storeV, DaimyoV daimyoV) {
        double d = 0.0;
        switch (n) {
            case 11: {
                d = storeV.getHorseRate() <= 0.0 ? 999.0 : storeV.getHorseRate();
                break;
            }
            case 12: {
                d = storeV.getGunRate() <= 0.0 ? 999.0 : storeV.getGunRate();
                break;
            }
            case 13: {
                d = storeV.getGunpowderRate() <= 0.0 ? 999.0 : storeV.getGunpowderRate();
                break;
            }
            case 15: {
                d = storeV.getSaltpeterRate() <= 0.0 ? 999.0 : storeV.getSaltpeterRate();
                break;
            }
            case 14: {
                double d2 = d = storeV.getIronRate() <= 0.0 ? 999.0 : storeV.getIronRate();
            }
        }
        if (d < 999.0 && AINegotiationUtil.storeHasTechnology(storeV, daimyoV)) {
            d = 0.0;
        }
        return d;
    }

    private static int orderStore(StoreV storeV, StoreV storeV2, int n, DaimyoV daimyoV) {
        double d = AINegotiationUtil.calcStoreValue(n, storeV, daimyoV);
        double d2 = AINegotiationUtil.calcStoreValue(n, storeV2, daimyoV);
        return (int)Math.signum(d - d2);
    }

    public static int selectBuy(GameDataV gameDataV, DaimyoV daimyoV, List<StoreAction> list) {
        int n;
        NegotiationValueTable negotiationValueTable = new NegotiationValueTable(gameDataV, daimyoV);
        int n2 = daimyoV.getMoney();
        int n3 = negotiationValueTable.getGunDemand();
        int n4 = negotiationValueTable.getHorseDemand();
        int n5 = negotiationValueTable.getIronDemand();
        int n6 = negotiationValueTable.getGunpowderDemand();
        int n7 = negotiationValueTable.getSaltpeterDemand();
        ArrayList<StoreV> arrayList = new ArrayList<StoreV>();
        Iterator iterator = daimyoV.getStoreIds().iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            StoreV storeV3 = (StoreV)gameDataV.getStores().get(n);
            if (storeV3 == null) continue;
            arrayList.add(storeV3);
        }
        int n8 = arrayList.stream().sorted((storeV, storeV2) -> AINegotiationUtil.orderStore(storeV, storeV2, 12, daimyoV)).mapToInt(storeV -> storeV.getId()).findFirst().orElse(0);
        n = arrayList.stream().sorted((storeV, storeV2) -> AINegotiationUtil.orderStore(storeV, storeV2, 11, daimyoV)).mapToInt(storeV -> storeV.getId()).findFirst().orElse(0);
        int n9 = arrayList.stream().sorted((storeV, storeV2) -> AINegotiationUtil.orderStore(storeV, storeV2, 14, daimyoV)).mapToInt(storeV -> storeV.getId()).findFirst().orElse(0);
        int n10 = arrayList.stream().sorted((storeV, storeV2) -> AINegotiationUtil.orderStore(storeV, storeV2, 13, daimyoV)).mapToInt(storeV -> storeV.getId()).findFirst().orElse(0);
        int n11 = arrayList.stream().sorted((storeV, storeV2) -> AINegotiationUtil.orderStore(storeV, storeV2, 15, daimyoV)).mapToInt(storeV -> storeV.getId()).findFirst().orElse(0);
        int n12 = 0;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            StoreV storeV4;
            int n13 = AINegotiationUtil.selectBuy(gameDataV, daimyoV, list, storeV4, n8 == (storeV4 = (StoreV)iterator2.next()).getId() ? n3 : 0, n == storeV4.getId() ? n4 : 0, n9 == storeV4.getId() ? n5 : 0, n10 == storeV4.getId() ? n6 : 0, n11 == storeV4.getId() ? n7 : 0, n2);
            n2 -= n13;
            n12 += n13;
        }
        return n12;
    }

    private static int selectBuy(GameDataV gameDataV, DaimyoV daimyoV, List<StoreAction> list, StoreV storeV, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6;
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        arrayList.add(new Pair<Integer, Integer>(2, n4));
        arrayList.add(new Pair<Integer, Integer>(3, n5));
        arrayList.add(new Pair<Integer, Integer>(4, n3));
        arrayList.add(new Pair<Integer, Integer>(1, n));
        arrayList.add(new Pair<Integer, Integer>(0, n2));
        arrayList.sort((pair, pair2) -> (int)Math.signum((Integer)pair2.getSecond() - (Integer)pair.getSecond()));
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (Pair object2 : arrayList) {
            switch ((Integer)object2.getFirst()) {
                case 1: {
                    if (0 >= n || !(0.0 < storeV.getGunRate())) break;
                    n8 = Math.min(n, (int)Math.floor((double)n7 / storeV.getGunRate()));
                    n7 = (int)((double)n7 - storeV.getGunRate() * (double)n8);
                    break;
                }
                case 0: {
                    if (0 >= n2 || !(0.0 < storeV.getHorseRate())) break;
                    n9 = Math.min(n2, (int)Math.floor((double)n7 / storeV.getHorseRate()));
                    n7 = (int)((double)n7 - storeV.getHorseRate() * (double)n9);
                    break;
                }
                case 4: {
                    if (0 >= n3 || !(0.0 < storeV.getIronRate())) break;
                    n10 = Math.min(n3, (int)Math.floor((double)n7 / storeV.getIronRate()));
                    n7 = (int)((double)n7 - storeV.getIronRate() * (double)n10);
                    break;
                }
                case 2: {
                    if (0 >= n4 || !(0.0 < storeV.getGunpowderRate())) break;
                    n11 = Math.min(n4, (int)Math.floor((double)n7 / storeV.getGunpowderRate()));
                    n7 = (int)((double)n7 - storeV.getGunpowderRate() * (double)n11);
                    break;
                }
                case 3: {
                    if (0 >= n5 || !(0.0 < storeV.getSaltpeterRate())) break;
                    n12 = Math.min(n5, (int)Math.floor((double)n7 / storeV.getSaltpeterRate()));
                    n7 = (int)((double)n7 - storeV.getSaltpeterRate() * (double)n12);
                }
            }
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Present> arrayList3 = new ArrayList<Present>();
        int n13 = 0;
        if (storeV.getFriendship().containsKey(daimyoV.getId())) {
            n13 = (Integer)storeV.getFriendship().get(daimyoV.getId());
        }
        for (Present present : storeV.getStore().getPresents()) {
            if (present.getFriendship() > n13 || daimyoV.getTechnologyIds().contains(present.getTechnologyId())) continue;
            arrayList3.add(present);
            n13 -= present.getFriendship();
            break;
        }
        int n14 = AINegotiationUtil.buy(gameDataV, daimyoV, list, storeV, n8, n9, n10, n11, n12, arrayList2, arrayList3, n6);
        return n14;
    }

    private static int buy(GameDataV gameDataV, DaimyoV daimyoV, List<StoreAction> list, StoreV storeV, int n, int n2, int n3, int n4, int n5, List<Integer> list2, List<Present> list3, int n6) {
        int n7 = GameCostUtil.price(gameDataV, daimyoV.getId(), storeV.getId(), n, n2, n3, n4, n5, list2);
        if (n6 < n7) {
            return 0;
        }
        StoreAction storeAction = new StoreAction(0, storeV.getId(), n, n2, n3, n4, n5, list2, list3);
        list.add(storeAction);
        return n7;
    }
}

