/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.sengoku.data.AITarget;
import game.sengoku.data.AIUseObject;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.RoleV;
import game.sengoku.data.SpotV;
import game.sengoku.data.UnitV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.GameTacticsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AIDiplomacyUtil {
    public static void updateAIUseObject(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV) {
        Object object;
        AIUseObject aIUseObject = playerV.getAIUseObject();
        aIUseObject.getCountryTarget().clear();
        aIUseObject.getDaimyoTarget().clear();
        List<CountryV> list = GameTacticsUtil.getOperationCountries(gameDataV, daimyoV.getId());
        for (CountryV object22 : list) {
            if (!AIDiplomacyUtil.whenInvaded(gameDataV, daimyoV, object22, aIUseObject) && !AIDiplomacyUtil.whenIkkou(gameDataV, daimyoV, object22, aIUseObject) && !AIDiplomacyUtil.whenInvadedNear(gameDataV, daimyoV, object22, aIUseObject) && !AIDiplomacyUtil.whenInvadedAlliance(gameDataV, daimyoV, object22, aIUseObject) && !AIDiplomacyUtil.whenNotInvaded(gameDataV, daimyoV, object22, aIUseObject)) continue;
        }
        for (DaimyoV daimyoV2 : gameDataV.getDaimyos().values()) {
            if (aIUseObject.getDaimyoTarget().containsKey(daimyoV2.getId())) continue;
            object = new AITarget(1);
            aIUseObject.getDaimyoTarget().put(daimyoV2.getId(), object);
        }
        List<UnitV> list2 = GameTacticsUtil.getOperationUnits(gameDataV, daimyoV.getId());
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : aIUseObject.getUnitTarget().entrySet()) {
            if (((AITarget)entry.getValue()).getKind() != 2) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        object = list2.iterator();
        block7: while (object.hasNext()) {
            UnitV unitV = (UnitV)object.next();
            AITarget aITarget = (AITarget)hashMap.get(unitV.getKnightId());
            if (aITarget != null) {
                if (aITarget.getKind() == 2) {
                    if (!GameTacticsUtil.existsBattleTargetUnit(gameDataV, daimyoV.getId(), unitV.getSpot(), 2) && 1 <= GameTacticsUtil.countGoOutKnight(gameDataV, unitV.getSpot().getCountryId(), playerV)) {
                        aITarget = new AITarget(1);
                        hashMap.put(unitV.getKnightId(), aITarget);
                    }
                } else {
                    aITarget = null;
                }
            }
            if (aITarget != null) continue;
            AITarget aITarget2 = (AITarget)aIUseObject.getCountryTarget().get(unitV.getCountryId());
            switch (aITarget2.getKind()) {
                case 4: {
                    hashMap.put(unitV.getKnightId(), aITarget2);
                    continue block7;
                }
                case 3: {
                    hashMap.put(unitV.getKnightId(), aITarget2);
                    continue block7;
                }
            }
            aITarget = new AITarget(1);
            hashMap.put(unitV.getKnightId(), aITarget);
        }
        aIUseObject.getUnitTarget().clear();
        aIUseObject.getUnitTarget().putAll(hashMap);
    }

    private static boolean whenIkkou(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, AIUseObject aIUseObject) {
        if (daimyoV.isCanHongan()) {
            return false;
        }
        int n = gameDataV.getParameters().getIkkouId();
        for (SpotV spotV : countryV.getSpots()) {
            for (UnitV unitV : spotV.getUnits()) {
                if (unitV.getUnit().getId() != n) continue;
                AITarget aITarget = new AITarget(4);
                aITarget.getArgs().add(spotV.getId());
                aIUseObject.getCountryTarget().put(countryV.getId(), aITarget);
                return true;
            }
        }
        return false;
    }

    private static boolean whenInvaded(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, int n, AIUseObject aIUseObject) {
        for (SpotV spotV : countryV.getSpots()) {
            if (!GameTacticsUtil.existsBattleTargetUnit(gameDataV, daimyoV.getId(), spotV)) continue;
            AITarget aITarget = new AITarget(3);
            aITarget.getArgs().add(spotV.getId());
            aIUseObject.getCountryTarget().put(n, aITarget);
            return true;
        }
        return false;
    }

    private static boolean whenInvaded(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, AIUseObject aIUseObject) {
        return AIDiplomacyUtil.whenInvaded(gameDataV, daimyoV, countryV, countryV.getId(), aIUseObject);
    }

    private static boolean whenInvadedNear(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, AIUseObject aIUseObject) {
        for (CountryV countryV2 : gameDataV.getCountries().values()) {
            if (gameDataV.distanceCountry(countryV.getId(), countryV2.getId()) != 1 || countryV.getDaimyoId() != countryV2.getDaimyoId() && !gameDataV.isAllianceLike(countryV.getDaimyoId(), countryV2.getDaimyoId()) || !AIDiplomacyUtil.whenInvaded(gameDataV, daimyoV, countryV2, countryV.getId(), aIUseObject)) continue;
            return true;
        }
        return false;
    }

    private static boolean whenInvadedAlliance(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV, AIUseObject aIUseObject) {
        for (CountryV countryV2 : gameDataV.getCountries().values()) {
            if (gameDataV.distanceCountry(countryV.getId(), countryV2.getId()) > 5 || countryV.getDaimyoId() != countryV2.getDaimyoId() && !gameDataV.isAllianceLike(countryV.getDaimyoId(), countryV2.getDaimyoId())) continue;
            DaimyoV daimyoV2 = countryV2.getDaimyo();
            List list = daimyoV2.getWars();
            for (DaimyoV daimyoV3 : list) {
                if (!gameDataV.isBattleTerget(daimyoV.getId(), daimyoV3.getId()) || gameDataV.distanceDaimyo(daimyoV.getId(), daimyoV3.getId()) != 1) continue;
                for (CountryV countryV3 : daimyoV3.getCountries()) {
                    if (gameDataV.distanceCountry(countryV.getId(), countryV3.getId()) != 1) continue;
                    AITarget aITarget = new AITarget(4);
                    aITarget.getArgs().add(countryV3.getCapitalSpot().getId());
                    aIUseObject.getCountryTarget().put(countryV.getId(), aITarget);
                    AITarget aITarget2 = new AITarget(4);
                    aITarget2.getArgs().add(daimyoV3.getId());
                    aIUseObject.getDaimyoTarget().put(daimyoV3.getId(), aITarget2);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean whenNotInvaded(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV3, AIUseObject aIUseObject) {
        List list = gameDataV.getCountries().values().stream().filter(countryV2 -> gameDataV.distanceCountry(countryV3.getId(), countryV2.getId()) <= 5).filter(countryV2 -> countryV3.getDaimyoId() != countryV2.getDaimyoId()).filter(countryV2 -> gameDataV.isBattleTerget(countryV3.getDaimyoId(), countryV2.getDaimyoId())).sorted((countryV, countryV2) -> AIDiplomacyUtil.targetPriority(gameDataV, daimyoV, countryV) - AIDiplomacyUtil.targetPriority(gameDataV, daimyoV, countryV2)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            AITarget aITarget;
            boolean bl = false;
            for (CountryV countryV4 : list) {
                if (!AIDiplomacyUtil.toAttack(gameDataV, daimyoV, countryV4)) continue;
                aITarget = new AITarget(4);
                aITarget.getArgs().add(countryV4.getCapitalSpot().getId());
                aIUseObject.getCountryTarget().put(countryV3.getId(), aITarget);
                AITarget aITarget2 = new AITarget(4);
                aITarget2.getArgs().add(countryV4.getDaimyoId());
                aIUseObject.getDaimyoTarget().put(countryV4.getDaimyoId(), aITarget2);
                bl = true;
                break;
            }
            if (!bl) {
                CountryV countryV4;
                CountryV countryV5 = (CountryV)list.get(0);
                countryV4 = new AITarget(5);
                countryV4.getArgs().add(countryV5.getCapitalSpot().getId());
                aIUseObject.getCountryTarget().put(countryV3.getId(), countryV4);
                aITarget = new AITarget(4);
                aITarget.getArgs().add(countryV5.getDaimyoId());
                aIUseObject.getDaimyoTarget().put(countryV5.getDaimyoId(), aITarget);
            }
        } else {
            AITarget aITarget = new AITarget(1);
            aIUseObject.getCountryTarget().put(countryV3.getId(), aITarget);
        }
        return false;
    }

    public static int targetPriority(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV) {
        switch (daimyoV.getAiType().getTacticsBias()) {
            case 3: {
                UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), countryV.getDaimyoId());
                return unmodifiableReration.getFriendShip();
            }
            case 1: {
                List list = gameDataV.getJusticeList(daimyoV.getId(), countryV.getDaimyoId());
                if (!list.isEmpty()) {
                    return 1;
                }
            }
            case 2: {
                return countryV.getArmyPower();
            }
            case 4: {
                break;
            }
        }
        return 99999;
    }

    public static boolean toAttack(GameDataV gameDataV, DaimyoV daimyoV, CountryV countryV) {
        switch (daimyoV.getAiType().getTacticsBias()) {
            case 3: {
                UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), countryV.getDaimyoId());
                return unmodifiableReration.getFriendShip() < 0;
            }
            case 1: {
                List list = gameDataV.getJusticeList(daimyoV.getId(), countryV.getDaimyoId());
                if (!list.isEmpty()) {
                    return true;
                }
            }
            case 2: {
                int n = daimyoV.getAiType().getWarBorder();
                if (countryV.getDaimyo().getActualArmyPower() * n < daimyoV.getActualArmyPower()) {
                    return true;
                }
            }
            case 4: {
                break;
            }
        }
        return false;
    }

    public static boolean mustEnemyTo(GameDataV gameDataV, PlayerV playerV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        return AIDiplomacyUtil.mustEnemyTo(gameDataV, playerV, daimyoV, daimyoV2);
    }

    public static boolean mustEnemyTo(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        int n;
        if (!GameDiplomacyUtil.canEnemyTo(gameDataV, daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() != 0) {
            return false;
        }
        if (unmodifiableReration.getFriendShipType() == -2) {
            return true;
        }
        if (unmodifiableReration.getFriendShipType() == 2 || unmodifiableReration.getFriendShipType() == 1) {
            return false;
        }
        return playerV != null && ((n = ((AITarget)playerV.getAIUseObject().getDaimyoTarget().get(daimyoV2.getId())).getKind()) == 5 || n == 4);
    }

    public static boolean shouldEnemyTo(GameDataV gameDataV, PlayerV playerV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        return AIDiplomacyUtil.shouldEnemyTo(gameDataV, playerV, daimyoV, daimyoV2);
    }

    public static boolean shouldEnemyTo(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) {
            return false;
        }
        if (unmodifiableReration.getFriendShipType() == 2 || unmodifiableReration.getFriendShipType() == 1) {
            return false;
        }
        if (AIDiplomacyUtil.shouldAlliance(gameDataV, playerV, daimyoV, daimyoV2)) {
            return false;
        }
        return 5 >= gameDataV.distanceDaimyo(daimyoV.getId(), daimyoV2.getId());
    }

    public static boolean mustRole(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2, RoleV roleV) {
        if (roleV.getDaimyoId() != 0) {
            return false;
        }
        return AIDiplomacyUtil.shouldRole(gameDataV, playerV, daimyoV, daimyoV2, roleV);
    }

    public static boolean shouldRole(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2, RoleV roleV) {
        long l;
        if (gameDataV.getWorld().getKingFamilyId() != daimyoV.getId()) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) {
            return false;
        }
        if (daimyoV2.getImpact() < roleV.getRole().getMinImpact()) {
            return false;
        }
        int n = 3;
        switch (unmodifiableReration.getFriendShipType()) {
            case -2: {
                n = 0;
                break;
            }
            case -1: {
                n = 1;
                break;
            }
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(roleV.getRole().getCountries());
        if (roleV.getRole().isAroundJapan()) {
            arrayList.addAll(gameDataV.getCountries().keySet());
        }
        return (l = daimyoV2.getCountries().stream().filter(countryV -> arrayList.contains(countryV.getId())).count()) * (long)n >= (long)arrayList.size();
    }

    public static boolean mustToubatsu(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV2, DaimyoV daimyoV3) {
        if (!GameDiplomacyUtil.canToubatsu(gameDataV, daimyoV2.getId(), daimyoV3.getId())) {
            return false;
        }
        long l = gameDataV.getDaimyos().values().stream().filter(daimyoV -> daimyoV.getToubatsuLeave() > 0).count();
        if (3L < l) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV2.getId(), daimyoV3.getId());
        if (unmodifiableReration.getStatus() == 5) {
            return true;
        }
        return unmodifiableReration.getFriendShipType() == -2;
    }

    public static boolean shouldToubatsu(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (gameDataV.getWorld().getKingFamilyId() != daimyoV.getId()) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration == null) {
            return false;
        }
        if (unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) {
            return true;
        }
        return unmodifiableReration.getFriendShipType() == -2 || unmodifiableReration.getFriendShipType() == -1;
    }

    public static boolean mustAlliance(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (!GameDiplomacyUtil.canAlliance(gameDataV, daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        if (AIDiplomacyUtil.shouldAlliance(gameDataV, playerV, daimyoV, daimyoV2) && AIDiplomacyUtil.shouldAlliance(gameDataV, null, daimyoV2, daimyoV)) {
            long l = gameDataV.getRelations().stream().filter(relationV -> relationV.getDaimyoId1() == daimyoV.getId()).filter(relationV -> relationV.getStatus() == 1).count();
            if (l == 0L) {
                return true;
            }
            return unmodifiableReration.getFriendShipType() != 0 && unmodifiableReration.getFriendShipType() != -1 && unmodifiableReration.getFriendShipType() != -2;
        }
        return false;
    }

    public static boolean shouldAlliance(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        boolean bl = AIDiplomacyUtil.isEnemy(playerV, daimyoV, daimyoV2);
        if (unmodifiableReration.isIndirectEnemy1() || unmodifiableReration.isIndirectEnemy2()) {
            return false;
        }
        if (unmodifiableReration.isCommonEnemy()) {
            if (unmodifiableReration.getFriendShipType() == -2) {
                return false;
            }
        } else if (daimyoV.getArmyPower() * 2 < daimyoV2.getArmyPower()) {
            if (unmodifiableReration.getFriendShipType() == -2 || unmodifiableReration.getFriendShipType() == -1) {
                return false;
            }
        } else if (daimyoV.getArmyPower() / 2 < daimyoV2.getArmyPower()) {
            if (unmodifiableReration.getFriendShipType() == -2 || unmodifiableReration.getFriendShipType() == -1) {
                return false;
            }
            if (bl || unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) {
                return false;
            }
        } else {
            if (unmodifiableReration.getFriendShipType() == -2 || unmodifiableReration.getFriendShipType() == -1 || unmodifiableReration.getFriendShipType() == 0 || unmodifiableReration.getFriendShipType() == 1) {
                return false;
            }
            if (bl || unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5) {
                return false;
            }
        }
        if (5 < gameDataV.distanceDaimyo(daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        switch (daimyoV.getAiType().getDiplomacyBias()) {
            case 1: {
                if (daimyoV2.getToubatsuLeave() > 0) {
                    return false;
                }
                if (daimyoV2.getFame() >= 0) break;
                return false;
            }
            case 2: {
                if (daimyoV.getArmyPower() / 2 >= daimyoV2.getArmyPower()) {
                    return false;
                }
            }
            case 3: {
                if (unmodifiableReration.getFriendShip() >= 0) break;
                return false;
            }
        }
        return true;
    }

    public static boolean mustNonAggression(GameDataV gameDataV, PlayerV playerV, int n, int n2) {
        DaimyoV daimyoV;
        if (!GameDiplomacyUtil.canNonAggression(gameDataV, n, n2)) {
            return false;
        }
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n);
        return AIDiplomacyUtil.shouldNonAggression(gameDataV, playerV, daimyoV2, daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n2));
    }

    public static boolean mustNonAggression(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (!GameDiplomacyUtil.canNonAggression(gameDataV, daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        return AIDiplomacyUtil.shouldNonAggression(gameDataV, playerV, daimyoV, daimyoV2);
    }

    public static int pinchRate(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (gameDataV.isWar(daimyoV.getId(), daimyoV2.getId())) {
            int[] nArray = AIDiplomacyUtil.calcForNonAggreNonAggression(gameDataV, daimyoV, daimyoV2);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n2 > 0) {
                return n / n2;
            }
            return 999;
        }
        return 0;
    }

    public static boolean shouldNonAggression(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        int n;
        if (daimyoV.getOwner() != null) {
            return false;
        }
        int[] nArray = AIDiplomacyUtil.calcForNonAggreNonAggression(gameDataV, daimyoV, daimyoV2);
        int n2 = nArray[1];
        if (n2 * 2 < (n = nArray[0])) {
            return true;
        }
        nArray = AIDiplomacyUtil.calcForNonAggreNonAggression(gameDataV, daimyoV2, daimyoV);
        n2 = nArray[1];
        return !(n2 * 2 >= (n = nArray[0]) || daimyoV.getTechnologyIds().containsAll(daimyoV2.getTechnologyIds()) && daimyoV.getCultureIds().containsAll(daimyoV2.getCultureIds()));
        {
        }
    }

    private static int[] calcForNonAggreNonAggression(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        int n = gameDataV.getUnits().values().stream().filter(unitV -> unitV.getOperationDaimyoId() == daimyoV2.getId()).filter(unitV -> unitV.getSpot().getDaimyoId() == daimyoV.getId()).mapToInt(unitV -> unitV.getLeave() * AIDiplomacyUtil.rateOfLevel(unitV.getArmyLevel())).sum();
        int n2 = gameDataV.getUnits().values().stream().filter(unitV -> unitV.getOperationDaimyoId() == daimyoV.getId()).filter(unitV -> unitV.getSpot().getDaimyoId() == daimyoV.getId()).mapToInt(unitV -> unitV.getLeave() * AIDiplomacyUtil.rateOfLevel(unitV.getArmyLevel())).sum();
        return new int[]{n, n2 += daimyoV.getCountries().stream().mapToInt(countryV -> countryV.getUsableArmy() * 100 * AIDiplomacyUtil.rateOfLevel(countryV.getArmyLevel())).sum()};
    }

    private static int rateOfLevel(int n) {
        return (int)Math.floor(Math.pow(2.0, (double)n * 0.25) * 100.0);
    }

    public static boolean mustThreat(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        return GameDiplomacyUtil.canTreat(gameDataV, daimyoV.getId(), daimyoV2.getId()) && AIDiplomacyUtil.shouldSurrender(gameDataV, null, daimyoV2, daimyoV);
    }

    public static boolean shouldSurrender(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (daimyoV.getCountries().size() > 1) {
            return false;
        }
        return daimyoV.getImpact() * daimyoV.getAiType().getColonyBorder() < daimyoV2.getImpact() && daimyoV.getArmyPower() * daimyoV.getAiType().getColonyBorder() < daimyoV2.getArmyPower() && daimyoV.getNearbyDaimyoIds().contains(daimyoV2.getId());
    }

    public static boolean shouldIndependent(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        return daimyoV.getImpact() * daimyoV.getAiType().getColonyBorder() > daimyoV2.getImpact() * 2;
    }

    public static boolean mustBorderConflict(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (!GameDiplomacyUtil.canBorderConflict(gameDataV, daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        return AIDiplomacyUtil.shouldBorderConflict(gameDataV, playerV, daimyoV, daimyoV2) && AIDiplomacyUtil.shouldBorderConflict(gameDataV, null, daimyoV2, daimyoV);
    }

    public static boolean shouldBorderConflict(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        return unmodifiableReration.getStatus() != 4 && unmodifiableReration.getStatus() != 5 && !AIDiplomacyUtil.isEnemy(playerV, daimyoV, daimyoV2);
    }

    public static boolean mustDetente(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (!GameDiplomacyUtil.canDetante(gameDataV, daimyoV.getId(), daimyoV2.getId())) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        return unmodifiableReration.getStatus() == 4 && AIDiplomacyUtil.shouldDetente(gameDataV, playerV, daimyoV, daimyoV2) && AIDiplomacyUtil.shouldDetente(gameDataV, null, daimyoV2, daimyoV);
    }

    public static boolean shouldDetente(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 5 || AIDiplomacyUtil.isEnemy(playerV, daimyoV, daimyoV2)) {
            return false;
        }
        if (AIDiplomacyUtil.shouldAlliance(gameDataV, playerV, daimyoV, daimyoV2)) {
            return true;
        }
        return 5 < gameDataV.distanceDaimyo(daimyoV.getId(), daimyoV2.getId());
    }

    public static boolean shouldBreakAlliance(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        if (gameDataV.isAllianceLike(daimyoV.getId(), daimyoV2.getId())) {
            if (daimyoV2.getOwnerId() == daimyoV.getId()) {
                return false;
            }
            if (daimyoV.getOwnerId() == daimyoV2.getId() && AIDiplomacyUtil.shouldIndependent(gameDataV, playerV, daimyoV, daimyoV2)) {
                return true;
            }
            boolean bl = false;
            switch (daimyoV.getAiType().getDiplomacyBias()) {
                case 1: {
                    if (daimyoV2.getToubatsuLeave() > 0) {
                        bl = true;
                    }
                    if (daimyoV2.getFame() >= 0) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (daimyoV.getArmyPower() / 2 >= daimyoV2.getArmyPower()) {
                        bl = true;
                    }
                }
                case 3: {
                    UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
                    int n = daimyoV.getAiType().getFrisndshipAllianceMin();
                    if (unmodifiableReration.getFriendShip() >= n) break;
                    bl = true;
                }
            }
            if (bl && !AIDiplomacyUtil.shouldAlliance(gameDataV, playerV, daimyoV, daimyoV2)) {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldBreakAlliance(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2, DaimyoV daimyoV3) {
        if (gameDataV.isAllianceLike(daimyoV.getId(), daimyoV2.getId()) && gameDataV.isAllianceLike(daimyoV.getId(), daimyoV3.getId())) {
            UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
            UnmodifiableReration unmodifiableReration2 = gameDataV.getRelation(daimyoV.getId(), daimyoV3.getId());
            if (unmodifiableReration2.getFriendShip() * daimyoV3.getArmyPower() < unmodifiableReration.getFriendShip() * daimyoV2.getArmyPower()) {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldBreakAlliance(GameDataV gameDataV, PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2, int n) {
        DaimyoV daimyoV3 = (DaimyoV)gameDataV.getDaimyos().get(n);
        return AIDiplomacyUtil.shouldBreakAlliance(gameDataV, playerV, daimyoV, daimyoV2, daimyoV3);
    }

    private static boolean isEnemy(PlayerV playerV, DaimyoV daimyoV, DaimyoV daimyoV2) {
        int n;
        boolean bl = false;
        if (playerV != null && ((n = ((AITarget)playerV.getAIUseObject().getDaimyoTarget().get(daimyoV2.getId())).getKind()) == 5 || n == 4)) {
            bl = true;
        }
        return bl;
    }
}

