/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.sengoku.data.AIType;
import game.sengoku.data.Culture;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Technology;
import game.sengoku.data.TechnologyV;
import game.sengoku.game.domestic.DomesticResearchUtil;

public class AICalcUtil {
    public static int valuingTechnology(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, TechnologyV technologyV) {
        return (int)(AICalcUtil.learnedRate(technologyV.getLearned()) * (double)AICalcUtil.valuingTechnology(gameDataV, aIType, daimyoV, technologyV.getTechnology()));
    }

    public static int valuingTechnology(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, Technology technology) {
        if (technology == null) {
            return 0;
        }
        int n = DomesticResearchUtil.getProgress(technology.getId(), daimyoV);
        double d = (double)n / 100.0;
        double d2 = 1.0;
        if (0.5 < d) {
            d2 = 1.0 - (d - 0.5) * (d - 0.5) * 2.0;
        }
        if (n == 100) {
            d2 = 1.0;
        }
        int n2 = (int)Math.ceil(d2 * (double)technology.getEffect().getValue() * 60.0 * gameDataV.getWorld().getInflationRate());
        return n2;
    }

    public static int valuingCulture(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, Culture culture) {
        if (culture == null) {
            return 0;
        }
        int n = (int)Math.ceil(1.0 * (double)culture.getEffect().getValue() * 60.0 * gameDataV.getWorld().getInflationRate());
        return n;
    }

    public static int valuingCulture(GameDataV gameDataV, AIType aIType, DaimyoV daimyoV, CultureV cultureV) {
        return AICalcUtil.valuingCulture(gameDataV, aIType, daimyoV, cultureV.getCulture());
    }

    private static double learnedRate(int n) {
        return Math.sqrt(25.0 / (double)(n + 1));
    }
}

