/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.GengoInfo;
import game.sengoku.data.RoleV;
import org.simpleframework.xml.Element;

public class WorldDataV
extends GameDataObjectV {
    public static final int TURN_MIN = 0;
    public static final int TURN_MAX = 10000;
    public static final int YEAR_MIN = 1500;
    public static final int YEAR_MAX = 1700;
    public static final int MONTH_MIN = 1;
    public static final int MONTH_MAX = 12;
    public static final int DAY_MIN = 1;
    public static final int DAY_MAX = 31;
    public static final int AUTHORITY_MIN = 0;
    public static final int AUTHORITY_MAX = 9999;
    public static final int GENGO_YEAR_MIN = 0;
    public static final int GENGO_YEAR_MAX = 99;
    public static final int GDP_MIN = 0;
    public static final int GDP_MAX = 999999;
    public static final double INFLATION_RATE_MIN = 0.0;
    public static final double INFLATION_RATE_MAX = 100000.0;
    public static final double PRICE_GUN_MIN = 0.0;
    public static final double PRICE_GUN_MAX = 1000.0;
    public static final double PRICE_HORSE_MIN = 0.0;
    public static final double PRICE_HORSE_MAX = 1000.0;
    public static final double PRICE_GUNPOWDER_MIN = 0.0;
    public static final double PRICE_GUNPOWDER_MAX = 1000.0;
    public static final double PRICE_SALTPETER_MIN = 0.0;
    public static final double PRICE_SALTPETER_MAX = 1000.0;
    @Element(required=true, name="turn")
    private int turn = 0;
    @Element(required=true, name="year")
    private int year = 1550;
    @Element(required=true, name="month")
    private int month = 1;
    @Element(required=true, name="day")
    private int day = 1;
    @Element(required=true, name="intercalary")
    private boolean intercalary = false;
    private DaimyoV kingFamily = null;
    @Element(required=true, name="authority")
    private int authority = 0;
    private String gengo = "";
    private int gengoYear = 0;
    private int gdp = 0;
    @Element(required=true, name="inflation_rate")
    private double inflationRate = 0.0;
    private double priceGun = 0.0;
    private double priceHorse = 0.0;
    private double priceGunpowder = 0.0;
    private double priceSaltpeter = 0.0;
    private double priceIron = 0.0;

    public WorldDataV() {
    }

    public WorldDataV(@Element(name="turn") int n, @Element(name="year") int n2, @Element(name="month") int n3, @Element(name="day") int n4, @Element(name="intercalary") boolean bl, @Element(name="authority") int n5, @Element(name="inflation_rate") double d) {
        this.turn = n;
        this.turn = DataUtil.checkInteger(n, 0, 10000);
        this.year = n2;
        this.year = DataUtil.checkInteger(n2, 1500, 1700);
        this.month = n3;
        this.month = DataUtil.checkInteger(n3, 1, 12);
        this.day = n4;
        this.day = DataUtil.checkInteger(n4, 1, 31);
        this.intercalary = bl;
        this.kingFamily = null;
        this.authority = n5;
        this.authority = DataUtil.checkInteger(n5, 0, 9999);
        this.gengo = "";
        this.gengoYear = 0;
        this.gengoYear = DataUtil.checkInteger(this.gengoYear, 0, 99);
        this.gdp = 0;
        this.gdp = DataUtil.checkInteger(this.gdp, 0, 999999);
        this.inflationRate = d;
        this.inflationRate = DataUtil.checkDouble(d, 0.0, 100000.0);
    }

    public int getTurn() {
        return this.turn;
    }

    public void setTurn(int n) {
        this.turn = DataUtil.checkInteger(n, 0, 10000);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = DataUtil.checkInteger(n, 1500, 1700);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        this.month = DataUtil.checkInteger(n, 1, 12);
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int n) {
        this.day = DataUtil.checkInteger(n, 1, 31);
    }

    public boolean isIntercalary() {
        return this.intercalary;
    }

    public void setIntercalary(boolean bl) {
        this.intercalary = bl;
    }

    public DaimyoV getKingFamily() {
        return this.kingFamily;
    }

    public int getKingFamilyId() {
        return this.kingFamily == null ? 0 : this.kingFamily.getId();
    }

    public void updateKingFamily() {
        for (RoleV roleV : this.getGameDataV().getRoles().values()) {
            if (!roleV.getRole().isTop()) continue;
            this.kingFamily = roleV.getDaimyo();
            break;
        }
    }

    public int getAuthority() {
        return this.authority;
    }

    public void setAuthority(int n) {
        this.authority = DataUtil.checkInteger(n, 0, 9999);
    }

    public String getGengo() {
        return this.gengo;
    }

    public void setGengo(String string) {
        this.gengo = string;
    }

    public void updateGengo() {
        GengoInfo gengoInfo3;
        if (this.gameData != null && (gengoInfo3 = (GengoInfo)this.gameData.getCalendar().getGengoInfos().stream().sorted((gengoInfo, gengoInfo2) -> gengoInfo2.getYear() - gengoInfo.getYear()).filter(gengoInfo -> gengoInfo.getYear() <= this.year).findFirst().orElse(null)) != null) {
            this.gengo = gengoInfo3.getName();
            this.gengoYear = this.year - gengoInfo3.getYear() + 1;
        }
    }

    public int getGengoYear() {
        return this.gengoYear;
    }

    public void setGengoYear(int n) {
        this.gengoYear = n;
    }

    public int getGdp() {
        return this.gdp;
    }

    public void setGdp(int n) {
        this.gdp = DataUtil.checkInteger(n, 0, 999999);
    }

    public void updateGdp() {
        int n = this.getParameters().getCommerceDiv();
        int n2 = this.getGameDataV().getCountries().values().stream().mapToInt(countryV -> countryV.getCommerce()).sum();
        this.gdp = (int)Math.ceil((double)(n2 /= n) * 1.0 / (double)this.getGameDataV().getCountries().size());
    }

    public double getInflationRate() {
        return Math.sqrt((double)this.gdp / 100.0);
    }

    public double getPriceGun() {
        return this.priceGun;
    }

    public void updatePriceGun() {
        this.priceGun = 2.0;
    }

    public double getPriceHorse() {
        return this.priceHorse;
    }

    public void updatePriceHorse() {
        this.priceHorse = 1.0;
    }

    public double getPriceGunpowder() {
        return this.priceGunpowder;
    }

    public void updatePriceGunpowder() {
        this.priceGunpowder = 1.0;
    }

    public double getPriceSaltpeter() {
        return this.priceSaltpeter;
    }

    public void updatePriceSaltpeter() {
        this.priceSaltpeter = 0.2;
    }

    public double getPriceIron() {
        return this.priceIron;
    }

    public void updatePriceIron() {
        this.priceIron = 0.5;
    }

    public void update() {
        this.updateKingFamily();
        this.updateGengo();
        this.updateGdp();
        this.updatePriceGun();
        this.updatePriceHorse();
        this.updatePriceGunpowder();
        this.updatePriceSaltpeter();
        this.updatePriceIron();
    }

    public void stepMonth() {
        ++this.turn;
        boolean bl = false;
        if (!this.intercalary && this.gameData != null) {
            bl = this.gameData.getCalendar().getIntercalarys().stream().anyMatch(intercalary -> intercalary.getYear() == this.year && intercalary.getMonth() == this.month);
        }
        if (bl) {
            this.setIntercalary(true);
        } else {
            this.setIntercalary(false);
            if (this.month == 12) {
                this.setYear(this.year + 1);
                this.setMonth(1);
            } else {
                this.setMonth(this.month + 1);
            }
        }
        this.setDay(1);
        this.updateGengo();
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }
}

