/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.CountryV;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.KnightV;
import game.sengoku.data.RoleV;
import game.sengoku.data.SpotV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.UnitEffect;
import game.sengoku.data.UnitType;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class UnitV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 999999;
    public static final int TOTAL_MIN = 0;
    public static final int TOTAL_MAX = 9999;
    public static final int LEAVE_MIN = 0;
    public static final int LEAVE_MAX = 9999;
    public static final int MORALE_MIN = 0;
    public static final int MORALE_MAX = 999;
    public static final int SPEED_MIN = 0;
    public static final int SPEED_MAX = 9999;
    public static final int ATTACK_MIN = 0;
    public static final int ATTACK_MAX = 9999;
    public static final int DEFENSE_MIN = 0;
    public static final int DEFENSE_MAX = 9999;
    public static final int RESERVE_MIN = 0;
    public static final int RESERVE_MAX = 10;
    public static final int WAIT_TURN_MIN = 0;
    public static final int WAIT_TURN_MAX = 9999;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;
    @Element(required=true, name="knight_id")
    private int knightId = 0;
    @Element(required=true, name="country_id")
    private int countryId = 0;
    @Element(required=true, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="before_spot_id")
    private int beforeSpotId = 0;
    @Element(required=true, name="unit_id")
    private int unitId = 0;
    @Element(required=true, name="total")
    private int total = 0;
    @Element(required=true, name="leave")
    private int leave = 0;
    @Element(required=true, name="morale")
    private int morale = 0;
    private int speed = 0;
    private int attack = 0;
    private int defense = 0;
    @Element(required=true, name="wait_turn")
    private int waitTurn = 0;
    @Element(required=true, name="plunder")
    private boolean plunder = false;
    @Element(required=true, name="confused")
    private boolean confused = false;
    @Element(required=true, name="stealth")
    private boolean stealth = false;
    @ElementList(required=true, name="unit_effects")
    private List<UnitEffect> unitEffects = null;
    private Effect amountEffect = null;
    private boolean battle = false;
    private int indexOnSpot = 0;
    private int moveOrder = 0;

    public UnitV(int n) {
        this.id = n;
        this.unitEffects = new ArrayList<UnitEffect>();
        this.amountEffect = new Effect();
    }

    public UnitV(@Attribute(name="id") int n, @Element(name="daimyo_id") int n2, @Element(name="knight_id") int n3, @Element(name="country_id") int n4, @Element(name="spot_id") int n5, @Element(name="before_spot_id") int n6, @Element(name="unit_id") int n7, @Element(name="total") int n8, @Element(name="leave") int n9, @Element(name="morale") int n10, @Element(name="wait_turn") int n11, @Element(name="plunder") boolean bl, @Element(name="confused") boolean bl2, @Element(name="stealth") boolean bl3) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 999999);
        this.daimyoId = n2;
        this.knightId = n3;
        this.countryId = n4;
        this.spotId = n5;
        this.beforeSpotId = n6;
        this.unitId = n7;
        this.total = n8;
        this.total = DataUtil.checkInteger(n8, 0, 9999);
        this.leave = n9;
        this.leave = DataUtil.checkInteger(n9, 0, 9999);
        this.morale = n10;
        this.morale = DataUtil.checkInteger(n10, 0, 999);
        this.speed = 0;
        this.speed = DataUtil.checkInteger(this.speed, 0, 9999);
        this.attack = 0;
        this.attack = DataUtil.checkInteger(this.attack, 0, 9999);
        this.defense = 0;
        this.defense = DataUtil.checkInteger(this.defense, 0, 9999);
        this.waitTurn = n11;
        this.waitTurn = DataUtil.checkInteger(n11, 0, 9999);
        this.plunder = bl;
        this.confused = bl2;
        this.stealth = bl3;
        this.unitEffects = new ArrayList<UnitEffect>();
        this.amountEffect = new Effect();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int n) {
        this.unitId = n;
    }

    public UnitType getUnit() {
        return this.getGameData().getUnitTypes().get(this.unitId);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public DaimyoV getOperationDaimyo() {
        DaimyoV daimyoV = this.getDaimyo();
        if (daimyoV == null) {
            return null;
        }
        return daimyoV.getOwner() == null ? daimyoV : daimyoV.getOwner();
    }

    public int getOperationDaimyoId() {
        if (this.getOperationDaimyo() == null) {
            return 0;
        }
        return this.getOperationDaimyo().getId();
    }

    public int getKnightId() {
        return this.knightId;
    }

    public void setKnightId(int n) {
        this.knightId = n;
    }

    public KnightV getKnight() {
        return this.getGameDataV().getKnights().get(this.knightId);
    }

    public int getCountryId() {
        return this.countryId;
    }

    public void setCountryId(int n) {
        this.countryId = n;
    }

    public CountryV getCountry() {
        return this.getGameDataV().getCountries().get(this.countryId);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public SpotV getSpot() {
        return this.getGameDataV().getSpots().get(this.spotId);
    }

    public int getBeforeSpotId() {
        return this.beforeSpotId;
    }

    public void setBeforeSpotId(int n) {
        this.beforeSpotId = n;
    }

    public SpotV getBeforeSpot() {
        return this.getGameDataV().getSpots().get(this.beforeSpotId);
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int n) {
        this.total = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getLeave() {
        return this.leave;
    }

    public void setLeave(int n) {
        this.leave = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMorale() {
        return this.morale;
    }

    public void setMorale(int n) {
        this.morale = DataUtil.checkInteger(n, 0, 999);
    }

    public int getArmyLevel() {
        return this.getCountry() == null ? 2 : this.getCountry().getArmyLevel();
    }

    public int getSpeed() {
        return this.speed;
    }

    public void updateSpeed() {
        this.speed = this.getUnit().getSpeedRate() + this.amountEffect.getSpeedPlusRate();
        if (this.confused) {
            this.speed /= 2;
        }
    }

    public int getAttack() {
        return this.attack;
    }

    private int calcBase() {
        return (int)Math.floor(Math.pow(2.0, (double)this.getArmyLevel() * 0.25) * Math.pow(2.0, this.getMorale() / 60) * 100.0);
    }

    public void updateAttack() {
        this.attack = this.calcBase();
        int n = this.getUnit().getAttackRate() + this.amountEffect.getAttackPlusRate();
        if (this.getKnight() != null) {
            n += this.getKnight().getTactics() * 10;
        }
        if (this.getDaimyo() != null) {
            for (RoleV roleV : this.getDaimyo().getRoles()) {
                if (!roleV.getRole().getCountries().contains(this.countryId) && !roleV.getRole().isAroundJapan()) continue;
                n += roleV.getRole().getAttackPlusRate();
            }
        }
        this.attack = this.attack * n / 100;
        if (this.confused) {
            this.attack /= 2;
        }
    }

    public int getDefense() {
        return this.defense;
    }

    public void updateDefense() {
        this.defense = this.calcBase();
        int n = this.getUnit().getDefenseRate() + this.amountEffect.getDefensePlusRate();
        if (this.getKnight() != null) {
            n += this.getKnight().getTactics() * 10;
        }
        if (this.getDaimyo() != null) {
            for (RoleV roleV : this.getDaimyo().getRoles()) {
                if (!roleV.getRole().getCountries().contains(this.countryId) && !roleV.getRole().isAroundJapan()) continue;
                n += roleV.getRole().getDefensePlusRate();
            }
        }
        this.defense = this.defense * n / 100;
        if (this.confused) {
            this.defense /= 2;
        }
    }

    public int getWaitTurn() {
        return this.waitTurn;
    }

    public void setWaitTurn(int n) {
        this.waitTurn = DataUtil.checkInteger(n, 0, 9999);
    }

    public boolean isPlunder() {
        return this.plunder;
    }

    public void setPlunder(boolean bl) {
        this.plunder = bl;
    }

    public boolean isStealth() {
        return this.stealth;
    }

    public void setStealth(boolean bl) {
        this.stealth = bl;
    }

    public boolean isConfused() {
        return this.confused;
    }

    public void setConfused(boolean bl) {
        this.confused = bl;
    }

    public List<UnitEffect> getUnitEffects() {
        return this.unitEffects;
    }

    public Effect getAmountEffect() {
        return this.amountEffect;
    }

    public List<Integer> getTechniqueIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.getUnit().getUniqTechniqueIds());
        if (this.getKnight() != null && !arrayList.contains(this.getKnight().getKnight().getTechnique())) {
            arrayList.add(this.getKnight().getKnight().getTechnique());
        }
        return arrayList;
    }

    public boolean isBattle() {
        return this.battle;
    }

    public void updateBattle() {
        this.battle = this.getSpot().getUnits().stream().anyMatch(unitV -> this.getGameDataV().isBattleTerget(this, (UnitV)unitV));
    }

    public boolean isReleasable() {
        if (this.battle) {
            return false;
        }
        if (this.getSpot().getCountry() == null) {
            return false;
        }
        if (this.getSpot().getCountry().getDaimyoId() == this.getDaimyoId()) {
            return true;
        }
        return this.getGameDataV().isAllianceLike(this.getSpot().getCountry().getDaimyoId(), this.getDaimyoId());
    }

    public void updateAmountEffect() {
        int[] nArray;
        Object object2;
        this.amountEffect.init();
        int[] nArray2 = this.amountEffect.getValues();
        if (this.getCountry() != null) {
            object2 = this.getCountry().getAmountEffect().getValues();
            DataUtil.addArray(nArray2, (int[])object2);
        }
        if (this.getDaimyo() != null) {
            object2 = this.getDaimyo().getTechnologies().iterator();
            while (object2.hasNext()) {
                TechnologyV object3 = (TechnologyV)object2.next();
                nArray = object3.getTechnology().getEffect().getValues();
                DataUtil.addArray(nArray2, nArray);
            }
            for (CultureV cultureV : this.getDaimyo().getCultures()) {
                nArray = cultureV.getCulture().getEffect().getValues();
                DataUtil.addArray(nArray2, nArray);
            }
        }
        object2 = this.getUnitEffects().iterator();
        while (object2.hasNext()) {
            UnitEffect unitEffect = (UnitEffect)object2.next();
            nArray = unitEffect.getEffect().getValues();
            DataUtil.addArray(nArray2, nArray);
        }
        this.amountEffect.setValues(nArray2);
    }

    public void update() {
        this.updateSpeed();
        this.updateAttack();
        this.updateDefense();
        this.updateBattle();
        this.updateAmountEffect();
    }

    public void updateByTurn() {
        for (UnitEffect unitEffect2 : this.getUnitEffects()) {
            unitEffect2.setLostTurn(unitEffect2.getLostTurn() - 1);
        }
        this.unitEffects.removeIf(unitEffect -> unitEffect.getLostTurn() <= 0);
        if (0 < this.waitTurn) {
            --this.waitTurn;
        }
        this.update();
    }

    @Override
    public String getName() {
        return this.getKnight() == null ? this.getUnit().getName() : this.getKnight().getFullName();
    }

    public int getIndexOnSpot() {
        return this.indexOnSpot;
    }

    public void setIndexOnSpot(int n) {
        this.indexOnSpot = n;
    }

    public int getMoveOrder() {
        return this.moveOrder;
    }

    public void setMoveOrder(int n) {
        this.moveOrder = n;
    }
}

