/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.KnightV;
import game.sengoku.data.StoreV;
import game.sengoku.data.Treasure;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class TreasureV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int STORE_ID_MIN = 0;
    public static final int STORE_ID_MAX = 99;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="store_id")
    private int storeId = 0;
    @Element(required=true, name="knight_id")
    private int knightId = 0;
    @Element(required=true, name="appear")
    private boolean appear = false;
    @Element(required=true, name="disappear")
    private boolean disappear = false;

    public TreasureV() {
    }

    public TreasureV(@Attribute(name="id") int n) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 9999);
    }

    public TreasureV(@Attribute(name="id") int n, @Element(name="store_id") int n2, @Element(name="knight_id") int n3, @Element(name="appear") boolean bl, @Element(name="disappear") boolean bl2) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 9999);
        this.storeId = n2;
        this.storeId = DataUtil.checkInteger(n2, 0, 99);
        this.knightId = n3;
        this.appear = bl;
        this.disappear = bl2;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 9999);
    }

    public Treasure getTreasure() {
        return this.getGameData().getTreasures().get(this.id);
    }

    public int getStoreId() {
        return this.storeId;
    }

    public void setStoreId(int n) {
        this.storeId = DataUtil.checkInteger(n, 0, 99);
    }

    public StoreV getStore() {
        return this.getGameDataV().getStores().get(this.storeId);
    }

    public int getKnightId() {
        return this.knightId;
    }

    public void setKnightId(int n) {
        this.knightId = n;
    }

    public KnightV getKnight() {
        return this.getGameDataV().getKnights().get(this.knightId);
    }

    public boolean isAppear() {
        return this.appear;
    }

    public void setAppear(boolean bl) {
        this.appear = bl;
    }

    public boolean isDisappear() {
        return this.disappear;
    }

    public void setDisappear(boolean bl) {
        this.disappear = bl;
    }

    public int getDaimyoId() {
        return this.knightId == 0 ? 0 : this.getKnight().getDaimyoId();
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.getDaimyoId());
    }

    public int getPrice() {
        double d = this.gameDataV.getWorld().getInflationRate();
        int n = this.getTreasure().getValue();
        return (int)Math.ceil((double)n * d);
    }

    public void update() {
    }

    @Override
    public String getName() {
        return this.getTreasure().getName();
    }
}

