/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.BgMusic;
import game.sengoku.data.DataUtil;
import game.sengoku.data.SoundEffect;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;

public class SystemData {
    public static final int ID_NONE = 0;
    public static final int MAJOR_MIN = 0;
    public static final int MAJOR_MAX = 100;
    public static final int MINOR_MIN = 0;
    public static final int MINOR_MAX = 100;
    public static final int REVISION_MIN = 0;
    public static final int REVISION_MAX = 100;
    public static final double SE_VOLUME_MIN = 0.0;
    public static final double SE_VOLUME_MAX = 1.0;
    public static final double MUSIC_VOLUME_MIN = 0.0;
    public static final double MUSIC_VOLUME_MAX = 1.0;
    @Element(required=true, name="title")
    private String title = "";
    @Element(required=true, name="major")
    private int major = 0;
    @Element(required=true, name="minor")
    private int minor = 9;
    @Element(required=true, name="revision")
    private int revision = 0;
    @ElementMap(required=true, name="sounds", key="key", attribute=true)
    private Map<Integer, SoundEffect> sounds = null;
    @ElementMap(required=true, name="bgms", key="key", attribute=true)
    private Map<Integer, BgMusic> bgms = null;
    @Element(required=true, name="se_volume")
    private double seVolume = 1.0;
    @Element(required=true, name="music_volume")
    private double musicVolume = 1.0;
    @Element(required=true, name="se_mute")
    private boolean seMute = false;
    @Element(required=true, name="music_mute")
    private boolean musicMute = false;

    public SystemData() {
        this.sounds = new HashMap<Integer, SoundEffect>();
        this.bgms = new HashMap<Integer, BgMusic>();
    }

    public SystemData(@Element(name="title") String string, @Element(name="major") int n, @Element(name="minor") int n2, @Element(name="revision") int n3, @Element(name="se_volume") double d, @Element(name="music_volume") double d2, @Element(name="se_mute") boolean bl, @Element(name="music_mute") boolean bl2) {
        this.title = string;
        this.major = n;
        this.major = DataUtil.checkInteger(n, 0, 100);
        this.minor = n2;
        this.minor = DataUtil.checkInteger(n2, 0, 100);
        this.revision = n3;
        this.revision = DataUtil.checkInteger(n3, 0, 100);
        this.sounds = new HashMap<Integer, SoundEffect>();
        this.bgms = new HashMap<Integer, BgMusic>();
        this.seVolume = d;
        this.seVolume = DataUtil.checkDouble(d, 0.0, 1.0);
        this.musicVolume = d2;
        this.musicVolume = DataUtil.checkDouble(d2, 0.0, 1.0);
        this.seMute = bl;
        this.musicMute = bl2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = DataUtil.checkInteger(n, 0, 100);
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = DataUtil.checkInteger(n, 0, 100);
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int n) {
        this.revision = DataUtil.checkInteger(n, 0, 100);
    }

    public Map<Integer, SoundEffect> getSounds() {
        return this.sounds;
    }

    public void setSounds(Map<Integer, SoundEffect> map) {
        this.sounds = map;
    }

    public Map<Integer, BgMusic> getBgms() {
        return this.bgms;
    }

    public void setBgms(Map<Integer, BgMusic> map) {
        this.bgms = map;
    }

    public double getSeVolume() {
        return this.seVolume;
    }

    public void setSeVolume(double d) {
        this.seVolume = DataUtil.checkDouble(d, 0.0, 1.0);
    }

    public double getMusicVolume() {
        return this.musicVolume;
    }

    public void setMusicVolume(double d) {
        this.musicVolume = DataUtil.checkDouble(d, 0.0, 1.0);
    }

    public boolean isSeMute() {
        return this.seMute;
    }

    public void setSeMute(boolean bl) {
        this.seMute = bl;
    }

    public boolean isMusicMute() {
        return this.musicMute;
    }

    public void setMusicMute(boolean bl) {
        this.musicMute = bl;
    }
}

