/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.CountryV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Store;
import game.sengoku.data.TreasureV;
import game.sengoku.data.WorldDataV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementMap;

public class StoreV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    @Attribute(required=true, name="id")
    private int id = 0;
    @ElementMap(required=true, name="friendship", key="key", attribute=true)
    private Map<Integer, Integer> friendship = null;
    protected List<TreasureV> treasures;
    protected List<TreasureV> treatTreasures;

    public StoreV() {
        this.friendship = new HashMap<Integer, Integer>();
        this.treasures = new ArrayList<TreasureV>();
        this.treatTreasures = new ArrayList<TreasureV>();
    }

    public StoreV(@Attribute(name="id") int n) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 99);
        this.friendship = new HashMap<Integer, Integer>();
        this.treasures = new ArrayList<TreasureV>();
        this.treatTreasures = new ArrayList<TreasureV>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 99);
    }

    public Map<Integer, Integer> getFriendship() {
        return this.friendship;
    }

    public void setFriendship(Map<Integer, Integer> map) {
        this.friendship = map;
    }

    public Store getStore() {
        return this.getGameData().getStores().get(this.id);
    }

    public CountryV getCountry() {
        return this.getGameDataV().getCountries().get(this.getStore().getCountryId());
    }

    public WorldDataV getWorld() {
        return this.getGameDataV().getWorld();
    }

    public double getGunRate() {
        return this.getWorld().getPriceGun() * (double)this.getStore().getGunRate() / 100.0;
    }

    public double getHorseRate() {
        return this.getWorld().getPriceHorse() * (double)this.getStore().getHorseRate() / 100.0;
    }

    public double getIronRate() {
        return this.getWorld().getPriceIron() * (double)this.getStore().getIronRate() / 100.0;
    }

    public double getGunpowderRate() {
        return this.getWorld().getPriceGunpowder() * (double)this.getStore().getGunpowderRate() / 100.0;
    }

    public double getSaltpeterRate() {
        return this.getWorld().getPriceSaltpeter() * (double)this.getStore().getSaltpeterRate() / 100.0;
    }

    public List<TreasureV> getTreasures() {
        return this.treasures;
    }

    public void updateTreasures() {
        this.treasures.clear();
        for (TreasureV treasureV : this.getGameDataV().getTreasures().values()) {
            if (treasureV.getStoreId() != this.id) continue;
            this.treasures.add(treasureV);
        }
    }

    public List<TreasureV> getTreatTreasures() {
        return this.treatTreasures;
    }

    public void update() {
        this.updateTreasures();
    }

    public void updateByMonth() {
        this.update();
        this.updateTreatTreasures();
    }

    private void updateTreatTreasures() {
        this.treatTreasures.clear();
        int n = Math.min(10, this.treasures.size());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (hashSet.size() < n) {
            int n2 = (int)Math.floor(Math.random() * 10000.0) % this.treasures.size();
            hashSet.add(n2);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            this.treatTreasures.add(this.treasures.get(n3));
        }
    }

    @Override
    public String getName() {
        return this.getStore().getName();
    }
}

