/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class Role
extends GameDataObject {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    public static final int ATTACK_PLUS_RATE_MIN = 0;
    public static final int ATTACK_PLUS_RATE_MAX = 1000;
    public static final int DEFENSE_PLUS_RATE_MIN = 0;
    public static final int DEFENSE_PLUS_RATE_MAX = 1000;
    public static final int MIN_IMPACT_MIN = 0;
    public static final int MIN_IMPACT_MAX = 999999;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="name")
    private String name = "";
    @Element(required=false, name="attack_plus_rate")
    private int attackPlusRate = 0;
    @Element(required=false, name="defense_plus_rate")
    private int defensePlusRate = 0;
    @Element(required=false, name="around_japan")
    private boolean aroundJapan = false;
    @Element(required=true, name="min_impact")
    private int minImpact = 0;
    @ElementList(required=false, name="countries")
    private List<Integer> countries = null;
    @Element(required=false, name="top")
    private boolean top = false;
    @Element(required=false, name="explain")
    private String explain = "";

    public Role() {
    }

    public Role(@Attribute(name="id") int n, @Element(name="name") String string, @Element(name="attack_plus_rate") int n2, @Element(name="defense_plus_rate") int n3, @Element(name="around_japan") boolean bl, @Element(name="min_impact") int n4, @Element(name="top") boolean bl2, @Element(name="explain") String string2) {
        this.id = n;
        DataUtil.assertInteger(n, 0, 99);
        this.name = string;
        this.attackPlusRate = n2;
        this.attackPlusRate = DataUtil.checkInteger(n2, 0, 1000);
        this.defensePlusRate = n3;
        this.defensePlusRate = DataUtil.checkInteger(n3, 0, 1000);
        this.aroundJapan = bl;
        this.minImpact = n4;
        this.minImpact = DataUtil.checkInteger(n4, 0, 999999);
        this.countries = new ArrayList<Integer>();
        this.top = bl2;
        this.explain = string2;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getAttackPlusRate() {
        return this.attackPlusRate;
    }

    public void setAttackPlusRate(int n) {
        this.attackPlusRate = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getDefensePlusRate() {
        return this.defensePlusRate;
    }

    public void setDefensePlusRate(int n) {
        this.defensePlusRate = DataUtil.checkInteger(n, 0, 1000);
    }

    public boolean isAroundJapan() {
        return this.aroundJapan;
    }

    public void setAroundJapan(boolean bl) {
        this.aroundJapan = bl;
    }

    public int getMinImpact() {
        return this.minImpact;
    }

    public void setMinImpact(int n) {
        this.minImpact = DataUtil.checkInteger(n, 0, 999999);
    }

    public List<Integer> getCountries() {
        return this.countries;
    }

    public void setCountries(List<Integer> list) {
        this.countries = list;
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean bl) {
        this.top = bl;
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String string) {
        this.explain = string;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : this.countries) {
            if (n2 == 0 || this.getGameData().getJapan().getCountries().containsKey(n2)) continue;
            arrayList.add(n2);
        }
        this.countries.removeAll(arrayList);
        return n == 0;
    }
}

