/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Giant;
import game.sengoku.data.SpotV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.ValidErrorMessage;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class GiantV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 999;
    public static final int DAIMYO_ID_MIN = 0;
    public static final int DAIMYO_ID_MAX = 99;
    public static final int MONTH_MIN = 0;
    public static final int MONTH_MAX = 999;
    public static final int PAY_MIN = 0;
    public static final int PAY_MAX = 99999;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;
    @Element(required=true, name="month")
    private int month = 0;
    @Element(required=true, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="appear")
    private boolean appear = false;
    @Element(required=true, name="disappear")
    private boolean disappear = false;
    @Element(required=true, name="pay")
    private int pay = 0;

    public GiantV(int n) {
        this.id = n;
    }

    public GiantV(@Attribute(name="id") int n, @Element(name="daimyo_id") int n2, @Element(name="month") int n3, @Element(name="spot_id") int n4, @Element(name="appear") boolean bl, @Element(name="disappear") boolean bl2, @Element(name="pay") int n5) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 999);
        this.daimyoId = n2;
        this.daimyoId = DataUtil.checkInteger(n2, 0, 99);
        this.month = n3;
        this.month = DataUtil.checkInteger(n3, 0, 999);
        this.spotId = n4;
        this.appear = bl;
        this.disappear = bl2;
        this.pay = n5;
        this.pay = DataUtil.checkInteger(n5, 0, 99999);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 999);
    }

    public Giant getGiant() {
        return this.getGameData().getGiants().get(this.id);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = DataUtil.checkInteger(n, 0, 99);
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        this.month = DataUtil.checkInteger(n, 0, 999);
    }

    public SpotV getSpot() {
        return this.getGameDataV().getSpots().get(this.spotId);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public boolean isAppear() {
        return this.appear;
    }

    public void setAppear(boolean bl) {
        this.appear = bl;
    }

    public boolean isDisappear() {
        return this.disappear;
    }

    public void setDisappear(boolean bl) {
        this.disappear = bl;
    }

    public CultureV getCulture() {
        if (this.getGiant().getCultureId() == 0) {
            return null;
        }
        return this.gameDataV.getCultures().get(this.getGiant().getCultureId());
    }

    public TechnologyV getTechnology() {
        if (this.getGiant().getTechnologyId() == 0) {
            return null;
        }
        return this.gameDataV.getTechnologies().get(this.getGiant().getTechnologyId());
    }

    public TreasureV getTreasure() {
        if (this.getGiant().getTreasureId() == 0) {
            return null;
        }
        return this.gameDataV.getTreasures().get(this.getGiant().getTreasureId());
    }

    public int getHeadPay() {
        int n = this.getParameters().getGiantEmployCostRate();
        return this.getPay() * n;
    }

    public int getPay() {
        return this.pay;
    }

    public void setPay(int n) {
        this.pay = DataUtil.checkInteger(n, 0, 99999);
    }

    public boolean isComplete() {
        return this.getGiant() != null && this.getGiant().getCultureMonths() <= this.month;
    }

    public void update() {
    }

    @Override
    public String getName() {
        return this.getGiant().getName();
    }

    @Override
    public String getLabel() {
        return this.getGiant().getLabel();
    }

    public String getFullName() {
        Giant giant = this.getGiant();
        return giant.getFamily() + giant.getName();
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (this.spotId != 0 && !this.getGameData().getJapan().getSpots().containsKey(this.spotId)) {
            this.spotId = 0;
        }
        return n == 0;
    }
}

