/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.Calendar;
import game.sengoku.data.Country;
import game.sengoku.data.CountryV;
import game.sengoku.data.Culture;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameColorUtil;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GengoInfo;
import game.sengoku.data.Giant;
import game.sengoku.data.GiantV;
import game.sengoku.data.Intercalary;
import game.sengoku.data.Knight;
import game.sengoku.data.KnightV;
import game.sengoku.data.Role;
import game.sengoku.data.RoleV;
import game.sengoku.data.Spot;
import game.sengoku.data.SpotV;
import game.sengoku.data.Store;
import game.sengoku.data.StoreV;
import game.sengoku.data.Technology;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.Treasure;
import game.sengoku.data.TreasureV;
import game.sengoku.data.ValidErrorMessage;
import game.sengoku.data.WorldDataV;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GameDataVCreator {
    public void createCalendar(Calendar calendar) {
        List<GengoInfo> list = calendar.getGengoInfos();
        list.add(new GengoInfo(1501, "\u6587\u4e80"));
        list.add(new GengoInfo(1504, "\u6c38\u6b63"));
        list.add(new GengoInfo(1521, "\u5927\u6c38"));
        list.add(new GengoInfo(1528, "\u4eab\u7984"));
        list.add(new GengoInfo(1532, "\u5929\u6587"));
        list.add(new GengoInfo(1555, "\u5f18\u6cbb"));
        list.add(new GengoInfo(1558, "\u6c38\u7984"));
        list.add(new GengoInfo(1570, "\u5143\u4e80"));
        list.add(new GengoInfo(1573, "\u5929\u6b63"));
        list.add(new GengoInfo(1592, "\u6587\u7984"));
        list.add(new GengoInfo(1596, "\u6176\u9577"));
        list.add(new GengoInfo(1615, "\u5143\u548c"));
        list.add(new GengoInfo(1624, "\u5bdb\u6c38"));
        List<Intercalary> list2 = calendar.getIntercalarys();
        list2.add(new Intercalary(1501, 6));
        list2.add(new Intercalary(1504, 3));
        list2.add(new Intercalary(1506, 11));
        list2.add(new Intercalary(1509, 8));
        list2.add(new Intercalary(1512, 4));
        list2.add(new Intercalary(1515, 2));
        list2.add(new Intercalary(1517, 10));
        list2.add(new Intercalary(1520, 6));
        list2.add(new Intercalary(1523, 3));
        list2.add(new Intercalary(1525, 11));
        list2.add(new Intercalary(1528, 9));
        list2.add(new Intercalary(1531, 5));
        list2.add(new Intercalary(1534, 1));
        list2.add(new Intercalary(1536, 10));
        list2.add(new Intercalary(1539, 6));
        list2.add(new Intercalary(1542, 3));
        list2.add(new Intercalary(1544, 11));
        list2.add(new Intercalary(1547, 7));
        list2.add(new Intercalary(1550, 5));
        list2.add(new Intercalary(1553, 1));
        list2.add(new Intercalary(1555, 10));
        list2.add(new Intercalary(1558, 6));
        list2.add(new Intercalary(1561, 3));
        list2.add(new Intercalary(1563, 12));
        list2.add(new Intercalary(1566, 8));
        list2.add(new Intercalary(1569, 5));
        list2.add(new Intercalary(1572, 1));
        list2.add(new Intercalary(1574, 11));
        list2.add(new Intercalary(1577, 7));
        list2.add(new Intercalary(1580, 3));
        list2.add(new Intercalary(1583, 1));
        list2.add(new Intercalary(1585, 8));
        list2.add(new Intercalary(1588, 5));
        list2.add(new Intercalary(1591, 1));
        list2.add(new Intercalary(1593, 9));
        list2.add(new Intercalary(1596, 7));
        list2.add(new Intercalary(1599, 3));
    }

    public void create(GameData gameData, GameDataV gameDataV) {
        WorldDataV worldDataV = gameDataV.getWorld();
        Map<Integer, DaimyoV> map = gameDataV.getDaimyos();
        Map<Integer, CountryV> map2 = gameDataV.getCountries();
        for (Country object72 : gameData.getJapan().getCountries().values()) {
            if (map2.containsKey(object72.getId())) continue;
            CountryV countryV = new CountryV(object72.getId());
            map2.put(object72.getId(), countryV);
        }
        Map<Integer, SpotV> map3 = gameDataV.getSpots();
        for (Spot spot : gameData.getJapan().getSpots().values()) {
            if (map3.containsKey(spot.getId())) continue;
            map3.put(spot.getId(), new SpotV(spot.getId(), 0));
        }
        Map<Integer, KnightV> map4 = gameDataV.getKnights();
        for (Knight knight : gameData.getKnights().values()) {
            if (map4.containsKey(knight.getId())) continue;
            map4.put(knight.getId(), new KnightV(knight.getId()));
        }
        Map<Integer, TechnologyV> map5 = gameDataV.getTechnologies();
        for (Technology technology : gameData.getTechnologies().values()) {
            if (map5.containsKey(technology.getId())) continue;
            map5.put(technology.getId(), new TechnologyV(technology.getId()));
        }
        Map<Integer, CultureV> map6 = gameDataV.getCultures();
        for (Culture culture : gameData.getCultures().values()) {
            if (map6.containsKey(culture.getId())) continue;
            map6.put(culture.getId(), new CultureV(culture.getId()));
        }
        Map<Integer, GiantV> map7 = gameDataV.getGiants();
        for (Giant giant : gameData.getGiants().values()) {
            if (map7.containsKey(giant.getId())) continue;
            map7.put(giant.getId(), new GiantV(giant.getId()));
        }
        Map<Integer, TreasureV> map8 = gameDataV.getTreasures();
        for (Treasure treasure : gameData.getTreasures().values()) {
            if (map8.containsKey(treasure.getId())) continue;
            map8.put(treasure.getId(), new TreasureV(treasure.getId()));
        }
        Map<Integer, RoleV> map9 = gameDataV.getRoles();
        for (Role role : gameData.getRoleList().values()) {
            if (map9.containsKey(role.getId())) continue;
            map9.put(role.getId(), new RoleV(role.getId()));
        }
        Map<Integer, StoreV> map10 = gameDataV.getStores();
        for (Store store : gameData.getStores().values()) {
            if (map10.containsKey(store.getId())) continue;
            map10.put(store.getId(), new StoreV(store.getId()));
        }
        gameDataV.setGameData(gameData);
        gameDataV.setReference();
    }

    public void update(GameData gameData, GameDataV gameDataV) {
        Map<Integer, KnightV> map2;
        WorldDataV worldDataV = gameDataV.getWorld();
        int n = worldDataV.getYear();
        gameDataV.setGameData(gameData);
        gameDataV.setReference();
        List<Integer> list = GameColorUtil.createColors();
        int n2 = 0;
        ArrayList<ValidErrorMessage> arrayList = new ArrayList<ValidErrorMessage>();
        Map<Integer, DaimyoV> map5 = gameDataV.getDaimyos();
        for (DaimyoV map42 : map5.values()) {
            map2 = map42.getKnight();
            ((KnightV)((Object)map2)).setAppear(true);
            ((KnightV)((Object)map2)).setDaimyoId(map42.getId());
            map42.setFame(map42.getMaxFame());
            map42.setColor(list.get(n2 % list.size()));
            map42.checkValid(arrayList);
            n2 += 13;
        }
        Map<Integer, CountryV> map6 = gameDataV.getCountries();
        for (Map<Integer, KnightV> map2 : map6.values()) {
            ((CountryV)((Object)map2)).checkValid(arrayList);
        }
        Map<Integer, SpotV> map3 = gameDataV.getSpots();
        for (SpotV spotV : map3.values()) {
            List<Integer> list2 = spotV.getBuildIds();
            gameData.getBuilds().values().stream().filter(build -> build.getSpotId() == spotV.getId()).filter(build -> build.getKind() == 7 || build.getKind() == 11 || build.getKind() == 9).forEach(build -> object2.add(build.getId()));
            spotV.checkValid(arrayList);
        }
        map2 = gameDataV.getKnights();
        for (KnightV knightV : map2.values()) {
            knightV.checkValid(arrayList);
        }
        Map<Integer, GiantV> map4 = gameDataV.getGiants();
        for (GiantV giantV : map4.values()) {
            giantV.checkValid(arrayList);
        }
        Map<Integer, TreasureV> map7 = gameDataV.getTreasures();
        for (Iterator<DaimyoV> iterator : map7.values()) {
            ((GameDataObject)((Object)iterator)).checkValid(arrayList);
        }
        Map<Integer, RoleV> map8 = gameDataV.getRoles();
        for (RoleV roleV : map8.values()) {
            roleV.checkValid(arrayList);
        }
        for (DaimyoV daimyoV : map5.values()) {
            KnightV knightV = gameDataV.getKnights().get(daimyoV.getKnightId());
            knightV.setAppear(true);
        }
    }
}

