/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.base.common.PairKeyMap;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.CountryV;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.GameParameters;
import game.sengoku.data.GiantV;
import game.sengoku.data.Justice;
import game.sengoku.data.KnightV;
import game.sengoku.data.Nearby;
import game.sengoku.data.RankingUtil;
import game.sengoku.data.RelationV;
import game.sengoku.data.RoleV;
import game.sengoku.data.SpotV;
import game.sengoku.data.StoreV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.UnitV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.data.ValidErrorMessage;
import game.sengoku.data.WorldDataV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;

public class GameDataV {
    @Element(required=true, name="world")
    private WorldDataV world = null;
    @ElementMap(required=true, name="countries", key="key", attribute=true)
    private Map<Integer, CountryV> countries = null;
    @ElementMap(required=true, name="spots", key="key", attribute=true)
    private Map<Integer, SpotV> spots = null;
    @ElementMap(required=true, name="daimyos", key="key", attribute=true)
    private Map<Integer, DaimyoV> daimyos = null;
    @ElementMap(required=true, name="knights", key="key", attribute=true)
    private Map<Integer, KnightV> knights = null;
    @ElementMap(required=true, name="technologies", key="key", attribute=true)
    private Map<Integer, TechnologyV> technologies = null;
    @ElementMap(required=true, name="cultures", key="key", attribute=true)
    private Map<Integer, CultureV> cultures = null;
    @ElementMap(required=true, name="giants", key="key", attribute=true)
    private Map<Integer, GiantV> giants = null;
    @ElementMap(required=true, name="treasures", key="key", attribute=true)
    private Map<Integer, TreasureV> treasures = null;
    @ElementMap(required=true, name="roles", key="key", attribute=true)
    private Map<Integer, RoleV> roles = null;
    @ElementMap(required=true, name="units", key="key", attribute=true)
    private Map<Integer, UnitV> units = null;
    @ElementMap(required=true, name="stores", key="key", attribute=true)
    private Map<Integer, StoreV> stores = null;
    @ElementList(required=true, name="relations")
    private List<RelationV> relations = null;
    @ElementList(required=true, name="borderConflicts")
    private List<BorderConflictV> borderConflicts = null;
    @ElementList(required=false, name="justices")
    private List<Justice> justices = null;
    private GameData gameData;
    private GameAIData gameAIData;
    private Set<Integer> nearbyKeys = null;
    private Map<Integer, Integer> distanceSpot = null;
    private Map<Integer, Set<Integer>> nearbyIds = null;
    private Map<Integer, Integer> distanceCountry = null;
    private PairKeyMap<Integer, Integer, Integer> ranking = null;
    private List<RelationV> colonyRelations = null;

    public GameDataV() {
        this.countries = new HashMap<Integer, CountryV>();
        this.spots = new HashMap<Integer, SpotV>();
        this.daimyos = new HashMap<Integer, DaimyoV>();
        this.knights = new HashMap<Integer, KnightV>();
        this.technologies = new HashMap<Integer, TechnologyV>();
        this.cultures = new HashMap<Integer, CultureV>();
        this.giants = new HashMap<Integer, GiantV>();
        this.treasures = new HashMap<Integer, TreasureV>();
        this.roles = new HashMap<Integer, RoleV>();
        this.units = new HashMap<Integer, UnitV>();
        this.stores = new HashMap<Integer, StoreV>();
        this.relations = new ArrayList<RelationV>();
        this.nearbyKeys = new HashSet<Integer>();
        this.distanceSpot = new HashMap<Integer, Integer>();
        this.distanceCountry = new HashMap<Integer, Integer>();
        this.nearbyIds = new HashMap<Integer, Set<Integer>>();
        this.ranking = new PairKeyMap();
        this.borderConflicts = new ArrayList<BorderConflictV>();
        this.justices = new ArrayList<Justice>();
    }

    public GameDataV(@Element(name="world") WorldDataV worldDataV) {
        this.world = worldDataV;
        this.countries = new HashMap<Integer, CountryV>();
        this.spots = new HashMap<Integer, SpotV>();
        this.daimyos = new HashMap<Integer, DaimyoV>();
        this.knights = new HashMap<Integer, KnightV>();
        this.technologies = new HashMap<Integer, TechnologyV>();
        this.cultures = new HashMap<Integer, CultureV>();
        this.giants = new HashMap<Integer, GiantV>();
        this.treasures = new HashMap<Integer, TreasureV>();
        this.roles = new HashMap<Integer, RoleV>();
        this.units = new HashMap<Integer, UnitV>();
        this.stores = new HashMap<Integer, StoreV>();
        this.relations = new ArrayList<RelationV>();
        this.nearbyKeys = new HashSet<Integer>();
        this.distanceSpot = new HashMap<Integer, Integer>();
        this.nearbyIds = new HashMap<Integer, Set<Integer>>();
        this.distanceCountry = new HashMap<Integer, Integer>();
        this.ranking = new PairKeyMap();
        this.borderConflicts = new ArrayList<BorderConflictV>();
        this.justices = new ArrayList<Justice>();
    }

    public WorldDataV getWorld() {
        return this.world;
    }

    public void setWorld(WorldDataV worldDataV) {
        this.world = worldDataV;
    }

    public Map<Integer, CountryV> getCountries() {
        return this.countries;
    }

    public void setCountries(Map<Integer, CountryV> map) {
        this.countries = map;
    }

    public Map<Integer, SpotV> getSpots() {
        return this.spots;
    }

    public void setSpots(Map<Integer, SpotV> map) {
        this.spots = map;
    }

    public Map<Integer, DaimyoV> getDaimyos() {
        return this.daimyos;
    }

    public void setDaimyos(Map<Integer, DaimyoV> map) {
        this.daimyos = map;
    }

    public Map<Integer, KnightV> getKnights() {
        return this.knights;
    }

    public void setKnights(Map<Integer, KnightV> map) {
        this.knights = map;
    }

    public Map<Integer, TechnologyV> getTechnologies() {
        return this.technologies;
    }

    public void setTechnologies(Map<Integer, TechnologyV> map) {
        this.technologies = map;
    }

    public Map<Integer, CultureV> getCultures() {
        return this.cultures;
    }

    public void setCultures(Map<Integer, CultureV> map) {
        this.cultures = map;
    }

    public Map<Integer, GiantV> getGiants() {
        return this.giants;
    }

    public void setGiants(Map<Integer, GiantV> map) {
        this.giants = map;
    }

    public Map<Integer, TreasureV> getTreasures() {
        return this.treasures;
    }

    public void setTreasures(Map<Integer, TreasureV> map) {
        this.treasures = map;
    }

    public Map<Integer, RoleV> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<Integer, RoleV> map) {
        this.roles = map;
    }

    public Map<Integer, UnitV> getUnits() {
        return this.units;
    }

    public void setUnits(Map<Integer, UnitV> map) {
        this.units = map;
    }

    public Map<Integer, StoreV> getStores() {
        return this.stores;
    }

    public void setStores(Map<Integer, StoreV> map) {
        this.stores = map;
    }

    public List<RelationV> getRelations() {
        return this.relations;
    }

    public void setRelations(List<RelationV> list) {
        this.relations = list;
    }

    public boolean checkValid(List<ValidErrorMessage> list) {
        for (GameDataObject gameDataObject : this.countries.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.spots.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.knights.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.technologies.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.cultures.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.daimyos.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.giants.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.treasures.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.roles.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.stores.values()) {
            gameDataObject.checkValid(list);
        }
        this.relations.removeIf(relationV -> !this.getDaimyos().containsKey(relationV.getDaimyoId1()) || !this.getDaimyos().containsKey(relationV.getDaimyoId2()));
        return list.isEmpty();
    }

    public GameData getGameData() {
        return this.gameData;
    }

    public void setGameData(GameData gameData) {
        this.gameData = gameData;
    }

    public GameAIData getGameAIData() {
        return this.gameAIData;
    }

    public void setGameAIData(GameAIData gameAIData) {
        this.gameAIData = gameAIData;
    }

    public void setReference(GameDataObjectV gameDataObjectV) {
        gameDataObjectV.setGameData(this.gameData);
        gameDataObjectV.setGameAIData(this.gameAIData);
        gameDataObjectV.setGameDataV(this);
        gameDataObjectV.setReference();
    }

    public PairKeyMap<Integer, Integer, Integer> getRanking() {
        if (this.ranking == null) {
            this.ranking = RankingUtil.getRankPairKeyMap(this);
        }
        return this.ranking;
    }

    public List<BorderConflictV> getBorderConflicts() {
        return this.borderConflicts;
    }

    public void setBorderConflicts(List<BorderConflictV> list) {
        this.borderConflicts = list;
    }

    public List<Justice> getJustices() {
        return this.justices;
    }

    public void setJustices(List<Justice> list) {
        this.justices = list;
    }

    public GameParameters getParameters() {
        return this.gameData.getParameters();
    }

    public void setReference() {
        this.setReference(this.world);
        this.countries.values().forEach(this::setReference);
        this.spots.values().forEach(this::setReference);
        this.daimyos.values().forEach(this::setReference);
        this.knights.values().forEach(this::setReference);
        this.technologies.values().forEach(this::setReference);
        this.cultures.values().forEach(this::setReference);
        this.giants.values().forEach(this::setReference);
        this.treasures.values().forEach(this::setReference);
        this.roles.values().forEach(this::setReference);
        this.units.values().forEach(this::setReference);
        this.stores.values().forEach(this::setReference);
        this.relations.forEach(this::setReference);
        this.borderConflicts.forEach(this::setReference);
    }

    public void update() {
        this.world.update();
        this.spots.values().forEach(spotV -> spotV.update());
        this.countries.values().forEach(countryV -> countryV.update());
        this.daimyos.values().forEach(daimyoV -> daimyoV.update());
        this.knights.values().forEach(knightV -> knightV.update());
        this.giants.values().forEach(giantV -> giantV.update());
        this.technologies.values().forEach(technologyV -> technologyV.update());
        this.cultures.values().forEach(cultureV -> cultureV.update());
        this.treasures.values().forEach(treasureV -> treasureV.update());
        this.roles.values().forEach(roleV -> roleV.update());
        this.units.values().forEach(unitV -> unitV.update());
        this.stores.values().forEach(storeV -> storeV.update());
        this.borderConflicts.forEach(borderConflictV -> borderConflictV.update());
        this.borderConflicts.removeIf(borderConflictV -> borderConflictV.getDaimyoId1() == borderConflictV.getDaimyoId2());
        this.updateRelations();
        this.justices.forEach(justice -> justice.update());
        this.justices.removeIf(justice -> this.deleteJustices((Justice)justice));
        this.world.update();
    }

    protected boolean deleteJustices(Justice justice) {
        switch (justice.getKind()) {
            case 2: {
                int n = justice.getTargetId();
                BorderConflictV borderConflictV2 = this.getBorderConflicts().stream().filter(borderConflictV -> borderConflictV.getId() == n).findFirst().orElse(null);
                if (borderConflictV2 == null) {
                    return true;
                }
                if (!borderConflictV2.match(justice.getDaimyoId(), justice.getTargetDaimyoId())) {
                    return true;
                }
                if (justice.getPeriod() > 0) break;
                return true;
            }
            case 3: {
                DaimyoV daimyoV = this.getDaimyos().get(justice.getTargetDaimyoId());
                if (daimyoV.getChristTreat() != -1) {
                    return true;
                }
                daimyoV = this.getDaimyos().get(justice.getDaimyoId());
                if (daimyoV.getChristTreat() != 1) {
                    return true;
                }
                if (justice.getPeriod() > 0) break;
                return true;
            }
            case 1: {
                CountryV countryV = this.getCountries().get(justice.getTargetCountryId());
                if (countryV == null) {
                    return true;
                }
                if (countryV.getDaimyoId() == justice.getTargetDaimyoId()) {
                    return true;
                }
                if (justice.getPeriod() > 0) break;
                return true;
            }
        }
        return false;
    }

    public List<Justice> getJusticeList(int n, int n2) {
        ArrayList<Justice> arrayList = new ArrayList<Justice>();
        this.getJustices().stream().filter(justice -> justice.getDaimyoId() == n || justice.getDaimyoId() == 0).filter(justice -> justice.getTargetDaimyoId() == n2).forEach(justice -> arrayList.add((Justice)justice));
        DaimyoV daimyoV = this.getDaimyos().get(n2);
        if (daimyoV.getFame() < 0) {
            arrayList.add(new Justice(4, n, n2, 0, 0, 0));
        }
        if (daimyoV.getToubatsuLeave() > 0) {
            arrayList.add(new Justice(5, n, n2, 0, 0, 0));
        }
        if (this.isWar(n, n2)) {
            arrayList.add(new Justice(6, n, n2, 0, 0, 0));
        } else if (!this.isAllianceLike(n, n)) {
            for (int n3 : this.getDaimyos().keySet()) {
                if (n3 == n || !this.isAllianceLike(n3, n) || !this.isWar(n3, n2)) continue;
                arrayList.add(new Justice(7, n, n2, 0, 0, 0));
                break;
            }
        }
        return arrayList;
    }

    public void updateRelations() {
        this.ranking = null;
        Set<Integer> set = this.getDaimyos().keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            for (int n2 : set) {
                if (n == n2) continue;
                RelationV relationV2 = this.getRelationV(n, n2);
                this.setReference(relationV2);
            }
        }
        for (UnmodifiableReration unmodifiableReration : this.relations) {
            if (0 < unmodifiableReration.getWar()) {
                this.setRelation(unmodifiableReration.getDaimyoId1(), unmodifiableReration.getDaimyoId2(), 5, 0);
            } else if (unmodifiableReration.getStatus() == 5) {
                this.setRelation(unmodifiableReration.getDaimyoId1(), unmodifiableReration.getDaimyoId2(), 4, 0);
            }
            if (0 < unmodifiableReration.getNonAggression()) {
                this.setRelation(unmodifiableReration.getDaimyoId1(), unmodifiableReration.getDaimyoId2(), 2, 0);
                continue;
            }
            if (unmodifiableReration.getStatus() != 2) continue;
            this.setRelation(unmodifiableReration.getDaimyoId1(), unmodifiableReration.getDaimyoId2(), 0, 0);
        }
        this.relations.forEach(relationV -> relationV.update());
        if (this.colonyRelations != null) {
            this.colonyRelations.forEach(relationV -> relationV.setNeedResetRelation(true));
        }
    }

    public UnmodifiableReration getRelation(int n, int n2) {
        DaimyoV daimyoV = this.getDaimyos().get(n);
        DaimyoV daimyoV2 = this.getDaimyos().get(n2);
        if (daimyoV == null || daimyoV2 == null) {
            return null;
        }
        if (n == n2) {
            return null;
        }
        if (!daimyoV.isIndependent() && !daimyoV2.isIndependent()) {
            if (daimyoV.getOwnerId() == daimyoV2.getOwnerId()) {
                RelationV relationV = this.getColonyRelationV(n, n2);
                if (relationV.isNeedResetRelation()) {
                    RelationV relationV2 = this.getRelationV(n, n2);
                    relationV.resetRelation(n, n2, relationV2, relationV2);
                    relationV.setStatus(1);
                    relationV.setWar(0);
                    relationV.setNonAggression(0);
                }
                this.setReference(relationV);
                return relationV;
            }
            RelationV relationV = this.getColonyRelationV(n, n2);
            if (relationV.isNeedResetRelation()) {
                UnmodifiableReration unmodifiableReration = this.getRelation(daimyoV.getOwnerId(), daimyoV2.getOwnerId());
                RelationV relationV3 = this.getRelationV(n, n2);
                relationV.resetRelation(n, n2, unmodifiableReration, relationV3);
            }
            this.setReference(relationV);
            return relationV;
        }
        if (!daimyoV.isIndependent()) {
            if (daimyoV.getOwnerId() == n2) {
                return this.getRelationV(n, n2);
            }
            RelationV relationV = this.getColonyRelationV(n, n2);
            if (relationV.isNeedResetRelation()) {
                UnmodifiableReration unmodifiableReration = this.getRelation(daimyoV.getOwnerId(), n2);
                RelationV relationV4 = this.getRelationV(n, n2);
                relationV.resetRelation(n, n2, unmodifiableReration, relationV4);
            }
            this.setReference(relationV);
            return relationV;
        }
        if (!daimyoV2.isIndependent()) {
            if (daimyoV2.getOwnerId() == n) {
                return this.getRelationV(n, n2);
            }
            RelationV relationV = this.getColonyRelationV(n, n2);
            if (relationV.isNeedResetRelation()) {
                UnmodifiableReration unmodifiableReration = this.getRelation(n, daimyoV2.getOwnerId());
                RelationV relationV5 = this.getRelationV(n, n2);
                relationV.resetRelation(n, n2, unmodifiableReration, relationV5);
            }
            this.setReference(relationV);
            return relationV;
        }
        return this.getRelationV(n, n2);
    }

    private RelationV getRelationV(int n, int n2) {
        Object object;
        RelationV relationV3;
        if (n == n2) {
            return null;
        }
        Set<Integer> set = this.getDaimyos().keySet();
        if (!set.contains(n) || !set.contains(n2)) {
            return null;
        }
        List<RelationV> list = this.getRelations();
        RelationV relationV2 = null;
        for (RelationV relationV3 : list) {
            if (relationV3.getDaimyoId1() == n && relationV3.getDaimyoId2() == n2) {
                return relationV3;
            }
            if (relationV3.getDaimyoId1() != n2 || relationV3.getDaimyoId2() != n) continue;
            relationV2 = relationV3;
        }
        if (relationV2 != null) {
            if (relationV2.getStatus() == 1) {
                object = new RelationV(n, n2, 1, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            if (relationV2.getStatus() == 7) {
                object = new RelationV(n, n2, 6, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            if (relationV2.getStatus() == 2) {
                object = new RelationV(n, n2, 2, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            if (relationV2.getStatus() == 6) {
                object = new RelationV(n, n2, 7, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            if (relationV2.getStatus() == 4) {
                object = new RelationV(n, n2, 4, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            if (relationV2.getStatus() == 5) {
                object = new RelationV(n, n2, 5, 0, 0, 0, 0);
                list.add((RelationV)object);
                return object;
            }
            object = new RelationV(n, n2, 0, 0, 0, 0, 0);
            list.add((RelationV)object);
            return object;
        }
        object = new RelationV(n, n2, 0, 0, 0, 0, 0);
        list.add((RelationV)object);
        relationV3 = new RelationV(n2, n, 0, 0, 0, 0, 0);
        list.add(relationV3);
        return object;
    }

    public boolean isBattleTerget(UnitV unitV, UnitV unitV2) {
        if (this.isIkkou(unitV) && this.isIkkou(unitV2)) {
            return false;
        }
        return this.isBattleTerget(unitV.getDaimyoId(), unitV2.getDaimyoId());
    }

    public boolean isIkkou(UnitV unitV) {
        if (unitV.getDaimyo() == null) {
            return this.getGameData().getParameters().getIkkouId() == unitV.getUnitId();
        }
        return unitV.getDaimyo().isCanHongan();
    }

    public boolean isBattleTerget(int n, int n2) {
        return n != n2 && !this.isAllianceLike(n, n2) && !this.isNonAggression(n, n2);
    }

    public boolean isAlliance(int n, int n2) {
        UnmodifiableReration unmodifiableReration = this.getRelation(n, n2);
        if (unmodifiableReration == null) {
            return false;
        }
        return unmodifiableReration.getStatus() == 1;
    }

    public boolean isAllianceLike(int n, int n2) {
        DaimyoV daimyoV = this.getDaimyos().get(n);
        DaimyoV daimyoV2 = this.getDaimyos().get(n2);
        if (daimyoV == null || daimyoV2 == null) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = this.getRelation(n, n2);
        if (n == n2) {
            return true;
        }
        if (unmodifiableReration == null) {
            return false;
        }
        return unmodifiableReration.getStatus() == 1 || unmodifiableReration.getStatus() == 7 || unmodifiableReration.getStatus() == 6;
    }

    public boolean isNonAggression(int n, int n2) {
        DaimyoV daimyoV = this.getDaimyos().get(n);
        DaimyoV daimyoV2 = this.getDaimyos().get(n2);
        if (daimyoV == null || daimyoV2 == null) {
            return false;
        }
        UnmodifiableReration unmodifiableReration = this.getRelation(n, n2);
        if (unmodifiableReration == null) {
            return false;
        }
        return unmodifiableReration.getStatus() == 2;
    }

    public boolean isEnemy(int n, int n2) {
        UnmodifiableReration unmodifiableReration = this.getRelation(n, n2);
        if (unmodifiableReration == null) {
            return false;
        }
        return unmodifiableReration.getStatus() == 4 || unmodifiableReration.getStatus() == 5;
    }

    public boolean isWar(int n, int n2) {
        UnmodifiableReration unmodifiableReration = this.getRelation(n, n2);
        if (unmodifiableReration == null) {
            return false;
        }
        return unmodifiableReration.getStatus() == 5;
    }

    private void setRelation(int n, int n2, int n3, int n4) {
        if (n == n2) {
            return;
        }
        RelationV relationV = this.getRelationV(n, n2);
        relationV.setStatus(n3);
        relationV.setArg1(n4);
        RelationV relationV2 = this.getRelationV(n2, n);
        if (n3 == 1) {
            relationV2.setStatus(1);
            relationV2.setArg1(n4);
            relationV.setNonAggression(0);
            relationV2.setNonAggression(0);
        } else if (n3 == 7) {
            relationV2.setStatus(6);
            relationV2.setArg1(n4);
            relationV.setNonAggression(0);
            relationV2.setNonAggression(0);
        } else if (n3 == 2) {
            relationV2.setStatus(2);
            relationV2.setArg1(n4);
        } else if (n3 == 6) {
            relationV2.setStatus(7);
            relationV2.setArg1(n4);
            relationV.setNonAggression(0);
            relationV2.setNonAggression(0);
        } else if (n3 == 4) {
            relationV2.setStatus(4);
            relationV2.setArg1(n4);
        } else if (n3 == 5) {
            relationV2.setStatus(5);
            relationV2.setArg1(n4);
        } else if (n3 == 0) {
            relationV2.setStatus(0);
            relationV2.setArg1(n4);
            relationV.setNonAggression(0);
            relationV2.setNonAggression(0);
            relationV.setWar(0);
            relationV2.setWar(0);
        }
    }

    public void setHate(int n, int n2, int n3) {
        RelationV relationV = this.getRelationV(n, n2);
        relationV.setHate(n3);
    }

    public void alliance(int n, int n2) {
        this.setRelation(n, n2, 1, 0);
    }

    public void none(int n, int n2) {
        this.setRelation(n, n2, 0, 0);
    }

    public void enemy(int n, int n2) {
        this.setRelation(n, n2, 4, 0);
    }

    public void surrender(int n, int n2) {
        this.setRelation(n, n2, 6, 0);
    }

    public void startWar(int n, int n2) {
        int n3 = this.getParameters().getWarPeriod();
        RelationV relationV = this.getRelationV(n, n2);
        RelationV relationV2 = this.getRelationV(n2, n);
        relationV.setWar(n3);
        relationV2.setWar(n3);
    }

    public void stopWar(int n, int n2) {
        int n3 = this.getParameters().getStopWarPeriod();
        RelationV relationV = this.getRelationV(n, n2);
        RelationV relationV2 = this.getRelationV(n2, n);
        relationV.setNonAggression(n3);
        relationV2.setNonAggression(n3);
    }

    private void createNearbyKeys() {
        this.nearbyKeys.clear();
        this.nearbyIds.clear();
        for (Nearby nearby : this.getGameData().getJapan().getNearbys()) {
            this.nearbyKeys.add(nearby.getKey());
            this.nearbyKeys.add(nearby.getRKey());
            this.addSet(nearby.getSpot1(), nearby.getSpot2());
            this.addSet(nearby.getSpot2(), nearby.getSpot1());
        }
    }

    private void addSet(int n, int n2) {
        Set<Integer> set = this.nearbyIds.get(n);
        if (set == null) {
            set = new HashSet<Integer>();
        }
        set.add(n2);
        this.nearbyIds.put(n, set);
    }

    public Set<Integer> nearbySpotIds(int n) {
        return this.nearbySpotIds(n, 1);
    }

    public Set<Integer> nearbySpotIds(int n, int n2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.nearbySpotIds(n, n2, hashSet);
        return hashSet;
    }

    private void nearbySpotIds(int n, int n2, Set<Integer> set) {
        if (n2 <= 0) {
            set.add(n);
        } else {
            for (int n3 : this.nearbyIds(n)) {
                set.add(n);
                this.nearbySpotIds(n3, n2 - 1, set);
            }
        }
    }

    private Set<Integer> nearbyIds(int n) {
        if (this.nearbyKeys.isEmpty()) {
            this.createNearbyKeys();
        }
        return this.nearbyIds.get(n);
    }

    public int distanceDaimyo(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        DaimyoV daimyoV = this.getDaimyos().get(n);
        DaimyoV daimyoV2 = this.getDaimyos().get(n2);
        int n3 = 999999;
        for (CountryV countryV : daimyoV.getCountries()) {
            for (CountryV countryV2 : daimyoV2.getCountries()) {
                if (this.distanceCountry(countryV.getId(), countryV2.getId()) >= n3) continue;
                n3 = this.distanceCountry(countryV.getId(), countryV2.getId());
            }
        }
        return n3;
    }

    public int distanceCountry(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (this.distanceCountry.containsKey(this.getKeySpot(n, n2))) {
            return this.distanceCountry.get(this.getKeySpot(n, n2));
        }
        CountryV countryV = this.getCountries().get(n);
        CountryV countryV2 = this.getCountries().get(n2);
        int n3 = 999999;
        for (SpotV spotV : countryV.getSpots()) {
            for (SpotV spotV2 : countryV2.getSpots()) {
                if (this.distanceSpot(spotV.getId(), spotV2.getId()) >= n3) continue;
                n3 = this.distanceSpot(spotV.getId(), spotV2.getId());
            }
        }
        this.distanceCountry.put(this.getKeySpot(n, n2), n3);
        this.distanceCountry.put(this.getKeySpot(n2, n), n3);
        return n3;
    }

    public int distanceSpot(int n, int n4) {
        int n5;
        if (this.nearbyKeys.isEmpty()) {
            this.createNearbyKeys();
        }
        if (n == n4) {
            return 0;
        }
        if (this.distanceSpot.containsKey(this.getKeySpot(n, n4))) {
            return this.distanceSpot.get(this.getKeySpot(n, n4));
        }
        Object object = this.getSpots().keySet().iterator();
        while (object.hasNext()) {
            n5 = object.next();
            this.distanceSpot.put(this.getKeySpot(n, n5), 999999);
        }
        this.distanceSpot.put(this.getKeySpot(n, n), 0);
        object = new HashSet();
        object.addAll(this.getSpots().keySet());
        while (!object.isEmpty() && (n5 = object.stream().sorted((n2, n3) -> this.distanceSpot.get(this.getKeySpot(n, (int)n2)) - this.distanceSpot.get(this.getKeySpot(n, (int)n3))).findFirst().orElse(-1).intValue()) >= 0) {
            object.remove(n5);
            Set<Integer> set = this.nearbyIds(n5);
            for (int n6 : set) {
                int n7 = 1;
                int n8 = this.distanceSpot.get(this.getKeySpot(n, n5)) + n7;
                if (this.distanceSpot.get(this.getKeySpot(n, n6)) <= n8) continue;
                this.distanceSpot.put(this.getKeySpot(n, n6), n8);
            }
        }
        return this.distanceSpot.get(this.getKeySpot(n, n4));
    }

    public int distanceSpotWeight(int n, int n4, int n5, List<Integer> list) {
        int n6;
        if (n == n4) {
            return 0;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        Object object = this.getSpots().keySet().iterator();
        while (object.hasNext()) {
            n6 = object.next();
            hashMap2.put(this.getKeySpot(n, n6), 999999);
        }
        hashMap2.put(this.getKeySpot(n, n), 0);
        object = new HashSet();
        object.addAll(this.getSpots().keySet());
        while (!object.isEmpty() && (n6 = object.stream().sorted((n2, n3) -> (Integer)hashMap2.get(this.getKeySpot(n, (int)n2)) - (Integer)hashMap2.get(this.getKeySpot(n, (int)n3))).findFirst().orElse(-1).intValue()) >= 0) {
            object.remove(n6);
            Set<Integer> set = this.nearbyIds(n6);
            for (int n7 : set) {
                SpotV spotV = this.getSpots().get(n7);
                int n8 = 1;
                n8 = spotV.getCountry() == null ? 1 : (this.isNonAggression(n5, spotV.getCountry().getDaimyoId()) ? 999999 : (this.isAllianceLike(n5, spotV.getCountry().getDaimyoId()) ? 1 : 10));
                int n9 = (Integer)hashMap2.get(this.getKeySpot(n, n6)) + n8;
                if ((Integer)hashMap2.get(this.getKeySpot(n, n7)) <= n9) continue;
                hashMap2.put(this.getKeySpot(n, n7), n9);
                hashMap.put(n7, n6);
            }
        }
        n6 = n4;
        while ((Integer)hashMap.get(n6) != n) {
            list.add(n6);
            n6 = (Integer)hashMap.get(n6);
        }
        list.add(n6);
        return (Integer)hashMap2.get(this.getKeySpot(n, n4));
    }

    private int getKeySpot(int n, int n2) {
        return n * 10000 + n2;
    }

    private RelationV getColonyRelationV(int n, int n2) {
        if (n == n2) {
            return null;
        }
        Set<Integer> set = this.getDaimyos().keySet();
        if (!set.contains(n) || !set.contains(n2)) {
            return null;
        }
        if (this.colonyRelations == null) {
            this.colonyRelations = new ArrayList<RelationV>();
        }
        for (RelationV relationV : this.colonyRelations) {
            if (relationV.getDaimyoId1() != n || relationV.getDaimyoId2() != n2) continue;
            return relationV;
        }
        RelationV relationV = new RelationV(n, n2);
        this.colonyRelations.add(relationV);
        return relationV;
    }
}

