/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.BuildPlan;
import game.sengoku.data.CalcValue;
import game.sengoku.data.Country;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Spot;
import game.sengoku.data.SpotV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.UnitV;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class CountryV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    public static final int DAIMYO_ID_MIN = 0;
    public static final int DAIMYO_ID_MAX = 99;
    public static final int MAX_POPULATION_MIN = 0;
    public static final int MAX_POPULATION_MAX = 9999;
    public static final int POPULATION_MIN = 0;
    public static final int POPULATION_MAX = 9999;
    public static final int POPULATION_PLUS_MIN = 0;
    public static final int POPULATION_PLUS_MAX = 9999;
    public static final int MAX_FOOD_MIN = 0;
    public static final int MAX_FOOD_MAX = 9999;
    public static final int FOOD_MIN = 0;
    public static final int FOOD_MAX = 9999;
    public static final int FOOD_PLUS_MIN = 0;
    public static final int FOOD_PLUS_MAX = 9999;
    public static final int MAX_COMMERCE_MIN = 0;
    public static final int MAX_COMMERCE_MAX = 9999;
    public static final int COMMERCE_MIN = 0;
    public static final int COMMERCE_MAX = 9999;
    public static final int COMMERCE_PLUS_MIN = 0;
    public static final int COMMERCE_PLUS_MAX = 9999;
    public static final int MAX_CULTURE_MIN = 0;
    public static final int MAX_CULTURE_MAX = 9999;
    public static final int CULTURE_MIN = 0;
    public static final int CULTURE_MAX = 9999;
    public static final int CULTURE_PLUS_MIN = 0;
    public static final int CULTURE_PLUS_MAX = 9999;
    public static final int MAX_TAMICHU_MIN = 0;
    public static final int MAX_TAMICHU_MAX = 999;
    public static final int TAMICHU_MIN = 0;
    public static final int TAMICHU_MAX = 999;
    public static final int TAMICHU_PLUS_MIN = 0;
    public static final int TAMICHU_PLUS_MAX = 999;
    public static final int MAX_ARMY_EXP_MIN = 0;
    public static final int MAX_ARMY_EXP_MAX = 9999;
    public static final int ARMY_EXP_MIN = 0;
    public static final int ARMY_EXP_MAX = 9999;
    public static final int ARMY_EXP_PLUS_MIN = 0;
    public static final int ARMY_EXP_PLUS_MAX = 9999;
    public static final int MAX_CHRIST_MIN = 0;
    public static final int MAX_CHRIST_MAX = 100;
    public static final int CHRIST_MIN = 0;
    public static final int CHRIST_MAX = 100;
    public static final int CHRIST_PLUS_MIN = -100;
    public static final int CHRIST_PLUS_MAX = 100;
    public static final int POWER_MIN = 0;
    public static final int POWER_MAX = 9999;
    public static final int ARMY_LEVEL_MIN = 0;
    public static final int ARMY_LEVEL_MAX = 20;
    public static final int MAX_ARMY_MIN = 0;
    public static final int MAX_ARMY_MAX = 9999;
    public static final int USABLE_ARMY_MIN = 0;
    public static final int USABLE_ARMY_MAX = 9999;
    public static final int ARMY_PLUS_MIN = 0;
    public static final int ARMY_PLUS_MAX = 9999;
    public static final int RUIN_MONTH_MIN = 0;
    public static final int RUIN_MONTH_MAX = 99;
    public static final int MISSIONARY_MIN = 0;
    public static final int MISSIONARY_MAX = 9999999;
    public static final int INCOME_MONTH_MIN = 0;
    public static final int INCOME_MONTH_MAX = 999999;
    public static final int INCOME_YEAR_MIN = 0;
    public static final int INCOME_YEAR_MAX = 999999;
    public static final int BASE_INCOME_MIN = 0;
    public static final int BASE_INCOME_MAX = 999999;
    public static final double INFLATION_RATE_MIN = 0.0;
    public static final double INFLATION_RATE_MAX = 100.0;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;
    private Effect amountEffect = null;
    private Effect amountEffectForCalc = null;
    private int maxPopulation = 0;
    @Element(required=true, name="population")
    private int population = 0;
    private int populationPlus = 0;
    private int maxFood = 0;
    @Element(required=true, name="food")
    private int food = 0;
    private int foodPlus = 0;
    private int maxCommerce = 0;
    @Element(required=true, name="commerce")
    private int commerce = 0;
    private int commercePlus = 0;
    private int maxCulture = 0;
    @Element(required=true, name="culture")
    private int culture = 0;
    private int culturePlus = 0;
    private int maxTamichu = 0;
    @Element(required=true, name="tamichu")
    private int tamichu = 0;
    private int tamichuPlus = 0;
    private int maxArmyExp = 0;
    @Element(required=true, name="army_exp")
    private int armyExp = 0;
    private int armyExpPlus = 0;
    private int maxChrist = 0;
    @Element(required=true, name="christ")
    private int christ = 0;
    private int christPlus = 0;
    private int power = 0;
    @Element(required=true, name="army_level")
    private int armyLevel = 0;
    private int maxArmy = 0;
    @Element(required=true, name="usable_army")
    private int usableArmy = 0;
    private int armyPlus = 0;
    @ElementList(required=true, name="build_plans")
    private List<BuildPlan> buildPlans = null;
    @Element(required=true, name="ruin_month")
    private int ruinMonth = 0;
    @Element(required=true, name="missionary")
    private int missionary = 0;
    private int incomeMonth = 0;
    private int incomeYear = 0;
    @Element(required=true, name="base_income")
    private int baseIncome = 0;
    private double inflationRate = 0.0;
    private List<Integer> spotIds = null;
    private List<SpotV> spots = null;
    private List<UnitV> units = null;
    private CalcValue calcValue;
    private boolean beIkkou = false;

    public CountryV(int n) {
        this.id = n;
        this.amountEffect = new Effect();
        this.amountEffectForCalc = new Effect();
        this.buildPlans = new ArrayList<BuildPlan>();
        this.spotIds = new ArrayList<Integer>();
        this.spots = new ArrayList<SpotV>();
        this.units = new ArrayList<UnitV>();
    }

    public CountryV(@Attribute(name="id") int n, @Element(name="daimyo_id") int n2, @Element(name="population") int n3, @Element(name="food") int n4, @Element(name="commerce") int n5, @Element(name="culture") int n6, @Element(name="tamichu") int n7, @Element(name="army_exp") int n8, @Element(name="christ") int n9, @Element(name="army_level") int n10, @Element(name="usable_army") int n11, @Element(name="ruin_month") int n12, @Element(name="missionary") int n13, @Element(name="base_income") int n14) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 99);
        this.daimyoId = n2;
        this.daimyoId = DataUtil.checkInteger(n2, 0, 99);
        this.amountEffect = new Effect();
        this.amountEffectForCalc = new Effect();
        this.maxPopulation = 0;
        this.maxPopulation = DataUtil.checkInteger(this.maxPopulation, 0, 9999);
        this.population = n3;
        this.population = DataUtil.checkInteger(n3, 0, 9999);
        this.populationPlus = 0;
        this.populationPlus = DataUtil.checkInteger(this.populationPlus, 0, 9999);
        this.maxFood = 0;
        this.maxFood = DataUtil.checkInteger(this.maxFood, 0, 9999);
        this.food = n4;
        this.food = DataUtil.checkInteger(n4, 0, 9999);
        this.foodPlus = 0;
        this.foodPlus = DataUtil.checkInteger(this.foodPlus, 0, 9999);
        this.maxCommerce = 0;
        this.maxCommerce = DataUtil.checkInteger(this.maxCommerce, 0, 9999);
        this.commerce = n5;
        this.commerce = DataUtil.checkInteger(n5, 0, 9999);
        this.commercePlus = 0;
        this.commercePlus = DataUtil.checkInteger(this.commercePlus, 0, 9999);
        this.maxCulture = 0;
        this.maxCulture = DataUtil.checkInteger(this.maxCulture, 0, 9999);
        this.culture = n6;
        this.culture = DataUtil.checkInteger(n6, 0, 9999);
        this.culturePlus = 0;
        this.culturePlus = DataUtil.checkInteger(this.culturePlus, 0, 9999);
        this.maxTamichu = 0;
        this.maxTamichu = DataUtil.checkInteger(this.maxTamichu, 0, 999);
        this.tamichu = n7;
        this.tamichu = DataUtil.checkInteger(n7, 0, 999);
        this.tamichuPlus = 0;
        this.tamichuPlus = DataUtil.checkInteger(this.tamichuPlus, 0, 999);
        this.maxArmyExp = 0;
        this.maxArmyExp = DataUtil.checkInteger(this.maxArmyExp, 0, 9999);
        this.armyExp = n8;
        this.armyExp = DataUtil.checkInteger(n8, 0, 9999);
        this.armyExpPlus = 0;
        this.armyExpPlus = DataUtil.checkInteger(this.armyExpPlus, 0, 9999);
        this.maxChrist = 0;
        this.maxChrist = DataUtil.checkInteger(this.maxChrist, 0, 100);
        this.christ = n9;
        this.christ = DataUtil.checkInteger(n9, 0, 100);
        this.christPlus = 0;
        this.christPlus = DataUtil.checkInteger(this.christPlus, -100, 100);
        this.power = 0;
        this.power = DataUtil.checkInteger(this.power, 0, 9999);
        this.armyLevel = n10;
        this.armyLevel = DataUtil.checkInteger(n10, 0, 20);
        this.maxArmy = 0;
        this.maxArmy = DataUtil.checkInteger(this.maxArmy, 0, 9999);
        this.usableArmy = n11;
        this.usableArmy = DataUtil.checkInteger(n11, 0, 9999);
        this.armyPlus = 0;
        this.armyPlus = DataUtil.checkInteger(this.armyPlus, 0, 9999);
        this.buildPlans = new ArrayList<BuildPlan>();
        this.ruinMonth = n12;
        this.ruinMonth = DataUtil.checkInteger(n12, 0, 99);
        this.missionary = n13;
        this.missionary = DataUtil.checkInteger(n13, 0, 9999999);
        this.incomeMonth = 0;
        this.incomeMonth = DataUtil.checkInteger(this.incomeMonth, 0, 999999);
        this.incomeYear = 0;
        this.incomeYear = DataUtil.checkInteger(this.incomeYear, 0, 999999);
        this.baseIncome = n14;
        this.baseIncome = DataUtil.checkInteger(n14, 0, 999999);
        this.inflationRate = 0.0;
        this.inflationRate = DataUtil.checkDouble(this.inflationRate, 0.0, 100.0);
        this.spotIds = new ArrayList<Integer>();
        this.spots = new ArrayList<SpotV>();
        this.units = new ArrayList<UnitV>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 99);
    }

    public Country getCountry() {
        return this.getGameData().getJapan().getCountries().get(this.id);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = DataUtil.checkInteger(n, 0, 99);
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public Effect getAmountEffect() {
        return this.amountEffect;
    }

    public void updateAmountEffect() {
        int[] nArray;
        this.amountEffect.init();
        int[] nArray2 = this.amountEffect.getValues();
        for (SpotV gameDataObjectV : this.spots) {
            nArray = gameDataObjectV.getAmountEffect().getValues();
            DataUtil.addArray(nArray2, nArray);
        }
        this.amountEffect.setValues(nArray2);
        this.amountEffectForCalc.init();
        if (this.getDaimyo() != null) {
            for (TechnologyV technologyV : this.getDaimyo().getTechnologies()) {
                nArray = technologyV.getTechnology().getEffect().getValues();
                DataUtil.addArray(nArray2, nArray);
            }
            for (CultureV cultureV : this.getDaimyo().getCultures()) {
                nArray = cultureV.getCulture().getEffect().getValues();
                DataUtil.addArray(nArray2, nArray);
            }
        }
        this.amountEffectForCalc.setValues(nArray2);
    }

    public int getMaxPopulation() {
        return this.maxPopulation;
    }

    public void updateMaxPopulation() {
        this.maxPopulation = this.getFood();
        this.maxPopulation = DataUtil.checkInteger(this.maxPopulation, 0, 9999);
    }

    public int getPopulation() {
        return Math.min(this.population, this.maxPopulation);
    }

    public void setPopulation(int n) {
        this.population = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getPopulationPlus() {
        return this.populationPlus;
    }

    public void updatePopulationPlus() {
        this.populationPlus = this.amountEffectForCalc.getPopulationPlus();
        this.populationPlus = (int)((double)this.populationPlus + (double)(this.populationPlus * this.amountEffectForCalc.getPopulationPlusRate()) / 100.0);
    }

    public int getMaxFood() {
        return this.getCountry().getFoodMax();
    }

    public void updateMaxFood() {
    }

    public int getFood() {
        return Math.min(this.food, this.getMaxFood());
    }

    public void setFood(int n) {
        this.food = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getFoodPlus() {
        return this.foodPlus;
    }

    public void updateFoodPlus() {
        this.foodPlus = this.amountEffectForCalc.getFoodPlus();
        this.foodPlus = (int)((double)this.foodPlus + (double)(this.foodPlus * this.amountEffectForCalc.getFoodPlusRate()) / 100.0);
    }

    public int getMaxCommerce() {
        return this.maxCommerce;
    }

    public void updateMaxCommerce() {
        this.maxCommerce = this.getPopulation();
        this.maxCommerce = (int)((double)this.maxCommerce + (double)(this.maxCommerce * this.amountEffectForCalc.getMaxCommerceRate()) / 100.0);
        this.maxCommerce = DataUtil.checkInteger(this.maxCommerce, 0, 9999);
    }

    public int getCommerce() {
        return Math.min(this.commerce, this.maxCommerce);
    }

    public void setCommerce(int n) {
        this.commerce = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getCommercePlus() {
        return this.commercePlus;
    }

    public void updateCommercePlus() {
        this.commercePlus = this.amountEffectForCalc.getCommercePlus();
        this.commercePlus = (int)((double)this.commercePlus + (double)(this.commercePlus * this.amountEffectForCalc.getCommercePlusRate()) / 100.0);
    }

    public int getMaxCulture() {
        return 9999;
    }

    public void updateMaxCulture() {
    }

    public int getCulture() {
        return Math.min(this.culture, this.getMaxCulture());
    }

    public void setCulture(int n) {
        this.culture = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getCulturePlus() {
        return this.culturePlus;
    }

    public void updateCulturePlus() {
        this.culturePlus = this.amountEffectForCalc.getCulturePlus();
        this.culturePlus = (int)((double)this.culturePlus + (double)(this.culturePlus * this.amountEffectForCalc.getCulturePlusRate()) / 100.0);
    }

    public int getMaxTamichu() {
        return this.maxTamichu;
    }

    public void updateMaxTamichu() {
        double d = this.getParameters().getTamichuDiv1();
        double d2 = this.getParameters().getTamichuDiv2();
        double d3 = this.getParameters().getTamichuBase();
        this.maxTamichu = (int)(d3 + (double)this.getCulture() / d + (double)this.getCommerce() / d2);
        this.maxTamichu += this.amountEffectForCalc.getMaxTamichuPlus();
        this.maxTamichu = DataUtil.checkInteger(this.maxTamichu, (int)d3, 999);
    }

    public int getTamichu() {
        return Math.min(this.tamichu, this.maxTamichu);
    }

    public void setTamichu(int n) {
        int n2 = this.getParameters().getTamichuBase();
        this.tamichu = DataUtil.checkInteger(n, n2, 999);
    }

    public int getTamichuPlus() {
        return this.tamichuPlus;
    }

    public void updateTamichuPlus() {
        int n = this.getParameters().getTamichuPlusBase();
        this.tamichuPlus = n + this.amountEffectForCalc.getTamichuPlus();
        this.tamichuPlus = (int)((double)this.tamichuPlus + (double)(this.tamichuPlus * this.amountEffectForCalc.getTamichuPlusRate()) / 100.0);
    }

    public int getMaxArmyExp() {
        return 9999;
    }

    public void updateMaxArmyExp() {
    }

    public int getArmyExp() {
        return Math.min(this.armyExp, this.getMaxArmyExp());
    }

    public void setArmyExp(int n) {
        this.armyExp = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getArmyExpPlus() {
        return this.armyExpPlus;
    }

    public void updateArmyExpPlus() {
        this.armyExpPlus = this.amountEffectForCalc.getArmyExpPlus();
        this.armyExpPlus = (int)((double)this.armyExpPlus + (double)(this.armyExpPlus * this.amountEffectForCalc.getArmyExpPlusRate()) / 100.0);
    }

    public int getMaxChrist() {
        return this.maxChrist;
    }

    public void updateMaxChrist() {
        double d = this.getParameters().getChristMaxBase();
        this.maxChrist = (int)(d + (double)this.amountEffectForCalc.getMaxChristRate());
        this.maxChrist = DataUtil.checkInteger(this.maxChrist, 0, 100);
        switch (this.getDaimyo().getChristTreat()) {
            case -1: {
                this.maxChrist = DataUtil.checkInteger(this.maxChrist, 0, (int)d);
                break;
            }
            case 0: {
                this.maxChrist = DataUtil.checkInteger(this.maxChrist, 0, 50);
                break;
            }
            case 1: {
                this.maxChrist = !this.getDaimyo().getKnight().isBaptism() ? DataUtil.checkInteger(this.maxChrist, 0, 80) : DataUtil.checkInteger(this.maxChrist, 0, 100);
            }
        }
    }

    public int getChrist() {
        return Math.min(this.christ, this.maxChrist);
    }

    public void setChrist(int n) {
        this.christ = DataUtil.checkInteger(n, 0, 100);
    }

    public int getChristPlus() {
        return this.christPlus;
    }

    public void setChristPlus(int n) {
        this.christPlus = n;
    }

    public void updateChristPlus() {
        this.christPlus = this.amountEffectForCalc.getChristPlus();
    }

    public int getPower() {
        return this.power;
    }

    public void updatePower() {
        double d = this.getParameters().getPowerDiv1();
        double d2 = this.getParameters().getPowerDiv2();
        double d3 = this.getParameters().getPowerBase();
        this.power = (int)(d3 + (double)this.getPopulation() / d + (double)this.getTamichu() / d2) * 2;
        this.power = (int)((double)this.power + (double)(this.power * this.amountEffectForCalc.getPowerRate()) / 100.0);
    }

    public int getArmyLevel() {
        return this.armyLevel;
    }

    public void setArmyLevel(int n) {
        this.armyLevel = DataUtil.checkInteger(n, 0, 20);
    }

    public int getMaxArmy() {
        return this.maxArmy;
    }

    public void updateMaxArmy() {
        double d = this.getParameters().getRecruitDiv();
        double d2 = this.getParameters().getRecruitBase();
        this.maxArmy = (int)((double)this.getPopulation() * (d2 + (double)this.getTamichu() / d) / 100.0);
    }

    public int getUsableArmy() {
        return this.usableArmy;
    }

    public void setUsableArmy(int n) {
        this.usableArmy = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getUsingArmy() {
        int n = this.units.stream().mapToInt(unitV -> unitV.getTotal()).sum();
        return n;
    }

    public int getArmyPlus() {
        return this.armyPlus;
    }

    public void updateArmyPlus() {
        int n = this.getParameters().getArmyPlusRateBase();
        this.armyPlus = n + this.amountEffectForCalc.getArmyPlus();
    }

    public List<UnitV> getUnits() {
        return this.units;
    }

    public void updateUnits() {
        this.units.clear();
        for (UnitV unitV : this.getGameDataV().getUnits().values()) {
            if (unitV.getCountryId() != this.id) continue;
            this.units.add(unitV);
        }
    }

    public List<BuildPlan> getBuildPlans() {
        return this.buildPlans;
    }

    public void setBuildPlans(List<BuildPlan> list) {
        this.buildPlans = list;
    }

    public int getRuinMonth() {
        return this.ruinMonth;
    }

    public void setRuinMonth(int n) {
        this.ruinMonth = DataUtil.checkInteger(n, 0, 99);
    }

    public int getArmyPower() {
        int n = (int)(Math.floor(Math.pow(2.0, this.getArmyLevel() / 4)) * (double)this.getMaxArmy());
        return n;
    }

    public int getMissionary() {
        return this.missionary;
    }

    public void setMissionary(int n) {
        this.missionary = DataUtil.checkInteger(n, 0, 9999999);
    }

    public int getIncomeMonth() {
        return this.incomeMonth;
    }

    public void updateIncomeMonth() {
        int n = this.getParameters().getCommerceDiv();
        double d = this.getGameDataV().getWorld().getInflationRate();
        this.incomeMonth = (int)Math.ceil((double)this.amountEffectForCalc.getMoneyPlus() * d) + this.getCommerce() / n;
    }

    public int getIncomeYear() {
        return this.incomeYear;
    }

    public void updateIncomeYear() {
        this.incomeYear = this.incomeMonth * 12;
    }

    public int getBaseIncome() {
        return this.baseIncome;
    }

    public void setBaseIncome(int n) {
        this.baseIncome = DataUtil.checkInteger(n, 0, 999999);
    }

    public double getInflationRate() {
        return this.inflationRate;
    }

    public void updateInflationRate() {
        this.inflationRate = this.getGameDataV().getWorld().getInflationRate();
    }

    public List<Integer> getSpotIds() {
        return this.spotIds;
    }

    public void updateSpotIds() {
        this.spotIds.clear();
        for (Spot spot : this.getGameData().getJapan().getSpots().values()) {
            if (spot.getCountryId() != this.id) continue;
            this.spotIds.add(spot.getId());
        }
    }

    public List<SpotV> getSpots() {
        return this.spots;
    }

    public void updateSpots() {
        this.spotIds.clear();
        this.spots.clear();
        for (SpotV spotV3 : this.getGameDataV().getSpots().values()) {
            if (spotV3.getSpot().getCountryId() != this.id) continue;
            this.spotIds.add(spotV3.getId());
            this.spots.add(spotV3);
        }
        this.spots.sort((spotV, spotV2) -> spotV.getId() - spotV2.getId());
    }

    public boolean isBeIkkou() {
        return this.beIkkou;
    }

    public void updateBeIkkou() {
        this.beIkkou = false;
        for (SpotV spotV : this.getSpots()) {
            for (UnitV unitV : spotV.getUnits()) {
                if (unitV.getUnit().getId() != this.getParameters().getIkkouId()) continue;
                this.beIkkou = true;
                return;
            }
        }
    }

    public SpotV getCapitalSpot() {
        return this.spots.get(0);
    }

    public void updateByMonth() {
        int n;
        this.update();
        if (this.getRuinMonth() <= 0) {
            this.setPopulation(Math.min(this.population + this.getPopulationPlus(), this.getMaxPopulation()));
            this.setFood(Math.min(this.food + this.getFoodPlus(), this.getMaxFood()));
            this.setCommerce(Math.min(this.commerce + this.getCommercePlus(), this.getMaxCommerce()));
            this.setCulture(Math.min(this.culture + this.getCulturePlus(), this.getMaxCulture()));
            this.setTamichu(Math.min(this.tamichu + this.getTamichuPlus(), this.getMaxTamichu()));
        }
        this.setArmyExp(Math.min(this.armyExp + this.getArmyExpPlus(), this.getMaxArmyExp()));
        this.setChrist(Math.min(this.christ + this.getChristPlus(), this.getMaxChrist()));
        int n2 = this.getArmyPlus() * this.getMaxArmy() / 100;
        this.setUsableArmy(Math.min(this.usableArmy + n2, this.getMaxArmy() - this.getUsingArmy()));
        this.setRuinMonth(this.getRuinMonth() - 1);
        if (this.getDaimyo().isCanHongan()) {
            this.missionary += 100;
        }
        if ((n = this.population * (100 - this.christ)) < this.missionary) {
            this.missionary = n;
        }
    }

    public void updateByYear() {
        this.updateSpots();
    }

    @Override
    public void setReference() {
        super.setReference();
        this.buildPlans.forEach(buildPlan -> {
            buildPlan.setGameData(this.gameData);
            buildPlan.setGameAIData(this.gameAIData);
            buildPlan.setGameDataV(this.gameDataV);
        });
    }

    public void update() {
        this.updateAmountEffect();
        this.buildPlans.forEach(buildPlan -> buildPlan.update());
        this.updateMaxPopulation();
        this.updatePopulationPlus();
        this.updateMaxFood();
        this.updateFoodPlus();
        this.updateMaxCommerce();
        this.updateCommercePlus();
        this.updateMaxCulture();
        this.updateCulturePlus();
        this.updateMaxTamichu();
        this.updateTamichuPlus();
        this.updateMaxArmyExp();
        this.updateArmyExpPlus();
        this.updateMaxChrist();
        this.updateChristPlus();
        this.updatePower();
        this.updateMaxArmy();
        this.updateArmyPlus();
        this.updateUnits();
        this.updateIncomeMonth();
        this.updateIncomeYear();
        this.updateInflationRate();
        this.updateSpots();
        this.updateBeIkkou();
        this.updateAmountEffect();
    }

    public CalcValue getCalcValue() {
        return this.calcValue;
    }

    public void setCalcValue(CalcValue calcValue) {
        this.calcValue = calcValue;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (!this.getGameDataV().getDaimyos().containsKey(this.daimyoId)) {
            list.add(new ValidErrorMessage(this, "\u5927\u540d\u304c\u53c2\u7167\u3067\u304d\u307e\u305b\u3093\u3002"));
            ++n;
        }
        return n == 0;
    }

    @Override
    public String getName() {
        return this.getCountry().getName();
    }

    public int getFoodRate() {
        return this.getFood() * 100 / this.getMaxFood();
    }
}

