/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.BattleReport;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameData;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class Condition {
    public static final int ID_NONE = 0;
    public static final int MIN_CULTURE_MIN = 0;
    public static final int MIN_CULTURE_MAX = 9999;
    public static final int MAX_CULTURE_MIN = 0;
    public static final int MAX_CULTURE_MAX = 9999;
    public static final int MIN_COMMERCE_MIN = 0;
    public static final int MIN_COMMERCE_MAX = 9999;
    public static final int MAX_COMMERCE_MIN = 0;
    public static final int MAX_COMMERCE_MAX = 9999;
    public static final int MIN_POPULATION_MIN = 0;
    public static final int MIN_POPULATION_MAX = 9999;
    public static final int MAX_POPULATION_MIN = 0;
    public static final int MAX_POPULATION_MAX = 9999;
    public static final int MIN_FOOD_MIN = 0;
    public static final int MIN_FOOD_MAX = 9999;
    public static final int MAX_FOOD_MIN = 0;
    public static final int MAX_FOOD_MAX = 9999;
    public static final int MIN_FOOD_RATE_MIN = 0;
    public static final int MIN_FOOD_RATE_MAX = 100;
    public static final int MAX_FOOD_RATE_MIN = 0;
    public static final int MAX_FOOD_RATE_MAX = 100;
    public static final int MIN_ARMY_LEVEL_MIN = 0;
    public static final int MIN_ARMY_LEVEL_MAX = 20;
    public static final int MAX_ARMY_LEVEL_MIN = 0;
    public static final int MAX_ARMY_LEVEL_MAX = 20;
    public static final int MIN_FAME_MIN = -99;
    public static final int MIN_FAME_MAX = 99;
    public static final int MAX_FAME_MIN = -99;
    public static final int MAX_FAME_MAX = 99;
    public static final int MIN_IMPACT_MIN = 0;
    public static final int MIN_IMPACT_MAX = 10000;
    public static final int MAX_IMPACT_MIN = 0;
    public static final int MAX_IMPACT_MAX = 10000;
    public static final int MIN_CHRIST_MIN = 0;
    public static final int MIN_CHRIST_MAX = 100;
    public static final int MAX_CHRIST_MIN = 0;
    public static final int MAX_CHRIST_MAX = 100;
    public static final int MIN_COUNTRIES_MIN = 0;
    public static final int MIN_COUNTRIES_MAX = 99;
    public static final int WIN_MIN = 0;
    public static final int WIN_MAX = 1000;
    public static final int WIN_PLANE_MIN = 0;
    public static final int WIN_PLANE_MAX = 1000;
    public static final int WIN_MOUNTAIN_MIN = 0;
    public static final int WIN_MOUNTAIN_MAX = 1000;
    public static final int WIN_SEA_MIN = 0;
    public static final int WIN_SEA_MAX = 1000;
    public static final int WIN_GUN_MIN = 0;
    public static final int WIN_GUN_MAX = 1000;
    public static final int WIN_HORSE_MIN = 0;
    public static final int WIN_HORSE_MAX = 1000;
    public static final int WIN_CASTLE_MIN = 0;
    public static final int WIN_CASTLE_MAX = 1000;
    public static final int WIN_DEFENSE_MIN = 0;
    public static final int WIN_DEFENSE_MAX = 1000;
    public static final int MIN_MONEY_MIN = 0;
    public static final int MIN_MONEY_MAX = 100000;
    public static final int MIN_GUN_MIN = 0;
    public static final int MIN_GUN_MAX = 100000;
    public static final int MIN_HORSE_MIN = 0;
    public static final int MIN_HORSE_MAX = 100000;
    public static final int MIN_IRON_MIN = 0;
    public static final int MIN_IRON_MAX = 100000;
    public static final int MIN_GUNPOWDER_MIN = 0;
    public static final int MIN_GUNPOWDER_MAX = 100000;
    public static final int MIN_SALTPETER_MIN = 0;
    public static final int MIN_SALTPETER_MAX = 100000;
    public static final int MIN_TAMICHU_MIN = 0;
    public static final int MIN_TAMICHU_MAX = 9999;
    public static final int MIN_MAX_TAMICHU_MIN = 0;
    public static final int MIN_MAX_TAMICHU_MAX = 9999;
    public static final int YEAR_MIN = 1500;
    public static final int YEAR_MAX = 1700;
    @Element(required=false, name="min_culture")
    private int minCulture = 0;
    @Element(required=false, name="max_culture")
    private int maxCulture = 9999;
    @Element(required=false, name="min_commerce")
    private int minCommerce = 0;
    @Element(required=false, name="max_commerce")
    private int maxCommerce = 9999;
    @Element(required=false, name="min_population")
    private int minPopulation = 0;
    @Element(required=false, name="max_population")
    private int maxPopulation = 9999;
    @Element(required=false, name="min_food")
    private int minFood = 0;
    @Element(required=false, name="max_food")
    private int maxFood = 9999;
    @Element(required=false, name="min_food_rate")
    private int minFoodRate = 0;
    @Element(required=false, name="max_food_rate")
    private int maxFoodRate = 100;
    @Element(required=false, name="min_army_level")
    private int minArmyLevel = 0;
    @Element(required=false, name="max_army_level")
    private int maxArmyLevel = 20;
    @Element(required=false, name="min_fame")
    private int minFame = -99;
    @Element(required=false, name="max_fame")
    private int maxFame = 99;
    @Element(required=false, name="min_impact")
    private int minImpact = 0;
    @Element(required=false, name="max_impact")
    private int maxImpact = 100000;
    @Element(required=false, name="min_christ")
    private int minChrist = 0;
    @Element(required=false, name="max_christ")
    private int maxChrist = 100;
    @ElementList(required=false, name="countries")
    private List<Integer> countries = null;
    @ElementList(required=false, name="spots")
    private List<Integer> spots = null;
    @ElementList(required=false, name="technologies")
    private List<Integer> technologies = null;
    @ElementList(required=false, name="cultures")
    private List<Integer> cultures = null;
    @Element(required=false, name="min_countries")
    private int minCountries = 0;
    @Element(required=false, name="win")
    private int win = 0;
    @Element(required=false, name="win_plane")
    private int winPlane = 0;
    @Element(required=false, name="win_mountain")
    private int winMountain = 0;
    @Element(required=false, name="win_sea")
    private int winSea = 0;
    @Element(required=false, name="win_gun")
    private int winGun = 0;
    @Element(required=false, name="win_horse")
    private int winHorse = 0;
    @Element(required=false, name="win_castle")
    private int winCastle = 0;
    @Element(required=false, name="win_defense")
    private int winDefense = 0;
    @Element(required=false, name="min_money")
    private int minMoney = 0;
    @Element(required=false, name="min_gun")
    private int minGun = 0;
    @Element(required=false, name="min_horse")
    private int minHorse = 0;
    @Element(required=false, name="min_iron")
    private int minIron = 0;
    @Element(required=false, name="min_gunpowder")
    private int minGunpowder = 0;
    @Element(required=false, name="min_saltpeter")
    private int minSaltpeter = 0;
    @Element(required=false, name="min_tamichu")
    private int minTamichu = 0;
    @Element(required=false, name="min_max_tamichu")
    private int minMaxTamichu = 0;
    @Element(required=false, name="year")
    private int year = 1500;

    public Condition() {
        this.countries = new ArrayList<Integer>();
        this.spots = new ArrayList<Integer>();
        this.technologies = new ArrayList<Integer>();
        this.cultures = new ArrayList<Integer>();
    }

    public Condition(@Element(name="min_culture") int n, @Element(name="max_culture") int n2, @Element(name="min_commerce") int n3, @Element(name="max_commerce") int n4, @Element(name="min_population") int n5, @Element(name="max_population") int n6, @Element(name="min_food") int n7, @Element(name="max_food") int n8, @Element(name="min_food_rate") int n9, @Element(name="max_food_rate") int n10, @Element(name="min_army_level") int n11, @Element(name="max_army_level") int n12, @Element(name="min_fame") int n13, @Element(name="max_fame") int n14, @Element(name="min_impact") int n15, @Element(name="max_impact") int n16, @Element(name="min_christ") int n17, @Element(name="max_christ") int n18, @Element(name="min_countries") int n19, @Element(name="win") int n20, @Element(name="win_plane") int n21, @Element(name="win_mountain") int n22, @Element(name="win_sea") int n23, @Element(name="win_gun") int n24, @Element(name="win_horse") int n25, @Element(name="win_castle") int n26, @Element(name="win_defense") int n27, @Element(name="min_money") int n28, @Element(name="min_gun") int n29, @Element(name="min_horse") int n30, @Element(name="min_iron") int n31, @Element(name="min_gunpowder") int n32, @Element(name="min_saltpeter") int n33, @Element(name="min_tamichu") int n34, @Element(name="min_max_tamichu") int n35, @Element(name="year") int n36) {
        this.minCulture = n;
        this.minCulture = DataUtil.checkInteger(n, 0, 9999);
        this.maxCulture = n2;
        this.maxCulture = DataUtil.checkInteger(n2, 0, 9999);
        this.minCommerce = n3;
        this.minCommerce = DataUtil.checkInteger(n3, 0, 9999);
        this.maxCommerce = n4;
        this.maxCommerce = DataUtil.checkInteger(n4, 0, 9999);
        this.minPopulation = n5;
        this.minPopulation = DataUtil.checkInteger(n5, 0, 9999);
        this.maxPopulation = n6;
        this.maxPopulation = DataUtil.checkInteger(n6, 0, 9999);
        this.minFood = n7;
        this.minFood = DataUtil.checkInteger(n7, 0, 9999);
        this.maxFood = n8;
        this.maxFood = DataUtil.checkInteger(n8, 0, 9999);
        this.minFoodRate = n9;
        this.minFoodRate = DataUtil.checkInteger(n9, 0, 100);
        this.maxFoodRate = n10;
        this.maxFoodRate = DataUtil.checkInteger(n10, 0, 100);
        this.minArmyLevel = n11;
        this.minArmyLevel = DataUtil.checkInteger(n11, 0, 20);
        this.maxArmyLevel = n12;
        this.maxArmyLevel = DataUtil.checkInteger(n12, 0, 20);
        this.minFame = n13;
        this.minFame = DataUtil.checkInteger(n13, -99, 99);
        this.maxFame = n14;
        this.maxFame = DataUtil.checkInteger(n14, -99, 99);
        this.minImpact = n15;
        this.minImpact = DataUtil.checkInteger(n15, 0, 10000);
        this.maxImpact = n16;
        this.maxImpact = DataUtil.checkInteger(n16, 0, 10000);
        this.minChrist = n17;
        this.minChrist = DataUtil.checkInteger(n17, 0, 100);
        this.maxChrist = n18;
        this.maxChrist = DataUtil.checkInteger(n18, 0, 100);
        this.countries = new ArrayList<Integer>();
        this.spots = new ArrayList<Integer>();
        this.technologies = new ArrayList<Integer>();
        this.cultures = new ArrayList<Integer>();
        this.minCountries = n19;
        this.minCountries = DataUtil.checkInteger(n19, 0, 99);
        this.win = n20;
        this.win = DataUtil.checkInteger(n20, 0, 1000);
        this.winPlane = n21;
        this.winPlane = DataUtil.checkInteger(n21, 0, 1000);
        this.winMountain = n22;
        this.winMountain = DataUtil.checkInteger(n22, 0, 1000);
        this.winSea = n23;
        this.winSea = DataUtil.checkInteger(n23, 0, 1000);
        this.winGun = n24;
        this.winGun = DataUtil.checkInteger(n24, 0, 1000);
        this.winHorse = n25;
        this.winHorse = DataUtil.checkInteger(n25, 0, 1000);
        this.winCastle = n26;
        this.winCastle = DataUtil.checkInteger(n26, 0, 1000);
        this.winDefense = n27;
        this.winDefense = DataUtil.checkInteger(n27, 0, 1000);
        this.minMoney = n28;
        this.minMoney = DataUtil.checkInteger(n28, 0, 100000);
        this.minGun = n29;
        this.minGun = DataUtil.checkInteger(n29, 0, 100000);
        this.minHorse = n30;
        this.minHorse = DataUtil.checkInteger(n30, 0, 100000);
        this.minIron = n31;
        this.minIron = DataUtil.checkInteger(n31, 0, 100000);
        this.minGunpowder = n32;
        this.minGunpowder = DataUtil.checkInteger(n32, 0, 100000);
        this.minSaltpeter = n33;
        this.minSaltpeter = DataUtil.checkInteger(n33, 0, 100000);
        this.minTamichu = n34;
        this.minTamichu = DataUtil.checkInteger(n34, 0, 9999);
        this.minMaxTamichu = n35;
        this.minMaxTamichu = DataUtil.checkInteger(n35, 0, 9999);
        this.year = n36;
        this.year = DataUtil.checkInteger(n36, 1500, 1700);
    }

    public int getMinCulture() {
        return this.minCulture;
    }

    public void setMinCulture(int n) {
        this.minCulture = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMaxCulture() {
        return this.maxCulture;
    }

    public void setMaxCulture(int n) {
        this.maxCulture = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMinCommerce() {
        return this.minCommerce;
    }

    public void setMinCommerce(int n) {
        this.minCommerce = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMaxCommerce() {
        return this.maxCommerce;
    }

    public void setMaxCommerce(int n) {
        this.maxCommerce = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMinPopulation() {
        return this.minPopulation;
    }

    public void setMinPopulation(int n) {
        this.minPopulation = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMaxPopulation() {
        return this.maxPopulation;
    }

    public void setMaxPopulation(int n) {
        this.maxPopulation = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMinFood() {
        return this.minFood;
    }

    public void setMinFood(int n) {
        this.minFood = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMaxFood() {
        return this.maxFood;
    }

    public void setMaxFood(int n) {
        this.maxFood = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMinFoodRate() {
        return this.minFoodRate;
    }

    public void setMinFoodRate(int n) {
        this.minFoodRate = DataUtil.checkInteger(n, 0, 100);
    }

    public int getMaxFoodRate() {
        return this.maxFoodRate;
    }

    public void setMaxFoodRate(int n) {
        this.maxFoodRate = DataUtil.checkInteger(n, 0, 100);
    }

    public int getMinArmyLevel() {
        return this.minArmyLevel;
    }

    public void setMinArmyLevel(int n) {
        this.minArmyLevel = DataUtil.checkInteger(n, 0, 20);
    }

    public int getMaxArmyLevel() {
        return this.maxArmyLevel;
    }

    public void setMaxArmyLevel(int n) {
        this.maxArmyLevel = DataUtil.checkInteger(n, 0, 20);
    }

    public int getMinFame() {
        return this.minFame;
    }

    public void setMinFame(int n) {
        this.minFame = DataUtil.checkInteger(n, -99, 99);
    }

    public int getMaxFame() {
        return this.maxFame;
    }

    public void setMaxFame(int n) {
        this.maxFame = DataUtil.checkInteger(n, -99, 99);
    }

    public int getMinImpact() {
        return this.minImpact;
    }

    public void setMinImpact(int n) {
        this.minImpact = DataUtil.checkInteger(n, 0, 10000);
    }

    public int getMaxImpact() {
        return this.maxImpact;
    }

    public void setMaxImpact(int n) {
        this.maxImpact = DataUtil.checkInteger(n, 0, 10000);
    }

    public int getMinChrist() {
        return this.minChrist;
    }

    public void setMinChrist(int n) {
        this.minChrist = DataUtil.checkInteger(n, 0, 100);
    }

    public int getMaxChrist() {
        return this.maxChrist;
    }

    public void setMaxChrist(int n) {
        this.maxChrist = DataUtil.checkInteger(n, 0, 100);
    }

    public List<Integer> getCountries() {
        return this.countries;
    }

    public void setCountries(List<Integer> list) {
        this.countries = list;
    }

    public List<Integer> getSpots() {
        return this.spots;
    }

    public void setSpots(List<Integer> list) {
        this.spots = list;
    }

    public List<Integer> getTechnologies() {
        return this.technologies;
    }

    public void setTechnologies(List<Integer> list) {
        this.technologies = list;
    }

    public List<Integer> getCultures() {
        return this.cultures;
    }

    public void setCultures(List<Integer> list) {
        this.cultures = list;
    }

    public int getMinCountries() {
        return this.minCountries;
    }

    public void setMinCountries(int n) {
        this.minCountries = DataUtil.checkInteger(n, 0, 99);
    }

    public int getWin() {
        return this.win;
    }

    public void setWin(int n) {
        this.win = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinPlane() {
        return this.winPlane;
    }

    public void setWinPlane(int n) {
        this.winPlane = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinMountain() {
        return this.winMountain;
    }

    public void setWinMountain(int n) {
        this.winMountain = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinSea() {
        return this.winSea;
    }

    public void setWinSea(int n) {
        this.winSea = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinGun() {
        return this.winGun;
    }

    public void setWinGun(int n) {
        this.winGun = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinHorse() {
        return this.winHorse;
    }

    public void setWinHorse(int n) {
        this.winHorse = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinCastle() {
        return this.winCastle;
    }

    public void setWinCastle(int n) {
        this.winCastle = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getWinDefense() {
        return this.winDefense;
    }

    public void setWinDefense(int n) {
        this.winDefense = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getMinMoney() {
        return this.minMoney;
    }

    public void setMinMoney(int n) {
        this.minMoney = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinGun() {
        return this.minGun;
    }

    public void setMinGun(int n) {
        this.minGun = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinHorse() {
        return this.minHorse;
    }

    public void setMinHorse(int n) {
        this.minHorse = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinIron() {
        return this.minIron;
    }

    public void setMinIron(int n) {
        this.minIron = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinGunpowder() {
        return this.minGunpowder;
    }

    public void setMinGunpowder(int n) {
        this.minGunpowder = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinSaltpeter() {
        return this.minSaltpeter;
    }

    public void setMinSaltpeter(int n) {
        this.minSaltpeter = DataUtil.checkInteger(n, 0, 100000);
    }

    public int getMinTamichu() {
        return this.minTamichu;
    }

    public void setMinTamichu(int n) {
        this.minTamichu = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getMinMaxTamichu() {
        return this.minMaxTamichu;
    }

    public void setMinMaxTamichu(int n) {
        this.minMaxTamichu = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = DataUtil.checkInteger(n, 1500, 1700);
    }

    public boolean checkValid(List<ValidErrorMessage> list, GameData gameData) {
        boolean bl = false;
        this.countries.removeIf(n -> n != 0 && !gameData.getJapan().getCountries().containsKey(n));
        this.spots.removeIf(n -> n != 0 && !gameData.getJapan().getSpots().containsKey(n));
        this.technologies.removeIf(n -> n != 0 && !gameData.getTechnologies().containsKey(n));
        this.cultures.removeIf(n -> n != 0 && !gameData.getCultures().containsKey(n));
        return !bl;
    }

    private boolean intersect(List<Integer> list, List<Integer> list2) {
        for (int n : list) {
            for (int n2 : list2) {
                if (n != n2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean judgeForTechnology(int n, DaimyoV daimyoV) {
        return this.judge(n, daimyoV) && this.minCulture <= daimyoV.getCultureArv() && daimyoV.getCultureArv() <= this.maxCulture && this.minCommerce <= daimyoV.getCommerce() && daimyoV.getCommerce() <= this.maxCommerce && this.minPopulation <= daimyoV.getPopulationAmount() && daimyoV.getPopulationAmount() <= this.maxPopulation && this.minFood <= daimyoV.getFoodAmount() && daimyoV.getFoodAmount() <= this.maxFood && this.minFoodRate <= daimyoV.getFoodRate() && daimyoV.getFoodRate() <= this.maxFoodRate && this.minChrist <= daimyoV.getChrist() && daimyoV.getChrist() <= this.maxChrist && this.minCountries <= daimyoV.getCountries().size() && this.minMoney <= daimyoV.getMoney() && this.minGun <= daimyoV.getGun() && this.minHorse <= daimyoV.getHorse() && this.minGunpowder <= daimyoV.getGunpowder() && this.minSaltpeter <= daimyoV.getSaltpeter() && this.minIron <= daimyoV.getIron();
    }

    private double calcRateMin(int n, int n2) {
        return n <= n2 ? 1.0 : (double)n2 * 1.0 / (double)n;
    }

    public double complateRate(DaimyoV daimyoV) {
        BattleReport battleReport = daimyoV.getReport();
        double d = 1.0;
        d *= this.calcRateMin(this.minFame, daimyoV.getFame());
        d *= daimyoV.getFame() <= this.maxFame ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minImpact, daimyoV.getImpact());
        d *= this.calcRateMin(this.minCountries, daimyoV.getCountries().size());
        d *= this.calcRateMin(this.win, battleReport.getWin());
        d *= this.calcRateMin(this.winPlane, battleReport.getWinPlane());
        d *= this.calcRateMin(this.winMountain, battleReport.getWinMountain());
        d *= this.calcRateMin(this.winSea, battleReport.getWinSea());
        d *= this.calcRateMin(this.winGun, battleReport.getWinGun());
        d *= this.calcRateMin(this.winHorse, battleReport.getWinHorse());
        d *= this.calcRateMin(this.winCastle, battleReport.getWinCastle());
        d *= this.calcRateMin(this.winDefense, battleReport.getWinDefense());
        d *= this.calcRateMin(this.minCulture, daimyoV.getCultureArv());
        d *= daimyoV.getCultureArv() <= this.maxCulture ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minCommerce, daimyoV.getCommerce());
        d *= daimyoV.getCommerce() <= this.maxCommerce ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minPopulation, daimyoV.getPopulationAmount());
        d *= daimyoV.getPopulationAmount() <= this.maxPopulation ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minFood, daimyoV.getFoodAmount());
        d *= daimyoV.getFoodAmount() <= this.maxFood ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minFoodRate, daimyoV.getFoodRate());
        d *= daimyoV.getFoodRate() <= this.maxFoodRate ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minChrist, daimyoV.getChrist());
        d *= daimyoV.getChrist() <= this.maxChrist ? 1.0 : 0.0;
        d *= this.calcRateMin(this.minMoney, daimyoV.getMoney());
        d *= this.calcRateMin(this.minGun, daimyoV.getGun());
        d *= this.calcRateMin(this.minHorse, daimyoV.getHorse());
        d *= this.calcRateMin(this.minGunpowder, daimyoV.getGunpowder());
        d *= this.calcRateMin(this.minSaltpeter, daimyoV.getSaltpeter());
        d *= this.calcRateMin(this.minIron, daimyoV.getIron());
        if (!daimyoV.getTechnologyIds().containsAll(this.technologies)) {
            d *= 0.5;
        }
        if (!daimyoV.getCultureIds().containsAll(this.cultures)) {
            d *= 0.5;
        }
        return d;
    }

    public boolean judge(int n, DaimyoV daimyoV) {
        BattleReport battleReport = daimyoV.getReport();
        return !(this.year > n || this.minFame > daimyoV.getFame() || daimyoV.getFame() > this.maxFame || this.minImpact > daimyoV.getImpact() || daimyoV.getImpact() > this.maxImpact || this.minCountries > daimyoV.getCountries().size() || this.win > battleReport.getWin() || this.winPlane > battleReport.getWin() || this.winMountain > battleReport.getWinMountain() || this.winSea > battleReport.getWinSea() || this.winGun > battleReport.getWinGun() || this.winHorse > battleReport.getWinHorse() || this.winCastle > battleReport.getWinCastle() || this.winDefense > battleReport.getWinDefense() || !this.technologies.isEmpty() && !this.intersect(this.technologies, daimyoV.getTechnologyIds()) || !this.cultures.isEmpty() && !this.intersect(this.cultures, daimyoV.getCultureIds()));
    }

    public boolean judge(int n, CountryV countryV) {
        return this.judgeOnly(n, countryV) && this.judge(n, countryV.getDaimyo());
    }

    public boolean judgeOnly(int n, CountryV countryV) {
        return this.year <= n && this.minCulture <= countryV.getCulture() && countryV.getCulture() <= this.maxCulture && this.minCommerce <= countryV.getCommerce() && countryV.getCommerce() <= this.maxCommerce && this.minPopulation <= countryV.getPopulation() && countryV.getPopulation() <= this.maxPopulation && this.minFood <= countryV.getFood() && countryV.getFood() <= this.maxFood && this.minFoodRate <= countryV.getFoodRate() && countryV.getFoodRate() <= this.maxFoodRate && this.minArmyLevel <= countryV.getArmyLevel() && countryV.getArmyLevel() <= this.maxArmyLevel && this.minChrist <= countryV.getChrist() && countryV.getChrist() <= this.maxChrist && this.minTamichu <= countryV.getTamichu() && this.minMaxTamichu <= countryV.getMaxTamichu();
    }
}

