/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;


/**
 * 
 * privateȃ\bhEtB[hERXgN^ɃANZX邽߂̃wpNXB
 * 
 * @author NTT DATA Corporation
 */
public final class AccessSupplier {
	
	/**
	 * 
	 * Cӂ̑loB<br>
	 * ObjectŕԂ̂ŁAK؂ȃNXɃLXg邱ƂKvB<br>
	 * ÓINXÓIl擾ꍇ́AÓINXClassn΂悢B
	 * 
	 * @param instance	olNX̃CX^X
	 * @param fieldName	
	 * @return	liK؂ȃLXgKvj
	 */
	public static Object getField( Object instance, String fieldName ) {
		
		return getField( instance, fieldName, 0 );
	}
	
	/**
	 * 
	 * Cӂ̑loB<br>
	 * rankɃCX^XƑێNXƂ̊Kw^邱ƂŁAX[p[NX̑łĂ擾łB
	 * 
	 * @param instance	olNX̃CX^X
	 * @param fieldName	
	 * @param rank	CX^XƎۂɂ̑ێNXƂ̃NXKwB
	 * 				OȂCX^X̂ێĂ邱ƂAPȂP̃X[p[NXێĂ邱ƂB
	 * @return	liK؂ȃLXgKvj
	 */
	private static Object getField( Object instance, String fieldName, int rank ) {
		
		Class cls;
		if( instance instanceof Class )	cls = (Class)instance;		//ÓINXłꍇ
		else								cls = instance.getClass();	//ʏ̃CX^Xłꍇ
		
		try {
			
			//Kwk
			for( int depth = rank; depth>0; depth-- ){
				cls = cls.getSuperclass();
			}
			
			//l̎擾
			Field field = cls.getDeclaredField(fieldName);
			field.setAccessible(true);
			
			return field.get(instance);
			
		} catch (NoSuchFieldException ne) {
			
			//eNXꍇ͂
			if( cls.getSuperclass() != null ){
				return getField(instance,fieldName, rank+1 );
			}
			
			HimawariLogger.outputException( ne );
			return null;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
		
	}
	
	/**
	 * 
	 * Cӂ̑lɑ΂ĔCӂ̒lݒ肷B<br>
	 * ÓINX̐ÓIlݒ肵ꍇ́AÓINXClassn΂悢B
	 * 
	 * @param instance	ݒ肵lNX̃CX^X
	 * @param fieldName	
	 * @param value	ݒ肵l
	 */
	public static void setField( Object instance, String fieldName, Object value ) {
		
		setField( instance, fieldName, value, 0 );
	}
	
	/**
	 * 
	 * Cӂ̑lɑ΂ĔCӂ̒lݒ肷B<br>
	 * rankɃCX^XƑێNXƂ̊Kw^邱ƂŁAX[p[NX̑łĂݒłB
	 * 
	 * @param instance	ݒ肵lNX̃CX^X
	 * @param fieldName	
	 * @param value 	ݒ肵l
	 * @param rank	CX^XƎۂɂ̑ێNXƂ̃NXKwB
	 * 				OȂCX^X̂ێĂ邱ƂAPȂP̃X[p[NXێĂ邱ƂB
	 */
	private static void setField( Object instance, String fieldName, Object value, int rank ) {
		
		Class cls;
		if( instance instanceof Class )	cls = (Class)instance;		//ÓINXłꍇ
		else								cls = instance.getClass();	//ʏ̃CX^Xłꍇ
		
		try {
			
			//Kwk
			for( ; rank>0; rank-- ){
				cls = cls.getSuperclass();
			}
			
			//l̎擾
			Field field = cls.getDeclaredField(fieldName);
			field.setAccessible(true);
			
			field.set( instance, value );
			return;
			
		} catch (NoSuchFieldException ne) {
			
			//eNXꍇ͂
			if( cls.getSuperclass() != null ){
				setField(instance,fieldName,value, rank+1 );
				return;
			}
			
			HimawariLogger.outputException( ne );
			return;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return;
		}
		
	}
	
	/**
	 * 
	 * Cӂ̃\bhoB<br>
	 * ÓINXÓI\bh擾ꍇ́AÓINXClassn΂悢B
	 * 
	 * @param instance	o\bhNX̃CX^X
	 * @param methodName	\bh
	 * @param parameterTypes	\bḧ
	 * @return	MethodIuWFNg
	 */
	public static Method getMethod( Object instance, String methodName, Class ... parameterTypes ) {
		try {
			
			Class cls;
			if( instance instanceof Class )	cls = (Class)instance;
			else								cls = instance.getClass();
			
			
			//NXXg̍쐬
			Class tmpCls;
			for( int i=0; i<parameterTypes.length; i++ ){
				
				//NX擾
				tmpCls = parameterTypes[i];

				//v~eBũbpȂ΃v~eBuɖ߂iBoolean܂ށj
				if( tmpCls.getSuperclass() == Number.class || tmpCls == Boolean.class ){
					tmpCls = (Class)tmpCls.getField("TYPE").get(tmpCls);
				}
				
				parameterTypes[i] = tmpCls;
			}
			
			//\bh̎擾
			Method method = cls.getDeclaredMethod(methodName, parameterTypes);
			method.setAccessible(true);
			
			return method;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
	}
	
	/**
	 * 
	 * Cӂ̃\bhsǍʂ擾B<br>
	 * ObjectŕԂ̂ŁAK؂ȃNXɃLXg邱ƂKvB<br>
	 * ÓINX̐ÓI\bhsꍇ́AÓINXClassn΂悢B
	 * 
	 * @param instance	s\bhNX̃CX^X
	 * @param methodName	\bh
	 * @param args	\bhsɕKvȃIuWFNg̃CX^X
	 * @return	sʁiK؂ȃLXgKvj
	 */
	public static Object invokeMethod( Object instance, String methodName, Object ... args ){
		try {
			
			Class[] parameterTypes = new Class[args.length];
			for( int i=0; i<parameterTypes.length; i++ ){
				parameterTypes[i] = args[i].getClass();
			}
			
			Method method = getMethod( instance, methodName, parameterTypes );
			
			Object ret = method.invoke( instance, args );
			
			return ret;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
	}
	
	/**
	 * 
	 * Cӂ̃RXgN^oB
	 * 
	 * @param cls	oRXgN^NX
	 * @param parameterTypes	RXgN^̈
	 * @return	ConstructorIuWFNg
	 */
	public static Constructor getConstructor( Class cls, Class ... parameterTypes ) {
		try {
			
			Constructor constr = cls.getDeclaredConstructor(parameterTypes);
			constr.setAccessible(true);
			
			return constr;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
	}
	
	/**
	 * 
	 * Cӂ̃RXgN^ŃCX^X𐶐B
	 * 
	 */
	public static <T> T getNewInstance( Class<T> cls, Object ... args ){
		try {
			
			//NXXg̍쐬
			Class[] argsClss = new Class[args.length];
			
			Class tmpCls;
			for( int i=0; i<argsClss.length; i++ ){
				
				//NX擾
				tmpCls = args[i].getClass();

				//v~eBũbpȂ΃v~eBuɖ߂iBoolean܂ށj
				if( tmpCls.getSuperclass() == Number.class || tmpCls == Boolean.class ){
					tmpCls = (Class)tmpCls.getField("TYPE").get(tmpCls);
				}
				
				argsClss[i] = tmpCls;
			}
			
			//RXgN^擾	
			Constructor<T> cnst = cls.getConstructor( argsClss );
			
			//̃RXgN^ŃCX^X
			return cnst.newInstance( args );
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
	}
	
	/**
	 * 
	 * Cӂ̓NXoB
	 * 
	 * @param instance	oNXNX̃CX^X
	 * @param clsname	NX
	 * @return	NXClassIuWFNg
	 */
	public static Class getInnerClass( Object instance, String clsname ){
		try {
			
			Class cls;
			if( instance instanceof Class )	cls = (Class)instance;
			else								cls = instance.getClass();
			
			Class[] classes = cls.getDeclaredClasses();
			
			//NX`ȂƂnullԂ
			if( classes.length == 0 ){
				return null;
			}
			
			//NX̒w薼̂̃NXT
			for( Class decClass : classes ){
				
				if( decClass.getSimpleName().equals( clsname ) ){
					cls = decClass;
				}
				
			}//end of for
			
			return cls;
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
		
	}
	
	/**
	 * 
	 * Cӂ̓NX̃CX^XoB
	 * 
	 * @param instance	oNXNX̃CX^X
	 * @param clsname	NX
	 * @return	NX̃CX^XiK؂ȃLXgKvj
	 */
	public static Object getInnerClassInstance( Object instance, String clsname ){
		try {
			
			//NX`擾
			Class innerClass = getInnerClass( instance, clsname );
			
			if( innerClass==null ){
				return null;
			}
			
			//NX̃CX^X
			Object ins;
			
			//NXstaticǂB
			if( Modifier.isStatic( innerClass.getModifiers() ) ){
				
				Constructor constr = getConstructor( innerClass );
				ins = constr.newInstance();
			
			}
			else{
				
				Constructor constr = getConstructor( innerClass, instance.getClass() );
				ins = constr.newInstance( instance );
				
			}
			
			return ins;
			
			
		} catch (Exception e) {
			HimawariLogger.outputException( e );
			return null;
		}
	}
}