// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying;
import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying_current;
import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying_peak;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 *  Varying variable templatised by type.
 *  ^Cvɂăev[gꂽ
 *  ς̕ϐShaderData̒ۃNX
 * @author NTT DATA Corporation
 */
abstract strictfp class CqShaderVariableVarying<R> extends CqShaderVariable {
	//protected  STLVector<R>	m_aValue;	///< Simgle uniform value of the appropriate type.
	protected  STLArray<R>	m_aValue;	///< Simgle uniform value of the appropriate type.
	protected  EqVariableType T;	//Generics T
	//protected  R	m_temp_R; //maybe unnecessary 

	/**
	 * RXgN^
	 * vXV
	 * @param T Generics T
	 */
	public CqShaderVariableVarying( EqVariableType T) 
	{
		super();
		this.T = T;
//		m_aValue.resize( 1 );qNXɈϏ
		
		CqStats.STATS_INC( SHD_var_varying );
		CqStats.STATS_INC( SHD_var_varying_current );
		int cvVar = CqStats.STATS_GETI( SHD_var_varying_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_varying_peak );
		CqStats.STATS_SETI( SHD_var_varying_peak, cvVar > cPeak ? cvVar : cPeak );
	}
	/**
	 * RXgN^
	 * vXV
	 * @param strName 
	 * @param T Generics T
	 */
	public CqShaderVariableVarying( final String strName,EqVariableType T){
		this(strName,false,T);
	}
	/**
	 * RXgN^
	 * vXV
	 * @param strName 
	 * @param fParameter
	 * @param T Generics T
	 */
	public CqShaderVariableVarying( final String strName, boolean fParameter,EqVariableType T)
	{
		super( strName, fParameter );
//		m_aValue.resize( 1 );qNXɈϏ
		this.T = T;
		CqStats.STATS_INC( SHD_var_varying );
		CqStats.STATS_INC( SHD_var_varying_current );
		int cvVar = CqStats.STATS_GETI( SHD_var_varying_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_varying_peak );
		CqStats.STATS_SETI( SHD_var_varying_peak, cvVar > cPeak ? cvVar : cPeak );
	}
	
    /**
     * RXgN^
     * vXVA2val̒lRs[
     * @param strName
     * @param val ShaderData̐擪̒lɑ
     * @param T Generics T
     */
	public CqShaderVariableVarying( final String strName,final R val ,EqVariableType T)
	{
		super( strName );
		this.T = T;
		//ǉ
		if(val instanceof CqColor){
			m_aValue = (STLArray<R>) new STLArray<CqColor>(CqColor.class);
			m_aValue.resize( 1 );
			((CqColor)m_aValue.elementAt(0)).assignment((CqColor)val);
		}else if(val instanceof CqVector3D){
			m_aValue = (STLArray<R>) new STLArray<CqVector3D>(CqVector3D.class);
			m_aValue.resize( 1 );
			((CqVector3D)m_aValue.elementAt(0)).assignment((CqVector3D)val);
		}else if(val instanceof CqMatrix){
			m_aValue = (STLArray<R>) new STLArray<CqMatrix>(CqMatrix.class);
			m_aValue.resize( 1 );
			((CqMatrix)m_aValue.elementAt(0)).assignment((CqMatrix)val);
		}else if(val instanceof p_float){
			m_aValue = (STLArray<R>) new STLArray<p_float>(p_float.class);
			m_aValue.resize( 1 );
			((p_float)m_aValue.elementAt(0)).value = ((p_float)val).value;
		}else if(val instanceof p_String){
			m_aValue = (STLArray<R>) new STLArray<p_String>(p_String.class);
			m_aValue.resize( 1 );
			((p_String)m_aValue.elementAt(0)).value = ((p_String)val).value;
		}
//		if(val instanceof CqColor){
//			m_aValue = (STLVector<R>) new STLVector<CqColor>(CqColor.class);
//			m_aValue.resize( 1 );
//			((CqColor)m_aValue.elementAt(0)).assignment((CqColor)val);
//		}else if(val instanceof CqVector3D){
//			m_aValue = (STLVector<R>) new STLVector<CqVector3D>(CqVector3D.class);
//			m_aValue.resize( 1 );
//			((CqVector3D)m_aValue.elementAt(0)).assignment((CqVector3D)val);
//		}else if(val instanceof CqMatrix){
//			m_aValue = (STLVector<R>) new STLVector<CqMatrix>(CqMatrix.class);
//			m_aValue.resize( 1 );
//			((CqMatrix)m_aValue.elementAt(0)).assignment((CqMatrix)val);
//		}else if(val instanceof p_float){
//			m_aValue = (STLVector<R>) new STLVector<p_float>(p_float.class);
//			m_aValue.resize( 1 );
//			((p_float)m_aValue.elementAt(0)).value = ((p_float)val).value;
//		}else if(val instanceof p_String){
//			m_aValue = (STLVector<R>) new STLVector<p_String>(p_String.class);
//			m_aValue.resize( 1 );
//			((p_String)m_aValue.elementAt(0)).value = ((p_String)val).value;
//		}
		//--܂
		
		CqStats.STATS_INC( SHD_var_varying );
		CqStats.STATS_INC( SHD_var_varying_current );
		int cvVar = CqStats.STATS_GETI( SHD_var_varying_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_varying_peak );
		CqStats.STATS_SETI( SHD_var_varying_peak, cvVar > cPeak ? cvVar : cPeak );
	}
	
	/**
	 * Rs[RXgN^
	 * @param val Rs[
	 * @param T Generics T
	 */
	public CqShaderVariableVarying( final CqShaderVariableVarying<R> val ,EqVariableType T)
	{
		super( val );
		this.T = T;
		//qNXɈϏ
//		m_aValue.resize( val.m_aValue.size() );
//		m_aValue.assign( val.m_aValue.begin(), val.m_aValue.begin() );
//		m_aValue.clear();
		//܂
		
		CqStats.STATS_INC( SHD_var_varying );
		CqStats.STATS_INC( SHD_var_varying_current );
		int cvVar = CqStats.STATS_GETI( SHD_var_varying_current );
		int cPeak = CqStats.STATS_GETI( SHD_var_varying_peak );
		CqStats.STATS_SETI( SHD_var_varying_peak, cvVar > cPeak ? cvVar : cPeak );
	}
	
	/**
	 * fXgN^
	 */
	public void destruct()
	{
		super.destruct();
		CqStats.STATS_DEC( SHD_var_varying_current );
	}
	
	/*
	 * qNXɈϏB
	 * R R ^CX^XłȂ
	public	void	Initialise( final int uGridRes, final int vGridRes )
	{
		R Def;
		
		if ( m_aValue.size() > 0 )
			Def = m_aValue.elementAt(0);
		//---ύX
//		m_aValue.assign( (( uGridRes + 1 ) * ( vGridRes + 1 )), Def );
		int limit = ( uGridRes + 1 ) * ( vGridRes + 1 );
		m_aValue.setSize(limit);
		for(int i=0;i < limit ;i++ ){
//			m_aValue.setElementAt(Def,i);
		}
		//܂
		CqStats.STATS_INC( SHD_Var_varying_init );
	}*/
	
	/**
	 * ShaderData̎Vector̒ύX
	 * @param size ύX̃TCY
	 */
	public	void	SetSize( final int size )
	{
		m_aValue.resize( size );
	}
	
	/**
	 * Ɏs֐
	 */
	public	void	GetFloat( p_float res, int index)
	{
		assert( false );
	}
	
	/**
	 * Ɏs֐
	 */
	public	void	GetString( p_String res, int index)
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetPoint( CqVector3D res, int index)
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetVector( CqVector3D res, int index)
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetNormal( CqVector3D res, int index)
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetColor( CqColor res, int index)
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetMatrix( CqMatrix res, int index)
	{
		assert( false );
	}
	
	/**
	 * Ɏs֐
	 */
	public	void	GetFloatPtr( final STLVector<p_float> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetStringPtr( final STLVector<p_String> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetPointPtr( final STLVector<CqVector3D> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetVectorPtr( final STLVector<CqVector3D> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetNormalPtr( final STLVector<CqVector3D> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetColorPtr( final STLVector<CqColor> res )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	GetMatrixPtr( final STLVector<CqMatrix> res )
	{
		assert( false );
	}
	
	
	/**
	 * Ɏs֐
	 */
	public	void	SetFloat( final float f )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetString( final String s )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetPoint( final CqVector3D p )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetVector( final CqVector3D v )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetNormal( final CqVector3D n )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetColor( final CqColor c )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetMatrix( final CqMatrix m )
	{
		assert( false );
	}
	
	/**
	 * Ɏs֐
	 */
	public	void	SetFloat( final float f, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetString( final String s, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetPoint( final CqVector3D p, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetVector( final CqVector3D v, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetNormal( final CqVector3D n, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetColor( final CqColor c, int index )
	{
		assert( false );
	}
	/**
	 * Ɏs֐
	 */
	public	void	SetMatrix( final CqMatrix m, int index )
	{
		assert( false );
	}
	
	/**
	 * shaderDataClassԂ
	 * @return EqVariableClass.class_varying̒lEqVariableClassԂ
	 */
	public	EqVariableClass	Class()
	{
		return ( new EqVariableClass(EqVariableClass.class_varying) );
	}
	/**
	 * shaderDataTypeԂ
	 * @return T̒lEqVariableTypeԂ
	 */
	public	EqVariableType	Type()
	{
		return ( T );
	}
	/**
	 * shaderData̎Vector̒Ԃ
	 * @return shaderData̎Vector̒
	 */
	public long	Size()
	{
		return ( m_aValue.size() );
	}

	//qNXɈϏ
	public abstract void assignment(final CqShaderVariableVarying<R> From);
	/*
	public	void	assignment( final CqShaderVariableVarying<R> From )
	{
		// use std::vector assignment
//		m_aValue = From.m_aValue;
	}*/
}
