// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.*;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqVector3D;

/**
 * CqShaderVaribaleUniformpA
 * CqVector3D^̕ϐShaderData
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableUniformVector extends CqShaderVariableUniform<CqVector3D> {
	
	/**
	 * RXgN^
	 *
	 */
	public CqShaderVariableUniformVector()
	{
		super(new EqVariableType(EqVariableType.type_vector));
		m_Value = new CqVector3D();
		
		CqStats.STATS_INC( SHD_var_uniform_vector );
	}
	
	/**
	 * RXgN^
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableUniformVector( final String strName, boolean fParameter)
	{
		super( strName, fParameter ,new EqVariableType(EqVariableType.type_vector));
		m_Value = new CqVector3D();
		CqStats.STATS_INC( SHD_var_uniform_vector);
	}
	/**
	 * RXgN^
	 * @param strName
	 */
	public CqShaderVariableUniformVector(final String strName){
		this(strName,false);
	}
	
	/**
	 * Rs[RXgN^
	 * @param val Rs[
	 */
	public CqShaderVariableUniformVector(CqShaderVariableUniformVector val){
		super(val,new EqVariableType(EqVariableType.type_vector));
	}
	/**
	 * ShaderData̎CqVector3D̒l擾
	 * @param res 擾li[ϐ
	 * @param index gpȂ
	 */	
	public	void	GetPoint( CqVector3D res, int index) 
	{
		res.assignment(m_Value);
	}
	/**
	 * ShaderData̎ACqVector3D̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderDataȂ̒le󂯂
	 */
	public	void	GetPointPtr( final STLVector<CqVector3D> res ) 
	{
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	
	/**
	 * ShaderData̒lύXB
	 * 
	 * @param s ύXl
	 */
	public	void	SetPoint( final CqVector3D p )
	{
		m_Value.assignment( p );
	}
	/**
	 * ShaderData̎CqVector3D̒l擾
	 * @param res 擾li[ϐ
	 * @param index gpȂ
	 */
	public	void	GetVector( CqVector3D res, int index) 
	{
		res.assignment(m_Value);
	}
	/**
	 * ShaderData̎ACqVector3D̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderDataȂ̒le󂯂
	 */
	public	void	GetVectorPtr( final STLVector<CqVector3D> res ) 
	{
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	/**
	 * ShaderData̒lύXB
	 * 
	 * @param s ύXl
	 */
	public	void	SetVector( final CqVector3D p )
	{
		m_Value.assignment(p);
	}
	/**
	 * ShaderData̎CqVector3D̒l擾
	 * @param res 擾li[ϐ
	 * @param index gpȂ
	 */
	public	void	GetNormal( CqVector3D res, int index ) 
	{
		
		res.assignment(m_Value);
	}
	/**
	 * ShaderData̎ACqVector3D̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderDataȂ̒le󂯂
	 */
	public	void	GetNormalPtr( final STLVector<CqVector3D> res ) 
	{
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	
	/**
	 * ShaderData̒lύXB
	 * 
	 * @param s ύXl
	 */
	public	void	SetNormal( final CqVector3D p )
	{
		m_Value.assignment( p );
	}
	
	/**
	 * ShaderData̎CqVector3D̒lS0̎AfalseԂA
	 * ȊOtrueԂ֐
	 * 
	 * @param res ʂi[ϐ
	 * @param index gpȂ
	 */
	public void	GetBool( p_boolean res, int index) 
	{
		res.value = ( ( m_Value.x != 0.0f ) || ( m_Value.y != 0.0f ) || ( m_Value.z != 0.0f ) );
	}
	/** 
	 * Copy the values from the passed variable into this, taking into account any class differences.
	 * œnꂽϐ̒lRs[B
	 * 
	 * @param pVal Rs[̕ϐ. The variable to copy from.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal )
	{
		pVal.GetVector( m_Value );
	}
	
	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
	public	IqShaderData Clone() 
	{
		CqShaderVariableUniformVector newVar = new CqShaderVariableUniformVector( this );
		newVar.SetSize( (int)Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
}
