// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.*;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 * CqShaderVaribaleUniformpA
 * String^̕ϐShaderData
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableUniformString extends CqShaderVariableUniform<p_String> {
	
	/**
	 * RXgN^
	 * vXVB
	 */
	public CqShaderVariableUniformString()
	{
		super(new EqVariableType(EqVariableType.type_string));
		m_Value = new p_String();
		CqStats.STATS_INC( SHD_var_uniform_string );
	}
	
	/**
	 * RXgN^
	 * vXVB
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableUniformString( final String strName, boolean fParameter)
	{
		super(strName, fParameter ,new EqVariableType(EqVariableType.type_string));
		m_Value = new p_String();
		CqStats.STATS_INC( SHD_var_uniform_string );
	}
	
	/**
	 * RXgN^
	 * @param strName
	 */
	public CqShaderVariableUniformString(final String strName){
		this(strName,false);
	}
	
	
	/**
	 * Rs[RXgN^
	 * @param val Rs[
	 */
	public CqShaderVariableUniformString(CqShaderVariableUniformString val){
		super(val,new EqVariableType(EqVariableType.type_string));
	}
	
	/**
	 * ShaderData̎String̒l擾
	 * @param res ʂi[ϐ
	 * @param index gpȂ
	 */
	public void	GetString( p_String res, int index)
	{
		res.value = m_Value.value;
	}
	
	/**
	 * ShaderData̎AString̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderDataȂ̒le󂯂
	 */
	public void GetStringPtr( final STLVector<p_String> res )
	{
//		res = m_Value;
		if(res.size() < 1)
			res.add(m_Value);
		else
			res.setElementAt(m_Value,0);
	}
	
	/**
	 * ShaderData̒lύXB
	 * 
	 * @param s ύXl
	 */
	public void	SetString( final String s )
	{
		m_Value.value = s;
	}
	/**
	 * ShaderData̒l""łȂꍇfalse
	 * ""łꍇtrueƕԂ\bh
	 * @param res ʂi[ϐ
	 * @param index gpȂ
	 */
	public void	GetBool(p_boolean res, int index)
	{
		res.value = m_Value.value.compareTo( "" ) == 0;
	}
	/** 
	 * Copy the values from the passed variable into this, taking into account any class differences.
	 * œnꂽϐ̒lRs[B
	 * 
	 * @param pVal Rs[̕ϐThe variable to copy from.
	 */
	public void	SetValueFromVariable(final IqShaderData pVal )
	{
		pVal.GetString( m_Value );
	}
	
	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
	public IqShaderData Clone()
	{
		CqShaderVariableUniformString newVar = new CqShaderVariableUniformString( this );
		newVar.SetSize((int) Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
	
}
