// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqIntIndex;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 * ׂẴVF[_ϐ`Ȃ΂ȂȂۓIȊNXB
 * @author NTT DATA Corporation
 */
public abstract strictfp class CqShaderVariable extends IqShaderData {
 
	protected String		m_strName;		// ϐ
    protected boolean	m_fParameter;	// ̕ϐVF[_̈ł邱ƂtO

	/**
	 * RXgN^
	 * vXV
	 */
	public CqShaderVariable(){
		m_fParameter = false;
		m_strName = "";
	    CqStats.STATS_INC( EqIntIndex.SHD_var_created_total );
	    CqStats.STATS_INC( EqIntIndex.SHD_var_current );
	    int cSHD = CqStats.STATS_GETI( EqIntIndex.SHD_var_current );
	    int cPeak = CqStats.STATS_GETI( EqIntIndex.SHD_var_peak );

	    CqStats.STATS_SETI( EqIntIndex.SHD_var_peak, cSHD > cPeak ? cSHD : cPeak );
	}
	
	/**
	 * RXgN^
	 * vXV
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariable(final String strName,boolean fParameter){
		m_strName = strName;
		m_fParameter = fParameter;
		
		CqStats.STATS_INC( EqIntIndex.SHD_var_created_total );
		CqStats.STATS_INC( EqIntIndex.SHD_var_current );
	    int cSHD = CqStats.STATS_GETI( EqIntIndex.SHD_var_current );
	    int cPeak = CqStats.STATS_GETI( EqIntIndex.SHD_var_peak );

	    CqStats.STATS_SETI( EqIntIndex.SHD_var_peak, cSHD > cPeak ? cSHD : cPeak );	
	}
	/**
	 * RXgN^
	 * 
	 * @param strName
	 */
	public CqShaderVariable(final String strName){
		this(strName,false);
	}
	
	/**
	 * Rs[RXgN^
	 * @param val
	 */
	public CqShaderVariable(CqShaderVariable val){
		m_strName = val.m_strName;
		m_fParameter = val.m_fParameter;
	}
	
	/**
	 * fXgN^
	 */
	public void destruct() {
	    CqStats.STATS_DEC( EqIntIndex.SHD_var_current );
	}

	/**
	 *Ɏs֐
	 */
	public void GetBoolPtr(final STLVector<p_boolean> vector) {
		assert(false);

	}



	/**
	 *Ɏs֐
	 */
	public void GetBool(p_boolean res, int index) {
		assert(false);
	}

	/**
	 *Ɏs֐
	 */
	public void SetBool(final boolean val) {
		assert(false);
	}

	/**
	 *Ɏs֐
	 */
	public void SetBool(final boolean val, int index) {
		assert(false);
	}
	
	/**
	 * m_strNamegetter
	 */
	public String strName() {
		return m_strName;
	}

	/**
	 * m_fParametersetter
	 * @param fParameter
	 */
	public void setfParameter(boolean fParameter){
		m_fParameter= fParameter;
	}
	
	/**
	 * m_fParametertrueɂsetter
	 */
	public final void setfParameter(){
		m_fParameter = true;
	}
	
	/**
	 * m_fParametergetter
	 */
	public boolean fParameter() {
		return m_fParameter;
	}
	/**
	 *0Ԃ\bh
	 */
	public int ArrayLength() {
		return 0;
	}
	
	/**
	 * gԂ\bh
	 */
	public IqShaderData ArrayEntry(int i) {
		return this;
	}

}
