/*
 KeywordProcedural.java
 Copyright (C) 2003 Gerardo Horvilleur Martinez

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.parser.keywords;

import java.lang.reflect.Method;

import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Tokenizer;

public strictfp class KeywordProcedural extends AbstractKeywordParser {

    public void parse(Tokenizer st) throws Exception 
    {
        // Expect procname
        match(st, TK_STRING);
        String procName = GetProc( st.sval);
        Method refineproc = RendermanInterface.class.getMethod( procName, Object[].class, float.class );
        
        // Expect args
        clearParameterList();
        parseArray(st);
        Object[] data = values();

        // Expect bounds
        float[] bounds = readBounds(st);
        
        //Get freeproc
        Method freeproc = RendermanInterface.class.getMethod( "RiProcFree", Object[].class );
        
        RendermanInterface.RiProcedural( data, bounds, refineproc, freeproc );
    }

    private String GetProc( String type )
    {
    	if( type.compareTo( "RunProgram" ) == 0 )
        	return  "RiProcRunProgram";
        else if( type.compareTo( "DelayedReadArchive" ) == 0 )
        	return  "RiProcDelayedReadArchive";
        else if( type.compareTo( "DynamicLoad" ) == 0 )
        	return  "RiProcDynamicLoad";
        else 
        	return "RiProcDynamicLoad";
    }
    
}
