// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;


/**
 * 
 * 4xNg<br>
 * 2/3xNg̕ϊAPʃxNg郁\bhB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqVector4D{

	private static final long serialVersionUID = -739144048439837317L;

	public float x;
	public float y;
	public float z;
	public float w;
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * ftHgRXgN^BevfB
	 */
	public CqVector4D() {
		this.x = 0.0f;
		this.y = 0.0f;
		this.z = 0.0f;
		this.w = 1.0f;
	}
	
	/**
	 * floaẗlƂɂSxNg쐬B
	 * @param x	s̑Pvf
	 * @param y	s̑Qvf
	 * @param z	s̑Rvf
	 * @param w	s̑Svf
	 */
	public CqVector4D( float x, float y, float z, float w ){
		this.x = x;
		this.y = y;
		this.z = z;
		this.w = w;
	}
	
	/**
	 * RxNgƂɂSxNg쐬B<br>
	 * Svfɂ͕KPB
	 * @param From	RxNg
	 */
	public CqVector4D( final CqVector3D From ){
		
	    this.x = From.x;
	    this.y = From.y;
	    this.z = From.z;
	    this.w = 1.0f;
	}
	
	/**
	 * float^SzƂɂSxNg쐬B
	 * @param array	float^Sz
	 */
	public CqVector4D( final float[] array ){
		
		this.x = array[0];
		this.y = array[1];
		this.z = array[2];
		this.w = array[3];
	}
	
	/**
	 * Rs[RXgN^
	 * @param v	Rs[
	 */
	public CqVector4D( final CqVector4D v ){
//		this.set(v);
		this.x = v.x;
		this.y = v.y;
		this.z = v.z;
		this.w = v.w;
	}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/**
	 * Pvf̃Zb^
	 * @param x	Pvf
	 */
	public void x( float x ){
		this.x = x;
	}
	
	/**
	 * Qvf̃Zb^
	 * @param y	Qvf
	 */
	public void y( float y ){
		this.y = y;
	}
	
	/**
	 * Rvf̃Zb^
	 * @param z	Rvf
	 */
	public void z( float z ){
		this.z = z;
	}
	
	/**
	 * Svf̃Zb^
	 * @param h	Svf
	 */
	public void h( float h ){
		this.w = h;
	}
	
	/**
	 * xNĝQԂ
	 * @return	xNĝQ
	 */
	public float Magnitude2()
    {
	    if ( w == 1.0f ){
	        return ( ( x * x ) + ( y * y ) + ( z * z ) );
	    }
	    else{
	        return ( ( ( x * x ) + ( y * y ) + ( z * z ) ) / ( w * w ) );
	    }
    }
	
	/**
	 * xNg̒Ԃ
	 * @return	xNg̒
	 */
	public float Magnitude()
    {
		return (float)Math.sqrt( Magnitude2() );
    }
	
	/**
	 *  Pʉ 
	 */
	public void Unit()
	{
		this.w = this.Magnitude();
	}
	
	/**
	 * ώ
	 */
	public void Homogenize()
	{
        if ( w != 1.0 )
        {
            x /= w;
            y /= w;
            z /= w;
            w = 1.0f;
        }
	}
	
	
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
	/**
	 * zQƉZqB
	 * 0,1,2,3ꂼx,y,z,wɑBȊO̒l̏ꍇwԂB
	 * 
	 * @param i	0,1,2,3̐
	 * @return	x,y,z,w
	 */
	public float valueAt( int i )
	{
        switch ( i )
        {
        case 0:		return ( x );
        case 1:		return ( y );
        case 2:		return ( z );
        case 3:		return ( w );
        default:	return ( w );
        }
	}
	
	/**
	 * ZqB
	 * RxNglRs[B<br>
	 * Svfɂ͕KP
	 * 
	 * @param From	CqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignment( final CqVector3D From )
	{
	    this.x = From.x;
	    this.y = From.y;
	    this.z = From.z;
	    this.w = 1.0f;
	    
	    return this;
	}
	
	/**
	 * ZqB
	 * RxNglRs[B<br>
	 * Svfɂ͕KP
	 * 
	 * @param From	CqVector3D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignment( final float a_x,final float a_y,final float a_z )
	{
	    this.x = a_x;
	    this.y = a_y;
	    this.z = a_z;
	    this.w = 1.0f;
	    
	    return this;
	}
	
	/**
	 * ZqB
	 * 
	 * @param From	CqVector4D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignment( final CqVector4D From )
	{
	    this.x = From.x;
	    this.y = From.y;
	    this.z = From.z;
	    this.w = From.w;
	    
	    return this;
	}
	
	
	public CqVector4D assignment( final float a_x,final float a_y,final float a_z ,final float a_w)
	{
	    this.x = a_x;
	    this.y = a_y;
	    this.z = a_z;
	    this.w = a_w;
	    
	    return this;
	}
	
	/**
	 * ZB
	 * Svf̊evfɊ|ĉZsB
	 * 
	 * @param From	ZCqVector4D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignAdd( final CqVector4D From )
	{
	    float Hom = w / From.w;

	    x += From.x * Hom;
	    y += From.y * Hom;
	    z += From.z * Hom;

	    return this;
	}
	
	/**
	 * ZB
	 * Svf̊evfɊ|ČZsB
	 * 
	 * @param From	ZCqVector4D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignSub( final CqVector4D From )
	{
	    float Hom = w / From.w;

	    x -= From.x * Hom;
	    y -= From.y * Hom;
	    z -= From.z * Hom;

	    return this;
	}
	
	/**
	 * ]ZB
	 * ACqVector4Dł͏]Z(%)́uOρvZƂĈB
	 * 
	 * @param From	OϑΏۂCqVector4D
	 * @return	vZʁithisj
	 */
	public CqVector4D assignMod( final CqVector4D From )
	{
	    CqVector4D	A = new CqVector4D( this );
	    CqVector4D	B = new CqVector4D( From );

	    A.Homogenize();
	    B.Homogenize();

	    x = ( A.y * B.z ) - ( A.z * B.y );
	    y = ( A.z * B.x ) - ( A.x * B.z );
	    z = ( A.x * B.y ) - ( A.y * B.x );

	    return this;
	}
	
	/**
	 * ZB
	 * P`Rvf܂łXJ{B
	 * 
	 * @param Scale	Zl
	 * @return	vZʁithisj
	 */
	public CqVector4D assignMul( final float Scale )
	{
		x *= Scale;
		y *= Scale;
		z *= Scale;
		
		return this;
	}
	
	/**
	 * ZB
	 * ACqVector4Dł͑Svf̃XJ{B
	 * 
	 * @param Scale	XJl
	 * @return	vZʁithisj
	 */
	public CqVector4D assignDiv( final float Scale )
	{
		w *= Scale;
		return this;
	}
	
	/**
	 * rZqB
	 * SĂ̗vfƂtrueԂB
	 * 
	 * @param Cmp	rΏۂCqVectorD
	 * @return	true:  SĂ̗vf<br>
	 * 			false: ꂩ̗vfȂ
	 */
	public boolean equals( final CqVector4D Cmp )
	{
		// exact equality of floats isn't actually very useful because of slight
		// differences due to rounding errors. a fuzzy compare is generally more useful.
		// if the vectors have different h values the above is unlikely to
		// return true, so we might as well just test for exact equality of each component.
		return ((x == Cmp.x) &&
				 (y == Cmp.y) &&
				 (z == Cmp.z) &&
				 (w == Cmp.w) );
	}
	
	/**
	 * ErZqB
	 * Svf̊evfɊ|ŁA̗vf̂傫trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector4D
	 * @return	trueF	Svf傫<br>
	 * 			falseF	ꂩ̗vf
	 */
	public boolean ge ( final CqVector4D Cmp ){
		
	    float Hom = w / Cmp.w;

	    return (( x >= ( Cmp.x * Hom ) ) &&
	             ( y >= ( Cmp.y * Hom ) ) &&
	             ( z >= ( Cmp.z * Hom ) ) );
	}
	
	/**
	 * rZqB
	 * Svf̊evfɊ|ŁA̗vf̂菬trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector4D
	 * @return	trueF	Svf<br>
	 * 			falseF	ꂩ̗vf傫
	 */
	public boolean le ( final CqVector4D Cmp ){
		
	    float Hom = w / Cmp.w;

	    return (( x <= ( Cmp.x * Hom ) ) &&
	             ( y <= ( Cmp.y * Hom ) ) &&
	             ( z <= ( Cmp.z * Hom ) ) );
	}
	
	/**
	 * ErZqB
	 * Svf̊evfɊ|ŁA̗vf̂傫trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector4D
	 * @return	trueF	Svf傫<br>
	 * 			falseF	ꂩ̗vf
	 */
	public boolean gt ( final CqVector4D Cmp ){
		
	    float Hom = w / Cmp.w;

	    return (( x > ( Cmp.x * Hom ) ) &&
	             ( y > ( Cmp.y * Hom ) ) &&
	             ( z > ( Cmp.z * Hom ) ) );
	}
	
	/**
	 * rZqB
	 * Svf̊evfɊ|ŁA̗vf̂菬trueԂB
	 * 
	 * @param Cmp	rΏۂCqVector4D
	 * @return	trueF	Svf<br>
	 * 			falseF	ꂩ̗vf傫
	 */
	public boolean lt ( final CqVector4D Cmp ){
		
	    float Hom = w / Cmp.w;

	    return (( x < ( Cmp.x * Hom ) ) &&
	             ( y < ( Cmp.y * Hom ) ) &&
	             ( z < ( Cmp.z * Hom ) ) );
	}
	
	/**
	 * ZZqB
	 * P`Rvf܂łXJ{B
	 * 
	 * @param f	Zl
	 * @return	vZ
	 */
	public CqVector4D mul( final float f )
	{
		CqVector4D r= new CqVector4D( this );
		return	r.assignMul(f);
	}
	
	/**
	 * ZZqB
	 * ACqVector4Dł͑Svf̃XJ{B
	 * 
	 * @param f	XJl
	 * @return	vZ
	 */
	public CqVector4D div( final float f )
	{
		CqVector4D r= new CqVector4D( this );
		return	r.assignDiv(f);
	}
	
	/**
	 * tZZqB
	 * ZZƓľvZB
	 * 
	 * @param f	XJl
	 * @return	vZ
	 */
	public CqVector4D divInv( final float f )
	{
		CqVector4D r= new CqVector4D( this );
		return	r.assignDiv(f);
	}
	
	/**
	 * ZZqB
	 * Svf̊evfɊ|ĉZsB
	 * 
	 * @param b	ZCqVector4D
	 * @return	vZ
	 */
	public CqVector4D add( final CqVector4D b )
	{		
		CqVector4D r= new CqVector4D( this );
		return	r.assignAdd(b);
		
	}
	
	/**
	 * ZZqB
	 * Svf̊evfɊ|ĉZsB
	 * 
	 * @param b	ZCqVector4D
	 * @return	vZ
	 */
	public CqVector4D sub( final CqVector4D b )
	{
		CqVector4D r= new CqVector4D( this );
		return	r.assignSub(b);
	}
	

	/**
	 * ZZqB
	 * ACqVector3Dł͏Z(*)́uρvZƂĈB
	 * 
	 * @param b	ϑΏۂCqVector4D
	 * @return	vZ
	 */
	public float mul( final CqVector4D b )
	{
	    CqVector4D A = new CqVector4D( this );
	    CqVector4D B = new CqVector4D( b );

	    A.Homogenize();
	    B.Homogenize();

	    return (( A.x * B.x ) +
	             ( A.y * B.y ) +
	             ( A.z * B.z ) );
	}
	
	/**
	 * ]ZZqB
	 * ACqVector4Dł͏]Z(%)́uOρvZƂĈB
	 * 
	 * @param b	OϑΏۂCqVector4D
	 * @return	vZ
	 */
	public CqVector4D mod( final CqVector4D b )
	{
	    CqVector4D Temp = new CqVector4D( this );
	    Temp.assignMod(b);
	    return ( Temp );
	}
	
	
}
