// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

/**
 * QƃJEg@\̃NXB <br>
 * <br>
 * This class provides a reference counting form of memory management for
 * Aqsis.<br>
 * <br>
 * This class is implemented in two different ways.  One way is a debug
 * version, which keeps track of AddRef() and Release() calls so that bugs
 * can be tracked easily.  The second version is a much faster, minimal
 * implementation that is used for non-debug builds.<br>
 * <br>
 * The basic idea with this class is that derived classes will have the
 * AddRef() function called whenever a new object needs access to the
 * derived class.  Calling AddRef() effectively marks the derived class as
 * "in use", and prevents it from being de-allocated.  When the object no 
 * longer needs the derived class, it will call Release().  Finally, when 
 * the last class has called Release(), the reference counter realises
 * that nobody needs it anymore and automatically deletes itself.<br>
 * 
 * @author Paul Gregory
 * @author NTT DATA Corporation
 */
public strictfp class CqRefCount {
	
	private int	m_cReferences;		///< Count of references to this object.

	/**
	 * RXgN^BQƃJEgOɁB
	 */
	public CqRefCount()	{
		m_cReferences = 0;
	}
	
	/**
	 * fXgN^
	 */
	public void destruct(){
		
	}
	
	/**
	 * QƃJEg̃Qb^ 
	 * @return	QƃJEg
	 */
	public int RefCount(){
		return ( m_cReferences );
	}
	
	/**
	 * QƂ̒ǉ
	 */
	public void	AddRef()
	{
		m_cReferences++;
	}
	
	/**
	 * QƂ̍폜
	 */
	public void	Release()
	{
		m_cReferences--; 
		if( m_cReferences <= 0 ){
			this.destruct();	// delete( this );
		}
	}
	
	
	
}
