// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * t@CNXB
 * ChJ[hA΃t@C̎擾At@C̎擾Ak`FbNȂǂT|[gB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqFile {

	private RandomAccessFile	m_pStream;
	private String				m_strRealName;
	
	/**
	 * ftHgRXgN^
	 */
	public CqFile()
	{
		m_pStream	= null;
	}
	
    /**
     * t@CƂ̖̎w肵ď
     * 
     * @param Stream	ɊJꂽRandomAccessFileIuWFNg
     * @param strRealName	t@C
     */
    public CqFile( RandomAccessFile Stream, final String strRealName )
    {
    	m_pStream		= Stream;
    	m_strRealName	= strRealName;
    }

    /**
     * pXw肵ăt@CJRXgN^
     * 
     * @param strFilename	Jt@C
     * @param strSearchPathOption	pX
     */
    public CqFile( final String strFilename, final String strSearchPathOption )
    {
    	m_pStream = null;
    	Open( strFilename, strSearchPathOption );
    }
    
    /**
     * t@CJRXgN^B<br>
     * JgfBNg̃t@CJB
     * 
     * @param strFilename	Jt@C
     */
    public CqFile( final String strFilename )
    {
    	m_pStream = null;
    	Open( strFilename, "" );
    }
	
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
    /**
     * pXw肵ăt@CJB<br>
     * ܂̓JgTAȂΌpXTB
     * 
     * @param strFilename	Jt@C
     * @param strSearchPathOption	pX
     * @param mode	I[v[hi"r","rw"j
     */
    public void Open( String strFilename, final String strSearchPathOption, final String mode )
    {
    	//nttdata ǉ 2006/03/16 
    	strFilename = FixupPath(strFilename);
    	
    	//܂̓JgfBNgT[`
    	m_strRealName = strFilename;
    	RandomAccessFile pFStream = null;
    	
    	try {
			pFStream = new RandomAccessFile( strFilename, mode );
			
			m_pStream = pFStream;
			return;
			
		} catch (FileNotFoundException e) {		//if ( !pFStream->is_open() )
			
			//T[`pXw肳Ă΂T[`
			if( !strSearchPathOption.equals("") )
			{

				//pX":"ŋ؂Ă̂ŁA̒T
				int len = 0;
				int start = 0;
		    	String strPath = "";

				while( true ){
					
					// Find the next search path in the spec.
					int index = strSearchPathOption.indexOf( ':', start );
					if( index==-1 )
						index = strSearchPathOption.length();
					len = index - start;
					
	                // Check if it is realy meant as a drive spec.
					
	                if ( len == 1 && Character.isLetter( strSearchPathOption.charAt(start) ) ) {
	                	int separatePos = strSearchPathOption.indexOf( ':', start+2 );
	                	if( separatePos==-1 ){
	                		len = strSearchPathOption.length() - start;
	                	}
	                	else{
	                		len = separatePos - start;
	                	}
	                }
	                strPath = strSearchPathOption.substring( start, start+len );
//	                if ( strPath == "" ) break;
	                if ( strPath.equals( "" ) ) break;
					
	                // Apply any system specific string modification.
	                strPath = FixupPath( strPath );
	                
					//T[`pX{t@C쐬
					String strAlternativeFilename = strPath;
					if( !strAlternativeFilename.endsWith(File.separator) ){
						strAlternativeFilename += File.separator;
					}
					strAlternativeFilename += strFilename;
					
					//t@C̗LmF
					File file = new File( strAlternativeFilename );
					if( file.isFile() )
					{
						//t@CI[v
						try {
							pFStream = new RandomAccessFile( file, "r" );
							
							//J炻oϐɃZbg
							m_pStream = pFStream;
							m_strRealName = strAlternativeFilename;
							
							return;
							
						} catch (FileNotFoundException e1) {
							m_pStream = null;
							
						}//end of try for FileOpen
					}
					
					//̃[vցB
					if( start + len < strSearchPathOption.length() ){
						start += len + 1; 
					}
					else{
						break;
					}
			
					
				}//end of while( ";:" )
			}
		}
    	
    }
    
    /**
	 * 
	 * RATȂǂo͂AȃpXwz邽߂̃\bh<br>
	 * wpX񂪁A`łȂ΂̂܂ܕԂB
	 * 
	 * @param strPath	pX
	 * @return	ɏCꂽpX
	 */
	private String FixupPath(String strPath) {
	    
		if( strPath.startsWith("//") )
	    {
	        if(strPath.charAt(3) == '/')
	        {
	            String strNewPath = strPath.substring(2,3);
	            strNewPath = strNewPath.concat(":/");
	            strNewPath = strNewPath.concat( strPath.substring(4) );
	            //std::cout << strNewPath.c_str() << std::endl;
	            return(strNewPath);
	        }
	    }

	    return( strPath );
	    
	}

	/**
     * pXw肵ēǂݍݐpt@CJB<br>
     * ܂̓JgTAȂΌpXTB
     * 
     * @param strFilename	Jt@C
     * @param strSearchPathOption	pX
     */
    public void Open( final String strFilename, final String strSearchPathOption )
    {
    	Open( strFilename, strSearchPathOption, "r" );
    }
    
    /**
     * t@CJB<br>
     * JgfBNg̃t@CJB
     * 
     * @param strFilename	Jt@C
     */
    public void Open( final String strFilename )
    {
    	Open( strFilename, "", "r" );
    }

    /**
     * t@C
     * 
     */
    public void Close()
    {
        if ( m_pStream != null ){
        	try {
				m_pStream.close();
			} catch (IOException e) {
				HimawariLogger.outputException( e );
			}
        }
        m_pStream = null;
    }

    /**
     * t@CIuWFNgnullǂ`FbN
     * 
     * @return	trueFt@Ct@CIuWFNgnull
     * 			false:t@CIuWFNg͊JĂ
     */
    public boolean IsValid()
    {
        return ( m_pStream != null );
    }
    
    /**
     * t@C̎擾
     * 
     * @return	t@C
     */
    public final String strRealName()
    {
        return ( m_strRealName );
    }
    
    /**
     * t@C|C^̈ʒu擾
     * 
     * @return	t@C|C^̈ʒu
     */
    public long Position()
    {
        try {
			return ( m_pStream.getFilePointer() );
			
		} catch (IOException e) {
			HimawariLogger.outputException( e );
			return -1;
		}
    }
    
    /**
     * t@CTCY̎擾
     * 
     * @return	t@CTCYioCgPʁj
     */
    public long Length()
    {
    	if( m_pStream == null )		return -1;
    	
        try {
			return m_pStream.length();
			
		} catch (IOException e) {
			HimawariLogger.outputException( e );
			return -1;
		}
    }

//    public String FixupPath( String strPath )
//    {
//        if( strPath.find("//",0,2) == 0 )
//        {
//            if(strPath[3] == '/')
//            {
//                CqString strNewPath(strPath.substr(2,1));
//                strNewPath.append(":/");
//                strNewPath.append(strPath.substr(4));
//                //std::cout << strNewPath.c_str() << std::endl;
//                return(strNewPath);
//            }
//        }
//
//        return( strPath );
//    }

    /**
     * 
     * ChJ[h𗘗păt@C̈ꗗB
     * 
     * @param strFileGlob	t@CiChJ[hpj
     * @return	ʂ̃Xg
     */
    static public ArrayList<String> Glob( final String strFileGlob )
    {
    	File hFile;
    	String pt = strFileGlob.trim();
    	
    	ArrayList<String> result = new ArrayList<String>();
    	int dp = pt.lastIndexOf(File.separator);
    	if( dp == -1 )
    	{
    		pt = "." + pt;
    		dp = 1;
    	}
    	else{
    		dp += File.separator.length();
    	}
    		hFile = new File( pt.substring(0,dp) );
//    		hFile = new File( pt );
    		if( hFile.exists() )
    		{
    			//K\ɂt@CT[`
    			String[] strFile;
    			strFile = hFile.list( new GlobFileFilter( pt.substring(dp) ) );
//    			strFile = hFile.list( new GlobFileFilter( pt ) );
    			
    			for( String str : strFile ){
    				result.add( str );
    			}
    		}
    		
//    	}
    	
    	return result;
    }
	
	
	//************************************************************************//
	//*** Zq̃I[o[[h
	//************************************************************************//
	
    /**
     * QƉZqB <br>
     * ݂̃t@CԂB
     * 
     * @return	JĂt@C
     */
    public RandomAccessFile ref(){
    	return ( m_pStream );
    }
    
	/**
	 * |C^ZqB,br>
     * ݂̃t@CԂB
     * 
     * @return	JĂt@C
	 */
	public RandomAccessFile point(){
		return ( m_pStream );
	}
	
	
	
	// 2006/03/16 ݕϊΉ
	public static String FixupPathIfNeed(String path){
		CqFile file = new CqFile();
		return file.FixupPath(path);
	}
	
}
