// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiHyperboloidṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiHyperboloidCache extends RiCacheBase {
	
	public RiHyperboloidCache(float[] point1, float[] point2, float thetamax, int count, String[] tokens, Object[] values)
	{
		m_point1 = new float[ 3 ];
		m_point2 = new float[ 3 ];
		
		m_point1[0] = point1[0];
		m_point1[1] = point1[1];
		m_point1[2] = point1[2];
		m_point2[0] = point2[0];
		m_point2[1] = point2[1];
		m_point2[2] = point2[2];
		m_thetamax = thetamax;
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		varying_size = 4;
		vertex_size = 4;
		facevarying_size = 4;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiHyperboloidV(m_point1, m_point2, m_thetamax, m_count, m_tokens, m_values);
	}
	
	private float[] m_point1;
	private float[] m_point2;
	private float m_thetamax;
	// plist information is stored in the base class.
	
}
