// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiCurvesṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiCurvesCache extends RiCacheBase {

	public RiCurvesCache(String type, int ncurves, int[] nvertices, String wrap, int count, String[] tokens, Object[] values)
	{
//		int __type_length = strlen(type);
//		m_type = new char[ __type_length + 1 ];
//		strcpy(m_type, type);
		m_type = new String( type );
		m_ncurves = ncurves;
		int __nvertices_length = ncurves;
		m_nvertices = new int[__nvertices_length];
		int __nvertices_index;
		for(__nvertices_index = 0; __nvertices_index<__nvertices_length; __nvertices_index++)
		{
			m_nvertices[__nvertices_index] = nvertices[__nvertices_index];
		}
//		int __wrap_length = strlen(wrap);
//		m_wrap = new char[ __wrap_length + 1 ];
//		strcpy(m_wrap, wrap);
		m_wrap = new String( wrap );
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		uniform_size = ncurves;
		varying_size = 0;
		{
			int __i;
			for(__i=0; __i<__nvertices_length; __i++)
			{
				if( type.compareTo("cubic")==0 )
				{
					int step = QGetRenderContext().pattrCurrent().GetIntegerAttribute( "System", "BasisStep" ) [ 0 ];
					if( wrap.compareTo("periodic")==0 )
						varying_size+=nvertices[__i]/step;
					else
						varying_size+=((nvertices[__i]-4)/step)+1;
				}
				else
				{
					if( wrap.compareTo("periodic")==0 )
						varying_size+=nvertices[__i];
					else
						varying_size+=nvertices[__i]-1;
				}
				varying_size+=1;
			}
		}
		vertex_size = 0;
		{
			int __i;
			for(__i=0; __i<ncurves; __i++)
				vertex_size+=nvertices[__i];
		}
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}

	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_type);
//		delete[](m_nvertices);
//		delete[](m_wrap);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiCurvesV(m_type, m_ncurves, m_nvertices, m_wrap, m_count, m_tokens, m_values);
	}

	private String	m_type;
	private int	m_ncurves;
	private int[]	m_nvertices;
	private String	m_wrap;
	// plist information is stored in the base class.
	
}
